/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class Verandah
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(Verandah.class);
    private static final String RULE_43A = "43A";
    private static final String RULE_43 = "43";
    public static final String VERANDAH_DESCRIPTION = "Verandah";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        for (Block b : pl.getBlocks()) {
            ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
            scrutinyDetail.setKey("Common_Verandah");
            scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
            scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
            scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
            scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
            if (b.getBuilding() == null || b.getBuilding().getFloors() == null || b.getBuilding().getFloors().isEmpty()) continue;
            for (Floor f : b.getBuilding().getFloors()) {
                HashMap<String, String> details;
                if (f.getVerandah() == null || f.getVerandah().getMeasurements() == null || f.getVerandah().getMeasurements().isEmpty()) continue;
                BigDecimal minVerandaWidth = f.getVerandah().getMeasurements().stream().map(Measurement::getWidth).reduce(BigDecimal::min).get();
                BigDecimal minVerandDepth = (BigDecimal)f.getVerandah().getHeightOrDepth().stream().reduce(BigDecimal::min).get();
                if (minVerandaWidth.compareTo(BigDecimal.ZERO) > 0) {
                    details = new HashMap<String, String>();
                    details.put("Byelaw", RULE_43);
                    details.put("Description", VERANDAH_DESCRIPTION);
                    if (minVerandaWidth.compareTo(BigDecimal.valueOf(1.8)) >= 0) {
                        details.put("Required", "Minimum width 1.8m   ");
                        details.put("Provided", "Width area " + minVerandaWidth + " at floor " + f.getNumber());
                        details.put("Status", Result.Accepted.getResultVal());
                        scrutinyDetail.getDetail().add(details);
                        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                    } else {
                        details.put("Required", "Minimum width 1.8m   ");
                        details.put("Provided", "Width area " + minVerandaWidth + " at floor " + f.getNumber());
                        details.put("Status", Result.Not_Accepted.getResultVal());
                        scrutinyDetail.getDetail().add(details);
                        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                    }
                }
                if (minVerandDepth.compareTo(BigDecimal.ZERO) <= 0) continue;
                details = new HashMap();
                details.put("Byelaw", RULE_43A);
                details.put("Description", VERANDAH_DESCRIPTION);
                if (minVerandDepth.compareTo(BigDecimal.valueOf(3.66)) <= 0) {
                    details.put("Required", "Minimum depth not more than 3.66 m ");
                    details.put("Provided", " Depth area  " + minVerandDepth + " at floor " + f.getNumber());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                    continue;
                }
                details.put("Required", "Minimum depth not more than 3.66 m ");
                details.put("Provided", " Depth area  " + minVerandDepth + " at floor " + f.getNumber());
                details.put("Status", Result.Not_Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

