/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class Ventilation
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(Ventilation.class);
    private static final String RULE_43 = "43";
    public static final String LIGHT_VENTILATION_DESCRIPTION = "Light and Ventilation";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        for (Block b : pl.getBlocks()) {
            ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
            scrutinyDetail.setKey("Common_Ventilation");
            scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
            scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
            scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
            scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
            if (b.getBuilding() == null || b.getBuilding().getFloors() == null || b.getBuilding().getFloors().isEmpty()) continue;
            for (Floor f : b.getBuilding().getFloors()) {
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("Byelaw", RULE_43);
                details.put("Description", LIGHT_VENTILATION_DESCRIPTION);
                if (f.getLightAndVentilation() == null || f.getLightAndVentilation().getMeasurements() == null || f.getLightAndVentilation().getMeasurements().isEmpty()) continue;
                BigDecimal totalVentilationArea = f.getLightAndVentilation().getMeasurements().stream().map(Measurement::getArea).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal totalCarpetArea = f.getOccupancies().stream().map(Occupancy::getCarpetArea).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalVentilationArea.compareTo(BigDecimal.ZERO) <= 0) continue;
                if (totalVentilationArea.compareTo(totalCarpetArea.divide(BigDecimal.valueOf(8L)).setScale(2, 4)) >= 0) {
                    details.put("Required", "Minimum 1/8th of the floor area ");
                    details.put("Provided", "Ventilation area " + totalVentilationArea + " of Carpet Area   " + totalCarpetArea + " at floor " + f.getNumber());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                    continue;
                }
                details.put("Required", "Minimum 1/8th of the floor area ");
                details.put("Provided", "Ventilation area " + totalVentilationArea + " of Carpet Area   " + totalCarpetArea + " at floor " + f.getNumber());
                details.put("Status", Result.Not_Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

