/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class VehicleRamp
extends FeatureProcess {
    private static final String SUBRULE_40_8 = "40-8";
    private static final String DESCRIPTION = "Vehicle Ramp";
    private static final String FLOOR = "Floor";

    @Override
    public Plan validate(Plan pl) {
        for (Block block : pl.getBlocks()) {
            if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty()) continue;
            for (Floor floor : block.getBuilding().getFloors()) {
                List vehicleRamps = floor.getVehicleRamps();
                if (vehicleRamps == null || vehicleRamps.isEmpty()) continue;
                for (org.egov.common.entity.edcr.VehicleRamp vehicleRamp : vehicleRamps) {
                    List vehicleRampPolyLines = vehicleRamp.getRamps();
                    if (vehicleRampPolyLines == null || vehicleRampPolyLines.isEmpty()) continue;
                    this.validateDimensions(pl, block.getNumber(), floor.getNumber(), vehicleRamp.getNumber().toString(), vehicleRampPolyLines);
                }
            }
        }
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        this.validate(pl);
        BigDecimal coverParkingArea = BigDecimal.ZERO;
        BigDecimal basementParkingArea = BigDecimal.ZERO;
        for (Block block : pl.getBlocks()) {
            for (Floor floor : block.getBuilding().getFloors()) {
                coverParkingArea = coverParkingArea.add(floor.getParking().getCoverCars().stream().map(Measurement::getArea).reduce(BigDecimal.ZERO, BigDecimal::add));
                basementParkingArea = basementParkingArea.add(floor.getParking().getBasementCars().stream().map(Measurement::getArea).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        BigDecimal totalProvidedCarParkArea = coverParkingArea.add(basementParkingArea);
        BigDecimal minWidth = BigDecimal.ZERO;
        ArrayList<BigDecimal> vehicleRampLengths = new ArrayList<BigDecimal>();
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", SUBRULE_40_8);
        details.put(DESCRIPTION, DESCRIPTION);
        if (totalProvidedCarParkArea != null && totalProvidedCarParkArea.compareTo(BigDecimal.ZERO) > 0 && pl != null && !pl.getBlocks().isEmpty()) {
            for (Block block : pl.getBlocks()) {
                this.scrutinyDetail = new ScrutinyDetail();
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), DESCRIPTION);
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), FLOOR);
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Required");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
                this.scrutinyDetail.setKey(DESCRIPTION);
                if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty()) continue;
                for (Floor floor : block.getBuilding().getFloors()) {
                    for (org.egov.common.entity.edcr.VehicleRamp vehicleRamp : floor.getVehicleRamps()) {
                        if (!vehicleRamp.getRampClosed().booleanValue()) continue;
                        vehicleRampLengths = new ArrayList();
                        for (Measurement measurement : vehicleRamp.getRamps()) {
                            vehicleRampLengths.add(measurement.getHeight());
                        }
                        BigDecimal vehicleRampTotalLength = BigDecimal.ZERO;
                        for (BigDecimal length : vehicleRampLengths) {
                            vehicleRampTotalLength = vehicleRampTotalLength.add(length);
                        }
                        if (vehicleRampTotalLength.compareTo(BigDecimal.valueOf(0L)) <= 0 || vehicleRamp.getFloorHeight() == null) continue;
                        BigDecimal vehicleRampSlope = vehicleRamp.getFloorHeight().divide(vehicleRampTotalLength, 2, RoundingMode.HALF_UP);
                        vehicleRamp.setSlope(vehicleRampSlope);
                    }
                    if (floor.getNumber() == 0) continue;
                    if (floor.getParking() != null && floor.getParking().getMechanicalLifts() != null && !floor.getParking().getMechanicalLifts().isEmpty() || floor.getVehicleRamps() != null && !floor.getVehicleRamps().isEmpty()) {
                        if (floor.getParking().getMechanicalLifts() != null && !floor.getParking().getMechanicalLifts().isEmpty()) continue;
                        boolean valid = false;
                        boolean valid1 = false;
                        boolean valid2 = false;
                        for (org.egov.common.entity.edcr.VehicleRamp vehicleRamp : floor.getVehicleRamps()) {
                            minWidth = BigDecimal.ZERO;
                            for (Measurement polyLine : vehicleRamp.getRamps()) {
                                if (polyLine.getWidth().compareTo(minWidth) >= 0) continue;
                                minWidth = polyLine.getWidth();
                            }
                            if (minWidth.compareTo(new BigDecimal(5.4)) >= 0 && vehicleRamp.getSlope() != null && vehicleRamp.getSlope().compareTo(new BigDecimal(0.12)) <= 0) {
                                valid = true;
                            }
                            if (valid1 && minWidth.compareTo(new BigDecimal(3.6)) >= 0 && vehicleRamp.getSlope() != null && vehicleRamp.getSlope().compareTo(new BigDecimal(0.12)) <= 0) {
                                valid2 = true;
                            }
                            if (valid1 || minWidth.compareTo(new BigDecimal(3.6)) < 0 || vehicleRamp.getSlope() == null || vehicleRamp.getSlope().compareTo(new BigDecimal(0.12)) > 0) continue;
                            valid1 = true;
                        }
                        if (valid || valid1 && valid2) {
                            details.put(FLOOR, "Floor " + floor.getNumber());
                            details.put("Required", "At least two vehicle ramps of minimum 3.6 m width or one vehicle ramp of minimum 5.4 m width and in maximum 1:8 slope");
                            details.put("Provided", valid ? "Provided vehicle ramp with minimum 5.4 width" : "Provided two vehicle ramps of minimum 3.6 m width");
                            details.put("Status", Result.Accepted.getResultVal());
                            this.scrutinyDetail.getDetail().add(details);
                            pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
                            continue;
                        }
                        details.put(FLOOR, "Floor " + floor.getNumber());
                        details.put("Required", "At least two vehicle ramps of minimum 3.6 m width or one vehicle ramp of minimum 5.4 m width and in maximum 1:8 slope");
                        details.put("Provided", "Not Provided vehicle ramp with minimum 5.4 width or  two vehicle ramps of minimum 3.6 m width");
                        details.put("Status", Result.Not_Accepted.getResultVal());
                        this.scrutinyDetail.getDetail().add(details);
                        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
                        continue;
                    }
                    errors.put(DESCRIPTION, "Either ramp or mechanical lift is required");
                    pl.addErrors(errors);
                }
            }
        }
        return pl;
    }

    private void validateDimensions(Plan plan, String blockNo, int floorNo, String rampNo, List<Measurement> rampPolylines) {
        int count = 0;
        for (Measurement m : rampPolylines) {
            if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
            ++count;
        }
        if (count > 0) {
            plan.addError(String.format("BLK_%s_FLR_%s_VEHICLE_RAMP_%s", blockNo, floorNo, rampNo), count + " number of vehicle ramp polyline not having only 4 points in layer " + String.format("BLK_%s_FLR_%s_VEHICLE_RAMP_%s", blockNo, floorNo, rampNo));
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

