/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.service.ProcessHelper;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class TravelDistanceToExit
extends FeatureProcess {
    private static final String SUBRULE_42_2 = "42-2";
    private static final String SUBRULE_42_2_DESC = "Maximum travel distance to emergency exit";
    public static final BigDecimal VAL_30 = BigDecimal.valueOf(30L);
    public static final BigDecimal VAL_20 = BigDecimal.valueOf(20L);

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        Boolean exemption = Boolean.FALSE;
        if (pl != null && pl.getVirtualBuilding() != null && !pl.getVirtualBuilding().getOccupancyTypes().isEmpty() && !pl.getBlocks().isEmpty()) {
            boolean floorsAboveGroundLessThanOrEqualTo3ForAllBlks = true;
            for (Block block : pl.getBlocks()) {
                if (block.getBuilding() == null || block.getBuilding().getFloorsAboveGround() == null || block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(3L)) <= 0) continue;
                floorsAboveGroundLessThanOrEqualTo3ForAllBlks = false;
                break;
            }
            if (pl.getVirtualBuilding().getResidentialBuilding().equals(Boolean.TRUE) && floorsAboveGroundLessThanOrEqualTo3ForAllBlks || ProcessHelper.isSmallPlot(pl)) {
                exemption = Boolean.TRUE;
            }
        }
        if (!exemption.booleanValue()) {
            HashMap<String, String> errors = new HashMap<String, String>();
            if (pl != null && pl.getTravelDistancesToExit().isEmpty()) {
                errors.put(SUBRULE_42_2_DESC, this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{SUBRULE_42_2_DESC}, LocaleContextHolder.getLocale()));
                pl.addErrors(errors);
                return pl;
            }
            String subRule = SUBRULE_42_2;
            String subRuleDesc = SUBRULE_42_2_DESC;
            this.scrutinyDetail = new ScrutinyDetail();
            this.scrutinyDetail.setKey("Common_Travel Distance To Emergency Exits");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Required");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Provided");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Status");
            this.scrutinyDetail.setSubHeading(SUBRULE_42_2_DESC);
            if (pl != null && pl.getVirtualBuilding() != null) {
                OccupancyTypeHelper mostRestrictiveFarHelper = pl.getVirtualBuilding().getMostRestrictiveFarHelper();
                String code = mostRestrictiveFarHelper.getType().getCode();
                Map<String, BigDecimal> occupancyValues = this.getOccupancyValues();
                BigDecimal requiredValue = occupancyValues.get(code);
                if (requiredValue != null) {
                    for (BigDecimal maximumTravelDistance : pl.getTravelDistancesToExit()) {
                        boolean valid = false;
                        if (maximumTravelDistance.compareTo(requiredValue) <= 0) {
                            valid = true;
                        }
                        if (valid) {
                            this.setReportOutputDetails(pl, subRule, requiredValue + "(MTR)", maximumTravelDistance + "(MTR)", Result.Accepted.getResultVal());
                            continue;
                        }
                        this.setReportOutputDetails(pl, subRule, requiredValue + "(MTR)", maximumTravelDistance + "(MTR)", Result.Not_Accepted.getResultVal());
                    }
                }
            }
        }
        return pl;
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }

    public Map<String, BigDecimal> getOccupancyValues() {
        HashMap<String, BigDecimal> roadWidthValues = new HashMap<String, BigDecimal>();
        roadWidthValues.put("D", VAL_30);
        roadWidthValues.put("G", VAL_30);
        roadWidthValues.put("F", VAL_30);
        roadWidthValues.put("H", VAL_30);
        roadWidthValues.put("A", VAL_20);
        roadWidthValues.put("I", VAL_20);
        roadWidthValues.put("B", VAL_20);
        return roadWidthValues;
    }
}

