/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.common.entity.edcr.TerraceUtility;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.Util;
import org.springframework.stereotype.Service;

@Service
public class TerraceUtilityService
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(TerraceUtility.class);
    private static final String RULE_34 = "43-1";
    public static final String TERRACEUTILITIESDISTANCE = "TerraceUtilitiesDistance";
    public static final BigDecimal THREE = BigDecimal.valueOf(3L);
    public static final String ERROR_MSG = "Minimum_distance";

    @Override
    public Map<String, Date> getAmendments() {
        return null;
    }

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        if (pl.getBlocks() != null) {
            for (Block block : pl.getBlocks()) {
                ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
                scrutinyDetail.setKey("Block_" + block.getNumber() + "_Terrace Utility");
                scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
                scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Permitted");
                scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
                scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
                for (TerraceUtility terraceUtility : block.getTerraceUtilities()) {
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("Byelaw", RULE_34);
                    BigDecimal minDistance = (BigDecimal)terraceUtility.getDistances().stream().reduce(BigDecimal::min).get();
                    details.put("Description", terraceUtility.getName());
                    if (Util.roundOffTwoDecimal((BigDecimal)minDistance).compareTo(THREE) >= 0) {
                        details.put("Permitted", THREE + "(MTR)");
                        details.put("Provided", minDistance + "(MTR)");
                        details.put("Status", Result.Accepted.getResultVal());
                        scrutinyDetail.getDetail().add(details);
                        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                        continue;
                    }
                    details.put("Permitted", THREE + "(MTR)");
                    details.put("Provided", minDistance + "(MTR)");
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            }
        }
        return pl;
    }
}

