/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class StairCover
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(StairCover.class);
    private static final String RULE_44_C = "44-c";
    public static final String STAIRCOVER_DESCRIPTION = "Mumty";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Mumty");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Verified");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Action");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_44_C);
        BigDecimal minHeight = BigDecimal.ZERO;
        for (Block b : pl.getBlocks()) {
            minHeight = BigDecimal.ZERO;
            if (b.getStairCovers() == null || b.getStairCovers().isEmpty()) continue;
            minHeight = (BigDecimal)b.getStairCovers().stream().reduce(BigDecimal::min).get();
            if (minHeight.compareTo(new BigDecimal(3)) <= 0) {
                details.put("Description", STAIRCOVER_DESCRIPTION);
                details.put("Verified", "Verified whether stair cover height is <= 3 meters");
                details.put("Action", "Not included stair cover height(" + minHeight + ") to building height");
                details.put("Status", Result.Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                continue;
            }
            details.put("Description", STAIRCOVER_DESCRIPTION);
            details.put("Verified", "Verified whether stair cover height is <= 3 meters");
            details.put("Action", "Included stair cover height(" + minHeight + ") to building height");
            details.put("Status", Result.Verify.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

