/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Circle;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.Util;
import org.springframework.stereotype.Service;

@Service
public class SpiralStair
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(SpiralStair.class);
    private static final String FLOOR = "Floor";
    private static final String EXPECTED_DIAMETER = "1.50";
    private static final String RULE42_5_IV = "42-5-iv";
    private static final String DIAMETER_DESCRIPTION = "Minimum diameter for spiral fire stair %s";

    @Override
    public Plan process(Plan plan) {
        for (Block block : plan.getBlocks()) {
            if (block.getBuilding() == null || block.getBuilding().getOccupancies().isEmpty()) continue;
            ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
            scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Required");
            scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Permissible");
            scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetail.setKey("Block_" + block.getNumber() + "_Spiral Fire Stair");
            List floors = block.getBuilding().getFloors();
            for (Floor floor : floors) {
                boolean isTypicalRepititiveFloor = false;
                Map typicalFloorValues = Util.getTypicalFloorValues((Block)block, (Floor)floor, (Boolean)isTypicalRepititiveFloor);
                List spiralStairs = floor.getSpiralStairs();
                if (spiralStairs.size() == 0) continue;
                boolean valid = false;
                for (org.egov.common.entity.edcr.SpiralStair spiralStair : spiralStairs) {
                    BigDecimal minDiameter;
                    String value;
                    List spiralPolyLines = spiralStair.getCircles();
                    if (((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) continue;
                    if (Util.roundOffTwoDecimal((BigDecimal)block.getBuilding().getBuildingHeight()).compareTo(Util.roundOffTwoDecimal((BigDecimal)BigDecimal.valueOf(10L))) > 0 && !spiralPolyLines.isEmpty()) {
                        valid = true;
                    }
                    String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
                    if (valid) {
                        this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_IV, value, spiralStair.getNumber(), "", "spiral stair of fire stair not allowed for building with height > 9 for block " + block.getNumber() + " " + value, Result.Not_Accepted.getResultVal(), scrutinyDetail);
                        continue;
                    }
                    if (spiralPolyLines.isEmpty()) continue;
                    Circle minSpiralStair = spiralPolyLines.stream().min(Comparator.comparing(Circle::getRadius)).get();
                    BigDecimal minRadius = minSpiralStair.getRadius();
                    BigDecimal radius = Util.roundOffTwoDecimal((BigDecimal)minRadius);
                    BigDecimal diameter = Util.roundOffTwoDecimal((BigDecimal)radius.multiply(Util.roundOffTwoDecimal((BigDecimal)BigDecimal.valueOf(2L))));
                    if (diameter.compareTo(minDiameter = Util.roundOffTwoDecimal((BigDecimal)BigDecimal.valueOf(1.5))) >= 0) {
                        this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_IV, value, String.format(DIAMETER_DESCRIPTION, spiralStair.getNumber()), EXPECTED_DIAMETER, String.valueOf(diameter), Result.Accepted.getResultVal(), scrutinyDetail);
                        continue;
                    }
                    this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_IV, value, String.format(DIAMETER_DESCRIPTION, spiralStair.getNumber()), EXPECTED_DIAMETER, String.valueOf(diameter), Result.Not_Accepted.getResultVal(), scrutinyDetail);
                }
            }
        }
        return plan;
    }

    private void setReportOutputDetailsFloorStairWise(Plan pl, String ruleNo, String floor, String description, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put(FLOOR, floor);
        details.put("Description", description);
        details.put("Required", expected);
        details.put("Permissible", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

