/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.FloorUnit;
import org.egov.common.entity.edcr.OccupancyType;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class SolidLiquidWasteTreatment
extends FeatureProcess {
    public static final String SUBRULE_55_11_DESC = "Collection and disposal of solid and liquid Waste";
    private static final String SUBRULE_55_11 = "55-11";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        return pl;
    }

    private void processSolidLiquidWasteTreat(Plan pl) {
        this.validate(pl);
        this.scrutinyDetail = new ScrutinyDetail();
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Field Verified");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Status");
        this.scrutinyDetail.setKey("Common_Collection and disposal of Solid and Liquid Waste");
        if (pl != null && !pl.getBlocks().isEmpty()) {
            HashMap<String, String> details;
            Boolean isFound = false;
            for (Block b : pl.getBlocks()) {
                for (Floor f : b.getBuilding().getFloors()) {
                    for (FloorUnit unit : f.getUnits()) {
                        if (!OccupancyType.OCCUPANCY_E.equals((Object)unit.getOccupancy().getType())) continue;
                        isFound = true;
                    }
                }
            }
            if (isFound.booleanValue() && pl.getUtility().getSolidLiqdWasteTrtmnt().isEmpty()) {
                details = new HashMap<String, String>();
                details.put("Byelaw", SUBRULE_55_11);
                details.put("Description", SUBRULE_55_11_DESC);
                details.put("Field Verified", "Not Defined in plan. Verify whether required for defined Business.");
                details.put("Status", Result.Verify.getResultVal());
                this.scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
            } else if (isFound.booleanValue() && !pl.getUtility().getSolidLiqdWasteTrtmnt().isEmpty()) {
                details = new HashMap();
                details.put("Byelaw", SUBRULE_55_11);
                details.put("Description", SUBRULE_55_11_DESC);
                details.put("Field Verified", "Defined in the Plan.");
                details.put("Status", Result.Accepted.getResultVal());
                this.scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
            }
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

