/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.OccupancyType;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class Solar
extends FeatureProcess {
    private static final String SUB_RULE_109_C_DESCRIPTION = "Solar Assisted Water Heating / Lighting system ";
    private static final String SUB_RULE_109_C = "109-C";
    private static final BigDecimal FOURHUNDRED = BigDecimal.valueOf(400L);

    @Override
    public Plan validate(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (pl != null && pl.getUtility() != null && pl.getVirtualBuilding() != null && !pl.getVirtualBuilding().getOccupancies().isEmpty()) {
            for (OccupancyType occupancyType : pl.getVirtualBuilding().getOccupancies()) {
                if (occupancyType.equals((Object)OccupancyType.OCCUPANCY_A1) && pl.getVirtualBuilding().getTotalBuitUpArea() != null && pl.getVirtualBuilding().getTotalBuitUpArea().compareTo(FOURHUNDRED) > 0 && pl.getUtility().getSolar().isEmpty()) {
                    errors.put("Solar assisted water heating/lighting system ", this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{"msg.error.not.defined"}, LocaleContextHolder.getLocale()));
                    pl.addErrors(errors);
                    break;
                }
                if (!occupancyType.equals((Object)OccupancyType.OCCUPANCY_A4) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_A2) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_A3) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_C) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_C1) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_C2) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_C3) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_D) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_D1) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_D2) || pl.getVirtualBuilding().getTotalBuitUpArea() == null || pl.getVirtualBuilding().getTotalBuitUpArea().compareTo(BigDecimal.valueOf(500L)) <= 0 || !pl.getUtility().getSolar().isEmpty()) continue;
                errors.put("Solar assisted water heating/lighting system ", this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{"Solar assisted water heating/lighting system "}, LocaleContextHolder.getLocale()));
                pl.addErrors(errors);
                break;
            }
        }
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        this.validate(pl);
        this.scrutinyDetail = new ScrutinyDetail();
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        this.scrutinyDetail.setKey("Common_Solar");
        String rule = "RULE109";
        String subRule = SUB_RULE_109_C;
        String subRuleDesc = SUB_RULE_109_C_DESCRIPTION;
        if (pl.getVirtualBuilding() != null && !pl.getVirtualBuilding().getOccupancies().isEmpty()) {
            for (OccupancyType occupancyType : pl.getVirtualBuilding().getOccupancies()) {
                if (occupancyType.equals((Object)OccupancyType.OCCUPANCY_A1) && pl.getVirtualBuilding().getTotalBuitUpArea() != null && pl.getVirtualBuilding().getTotalBuitUpArea().compareTo(FOURHUNDRED) > 0) {
                    this.processSolar(pl, rule, subRule, subRuleDesc);
                    break;
                }
                if (!occupancyType.equals((Object)OccupancyType.OCCUPANCY_A4) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_A2) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_A3) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_C) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_C1) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_C2) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_C3) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_D) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_D1) && !occupancyType.equals((Object)OccupancyType.OCCUPANCY_D2) || pl.getVirtualBuilding().getTotalBuitUpArea() == null || pl.getVirtualBuilding().getTotalBuitUpArea().compareTo(BigDecimal.valueOf(500L)) <= 0) continue;
                this.processSolar(pl, rule, subRule, subRuleDesc);
                break;
            }
        }
        return pl;
    }

    private void processSolar(Plan pl, String rule, String subRule, String subRuleDesc) {
        if (!pl.getUtility().getSolar().isEmpty()) {
            this.setReportOutputDetailsWithoutOccupancy(pl, subRule, subRuleDesc, "", " Defined in the plan.", Result.Accepted.getResultVal());
            return;
        }
        this.setReportOutputDetailsWithoutOccupancy(pl, subRule, subRuleDesc, "", " Not defined in the plan.", Result.Not_Accepted.getResultVal());
    }

    private void setReportOutputDetailsWithoutOccupancy(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

