/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.HashMap;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Building;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Plot;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.common.entity.edcr.SetBack;
import org.egov.common.entity.edcr.Yard;
import org.egov.edcr.feature.GeneralRule;
import org.egov.infra.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SideYardService
extends GeneralRule {
    private static final BigDecimal SIDEVALUE_ONE = BigDecimal.valueOf(1L);
    private static final BigDecimal SIDEVALUE_ONE_TWO = BigDecimal.valueOf(1.2);
    private static final BigDecimal SIDEVALUE_ONEPOINTFIVE = BigDecimal.valueOf(1.5);
    private static final BigDecimal SIDEVALUE_ONEPOINTEIGHT = BigDecimal.valueOf(1.8);
    private static final BigDecimal SIDEVALUE_TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal SIDEVALUE_TWOPOINTFIVE = BigDecimal.valueOf(2.5);
    private static final BigDecimal SIDEVALUE_THREE = BigDecimal.valueOf(3L);
    private static final BigDecimal SIDEVALUE_THREEPOINTSIX = BigDecimal.valueOf(3.66);
    private static final BigDecimal SIDEVALUE_FOUR = BigDecimal.valueOf(4L);
    private static final BigDecimal SIDEVALUE_FOURPOINTFIVE = BigDecimal.valueOf(4.5);
    private static final BigDecimal SIDEVALUE_FIVE = BigDecimal.valueOf(5L);
    private static final BigDecimal SIDEVALUE_SIX = BigDecimal.valueOf(6L);
    private static final BigDecimal SIDEVALUE_SEVEN = BigDecimal.valueOf(7L);
    private static final BigDecimal SIDEVALUE_SEVENTYFIVE = BigDecimal.valueOf(0.75);
    private static final BigDecimal SIDEVALUE_EIGHT = BigDecimal.valueOf(8L);
    private static final BigDecimal SIDEVALUE_NINE = BigDecimal.valueOf(9L);
    private static final BigDecimal SIDEVALUE_TEN = BigDecimal.valueOf(10L);
    private static final String SIDENUMBER = "Side Number";
    private static final String MINIMUMLABEL = "Minimum distance ";
    private static final String RULE_35 = "35 Table-9";
    private static final String RULE_36 = "36";
    private static final String RULE_37_TWO_A = "37-2-A";
    private static final String RULE_37_TWO_B = "37-2-B";
    private static final String RULE_37_TWO_C = "37-2-C";
    private static final String RULE_37_TWO_D = "37-2-D";
    private static final String RULE_37_TWO_G = "37-2-G";
    private static final String RULE_37_TWO_H = "37-2-H";
    private static final String RULE_37_TWO_I = "37-2-I";
    private static final String RULE_47 = "47";
    private static final String SIDE_YARD_2_NOTDEFINED = "side2yardNodeDefined";
    private static final String SIDE_YARD_1_NOTDEFINED = "side1yardNodeDefined";
    public static final String BSMT_SIDE_YARD_DESC = "Basement Side Yard";
    private static final int PLOTAREA_300 = 300;
    public static final BigDecimal ROAD_WIDTH_TWELVE_POINTTWO = BigDecimal.valueOf(12.2);

    public void processSideYard(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        Plot plot = pl.getPlot();
        if (plot == null) {
            return;
        }
        this.validateSideYardRule(pl);
        Boolean valid = false;
        if (plot != null && !pl.getBlocks().isEmpty()) {
            for (Block block : pl.getBlocks()) {
                this.scrutinyDetail = new ScrutinyDetail();
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Level");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Occupancy");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), SIDENUMBER);
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Field Verified");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Permissible");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(7), "Provided");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(8), "Status");
                this.scrutinyDetail.setHeading("Side Setback");
                SideYardResult sideYard1Result = new SideYardResult();
                SideYardResult sideYard2Result = new SideYardResult();
                for (SetBack setback : block.getSetBacks()) {
                    Yard sideYard1 = null;
                    Yard sideYard2 = null;
                    if (setback.getSideYard1() != null && setback.getSideYard1().getMean().compareTo(BigDecimal.ZERO) > 0) {
                        sideYard1 = setback.getSideYard1();
                    }
                    if (setback.getSideYard2() != null && setback.getSideYard2().getMean().compareTo(BigDecimal.ZERO) > 0) {
                        sideYard2 = setback.getSideYard2();
                    }
                    if (sideYard1 != null || sideYard2 != null) {
                        BigDecimal buildingHeight = sideYard1 != null && sideYard1.getHeight() != null && sideYard1.getHeight().compareTo(BigDecimal.ZERO) > 0 && sideYard2 != null && sideYard2.getHeight() != null && sideYard2.getHeight().compareTo(BigDecimal.ZERO) > 0 ? (sideYard1.getHeight().compareTo(sideYard2.getHeight()) >= 0 ? sideYard1.getHeight() : sideYard2.getHeight()) : (sideYard1 != null && sideYard1.getHeight() != null && sideYard1.getHeight().compareTo(BigDecimal.ZERO) > 0 ? sideYard1.getHeight() : (sideYard2 != null && sideYard2.getHeight() != null && sideYard2.getHeight().compareTo(BigDecimal.ZERO) > 0 ? sideYard2.getHeight() : block.getBuilding().getBuildingHeight()));
                        double minlength = 0.0;
                        double max = 0.0;
                        double minMeanlength = 0.0;
                        double maxMeanLength = 0.0;
                        if (sideYard2 != null && sideYard1 != null) {
                            if (sideYard2.getMinimumDistance().doubleValue() > sideYard1.getMinimumDistance().doubleValue()) {
                                minlength = sideYard1.getMinimumDistance().doubleValue();
                                max = sideYard2.getMinimumDistance().doubleValue();
                            } else {
                                minlength = sideYard2.getMinimumDistance().doubleValue();
                                max = sideYard1.getMinimumDistance().doubleValue();
                            }
                        } else if (sideYard1 != null) {
                            max = sideYard1.getMinimumDistance().doubleValue();
                        } else {
                            minlength = sideYard2.getMinimumDistance().doubleValue();
                        }
                        if (buildingHeight != null && (minlength > 0.0 || max > 0.0)) {
                            for (Occupancy occupancy : block.getBuilding().getTotalArea()) {
                                this.scrutinyDetail.setKey("Block_" + block.getName() + "_Side Setback");
                                if (setback.getLevel() < 0) {
                                    this.scrutinyDetail.setKey("Block_" + block.getName() + "_Basement Side Yard");
                                    this.checkSideYardBasement(pl, block.getBuilding(), buildingHeight, block.getName(), setback.getLevel(), plot, minlength, max, minMeanlength, maxMeanLength, occupancy.getTypeHelper(), sideYard1Result, sideYard2Result);
                                }
                                if (occupancy.getTypeHelper().getSubtype() != null && ("A-R".equalsIgnoreCase(occupancy.getTypeHelper().getSubtype().getCode()) || "A-AF".equalsIgnoreCase(occupancy.getTypeHelper().getSubtype().getCode()) || "A-PO".equalsIgnoreCase(occupancy.getTypeHelper().getSubtype().getCode())) || "F".equalsIgnoreCase(occupancy.getTypeHelper().getType().getCode())) {
                                    if (buildingHeight.compareTo(BigDecimal.valueOf(10L)) <= 0 && block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(3L)) <= 0) {
                                        this.checkSideYardUptoTenMts(pl, block.getBuilding(), buildingHeight, block.getName(), setback.getLevel(), plot, minlength, max, minMeanlength, maxMeanLength, occupancy.getTypeHelper(), sideYard1Result, sideYard2Result);
                                        continue;
                                    }
                                    if (buildingHeight.compareTo(BigDecimal.valueOf(12L)) <= 0 && block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(4L)) <= 0) {
                                        this.checkSideYardUptoTwelveMts(pl, block.getBuilding(), buildingHeight, block.getName(), setback.getLevel(), plot, minlength, max, minMeanlength, maxMeanLength, occupancy.getTypeHelper(), sideYard1Result, sideYard2Result, errors);
                                        continue;
                                    }
                                    if (buildingHeight.compareTo(BigDecimal.valueOf(16L)) <= 0) {
                                        this.checkSideYardUptoSixteenMts(pl, block.getBuilding(), buildingHeight, block.getName(), setback.getLevel(), plot, minlength, max, minMeanlength, maxMeanLength, occupancy.getTypeHelper(), sideYard1Result, sideYard2Result, errors);
                                        continue;
                                    }
                                    if (buildingHeight.compareTo(BigDecimal.valueOf(16L)) <= 0) continue;
                                    this.checkSideYardAboveSixteenMts(pl, block.getBuilding(), buildingHeight, block.getName(), setback.getLevel(), plot, minlength, max, minMeanlength, maxMeanLength, occupancy.getTypeHelper(), sideYard1Result, sideYard2Result);
                                    continue;
                                }
                                if ("G".equalsIgnoreCase(occupancy.getTypeHelper().getType().getCode())) {
                                    this.checkSideYardForIndustrial(pl, block.getBuilding(), buildingHeight, block.getName(), setback.getLevel(), plot, minlength, max, minMeanlength, maxMeanLength, occupancy.getTypeHelper(), sideYard1Result, sideYard2Result);
                                    continue;
                                }
                                this.checkSideYardForOtherOccupancies(pl, block.getBuilding(), buildingHeight, block.getName(), setback.getLevel(), plot, minlength, max, minMeanlength, maxMeanLength, occupancy.getTypeHelper(), sideYard1Result, sideYard2Result);
                            }
                            this.addSideYardResult(pl, errors, sideYard1Result, sideYard2Result);
                        }
                        if (pl.getPlanInformation() == null || pl.getPlanInformation().getWidthOfPlot().compareTo(BigDecimal.valueOf(10L)) > 0) continue;
                        this.exemptSideYardForAAndF(pl, block, sideYard1Result, sideYard2Result);
                        continue;
                    }
                    if (pl.getPlanInformation() == null || pl.getPlanInformation().getWidthOfPlot().compareTo(BigDecimal.valueOf(10L)) > 0) continue;
                    this.exemptSideYardForAAndF(pl, block, sideYard1Result, sideYard2Result);
                    this.addSideYardResult(pl, errors, sideYard1Result, sideYard2Result);
                }
            }
        }
    }

    private void addSideYardResult(Plan pl, HashMap<String, String> errors, SideYardResult sideYard1Result, SideYardResult sideYard2Result) {
        if (sideYard1Result != null) {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", sideYard1Result.subRule);
            details.put("Level", sideYard1Result.level != null ? sideYard1Result.level.toString() : "");
            details.put("Occupancy", sideYard1Result.occupancy);
            details.put("Field Verified", MINIMUMLABEL);
            details.put("Permissible", sideYard1Result.expectedDistance.toString());
            details.put("Provided", sideYard1Result.actualDistance.toString());
            details.put(SIDENUMBER, "Side Setback 1");
            if (sideYard1Result.status) {
                details.put("Status", Result.Accepted.getResultVal());
            } else {
                details.put("Status", Result.Not_Accepted.getResultVal());
            }
            this.scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
        }
        if (errors.isEmpty() && sideYard2Result != null) {
            HashMap<String, String> detailsSideYard2 = new HashMap<String, String>();
            detailsSideYard2.put("Byelaw", sideYard2Result.subRule);
            detailsSideYard2.put("Level", sideYard2Result.level != null ? sideYard2Result.level.toString() : "");
            detailsSideYard2.put("Occupancy", sideYard2Result.occupancy);
            detailsSideYard2.put(SIDENUMBER, "Side Setback 2");
            detailsSideYard2.put("Field Verified", MINIMUMLABEL);
            detailsSideYard2.put("Permissible", sideYard2Result.expectedDistance.toString());
            detailsSideYard2.put("Provided", sideYard2Result.actualDistance.toString());
            if (sideYard2Result.status) {
                detailsSideYard2.put("Status", Result.Accepted.getResultVal());
            } else {
                detailsSideYard2.put("Status", Result.Not_Accepted.getResultVal());
            }
            this.scrutinyDetail.getDetail().add(detailsSideYard2);
            pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
        }
    }

    private void exemptSideYardForAAndF(Plan pl, Block block, SideYardResult sideYard1Result, SideYardResult sideYard2Result) {
        for (Occupancy occupancy : block.getBuilding().getTotalArea()) {
            this.scrutinyDetail.setKey("Block_" + block.getName() + "_Side Setback");
            if (occupancy.getTypeHelper().getType() != null && "A".equalsIgnoreCase(occupancy.getTypeHelper().getType().getCode()) || "F".equalsIgnoreCase(occupancy.getTypeHelper().getType().getCode())) {
                if (pl.getErrors().containsKey(SIDE_YARD_2_NOTDEFINED)) {
                    pl.getErrors().remove(SIDE_YARD_2_NOTDEFINED);
                }
                if (pl.getErrors().containsKey(SIDE_YARD_1_NOTDEFINED)) {
                    pl.getErrors().remove(SIDE_YARD_1_NOTDEFINED);
                }
                if (pl.getErrors().containsKey("Side Setback")) {
                    pl.getErrors().remove("Side Setback");
                }
                if (pl.getErrors().containsValue("BLK_" + block.getNumber() + "_LVL_0_SIDE_SETBACK1 not defined in the plan.")) {
                    pl.getErrors().remove("", "BLK_" + block.getNumber() + "_LVL_0_SIDE_SETBACK1 not defined in the plan.");
                }
                if (pl.getErrors().containsValue("BLK_" + block.getNumber() + "_LVL_0_SIDE_SETBACK2 not defined in the plan.")) {
                    pl.getErrors().remove("", "BLK_" + block.getNumber() + "_LVL_0_SIDE_SETBACK2 not defined in the plan.");
                }
            }
            this.compareSideYard2Result(block.getName(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, occupancy.getTypeHelper(), sideYard2Result, true, RULE_35, "Side Setback", 0);
            this.compareSideYard1Result(block.getName(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, occupancy.getTypeHelper(), sideYard1Result, true, RULE_35, "Side Setback", 0);
        }
    }

    private void checkSideYardUptoTenMts(Plan pl, Building building, BigDecimal buildingHeight, String blockName, Integer level, Plot plot, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result) {
        String rule = "Side Setback";
        String subRule = RULE_35;
        Boolean valid2 = false;
        Boolean valid1 = false;
        BigDecimal side2val = BigDecimal.ZERO;
        BigDecimal side1val = BigDecimal.ZERO;
        BigDecimal widthOfPlot = pl.getPlanInformation().getWidthOfPlot();
        if (mostRestrictiveOccupancy.getSubtype() != null && ("A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()))) {
            if (pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null && StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) && "COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) && pl.getPlanInformation().getRoadWidth().compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                this.checkCommercialUptoSixteen(blockName, level, min, max, minMeanlength, maxMeanLength, mostRestrictiveOccupancy, sideYard1Result, sideYard2Result, rule, "28", valid2, valid1, side2val, side1val, widthOfPlot);
            } else {
                this.checkResidentialUptoTenMts(pl, blockName, level, min, max, minMeanlength, maxMeanLength, mostRestrictiveOccupancy, sideYard1Result, sideYard2Result, rule, subRule, valid2, valid1, side2val, side1val, widthOfPlot);
            }
        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            this.checkCommercialUptoSixteen(blockName, level, min, max, minMeanlength, maxMeanLength, mostRestrictiveOccupancy, sideYard1Result, sideYard2Result, rule, subRule, valid2, valid1, side2val, side1val, widthOfPlot);
        }
    }

    private void checkResidentialUptoTenMts(Plan pl, String blockName, Integer level, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result, String rule, String subRule, Boolean valid2, Boolean valid1, BigDecimal side2val, BigDecimal side1val, BigDecimal widthOfPlot) {
        if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            if (pl.getErrors().containsKey(SIDE_YARD_2_NOTDEFINED)) {
                pl.getErrors().remove(SIDE_YARD_2_NOTDEFINED);
            }
            if (pl.getErrors().containsKey(SIDE_YARD_1_NOTDEFINED)) {
                pl.getErrors().remove(SIDE_YARD_1_NOTDEFINED);
            }
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            side2val = SIDEVALUE_SEVENTYFIVE;
            side1val = SIDEVALUE_SEVENTYFIVE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            side2val = SIDEVALUE_ONE;
            side1val = SIDEVALUE_ONE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            side2val = SIDEVALUE_ONEPOINTFIVE;
            side1val = SIDEVALUE_ONEPOINTFIVE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            side2val = SIDEVALUE_ONEPOINTFIVE;
            side1val = SIDEVALUE_ONEPOINTFIVE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            side2val = SIDEVALUE_TWO;
            side1val = SIDEVALUE_TWO;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            side2val = SIDEVALUE_TWO;
            side1val = SIDEVALUE_TWO;
        }
        if (max >= side1val.doubleValue()) {
            valid1 = true;
        }
        if (min >= side2val.doubleValue()) {
            valid2 = true;
        }
        this.compareSideYard2Result(blockName, side2val, BigDecimal.valueOf(min), BigDecimal.ZERO, BigDecimal.valueOf(minMeanlength), mostRestrictiveOccupancy, sideYard2Result, valid2, subRule, rule, level);
        this.compareSideYard1Result(blockName, side1val, BigDecimal.valueOf(max), BigDecimal.ZERO, BigDecimal.valueOf(maxMeanLength), mostRestrictiveOccupancy, sideYard1Result, valid1, subRule, rule, level);
    }

    private void checkSideYardBasement(Plan pl, Building building, BigDecimal buildingHeight, String blockName, Integer level, Plot plot, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result) {
        String rule = "Side Setback";
        String subRule = RULE_47;
        Boolean valid2 = false;
        Boolean valid1 = false;
        BigDecimal side2val = BigDecimal.ZERO;
        BigDecimal side1val = BigDecimal.ZERO;
        if ((mostRestrictiveOccupancy.getSubtype() != null && "A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) && plot.getArea().compareTo(BigDecimal.valueOf(300L)) <= 0) {
            side2val = SIDEVALUE_THREE;
            side1val = SIDEVALUE_THREE;
            if (max >= side1val.doubleValue()) {
                valid1 = true;
            }
            if (min >= side2val.doubleValue()) {
                valid2 = true;
            }
            rule = BSMT_SIDE_YARD_DESC;
            this.compareSideYard2Result(blockName, side2val, BigDecimal.valueOf(min), BigDecimal.ZERO, BigDecimal.valueOf(minMeanlength), mostRestrictiveOccupancy, sideYard2Result, valid2, subRule, rule, level);
            this.compareSideYard1Result(blockName, side1val, BigDecimal.valueOf(max), BigDecimal.ZERO, BigDecimal.valueOf(maxMeanLength), mostRestrictiveOccupancy, sideYard1Result, valid1, subRule, rule, level);
        }
    }

    private void checkSideYardForIndustrial(Plan pl, Building building, BigDecimal buildingHeight, String blockName, Integer level, Plot plot, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result) {
        String rule = "Side Setback";
        String subRule = RULE_35;
        Boolean valid2 = false;
        Boolean valid1 = false;
        BigDecimal side2val = BigDecimal.ZERO;
        BigDecimal side1val = BigDecimal.ZERO;
        BigDecimal widthOfPlot = pl.getPlanInformation().getWidthOfPlot();
        BigDecimal plotArea = pl.getPlot().getArea();
        if (plotArea.compareTo(BigDecimal.valueOf(550L)) < 0) {
            if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
                side2val = SIDEVALUE_ONEPOINTFIVE;
                side1val = SIDEVALUE_ONEPOINTFIVE;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(12L)) <= 0) {
                side2val = SIDEVALUE_TWO;
                side1val = SIDEVALUE_TWO;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
                side2val = SIDEVALUE_THREE;
                side1val = SIDEVALUE_THREE;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(18L)) <= 0) {
                side2val = SIDEVALUE_FOUR;
                side1val = SIDEVALUE_FOUR;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(18L)) > 0) {
                side2val = SIDEVALUE_FOURPOINTFIVE;
                side1val = SIDEVALUE_FOURPOINTFIVE;
            }
        } else if (plotArea.compareTo(BigDecimal.valueOf(550L)) > 0 && plotArea.compareTo(BigDecimal.valueOf(1000L)) <= 0) {
            side2val = SIDEVALUE_FOURPOINTFIVE;
            side1val = SIDEVALUE_FOURPOINTFIVE;
        } else if (plotArea.compareTo(BigDecimal.valueOf(1000L)) > 0 && plotArea.compareTo(BigDecimal.valueOf(5000L)) <= 0) {
            side2val = SIDEVALUE_SIX;
            side1val = SIDEVALUE_SIX;
        } else if (plotArea.compareTo(BigDecimal.valueOf(5000L)) > 0 && plotArea.compareTo(BigDecimal.valueOf(30000L)) <= 0) {
            side2val = SIDEVALUE_NINE;
            side1val = SIDEVALUE_NINE;
        } else if (plotArea.compareTo(BigDecimal.valueOf(30000L)) > 0) {
            side2val = SIDEVALUE_TEN;
            side1val = SIDEVALUE_TEN;
        }
        if (max >= side1val.doubleValue()) {
            valid1 = true;
        }
        if (min >= side2val.doubleValue()) {
            valid2 = true;
        }
        this.compareSideYard2Result(blockName, side2val, BigDecimal.valueOf(min), BigDecimal.ZERO, BigDecimal.valueOf(minMeanlength), mostRestrictiveOccupancy, sideYard2Result, valid2, subRule, rule, level);
        this.compareSideYard1Result(blockName, side1val, BigDecimal.valueOf(max), BigDecimal.ZERO, BigDecimal.valueOf(maxMeanLength), mostRestrictiveOccupancy, sideYard1Result, valid1, subRule, rule, level);
    }

    private void checkSideYardForOtherOccupancies(Plan pl, Building building, BigDecimal buildingHeight, String blockName, Integer level, Plot plot, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result) {
        String rule = "Side Setback";
        String subRule = RULE_35;
        Boolean valid2 = false;
        Boolean valid1 = false;
        BigDecimal side2val = BigDecimal.ZERO;
        BigDecimal side1val = BigDecimal.ZERO;
        if (mostRestrictiveOccupancy.getType() != null && "B".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            side2val = SIDEVALUE_SIX;
            side1val = SIDEVALUE_SIX;
            subRule = RULE_37_TWO_A;
        }
        if (mostRestrictiveOccupancy.getType() != null && "B".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            side2val = SIDEVALUE_SIX;
            side1val = SIDEVALUE_SIX;
            subRule = RULE_37_TWO_B;
        }
        if (mostRestrictiveOccupancy.getType() != null && "D".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            side2val = SIDEVALUE_SIX;
            side1val = SIDEVALUE_SIX;
            subRule = RULE_37_TWO_C;
        }
        if (mostRestrictiveOccupancy.getType() != null && "D".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            side2val = SIDEVALUE_SEVEN;
            side1val = SIDEVALUE_SEVEN;
            subRule = RULE_37_TWO_D;
        }
        if (mostRestrictiveOccupancy.getType() != null && "I".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            side2val = SIDEVALUE_NINE;
            side1val = SIDEVALUE_NINE;
            subRule = RULE_37_TWO_G;
        }
        if (mostRestrictiveOccupancy.getType() != null && "A".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            side2val = SIDEVALUE_THREE;
            side1val = SIDEVALUE_THREE;
            subRule = RULE_37_TWO_H;
        }
        if (mostRestrictiveOccupancy.getType() != null && "F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            subRule = RULE_37_TWO_I;
        }
        if (max >= side1val.doubleValue()) {
            valid1 = true;
        }
        if (min >= side2val.doubleValue()) {
            valid2 = true;
        }
        this.compareSideYard2Result(blockName, side2val, BigDecimal.valueOf(min), BigDecimal.ZERO, BigDecimal.valueOf(minMeanlength), mostRestrictiveOccupancy, sideYard2Result, valid2, subRule, rule, level);
        this.compareSideYard1Result(blockName, side1val, BigDecimal.valueOf(max), BigDecimal.ZERO, BigDecimal.valueOf(maxMeanLength), mostRestrictiveOccupancy, sideYard1Result, valid1, subRule, rule, level);
    }

    private void checkSideYardUptoTwelveMts(Plan pl, Building building, BigDecimal buildingHeight, String blockName, Integer level, Plot plot, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result, HashMap<String, String> errors) {
        String rule = "Side Setback";
        String subRule = RULE_35;
        Boolean valid2 = false;
        Boolean valid1 = false;
        BigDecimal side2val = BigDecimal.ZERO;
        BigDecimal side1val = BigDecimal.ZERO;
        BigDecimal widthOfPlot = pl.getPlanInformation().getWidthOfPlot();
        if (mostRestrictiveOccupancy.getSubtype() != null && "A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode())) {
            if (pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null && StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) && "COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) && pl.getPlanInformation().getRoadWidth().compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                this.checkCommercialUptoSixteen(blockName, level, min, max, minMeanlength, maxMeanLength, mostRestrictiveOccupancy, sideYard1Result, sideYard2Result, rule, "28", valid2, valid1, side2val, side1val, widthOfPlot);
            } else {
                this.checkResidentialUptoTwelveMts(pl, blockName, level, min, max, minMeanlength, maxMeanLength, mostRestrictiveOccupancy, sideYard1Result, sideYard2Result, errors, rule, subRule, valid2, valid1, side2val, side1val, widthOfPlot);
            }
        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            this.checkCommercialUptoSixteen(blockName, level, min, max, minMeanlength, maxMeanLength, mostRestrictiveOccupancy, sideYard1Result, sideYard2Result, rule, subRule, valid2, valid1, side2val, side1val, widthOfPlot);
        }
    }

    private void checkResidentialUptoTwelveMts(Plan pl, String blockName, Integer level, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result, HashMap<String, String> errors, String rule, String subRule, Boolean valid2, Boolean valid1, BigDecimal side2val, BigDecimal side1val, BigDecimal widthOfPlot) {
        if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            errors.put("uptoTwelveHeightUptoTenWidthSideYard", "No construction shall be permitted if width of plot is less than 10 and building height less than 12 having floors upto G+3.");
            pl.addErrors(errors);
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            side2val = SIDEVALUE_ONEPOINTFIVE;
            side1val = SIDEVALUE_ONEPOINTFIVE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            side2val = SIDEVALUE_ONEPOINTFIVE;
            side1val = SIDEVALUE_ONEPOINTFIVE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            side2val = SIDEVALUE_TWO;
            side1val = SIDEVALUE_TWO;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            side2val = SIDEVALUE_TWOPOINTFIVE;
            side1val = SIDEVALUE_TWOPOINTFIVE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            side2val = SIDEVALUE_THREE;
            side1val = SIDEVALUE_THREE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            side2val = SIDEVALUE_THREEPOINTSIX;
            side1val = SIDEVALUE_THREEPOINTSIX;
        }
        if (max >= side1val.doubleValue()) {
            valid1 = true;
        }
        if (min >= side2val.doubleValue()) {
            valid2 = true;
        }
        this.compareSideYard2Result(blockName, side2val, BigDecimal.valueOf(min), BigDecimal.ZERO, BigDecimal.valueOf(minMeanlength), mostRestrictiveOccupancy, sideYard2Result, valid2, subRule, rule, level);
        this.compareSideYard1Result(blockName, side1val, BigDecimal.valueOf(max), BigDecimal.ZERO, BigDecimal.valueOf(maxMeanLength), mostRestrictiveOccupancy, sideYard1Result, valid1, subRule, rule, level);
    }

    private void checkSideYardUptoSixteenMts(Plan pl, Building building, BigDecimal buildingHeight, String blockName, Integer level, Plot plot, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result, HashMap<String, String> errors) {
        String rule = "Side Setback";
        String subRule = RULE_35;
        Boolean valid2 = false;
        Boolean valid1 = false;
        BigDecimal side2val = SIDEVALUE_ONE;
        BigDecimal side1val = SIDEVALUE_ONE_TWO;
        BigDecimal widthOfPlot = pl.getPlanInformation().getWidthOfPlot();
        if (mostRestrictiveOccupancy.getSubtype() != null && "A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode())) {
            if (pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null && StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) && "COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) && pl.getPlanInformation().getRoadWidth().compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                this.checkCommercialUptoSixteen(blockName, level, min, max, minMeanlength, maxMeanLength, mostRestrictiveOccupancy, sideYard1Result, sideYard2Result, rule, "28", valid2, valid1, side2val, side1val, widthOfPlot);
            } else {
                this.checkResidentialUptoSixteen(pl, blockName, level, min, max, minMeanlength, maxMeanLength, mostRestrictiveOccupancy, sideYard1Result, sideYard2Result, errors, subRule, valid2, valid1, side2val, side1val, widthOfPlot);
            }
        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            this.checkCommercialUptoSixteen(blockName, level, min, max, minMeanlength, maxMeanLength, mostRestrictiveOccupancy, sideYard1Result, sideYard2Result, rule, subRule, valid2, valid1, side2val, side1val, widthOfPlot);
        }
    }

    private void checkCommercialUptoSixteen(String blockName, Integer level, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result, String rule, String subRule, Boolean valid2, Boolean valid1, BigDecimal side2val, BigDecimal side1val, BigDecimal widthOfPlot) {
        if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0) {
            if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
                side2val = SIDEVALUE_TWO;
                side1val = SIDEVALUE_TWO;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
                side2val = SIDEVALUE_TWOPOINTFIVE;
                side1val = SIDEVALUE_TWOPOINTFIVE;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
                side2val = SIDEVALUE_THREE;
                side1val = SIDEVALUE_THREE;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
                side2val = SIDEVALUE_FOUR;
                side1val = SIDEVALUE_FOUR;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
                side2val = SIDEVALUE_FIVE;
                side1val = SIDEVALUE_FIVE;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
                side2val = SIDEVALUE_SIX;
                side1val = SIDEVALUE_SIX;
            }
        }
        if (max >= side1val.doubleValue()) {
            valid1 = true;
        }
        if (min >= side2val.doubleValue()) {
            valid2 = true;
        }
        this.compareSideYard2Result(blockName, side2val, BigDecimal.valueOf(min), BigDecimal.ZERO, BigDecimal.valueOf(minMeanlength), mostRestrictiveOccupancy, sideYard2Result, valid2, subRule, rule, level);
        this.compareSideYard1Result(blockName, side1val, BigDecimal.valueOf(max), BigDecimal.ZERO, BigDecimal.valueOf(maxMeanLength), mostRestrictiveOccupancy, sideYard1Result, valid1, subRule, rule, level);
    }

    private void checkResidentialUptoSixteen(Plan pl, String blockName, Integer level, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result, HashMap<String, String> errors, String rule, Boolean valid2, Boolean valid1, BigDecimal side2val, BigDecimal side1val, BigDecimal widthOfPlot) {
        if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            errors.put("uptoSixteenHeightUptoTenWidthSideYard", "No construction shall be permitted if width of plot is less than 10 and building height less than 16 having floors upto G+4.");
            pl.addErrors(errors);
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            side2val = SIDEVALUE_ONEPOINTEIGHT;
            side1val = SIDEVALUE_ONEPOINTEIGHT;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            side2val = SIDEVALUE_TWO;
            side1val = SIDEVALUE_TWO;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            side2val = SIDEVALUE_TWOPOINTFIVE;
            side1val = SIDEVALUE_TWOPOINTFIVE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            side2val = SIDEVALUE_THREE;
            side1val = SIDEVALUE_THREE;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            side2val = SIDEVALUE_THREEPOINTSIX;
            side1val = SIDEVALUE_THREEPOINTSIX;
        } else if (widthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && widthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            side2val = SIDEVALUE_FOUR;
            side1val = SIDEVALUE_FOUR;
        }
        if (max >= side1val.doubleValue()) {
            valid1 = true;
        }
        if (min >= side2val.doubleValue()) {
            valid2 = true;
        }
        this.compareSideYard2Result(blockName, side2val, BigDecimal.valueOf(min), BigDecimal.ZERO, BigDecimal.valueOf(minMeanlength), mostRestrictiveOccupancy, sideYard2Result, valid2, rule, rule, level);
        this.compareSideYard1Result(blockName, side1val, BigDecimal.valueOf(max), BigDecimal.ZERO, BigDecimal.valueOf(maxMeanLength), mostRestrictiveOccupancy, sideYard1Result, valid1, rule, rule, level);
    }

    private void checkSideYardAboveSixteenMts(Plan pl, Building building, BigDecimal blockBuildingHeight, String blockName, Integer level, Plot plot, double min, double max, double minMeanlength, double maxMeanLength, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, SideYardResult sideYard2Result) {
        String rule = "Side Setback";
        String subRule = RULE_36;
        Boolean valid2 = false;
        Boolean valid1 = false;
        BigDecimal side2val = SIDEVALUE_ONE;
        BigDecimal side1val = SIDEVALUE_ONE_TWO;
        if (blockBuildingHeight.compareTo(BigDecimal.valueOf(16L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(19L)) <= 0) {
            side2val = SIDEVALUE_FOURPOINTFIVE;
            side1val = SIDEVALUE_FOURPOINTFIVE;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(19L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(22L)) <= 0) {
            side2val = SIDEVALUE_FOURPOINTFIVE;
            side1val = SIDEVALUE_FOURPOINTFIVE;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(22L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(25L)) <= 0) {
            side2val = SIDEVALUE_FIVE;
            side1val = SIDEVALUE_FIVE;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(25L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(28L)) <= 0) {
            side2val = SIDEVALUE_SIX;
            side1val = SIDEVALUE_SIX;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(28L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(31L)) <= 0) {
            side2val = SIDEVALUE_SEVEN;
            side1val = SIDEVALUE_SEVEN;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(31L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(36L)) <= 0) {
            side2val = SIDEVALUE_SEVEN;
            side1val = SIDEVALUE_SEVEN;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(36L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(41L)) <= 0) {
            side2val = SIDEVALUE_EIGHT;
            side1val = SIDEVALUE_EIGHT;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(41L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(46L)) <= 0) {
            side2val = SIDEVALUE_EIGHT;
            side1val = SIDEVALUE_EIGHT;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(46L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(51L)) <= 0) {
            side2val = SIDEVALUE_NINE;
            side1val = SIDEVALUE_NINE;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(51L)) > 0) {
            side2val = SIDEVALUE_NINE;
            side1val = SIDEVALUE_NINE;
        }
        if (max >= side1val.doubleValue()) {
            valid1 = true;
        }
        if (min >= side2val.doubleValue()) {
            valid2 = true;
        }
        this.compareSideYard2Result(blockName, side2val, BigDecimal.valueOf(min), BigDecimal.ZERO, BigDecimal.valueOf(minMeanlength), mostRestrictiveOccupancy, sideYard2Result, valid2, subRule, rule, level);
        this.compareSideYard1Result(blockName, side1val, BigDecimal.valueOf(max), BigDecimal.ZERO, BigDecimal.valueOf(maxMeanLength), mostRestrictiveOccupancy, sideYard1Result, valid1, subRule, rule, level);
    }

    private void compareSideYard1Result(String blockName, BigDecimal exptDistance, BigDecimal actualDistance, BigDecimal expectedMeanDistance, BigDecimal actualMeanDistance, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard1Result, Boolean valid, String subRule, String rule, Integer level) {
        String occupancyName = mostRestrictiveOccupancy.getSubtype() != null ? mostRestrictiveOccupancy.getSubtype().getName() : mostRestrictiveOccupancy.getType().getName();
        if (exptDistance.compareTo(sideYard1Result.expectedDistance) >= 0) {
            if (exptDistance.compareTo(sideYard1Result.expectedDistance) == 0) {
                sideYard1Result.rule = sideYard1Result.rule != null ? sideYard1Result.rule + "," + rule : rule;
                sideYard1Result.occupancy = sideYard1Result.occupancy != null ? sideYard1Result.occupancy + "," + occupancyName : occupancyName;
            } else {
                sideYard1Result.rule = rule;
                sideYard1Result.occupancy = occupancyName;
            }
            sideYard1Result.subRule = subRule;
            sideYard1Result.blockName = blockName;
            sideYard1Result.level = level;
            sideYard1Result.actualDistance = actualDistance;
            sideYard1Result.expectedDistance = exptDistance;
            sideYard1Result.status = valid;
        }
    }

    private void compareSideYard2Result(String blockName, BigDecimal exptDistance, BigDecimal actualDistance, BigDecimal expectedMeanDistance, BigDecimal actualMeanDistance, OccupancyTypeHelper mostRestrictiveOccupancy, SideYardResult sideYard2Result, Boolean valid, String subRule, String rule, Integer level) {
        String occupancyName = mostRestrictiveOccupancy.getSubtype() != null ? mostRestrictiveOccupancy.getSubtype().getName() : mostRestrictiveOccupancy.getType().getName();
        if (exptDistance.compareTo(sideYard2Result.expectedDistance) >= 0) {
            if (exptDistance.compareTo(sideYard2Result.expectedDistance) == 0) {
                sideYard2Result.rule = sideYard2Result.rule != null ? sideYard2Result.rule + "," + rule : rule;
                sideYard2Result.occupancy = sideYard2Result.occupancy != null ? sideYard2Result.occupancy + "," + occupancyName : occupancyName;
            } else {
                sideYard2Result.rule = rule;
                sideYard2Result.occupancy = occupancyName;
            }
            sideYard2Result.subRule = subRule;
            sideYard2Result.blockName = blockName;
            sideYard2Result.level = level;
            sideYard2Result.actualDistance = actualDistance;
            sideYard2Result.expectedDistance = exptDistance;
            sideYard2Result.status = valid;
        }
    }

    private void validateSideYardRule(Plan pl) {
        for (Block block : pl.getBlocks()) {
            if (block.getCompletelyExisting().booleanValue()) continue;
            Boolean sideYardDefined = false;
            for (SetBack setback : block.getSetBacks()) {
                if (setback.getSideYard1() != null && setback.getSideYard1().getMean().compareTo(BigDecimal.valueOf(0L)) > 0) {
                    sideYardDefined = true;
                    continue;
                }
                if (setback.getSideYard2() == null || setback.getSideYard2().getMean().compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                sideYardDefined = true;
            }
            if (sideYardDefined.booleanValue()) continue;
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("Side Setback", this.prepareMessage("msg.error.not.defined", "Side Setback for Block " + block.getName()));
            pl.addErrors(errors);
        }
    }

    private class SideYardResult {
        String rule;
        String subRule;
        String blockName;
        Integer level;
        BigDecimal actualMeanDistance = BigDecimal.ZERO;
        BigDecimal actualDistance = BigDecimal.ZERO;
        String occupancy;
        BigDecimal expectedDistance = BigDecimal.ZERO;
        BigDecimal expectedmeanDistance = BigDecimal.ZERO;
        boolean status = false;

        private SideYardResult() {
        }
    }
}

