/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.SetBack;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.feature.FrontYardService;
import org.egov.edcr.feature.RearYardService;
import org.egov.edcr.feature.SideYardService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SetBackService
extends FeatureProcess {
    @Autowired
    private FrontYardService frontYardService;
    @Autowired
    private SideYardService sideYardService;
    @Autowired
    private RearYardService rearYardService;

    @Override
    public Plan validate(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        BigDecimal heightOfBuilding = BigDecimal.ZERO;
        for (Block block : pl.getBlocks()) {
            heightOfBuilding = block.getBuilding().getBuildingHeight();
            int i = 0;
            if (block.getCompletelyExisting().booleanValue()) continue;
            for (SetBack setback : block.getSetBacks()) {
                ++i;
                if (setback.getLevel() == 0) {
                    if (setback.getFrontYard() == null) {
                        errors.put("frontyardNodeDefined", this.getLocaleMessage("msg.error.not.defined", " SetBack of " + block.getName() + "  at level zero "));
                    }
                    if (setback.getRearYard() == null && !pl.getPlanInformation().getNocToAbutRearDesc().equalsIgnoreCase("YES")) {
                        errors.put("rearyardNodeDefined", this.getLocaleMessage("msg.error.not.defined", " Rear Setback of  " + block.getName() + "  at level zero "));
                    }
                    if (setback.getSideYard1() == null) {
                        errors.put("side1yardNodeDefined", this.getLocaleMessage("msg.error.not.defined", " Side Setback 1 of block " + block.getName() + " at level zero"));
                    }
                    if (setback.getSideYard2() == null && !pl.getPlanInformation().getNocToAbutSideDesc().equalsIgnoreCase("YES")) {
                        errors.put("side2yardNodeDefined", this.getLocaleMessage("msg.error.not.defined", " Side Setback 2 of block " + block.getName() + " at level zero "));
                    }
                } else if (setback.getLevel() > 0) {
                    if (setback.getFrontYard() != null && setback.getFrontYard().getHeight() == null) {
                        errors.put("frontyardnotDefinedHeight", this.getLocaleMessage("msg.height.notdefined", "Front Setback ", block.getName(), setback.getLevel().toString()));
                    }
                    if (setback.getRearYard() != null && setback.getRearYard().getHeight() == null) {
                        errors.put("rearyardnotDefinedHeight", this.getLocaleMessage("msg.height.notdefined", "Rear Setback ", block.getName(), setback.getLevel().toString()));
                    }
                    if (setback.getSideYard1() != null && setback.getSideYard1().getHeight() == null) {
                        errors.put("side1yardnotDefinedHeight", this.getLocaleMessage("msg.height.notdefined", "Side Setback 1 ", block.getName(), setback.getLevel().toString()));
                    }
                    if (setback.getSideYard2() != null && setback.getSideYard2().getHeight() == null) {
                        errors.put("side2yardnotDefinedHeight", this.getLocaleMessage("msg.height.notdefined", "Side Setback 2 ", block.getName(), setback.getLevel().toString()));
                    }
                }
                if (setback.getLevel() <= 0 || block.getSetBacks().size() != i) continue;
                if (setback.getFrontYard() != null && setback.getFrontYard().getHeight() != null && setback.getFrontYard().getHeight().compareTo(heightOfBuilding) != 0) {
                    errors.put("frontyardDefinedWrongHeight", this.getLocaleMessage("msg.wrong.height.defined", "Front Setback ", block.getName(), setback.getLevel().toString(), heightOfBuilding.toString()));
                }
                if (setback.getRearYard() != null && setback.getRearYard().getHeight() != null && setback.getRearYard().getHeight().compareTo(heightOfBuilding) != 0) {
                    errors.put("rearyardDefinedWrongHeight", this.getLocaleMessage("msg.wrong.height.defined", "Rear Setback ", block.getName(), setback.getLevel().toString(), heightOfBuilding.toString()));
                }
                if (setback.getSideYard1() != null && setback.getSideYard1().getHeight() != null && setback.getSideYard1().getHeight().compareTo(heightOfBuilding) != 0) {
                    errors.put("side1yardDefinedWrongHeight", this.getLocaleMessage("msg.wrong.height.defined", "Side Setback 1 ", block.getName(), setback.getLevel().toString(), heightOfBuilding.toString()));
                }
                if (setback.getSideYard2() == null || setback.getSideYard2().getHeight() == null || setback.getSideYard2().getHeight().compareTo(heightOfBuilding) == 0) continue;
                errors.put("side2yardDefinedWrongHeight", this.getLocaleMessage("msg.wrong.height.defined", "Side Setback 2 ", block.getName(), setback.getLevel().toString(), heightOfBuilding.toString()));
            }
        }
        if (errors.size() > 0) {
            pl.addErrors(errors);
        }
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        BigDecimal widthOfPlot;
        this.validate(pl);
        BigDecimal depthOfPlot = pl.getPlanInformation().getDepthOfPlot();
        if (depthOfPlot != null && depthOfPlot.compareTo(BigDecimal.ZERO) > 0) {
            this.frontYardService.processFrontYard(pl);
            this.rearYardService.processRearYard(pl);
        }
        if ((widthOfPlot = pl.getPlanInformation().getWidthOfPlot()) != null && widthOfPlot.compareTo(BigDecimal.ZERO) > 0) {
            this.sideYardService.processSideYard(pl);
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

