/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class SepticTank
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(SepticTank.class);
    private static final String RULE_45_E = "45-e";
    public static final String DISTANCE_FROM_WATERSOURCE = "Distance from watersource";
    public static final String DISTANCE_FROM_BUILDING = "Distance from Building";
    public static final String MIN_DISTANCE_FROM_GOVTBUILDING_DESC = "Minimum distance fcrom government building";
    public static final BigDecimal MIN_DIS_WATERSRC = BigDecimal.valueOf(18L);
    public static final BigDecimal MIN_DIS_BUILDING = BigDecimal.valueOf(6L);

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Septic Tank ");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Permitted");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        List septicTanks = pl.getSepticTanks();
        for (org.egov.common.entity.edcr.SepticTank septicTank : septicTanks) {
            boolean validWaterSrcDistance = false;
            boolean validBuildingDistance = false;
            if (!septicTank.getDistanceFromWaterSource().isEmpty()) {
                BigDecimal minDistWaterSrc = (BigDecimal)septicTank.getDistanceFromWaterSource().stream().reduce(BigDecimal::min).get();
                if (minDistWaterSrc != null && minDistWaterSrc.compareTo(MIN_DIS_WATERSRC) >= 0) {
                    validWaterSrcDistance = true;
                }
                this.buildResult(pl, scrutinyDetail, validWaterSrcDistance, DISTANCE_FROM_WATERSOURCE, ">= 18", minDistWaterSrc.toString());
            }
            if (septicTank.getDistanceFromBuilding().isEmpty()) continue;
            BigDecimal minDistBuilding = (BigDecimal)septicTank.getDistanceFromBuilding().stream().reduce(BigDecimal::min).get();
            if (minDistBuilding != null && minDistBuilding.compareTo(MIN_DIS_BUILDING) >= 0) {
                validBuildingDistance = true;
            }
            this.buildResult(pl, scrutinyDetail, validBuildingDistance, DISTANCE_FROM_BUILDING, ">= 6", minDistBuilding.toString());
        }
        return pl;
    }

    private void buildResult(Plan pl, ScrutinyDetail scrutinyDetail, boolean valid, String description, String permited, String provided) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_45_E);
        details.put("Description", description);
        details.put("Permitted", permited);
        details.put("Provided", provided);
        details.put("Status", valid ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

