/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.infra.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SegregatedToilet
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(SegregatedToilet.class);
    private static final String RULE_59_10 = "59-10-i";
    public static final String SEGREGATEDTOILET_DESCRIPTION = "Num. of segregated toilets";
    public static final String SEGREGATEDTOILET_DIMENSION_DESCRIPTION = "Segregated toilet distance from main entrance";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Segregated Toilet");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_59_10);
        BigDecimal minDimension = BigDecimal.ZERO;
        BigDecimal maxHeightOfBuilding = BigDecimal.ZERO;
        BigDecimal maxNumOfFloorsOfBuilding = BigDecimal.ZERO;
        if (pl.getSegregatedToilet() != null && !pl.getSegregatedToilet().getDistancesToMainEntrance().isEmpty()) {
            minDimension = (BigDecimal)pl.getSegregatedToilet().getDistancesToMainEntrance().stream().reduce(BigDecimal::min).get();
        }
        for (Block b : pl.getBlocks()) {
            if (b.getBuilding().getBuildingHeight() == null) continue;
            if (b.getBuilding() != null && b.getBuilding().getBuildingHeight().compareTo(maxHeightOfBuilding) > 0) {
                maxHeightOfBuilding = b.getBuilding().getBuildingHeight();
            }
            if (b.getBuilding().getFloorsAboveGround() == null || b.getBuilding().getFloorsAboveGround().compareTo(maxNumOfFloorsOfBuilding) <= 0) continue;
            maxNumOfFloorsOfBuilding = b.getBuilding().getFloorsAboveGround();
        }
        if (pl.getVirtualBuilding() != null && pl.getVirtualBuilding().getMostRestrictiveFarHelper() != null && pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType() != null && (StringUtils.isNotBlank((String)pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType().getCode()) && "A".equals(pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType().getCode()) && maxHeightOfBuilding.compareTo(new BigDecimal(15)) >= 0 || ("I".equals(pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType().getCode()) || "A".equals(pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType().getCode()) || "E".equals(pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType().getCode())) && pl.getVirtualBuilding().getTotalBuitUpArea() != null && pl.getVirtualBuilding().getTotalBuitUpArea().compareTo(new BigDecimal(1000)) >= 0 && maxNumOfFloorsOfBuilding.compareTo(new BigDecimal(2)) >= 0 || "C".equals(pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType().getCode()) && pl.getVirtualBuilding().getTotalBuitUpArea() != null && pl.getVirtualBuilding().getTotalBuitUpArea().compareTo(new BigDecimal(500)) >= 0)) {
            if (pl.getSegregatedToilet() != null && pl.getSegregatedToilet().getSegregatedToilets() != null && !pl.getSegregatedToilet().getSegregatedToilets().isEmpty()) {
                details.put("Description", SEGREGATEDTOILET_DESCRIPTION);
                details.put("Required", "1");
                details.put("Provided", String.valueOf(pl.getSegregatedToilet().getSegregatedToilets().size()));
                details.put("Status", Result.Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            } else {
                details.put("Description", SEGREGATEDTOILET_DESCRIPTION);
                details.put("Required", "1");
                details.put("Provided", "0");
                details.put("Status", Result.Not_Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            }
            if (minDimension != null && minDimension.compareTo(new BigDecimal(200)) >= 0) {
                details.put("Description", SEGREGATEDTOILET_DIMENSION_DESCRIPTION);
                details.put("Required", ">= 200");
                details.put("Provided", minDimension.toString());
                details.put("Status", Result.Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            } else {
                details.put("Description", SEGREGATEDTOILET_DIMENSION_DESCRIPTION);
                details.put("Required", ">= 200");
                details.put("Provided", minDimension.toString());
                details.put("Status", Result.Not_Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

