/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.egov.common.entity.dcr.helper.OccupancyHelperDetail;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.SanityDetails;
import org.egov.common.entity.edcr.SanityHelper;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.stereotype.Service;

@Service
public class Sanitation
extends FeatureProcess {
    public static final String MSG_ERROR_MANDATORY = "msg.error.mandatory.object.not.defined";
    public static final String FEMALE = "Female ";
    public static final String MALE = "Male ";
    public static final String BLOCK = "Block ";
    public static final String SANITY_RULE_DESC = "Sanity facility for Occupancy ";
    public static final String NEWLINE = "\n";
    public static final String SANITATION = "Sanitation";
    public static final String BLOCK_U_S = "Block_";
    private static final String WITH = " with ";
    private static final String BLDG_PART_WATER_CLOSET = "Water Closet";
    private static final String BLDG_PART_SPECIAL_WATER_CLOSET = "Special Water Closet";
    private static final String BLDG_PART_URINAL = "Urinal";
    private static final String BLDG_PART_BATHROOM = "Bath Room";
    private static final String MALE_BATH_WITH_WC = "Bath Room with Water Closet";
    private static final String BLDG_PART_WASHBASIN = "Wash Basin";
    private static final String MINIMUM_SIDE_DIMENSION_VIOLATED = "Minimum Side Dimension of {0} M violated";
    private static final String MINIMUM_AREA_DIMENSION_VIOLATED = "Minimum Area of {0} M violated";
    private static final String DIMESION_DESC_KEY = "msg.sanity.dimension.desc";
    private static final Logger LOG = Logger.getLogger(Sanitation.class);
    private static final String FEATURE_NAME = "Sanitary Detail";
    private static final String RULE_38_1 = "38-1";
    private static final String NOOFBEDS = "No Of Beds";
    public static final String RULE_55_12 = "55-12";
    public static final String RULE_40_A_4 = "40A-4";
    public static final String RULE_54_6 = "54-6";
    public static final BigDecimal MINAREAOFSPWC = BigDecimal.valueOf(2.625);
    public static final BigDecimal MINDIMENSIONOFSPWC = BigDecimal.valueOf(1.5);
    public static final String MINIMUM_AREA_SPWC = "2.625 M2";
    public static final String MINIMUM_DIMENSION_SPWC = "1.5 M";

    @Override
    public Plan validate(Plan pl) {
        for (Block b : pl.getBlocks()) {
            if (b.getCompletelyExisting().booleanValue()) continue;
            int totalSpecialWC = 0;
            int totalWashBasins = 0;
            for (Floor f : b.getBuilding().getFloors()) {
                totalSpecialWC += f.getSpecialWaterClosets().size();
                totalWashBasins += f.getWashBasins().size();
            }
            b.getSanityDetails().setTotalSPWC(totalSpecialWC);
            b.getSanityDetails().setTotalwashBasins(totalWashBasins);
            List occupancies = b.getBuilding().getTotalArea();
            SanityDetails sanityDetails = b.getSanityDetails();
            this.validateDimensions(pl, b, sanityDetails);
            for (Occupancy occupancy : occupancies) {
                OccupancyHelperDetail o = occupancy.getTypeHelper().getSubtype() != null ? occupancy.getTypeHelper().getSubtype() : occupancy.getTypeHelper().getType();
                if (o == null) continue;
                switch (o.getCode()) {
                    case "A": 
                    case "A-SR": 
                    case "A-AF": {
                        if (sanityDetails.getTotalSPWC() != 0) break;
                        pl.addError(BLDG_PART_SPECIAL_WATER_CLOSET, this.getLocaleMessage(MSG_ERROR_MANDATORY, FEATURE_NAME, BLDG_PART_SPECIAL_WATER_CLOSET, b.getNumber()));
                        break;
                    }
                    case "A-HE": {
                        this.commonSanitationValidations(pl, b, sanityDetails, o);
                        this.validateBathRoom(pl, b, sanityDetails);
                        break;
                    }
                    case "B": 
                    case "B2": 
                    case "B-HEI": {
                        this.commonSanitationValidations(pl, b, sanityDetails, o);
                        break;
                    }
                    case "C-MIP": {
                        this.commonSanitationValidations(pl, b, sanityDetails, o);
                        if (pl.getPlanInformation().getNoOfBeds() != null) break;
                        pl.addError(NOOFBEDS, this.getLocaleMessage(MSG_ERROR_MANDATORY, FEATURE_NAME, NOOFBEDS, b.getNumber()));
                        break;
                    }
                    case "C-MOP": 
                    case "C-MA": {
                        this.commonSanitationValidations(pl, b, sanityDetails, o);
                        break;
                    }
                    case "D": 
                    case "D-AW": 
                    case "D-BT": {
                        this.commonSanitationValidations(pl, b, sanityDetails, o);
                        break;
                    }
                    case "E": 
                    case "F": 
                    case "F-K": {
                        this.commonSanitationValidations(pl, b, sanityDetails, o);
                        break;
                    }
                    case "F-H": {
                        this.commonSanitationValidations(pl, b, sanityDetails, o);
                        this.validateBathRoom(pl, b, sanityDetails);
                        break;
                    }
                    case "G": 
                    case "G-SI": 
                    case "H": 
                    case "I-1": 
                    case "I-2": {
                        if (sanityDetails.getMaleWaterClosets().isEmpty() && sanityDetails.getFemaleWaterClosets().isEmpty()) {
                            pl.addError(BLDG_PART_WATER_CLOSET, this.getLocaleMessage(MSG_ERROR_MANDATORY, FEATURE_NAME, BLDG_PART_WATER_CLOSET, b.getNumber()));
                        }
                        if (!sanityDetails.getUrinals().isEmpty()) break;
                        pl.addError(BLDG_PART_URINAL, this.getLocaleMessage(MSG_ERROR_MANDATORY, FEATURE_NAME, BLDG_PART_URINAL, b.getNumber()));
                    }
                }
            }
        }
        return pl;
    }

    private void validateBathRoom(Plan pl, Block b, SanityDetails sanityDetails) {
        if (sanityDetails.getMaleBathRooms().isEmpty() && sanityDetails.getFemaleBathRooms().isEmpty() && sanityDetails.getMaleRoomsWithWaterCloset().isEmpty() && sanityDetails.getFemaleRoomsWithWaterCloset().isEmpty()) {
            pl.addError(BLDG_PART_BATHROOM, this.getLocaleMessage(MSG_ERROR_MANDATORY, FEATURE_NAME, BLDG_PART_BATHROOM, b.getNumber()));
        }
    }

    private void commonSanitationValidations(Plan pl, Block b, SanityDetails sanityDetails, OccupancyHelperDetail type) {
        if (sanityDetails.getMaleWaterClosets().isEmpty() && sanityDetails.getFemaleWaterClosets().isEmpty() && sanityDetails.getMaleRoomsWithWaterCloset().isEmpty() && sanityDetails.getFemaleRoomsWithWaterCloset().isEmpty()) {
            pl.addError(BLDG_PART_WATER_CLOSET, this.getLocaleMessage(MSG_ERROR_MANDATORY, FEATURE_NAME, BLDG_PART_WATER_CLOSET, b.getNumber()));
        }
        if (sanityDetails.getUrinals().isEmpty()) {
            pl.addError(BLDG_PART_URINAL, this.getLocaleMessage(MSG_ERROR_MANDATORY, FEATURE_NAME, BLDG_PART_URINAL, b.getNumber()));
        }
        if (!("F".equals(type.getCode()) || "F-K".equals(type.getCode()) || "E".equals(type.getCode()) || sanityDetails.getTotalwashBasins() != 0)) {
            pl.addError(BLDG_PART_WASHBASIN, this.getLocaleMessage(MSG_ERROR_MANDATORY, FEATURE_NAME, BLDG_PART_WASHBASIN, b.getNumber()));
        }
        if (sanityDetails.getTotalSPWC() == 0) {
            pl.addError(BLDG_PART_SPECIAL_WATER_CLOSET, this.getLocaleMessage(MSG_ERROR_MANDATORY, FEATURE_NAME, BLDG_PART_SPECIAL_WATER_CLOSET, b.getNumber()));
        }
    }

    private void validateDimensions(Plan pl, Block b, SanityDetails sanityDetails) {
        if (!sanityDetails.getUrinals().isEmpty()) {
            int count = 0;
            for (Object m : sanityDetails.getUrinals()) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError("Sanity_Urinal" + b.getNumber(), count + " number of " + BLDG_PART_URINAL + " polyline not having only 4 points in block" + b.getNumber());
            }
        }
        ArrayList wcList = new ArrayList();
        wcList.addAll(sanityDetails.getMaleWaterClosets());
        wcList.addAll(sanityDetails.getFemaleWaterClosets());
        wcList.addAll(sanityDetails.getCommonWaterClosets());
        if (!wcList.isEmpty()) {
            int count = 0;
            for (Measurement m : wcList) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError("Sanity_Water Closet" + b.getNumber(), count + " number of " + BLDG_PART_WATER_CLOSET + " polyline not having only 4 points in block" + b.getNumber());
            }
        }
        ArrayList bath = new ArrayList();
        bath.addAll(sanityDetails.getMaleBathRooms());
        bath.addAll(sanityDetails.getFemaleBathRooms());
        bath.addAll(sanityDetails.getCommonBathRooms());
        ArrayList wcrList = new ArrayList();
        wcrList.addAll(sanityDetails.getMaleRoomsWithWaterCloset());
        wcrList.addAll(sanityDetails.getFemaleRoomsWithWaterCloset());
        wcrList.addAll(sanityDetails.getCommonRoomsWithWaterCloset());
        if (!bath.isEmpty()) {
            int count = 0;
            for (Measurement m : bath) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError("Sanity_Bath Room" + b.getNumber(), count + " number of " + BLDG_PART_BATHROOM + " polyline not having only 4 points in block" + b.getNumber());
            }
        }
        if (!wcrList.isEmpty()) {
            int count = 0;
            for (Measurement m : wcrList) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError("Sanity_Bath Room with Water Closet" + b.getNumber(), count + " number of " + MALE_BATH_WITH_WC + " polyline not having only 4 points in block" + b.getNumber());
            }
        }
    }

    @Override
    public Plan process(Plan pl) {
        this.verifyDimesions(pl);
        this.checkCount(pl);
        return pl;
    }

    private Plan verifyDimesions(Plan pl) {
        this.validate(pl);
        return pl;
    }

    private ScrutinyDetail getNewScrutinyDetail(String key) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        scrutinyDetail.setKey(key);
        return scrutinyDetail;
    }

    private void checkCount(Plan pl) {
        Boolean allStatus = true;
        Boolean accepted = true;
        for (Block b : pl.getBlocks()) {
            if (b.getCompletelyExisting().booleanValue()) continue;
            LOG.info((Object)("Starting  Sanitation of ....." + b.getNumber()));
            ScrutinyDetail scrutinyDetail = this.getNewScrutinyDetail(BLOCK_U_S + b.getNumber() + "_" + SANITATION);
            SanityHelper helper = new SanityHelper();
            ConcurrentHashMap<Integer, Integer> requiredSpWcMap = new ConcurrentHashMap<Integer, Integer>();
            ConcurrentHashMap<Integer, Integer> providedSpWcMap = new ConcurrentHashMap<Integer, Integer>();
            ConcurrentHashMap<Integer, Integer> failedAreaSpWcMap = new ConcurrentHashMap<Integer, Integer>();
            ConcurrentHashMap<Integer, Integer> failedDimensionSpWcMap = new ConcurrentHashMap<Integer, Integer>();
            for (Occupancy occupancy : b.getBuilding().getTotalArea()) {
                double carpetArea = 0.0;
                if (occupancy.getCarpetArea() == null || !(occupancy.getCarpetArea().doubleValue() > 0.0)) {
                    pl.addError("Invalid carpet area", "Carpet area is not calculated . Some thing wrong with builtup area");
                    return;
                }
                carpetArea = occupancy.getCarpetArea().doubleValue();
                LOG.info((Object)(occupancy.getType() + " area" + carpetArea));
                OccupancyHelperDetail o = occupancy.getTypeHelper().getSubtype() != null ? occupancy.getTypeHelper().getSubtype() : occupancy.getTypeHelper().getType();
                switch (o.getCode()) {
                    case "A": 
                    case "A-AF": {
                        if (!b.getResidentialBuilding().booleanValue()) break;
                        accepted = this.processSpecialWaterClosetForResidential(b, helper, scrutinyDetail, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        break;
                    }
                    case "A-SR": {
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        break;
                    }
                    case "A-HE": {
                        SanityHelper sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 142.5);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 114.0);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.urinal + carpetArea * 2.0 / 356.25);
                        sanityHelper.urinal = sanityHelper.urinal;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWash + carpetArea * 2.0 / 142.5);
                        sanityHelper.maleWash = sanityHelper.maleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWash + carpetArea / 142.5);
                        sanityHelper.femaleWash = sanityHelper.femaleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleBath + carpetArea * 2.0 / 142.5);
                        sanityHelper.maleBath = sanityHelper.maleBath;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleBath + carpetArea / 142.5);
                        sanityHelper.femaleBath = sanityHelper.femaleBath;
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        helper.ruleNo.add(RULE_54_6);
                        break;
                    }
                    case "B": 
                    case "B2": 
                    case "B-HEI": {
                        SanityHelper sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 570.0);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 356.25);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.urinal + carpetArea * 2.0 / 712.5);
                        sanityHelper.urinal = sanityHelper.urinal;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWash + carpetArea * 2.0 / 570.0);
                        sanityHelper.maleWash = sanityHelper.maleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWash + carpetArea / 570.0);
                        sanityHelper.femaleWash = sanityHelper.femaleWash;
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        helper.ruleNo.add(RULE_54_6);
                        break;
                    }
                    case "C-MIP": {
                        SanityHelper sanityHelper;
                        if (pl.getPlanInformation().getNoOfBeds() == null) break;
                        double noofBeds = pl.getPlanInformation().getNoOfBeds().doubleValue();
                        if (pl.getPlanInformation().getNoOfBeds() != null) {
                            sanityHelper = helper;
                            Double.valueOf(sanityHelper.maleWc + noofBeds / 8.0);
                            sanityHelper.maleWc = sanityHelper.maleWc;
                        }
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + noofBeds / 8.0);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWash + (2.0 + (noofBeds - 30.0) / 30.0));
                        sanityHelper.maleWash = sanityHelper.maleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWash + (2.0 + (noofBeds - 30.0) / 30.0));
                        sanityHelper.femaleWash = sanityHelper.femaleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleBath + noofBeds / 8.0);
                        sanityHelper.maleBath = sanityHelper.maleBath;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleBath + noofBeds / 8.0);
                        sanityHelper.femaleBath = sanityHelper.femaleBath;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.abultionTap + (helper.maleWc + helper.femaleWc + carpetArea / 14.25));
                        sanityHelper.abultionTap = sanityHelper.abultionTap;
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        helper.ruleNo.add(RULE_55_12);
                        break;
                    }
                    case "C-MOP": {
                        SanityHelper sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 1425.0);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 114.0);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.urinal + carpetArea * 2.0 / 712.5);
                        sanityHelper.urinal = sanityHelper.urinal;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWash + carpetArea * 2.0 / 475.0);
                        sanityHelper.maleWash = sanityHelper.maleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWash + carpetArea / 475.0);
                        sanityHelper.femaleWash = sanityHelper.femaleWash;
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        helper.ruleNo.add(RULE_55_12);
                        break;
                    }
                    case "C-MA": {
                        SanityHelper sanityHelper7;
                        helper.ruleNo.add(RULE_55_12);
                        SanityHelper sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 356.25);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 213.75);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWash + carpetArea * 2.0 / 356.25);
                        sanityHelper.maleWash = sanityHelper.maleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWash + carpetArea * 2.0 / 356.25);
                        sanityHelper.femaleWash = sanityHelper.femaleWash;
                        Double noOfPersons = carpetArea * 2.0 / 14.25;
                        BigDecimal noOfPersonsBig = BigDecimal.valueOf(noOfPersons).divide(BigDecimal.ONE, RoundingMode.HALF_UP);
                        int noofPerson = noOfPersonsBig.intValue();
                        if (noofPerson >= 7 && noofPerson <= 20) {
                            sanityHelper7 = helper;
                            Double.valueOf(sanityHelper7.urinal + 1.0);
                            sanityHelper7.urinal = sanityHelper7.urinal;
                        } else if (noofPerson <= 45) {
                            SanityHelper sanityHelper2 = helper;
                            Double.valueOf(sanityHelper2.urinal + 2.0);
                            sanityHelper2.urinal = sanityHelper2.urinal;
                        } else if (noofPerson <= 70) {
                            SanityHelper sanityHelper3 = helper;
                            Double.valueOf(sanityHelper3.urinal + 3.0);
                            sanityHelper3.urinal = sanityHelper3.urinal;
                        } else if (noofPerson <= 100) {
                            SanityHelper sanityHelper4 = helper;
                            Double.valueOf(sanityHelper4.urinal + 4.0);
                            sanityHelper4.urinal = sanityHelper4.urinal;
                        } else if (noofPerson <= 200) {
                            SanityHelper sanityHelper5 = helper;
                            Double.valueOf(sanityHelper5.urinal + (4.0 + (double)noofPerson * 0.3));
                            sanityHelper5.urinal = sanityHelper5.urinal;
                        } else if (noofPerson > 200) {
                            SanityHelper sanityHelper6 = helper;
                            Double.valueOf(sanityHelper6.urinal + (4.0 + (double)noofPerson * 0.55));
                            sanityHelper6.urinal = sanityHelper6.urinal;
                        }
                        sanityHelper7 = helper;
                        Double.valueOf(sanityHelper7.abultionTap + (helper.maleWc + helper.femaleWc + carpetArea / 237.5));
                        sanityHelper7.abultionTap = sanityHelper7.abultionTap;
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        break;
                    }
                    case "D": 
                    case "D-AW": {
                        SanityHelper sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 600.0);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 300.0);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.urinal + carpetArea * 2.0 / 150.0);
                        sanityHelper.urinal = sanityHelper.urinal;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWash + carpetArea * 2.0 / 600.0);
                        sanityHelper.maleWash = sanityHelper.maleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWash + carpetArea / 1200.0);
                        sanityHelper.femaleWash = sanityHelper.femaleWash;
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        helper.ruleNo.add(RULE_55_12);
                        break;
                    }
                    case "D-BT": {
                        SanityHelper sanityHelper;
                        helper.ruleNo.add(RULE_55_12);
                        if (carpetArea <= 1000.0) {
                            sanityHelper = helper;
                            Double.valueOf(sanityHelper.maleWc + 4.0);
                            sanityHelper.maleWc = sanityHelper.maleWc;
                        } else {
                            sanityHelper = helper;
                            Double.valueOf(sanityHelper.maleWc + (4.0 + (carpetArea - 1000.0)));
                            sanityHelper.maleWc = sanityHelper.maleWc;
                        }
                        if (carpetArea <= 1000.0) {
                            sanityHelper = helper;
                            Double.valueOf(sanityHelper.urinal + 6.0);
                            sanityHelper.urinal = sanityHelper.urinal;
                        } else {
                            sanityHelper = helper;
                            Double.valueOf(sanityHelper.urinal + (6.0 + (carpetArea - 1000.0) / 6.0));
                            sanityHelper.urinal = sanityHelper.urinal;
                        }
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 600.0);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 300.0);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.urinal + carpetArea * 2.0 / 150.0);
                        sanityHelper.urinal = sanityHelper.urinal;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWash + 4.0);
                        sanityHelper.maleWash = sanityHelper.maleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWash + 4.0);
                        sanityHelper.femaleWash = sanityHelper.femaleWash;
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        helper.ruleNo.add(RULE_54_6);
                        break;
                    }
                    case "E": 
                    case "F": 
                    case "F-K": {
                        SanityHelper sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 356.25);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 213.75);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.urinal + carpetArea * 2.0 / 356.25);
                        sanityHelper.urinal = sanityHelper.urinal;
                        helper.ruleNo.add("56(3C)");
                        helper.ruleDescription = SANITY_RULE_DESC + o.getCode();
                        if (!o.equals("F") && !o.equals("F-K")) break;
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        break;
                    }
                    case "H": {
                        SanityHelper sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 4500.0);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 2250.0);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.urinal + carpetArea * 2.0 / 9000.0);
                        sanityHelper.urinal = sanityHelper.urinal;
                        helper.ruleNo.add("58(6)");
                        break;
                    }
                    case "F-H": {
                        SanityHelper sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 356.25);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 213.75);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.urinal + carpetArea * 2.0 / 356.25);
                        sanityHelper.urinal = sanityHelper.urinal;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWash + carpetArea * 2.0 / 1425.0);
                        sanityHelper.maleWash = sanityHelper.maleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWash + carpetArea / 1425.0);
                        sanityHelper.femaleWash = sanityHelper.femaleWash;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.commonBath + carpetArea * 2.0 / 475.0);
                        sanityHelper.commonBath = sanityHelper.commonBath;
                        this.processSpecialWaterCloset(b, requiredSpWcMap, providedSpWcMap, failedAreaSpWcMap, failedDimensionSpWcMap);
                        helper.ruleNo.add(RULE_54_6);
                        break;
                    }
                    case "G": 
                    case "G-SI": {
                        SanityHelper sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWc + carpetArea * 2.0 / 356.25);
                        sanityHelper.maleWc = sanityHelper.maleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.femaleWc + carpetArea / 213.75);
                        sanityHelper.femaleWc = sanityHelper.femaleWc;
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.urinal + carpetArea * 2.0 / 356.25);
                        sanityHelper.urinal = sanityHelper.urinal;
                        helper.ruleNo.add("57(13)");
                        break;
                    }
                    case "I-1": 
                    case "I-2": {
                        SanityHelper sanityHelper;
                        double floorArea = carpetArea + carpetArea * 25.0 / 100.0;
                        Double maleOccupant = floorArea * 2.0 / 90.0;
                        Double femaleOccupant = floorArea / 90.0;
                        if (maleOccupant.intValue() <= 50) {
                            sanityHelper = helper;
                            Double.valueOf(sanityHelper.maleWc + 1.0);
                            sanityHelper.maleWc = sanityHelper.maleWc;
                        } else {
                            sanityHelper = helper;
                            Double.valueOf(sanityHelper.maleWc + (1.0 + (maleOccupant - 50.0) / 70.0));
                            sanityHelper.maleWc = sanityHelper.maleWc;
                        }
                        if (femaleOccupant.intValue() <= 50) {
                            sanityHelper = helper;
                            Double.valueOf(sanityHelper.femaleWc + 2.0);
                            sanityHelper.femaleWc = sanityHelper.femaleWc;
                        } else {
                            sanityHelper = helper;
                            Double.valueOf(sanityHelper.femaleWc + (2.0 + (maleOccupant - 50.0) / 70.0));
                            sanityHelper.femaleWc = sanityHelper.femaleWc;
                        }
                        sanityHelper = helper;
                        Double.valueOf(sanityHelper.maleWash + floorArea / 1500.0);
                        sanityHelper.maleWash = sanityHelper.maleWash;
                        double noOfPerson = floorArea * 2.0 / 90.0;
                        SanityHelper sanityHelper7 = helper;
                        Double.valueOf(sanityHelper7.urinal + noOfPerson / 100.0);
                        sanityHelper7.urinal = sanityHelper7.urinal;
                        helper.ruleNo.add("59(7)");
                    }
                }
                if (accepted.booleanValue()) continue;
                allStatus = false;
            }
            for (Map.Entry entry : requiredSpWcMap.entrySet()) {
                SanityHelper sanityHelper = helper;
                Double.valueOf(sanityHelper.requiredSpecialWc + (double)((Integer)entry.getValue()).intValue());
                sanityHelper.requiredSpecialWc = sanityHelper.requiredSpecialWc;
            }
            for (Map.Entry entry : providedSpWcMap.entrySet()) {
                SanityHelper sanityHelper = helper;
                Double.valueOf(sanityHelper.providedSpecialWc + (double)((Integer)entry.getValue()).intValue());
                sanityHelper.providedSpecialWc = sanityHelper.providedSpecialWc;
            }
            for (Map.Entry entry : failedAreaSpWcMap.entrySet()) {
                SanityHelper sanityHelper = helper;
                Double.valueOf(sanityHelper.failedAreaSpecialWc + (double)((Integer)entry.getValue()).intValue());
                sanityHelper.failedAreaSpecialWc = sanityHelper.failedAreaSpecialWc;
            }
            for (Map.Entry entry : failedDimensionSpWcMap.entrySet()) {
                SanityHelper sanityHelper = helper;
                Double.valueOf(sanityHelper.failedDimensionSpecialWc + (double)((Integer)entry.getValue()).intValue());
                sanityHelper.failedDimensionSpecialWc = sanityHelper.failedDimensionSpecialWc;
            }
            if (helper.requiredSpecialWc > 0.0) {
                HashSet<String> ruleNo = new HashSet<String>();
                ruleNo.add(RULE_40_A_4);
                if (helper.providedSpecialWc < helper.requiredSpecialWc) {
                    this.addReportDetail(ruleNo, "Special Water Closet - Minimum one at Ground Floor + Minimum 1 at every floors in multiples of 3, (GF, 3rd, 6th etc)", String.valueOf(helper.requiredSpecialWc.intValue()), String.valueOf(helper.providedSpecialWc.intValue()), Result.Not_Accepted.getResultVal(), scrutinyDetail);
                } else {
                    this.addReportDetail(ruleNo, "Special Water Closet - Minimum one at Ground Floor + Minimum 1 at every floors in multiples of 3, (GF, 3rd, 6th etc)", String.valueOf(helper.requiredSpecialWc.intValue()), String.valueOf(helper.providedSpecialWc.intValue()), Result.Accepted.getResultVal(), scrutinyDetail);
                }
                if (helper.failedAreaSpecialWc > 0.0 && helper.failedAreaSpecialWc <= helper.requiredSpecialWc) {
                    this.addReportDetail(ruleNo, "Special Water Closet - Minimum Area", MINIMUM_AREA_SPWC, String.valueOf(helper.failedAreaSpecialWc.intValue()) + " not having area 2.625 M2", Result.Not_Accepted.getResultVal(), scrutinyDetail);
                } else {
                    this.addReportDetail(ruleNo, "Special Water Closet - Minimum Area", MINIMUM_AREA_SPWC, String.valueOf(helper.providedSpecialWc.intValue() - helper.failedAreaSpecialWc.intValue()) + " having area 2.625 M2", Result.Accepted.getResultVal(), scrutinyDetail);
                }
                if (helper.failedDimensionSpecialWc > 0.0 && helper.failedDimensionSpecialWc <= helper.requiredSpecialWc) {
                    this.addReportDetail(ruleNo, "Special Water Closet - Minimum Dimension", MINIMUM_DIMENSION_SPWC, String.valueOf(helper.failedDimensionSpecialWc.intValue()) + " not having dimension 1.5M", Result.Not_Accepted.getResultVal(), scrutinyDetail);
                } else {
                    this.addReportDetail(ruleNo, "Special Water Closet - Minimum Dimension", MINIMUM_DIMENSION_SPWC, String.valueOf(helper.providedSpecialWc.intValue() - helper.failedDimensionSpecialWc.intValue()) + " having dimension 1.5M", Result.Accepted.getResultVal(), scrutinyDetail);
                }
            }
            accepted = this.processSanity(pl, b, helper, scrutinyDetail);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            LOG.info((Object)("Keys of the Sanitation Message ....." + scrutinyDetail.getKey() + "   " + scrutinyDetail.getDetail().size()));
        }
    }

    private void processSpecialWaterCloset(Block block, Map<Integer, Integer> requiredSpWcMap, Map<Integer, Integer> providedSpWcMap, Map<Integer, Integer> failedAreaSpWcMap, Map<Integer, Integer> failedDimensionSpWcMap) {
        for (Floor f : block.getBuilding().getFloors()) {
            if (f.getNumber() < 0 || f.getTerrace().booleanValue() || f.getNumber() % 3 != 0 || requiredSpWcMap.containsKey(f.getNumber())) continue;
            requiredSpWcMap.put(f.getNumber(), 1);
            if (!f.getSpecialWaterClosets().isEmpty()) {
                if (providedSpWcMap.containsKey(f.getNumber())) continue;
                providedSpWcMap.put(f.getNumber(), 1);
            }
            this.validateDimensionOfSPWC(f.getSpecialWaterClosets(), f.getNumber(), failedAreaSpWcMap, failedDimensionSpWcMap, providedSpWcMap);
        }
    }

    private Boolean processSpecialWaterClosetForResidential(Block block, SanityHelper helper, ScrutinyDetail detail, Map<Integer, Integer> requiredSpWcMap, Map<Integer, Integer> providedSpWcMap, Map<Integer, Integer> failedAreaSpWcMap, Map<Integer, Integer> failedDimensionSpWcMap) {
        boolean notFound = false;
        StringBuilder expectedResult = new StringBuilder();
        StringBuilder actualResult = new StringBuilder();
        expectedResult.append(" Minimum one at Ground Floor");
        int required = 0;
        int provided = 0;
        for (Floor f : block.getBuilding().getFloors()) {
            if (f.getNumber() < 0 || f.getNumber() != 0) continue;
            ++required;
            ++provided;
            if (f.getSpecialWaterClosets().isEmpty()) {
                notFound = true;
            }
            this.validateDimensionOfSPWC(f.getSpecialWaterClosets(), f.getNumber(), failedAreaSpWcMap, failedDimensionSpWcMap, providedSpWcMap);
        }
        HashSet<String> ruleNo = new HashSet<String>();
        ruleNo.add(RULE_40_A_4);
        if (notFound) {
            actualResult.append("Not Found");
            this.addReportDetail(ruleNo, "Special Water Closet - Minimum one at Ground Floor", String.valueOf(required), String.valueOf(provided), Result.Not_Accepted.getResultVal(), detail);
        } else {
            actualResult.append("Found");
            this.addReportDetail(ruleNo, "Special Water Closet - Minimum one at Ground Floor", String.valueOf(required), String.valueOf(provided), Result.Accepted.getResultVal(), detail);
        }
        return !notFound;
    }

    private Boolean processSanity(Plan pl, Block b, SanityHelper helper, ScrutinyDetail detail) {
        Boolean accepted = true;
        String description = "";
        String expected = "";
        String actual = "";
        SanityDetails sanityDetails = b.getSanityDetails();
        if (helper.maleWc > 0.0 || helper.femaleWc > 0.0) {
            int maleWcActual = sanityDetails.getMaleWaterClosets().size() + sanityDetails.getMaleRoomsWithWaterCloset().size();
            int femaleWcActual = sanityDetails.getFemaleWaterClosets().size() + sanityDetails.getFemaleRoomsWithWaterCloset().size();
            int commonWcActual = sanityDetails.getCommonWaterClosets().size() + sanityDetails.getCommonRoomsWithWaterCloset().size();
            Double specialWC = helper.providedSpecialWc;
            Double totalWCActual = Math.ceil((double)(maleWcActual + femaleWcActual + commonWcActual) + specialWC);
            Double totalWCExpected = Math.ceil(helper.maleWc + helper.femaleWc);
            if (totalWCExpected >= 0.0) {
                ArrayList<Measurement> wcList = new ArrayList<Measurement>();
                wcList.addAll(sanityDetails.getMaleWaterClosets());
                wcList.addAll(sanityDetails.getFemaleWaterClosets());
                wcList.addAll(sanityDetails.getCommonWaterClosets());
                this.checkDimension(totalWCExpected.intValue(), detail, wcList, 1.0, 1.1, BLDG_PART_WATER_CLOSET, DIMESION_DESC_KEY, RULE_38_1);
                expected = "" + totalWCExpected.intValue();
                actual = "" + totalWCActual.intValue();
                description = "Water Closet - Count";
                if (totalWCExpected.intValue() > totalWCActual.intValue()) {
                    this.addReportDetail(helper.ruleNo, description, expected, actual, Result.Not_Accepted.getResultVal(), detail);
                } else {
                    this.addReportDetail(helper.ruleNo, description, expected, actual, Result.Accepted.getResultVal(), detail);
                }
            }
        }
        if (helper.urinal > 0.0) {
            helper.urinal = Math.ceil(helper.urinal);
            description = "Urinal - Count";
            Integer urinalActual = sanityDetails.getUrinals().size();
            expected = "" + helper.urinal.intValue();
            actual = "" + urinalActual;
            if (helper.urinal.intValue() >= 0) {
                this.checkDimension(helper.urinal.intValue(), detail, sanityDetails.getUrinals(), 0.6, 0.42, BLDG_PART_URINAL, DIMESION_DESC_KEY, RULE_38_1);
                if (helper.urinal.intValue() > urinalActual) {
                    this.addReportDetail(helper.ruleNo, description, expected, actual, Result.Not_Accepted.getResultVal(), detail);
                } else {
                    this.addReportDetail(helper.ruleNo, description, expected, actual, Result.Accepted.getResultVal(), detail);
                }
            }
        }
        if (helper.maleWash > 0.0 || helper.femaleWash > 0.0) {
            int actualWash = 0;
            for (Floor f : b.getBuilding().getFloors()) {
                actualWash += f.getWashBasins().size();
            }
            description = "Wash Basin - Count";
            Double totalWashExpected = Math.ceil(helper.maleWash + helper.femaleWash);
            expected = "" + totalWashExpected.intValue();
            actual = "" + actualWash;
            if (totalWashExpected.intValue() >= 0) {
                if (totalWashExpected.intValue() > actualWash) {
                    this.addReportDetail(helper.ruleNo, description, expected, actual, Result.Not_Accepted.getResultVal(), detail);
                } else {
                    this.addReportDetail(helper.ruleNo, description, expected, actual, Result.Accepted.getResultVal(), detail);
                }
            }
        }
        if (helper.maleBath > 0.0 || helper.femaleBath > 0.0) {
            description = "Bath Room - Count";
            int maleBathActual = sanityDetails.getMaleBathRooms().size() + sanityDetails.getMaleRoomsWithWaterCloset().size();
            int femaleBathActual = sanityDetails.getFemaleBathRooms().size() + sanityDetails.getFemaleRoomsWithWaterCloset().size();
            int commomBathActual = sanityDetails.getCommonBathRooms().size() + sanityDetails.getCommonRoomsWithWaterCloset().size();
            int totalActualBath = maleBathActual + femaleBathActual + commomBathActual;
            Double totalBathExpected = Math.ceil(helper.maleBath + helper.femaleBath);
            expected = "" + totalBathExpected.intValue();
            actual = "" + totalActualBath;
            ArrayList<Measurement> wcList = new ArrayList<Measurement>();
            wcList.addAll(sanityDetails.getMaleBathRooms());
            wcList.addAll(sanityDetails.getFemaleBathRooms());
            wcList.addAll(sanityDetails.getCommonBathRooms());
            ArrayList<Measurement> wcrList = new ArrayList<Measurement>();
            wcrList.addAll(sanityDetails.getMaleRoomsWithWaterCloset());
            wcrList.addAll(sanityDetails.getFemaleRoomsWithWaterCloset());
            wcrList.addAll(sanityDetails.getCommonRoomsWithWaterCloset());
            if (totalBathExpected.intValue() >= 0) {
                this.checkDimension(totalBathExpected.intValue(), detail, wcList, 1.1, 1.5, BLDG_PART_BATHROOM, DIMESION_DESC_KEY, RULE_38_1);
                this.checkDimension(totalBathExpected.intValue(), detail, wcrList, 1.1, 2.2, MALE_BATH_WITH_WC, DIMESION_DESC_KEY, RULE_38_1);
                if (totalBathExpected.intValue() > totalActualBath) {
                    this.addReportDetail(helper.ruleNo, description, expected, actual, Result.Not_Accepted.getResultVal(), detail);
                } else {
                    this.addReportDetail(helper.ruleNo, description, expected, actual, Result.Accepted.getResultVal(), detail);
                }
            }
        }
        return accepted;
    }

    private boolean checkDimension(Integer required, ScrutinyDetail scrutinyDetail, List<Measurement> list, double minSide, double minArea, String type, String desc, String ruleNum) {
        if (!list.isEmpty()) {
            int wcNotMeetingSide = this.checkDimensionSide(list, minSide);
            int wcNotMeetingArea = this.checkDimensionArea(list, minArea);
            int totalSize = list.size();
            desc = type + "- Minimum Dimension";
            String expectedResult = minSide + " M";
            String actualResult = "";
            HashSet<String> ruleNo = new HashSet<String>();
            ruleNo.add(ruleNum);
            if (totalSize - wcNotMeetingSide < required && wcNotMeetingSide > 0) {
                actualResult = wcNotMeetingSide + " not having " + expectedResult;
                this.addReportDetail(ruleNo, desc, expectedResult, actualResult, Result.Not_Accepted.getResultVal(), scrutinyDetail);
            } else {
                actualResult = totalSize + " having " + expectedResult;
                this.addReportDetail(ruleNo, desc, expectedResult, actualResult, Result.Accepted.getResultVal(), scrutinyDetail);
            }
            desc = type + "- Minimum Area";
            expectedResult = minArea + " M2";
            if (totalSize - wcNotMeetingArea < required && wcNotMeetingArea > 0) {
                actualResult = wcNotMeetingArea + " not having " + expectedResult;
                this.addReportDetail(ruleNo, desc, expectedResult, actualResult, Result.Not_Accepted.getResultVal(), scrutinyDetail);
            } else {
                actualResult = totalSize + "  having " + expectedResult;
                this.addReportDetail(ruleNo, desc, expectedResult, actualResult, Result.Accepted.getResultVal(), scrutinyDetail);
            }
        }
        return true;
    }

    private void addReportDetail(Set<String> ruleNo, String ruleDesc, String expected, String actual, String status, ScrutinyDetail detail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo.stream().map(String::new).collect(Collectors.joining(",")));
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        detail.getDetail().add(details);
    }

    private int checkDimensionSide(List<Measurement> measurements, Double minValue) {
        int failedCount = 0;
        for (Measurement m : measurements) {
            double minSide;
            if (minValue == 0.0) {
                // empty if block
            }
            if (!((minSide = m.getMinimumSide().setScale(1, DcrConstants.ROUNDMODE_MEASUREMENTS).doubleValue()) < minValue)) continue;
            m.setIsValid(Boolean.valueOf(false));
            m.appendInvalidReason(String.format(MINIMUM_SIDE_DIMENSION_VIOLATED, minValue));
            ++failedCount;
        }
        return failedCount;
    }

    private int checkDimensionArea(List<Measurement> measurements, Double minValue) {
        int failedCount = 0;
        for (Measurement m : measurements) {
            double area = m.getArea().setScale(3, DcrConstants.ROUNDMODE_MEASUREMENTS).doubleValue();
            if (!(area < minValue)) continue;
            m.setIsValid(Boolean.valueOf(false));
            m.appendInvalidReason(String.format(MINIMUM_AREA_DIMENSION_VIOLATED, minValue));
            ++failedCount;
            LOG.debug((Object)("Area not matching is " + m.getArea()));
        }
        return failedCount;
    }

    private void validateDimensionOfSPWC(List<Measurement> spwcs, int flrNo, Map<Integer, Integer> failedAreaSpWcMap, Map<Integer, Integer> failedDimensionSpWcMap, Map<Integer, Integer> providedSpWcMap) {
        Integer failedAreaCount = 0;
        Integer failedDimensionCount = 0;
        Integer providedSpecialWc = 0;
        for (Map.Entry<Integer, Integer> pro : providedSpWcMap.entrySet()) {
            providedSpecialWc = providedSpecialWc + pro.getValue();
        }
        for (Measurement spwc : spwcs) {
            Integer n;
            Integer n2;
            BigDecimal area = spwc.getArea().setScale(3, DcrConstants.ROUNDMODE_MEASUREMENTS);
            BigDecimal width = spwc.getWidth().setScale(1, DcrConstants.ROUNDMODE_MEASUREMENTS);
            if (area.compareTo(MINAREAOFSPWC.setScale(3, DcrConstants.ROUNDMODE_MEASUREMENTS)) < 0) {
                n2 = failedAreaCount;
                n = failedAreaCount = Integer.valueOf(failedAreaCount + 1);
            }
            if (width.compareTo(MINDIMENSIONOFSPWC.setScale(1, DcrConstants.ROUNDMODE_MEASUREMENTS)) < 0) {
                n2 = failedDimensionCount;
                n = failedDimensionCount = Integer.valueOf(failedDimensionCount + 1);
            }
            if (providedSpecialWc == failedAreaCount) {
                failedAreaSpWcMap.put(flrNo, failedAreaCount);
            }
            if (providedSpecialWc != failedDimensionCount) continue;
            failedDimensionSpWcMap.put(flrNo, failedAreaCount);
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

