/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.dcr.helper.OccupancyHelperDetail;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class RoadWidth
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(RoadWidth.class);
    private static final String RULE_34 = "34-1";
    public static final String ROADWIDTH_DESCRIPTION = "Minimum Road Width";
    public static final BigDecimal TWELVE_POINT_TWENTY = BigDecimal.valueOf(12.2);
    public static final String NEW = "NEW";

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        if (pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null) {
            BigDecimal roadWidth = pl.getPlanInformation().getRoadWidth();
            String typeOfArea = pl.getPlanInformation().getTypeOfArea();
            if (typeOfArea != null && NEW.equalsIgnoreCase(typeOfArea)) {
                ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
                scrutinyDetail.setKey("Common_Road Width");
                scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
                scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Occupancy");
                scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Permitted");
                scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
                scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("Byelaw", RULE_34);
                details.put("Description", ROADWIDTH_DESCRIPTION);
                Map<String, BigDecimal> occupancyValuesMap = this.getOccupancyValues();
                if (pl.getVirtualBuilding() != null && pl.getVirtualBuilding().getMostRestrictiveFarHelper() != null) {
                    OccupancyHelperDetail occupancyType;
                    OccupancyHelperDetail occupancyHelperDetail = occupancyType = pl.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype() : pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType();
                    if (occupancyType != null) {
                        details.put("Occupancy", occupancyType.getName());
                        BigDecimal roadWidthRequired = occupancyValuesMap.get(occupancyType.getCode());
                        if (roadWidthRequired != null) {
                            if (roadWidth.compareTo(roadWidthRequired) >= 0) {
                                details.put("Permitted", String.valueOf(roadWidthRequired) + "m");
                                details.put("Provided", roadWidth.toString() + "m");
                                details.put("Status", Result.Accepted.getResultVal());
                                scrutinyDetail.getDetail().add(details);
                                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                            } else {
                                details.put("Permitted", String.valueOf(roadWidthRequired) + "m");
                                details.put("Provided", roadWidth.toString() + "m");
                                details.put("Status", Result.Not_Accepted.getResultVal());
                                scrutinyDetail.getDetail().add(details);
                                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                            }
                        }
                    }
                }
            }
        }
        return pl;
    }

    public Map<String, BigDecimal> getOccupancyValues() {
        HashMap<String, BigDecimal> roadWidthValues = new HashMap<String, BigDecimal>();
        roadWidthValues.put("B", TWELVE_POINT_TWENTY);
        roadWidthValues.put("D", TWELVE_POINT_TWENTY);
        roadWidthValues.put("G", TWELVE_POINT_TWENTY);
        roadWidthValues.put("F", TWELVE_POINT_TWENTY);
        roadWidthValues.put("F-RT", TWELVE_POINT_TWENTY);
        roadWidthValues.put("F-CB", TWELVE_POINT_TWENTY);
        return roadWidthValues;
    }
}

