/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.River;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.infra.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RiverDistance
extends FeatureProcess {
    private static final String RULE_22 = "22";
    public static final String RIVER_GANGA_DESCRIPTION = "Distance from ganga river";
    public static final String RIVER_NON_GANGA_DESCRIPTION = "Distance from non ganga river";
    public static final String PROTECTION_WALL_GANGA_DESCRIPTION = "Distance from protection wall ganga";
    public static final String EMBANKMENT_GANGA_DESCRIPTION = "Distance from embankment ganga";
    public static final String NO_DISTANCT_MENTIONED = "No distance is provided from protection wall ganga/embankment/river ganga edge or non ganga river";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ArrayList distancesFromSubRiver;
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_River Distance");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Permitted");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        HashMap<String, String> errors = new HashMap<String, String>();
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_22);
        BigDecimal minDistanceFromProtectionWall = BigDecimal.ZERO;
        BigDecimal minDistanceFromEmbankment = BigDecimal.ZERO;
        BigDecimal minDistanceFromMainRiverEdge = BigDecimal.ZERO;
        BigDecimal minDistanceFromSubRiver = BigDecimal.ZERO;
        List<Object> mainRiver = new ArrayList();
        List<Object> subRiver = new ArrayList();
        List rivers = pl.getDistanceToExternalEntity().getRivers();
        if (!rivers.isEmpty()) {
            mainRiver = rivers.stream().filter(river -> river.getName().equalsIgnoreCase("MainRiver")).collect(Collectors.toList());
            subRiver = rivers.stream().filter(river -> river.getName().equalsIgnoreCase("SubRiver")).collect(Collectors.toList());
        }
        ArrayList distancesFromRiverProtectionWall = !mainRiver.isEmpty() ? ((River)mainRiver.get(0)).getDistancesFromProtectionWall() : new ArrayList();
        ArrayList distancesFromEmbankment = !mainRiver.isEmpty() ? ((River)mainRiver.get(0)).getDistancesFromEmbankment() : new ArrayList();
        ArrayList distancesFromMainRiverEdge = !mainRiver.isEmpty() ? ((River)mainRiver.get(0)).getDistancesFromRiverEdge() : new ArrayList();
        List list = distancesFromSubRiver = !subRiver.isEmpty() ? ((River)subRiver.get(0)).getDistancesFromProtectionWall() : new ArrayList();
        if (StringUtils.isNotBlank((String)pl.getPlanInformation().getBuildingNearToRiver()) && "YES".equalsIgnoreCase(pl.getPlanInformation().getBuildingNearToRiver())) {
            if (distancesFromRiverProtectionWall != null && !distancesFromRiverProtectionWall.isEmpty()) {
                minDistanceFromProtectionWall = (BigDecimal)distancesFromRiverProtectionWall.stream().reduce(BigDecimal::min).get();
                if (minDistanceFromProtectionWall.compareTo(BigDecimal.valueOf(30L)) > 0) {
                    details.put("Description", PROTECTION_WALL_GANGA_DESCRIPTION);
                    details.put("Permitted", ">30");
                    details.put("Provided", minDistanceFromProtectionWall.toString());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    details.put("Description", PROTECTION_WALL_GANGA_DESCRIPTION);
                    details.put("Permitted", "<=30");
                    details.put("Provided", minDistanceFromProtectionWall.toString());
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            } else if (distancesFromRiverProtectionWall != null && !distancesFromEmbankment.isEmpty()) {
                details = new HashMap();
                details.put("Byelaw", RULE_22);
                minDistanceFromEmbankment = (BigDecimal)distancesFromEmbankment.stream().reduce(BigDecimal::min).get();
                if (minDistanceFromEmbankment.compareTo(BigDecimal.valueOf(50L)) > 0) {
                    details.put("Description", EMBANKMENT_GANGA_DESCRIPTION);
                    details.put("Permitted", ">50");
                    details.put("Provided", minDistanceFromEmbankment.toString());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    details.put("Description", EMBANKMENT_GANGA_DESCRIPTION);
                    details.put("Permitted", "<=50");
                    details.put("Provided", minDistanceFromEmbankment.toString());
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            } else if (distancesFromMainRiverEdge != null && !distancesFromMainRiverEdge.isEmpty()) {
                details = new HashMap();
                details.put("Byelaw", RULE_22);
                minDistanceFromMainRiverEdge = (BigDecimal)distancesFromMainRiverEdge.stream().reduce(BigDecimal::min).get();
                if (minDistanceFromMainRiverEdge.compareTo(BigDecimal.valueOf(200L)) > 0) {
                    details.put("Description", RIVER_GANGA_DESCRIPTION);
                    details.put("Permitted", ">200");
                    details.put("Provided", minDistanceFromMainRiverEdge.toString());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    details.put("Description", RIVER_GANGA_DESCRIPTION);
                    details.put("Permitted", "<=200");
                    details.put("Provided", minDistanceFromMainRiverEdge.toString());
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            }
            if (distancesFromSubRiver != null && !distancesFromSubRiver.isEmpty()) {
                minDistanceFromSubRiver = (BigDecimal)distancesFromSubRiver.stream().reduce(BigDecimal::min).get();
                details = new HashMap();
                details.put("Byelaw", RULE_22);
                if (minDistanceFromSubRiver.compareTo(BigDecimal.valueOf(100L)) > 0) {
                    details.put("Description", RIVER_NON_GANGA_DESCRIPTION);
                    details.put("Permitted", ">100");
                    details.put("Provided", minDistanceFromSubRiver.toString());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    details.put("Description", RIVER_NON_GANGA_DESCRIPTION);
                    details.put("Permitted", "<=100");
                    details.put("Provided", minDistanceFromSubRiver.toString());
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            }
            if (distancesFromRiverProtectionWall.isEmpty() && distancesFromEmbankment.isEmpty() && distancesFromMainRiverEdge.isEmpty() && distancesFromSubRiver.isEmpty()) {
                errors.put("Distance_From_River", NO_DISTANCT_MENTIONED);
                pl.addErrors(errors);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

