/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.HashMap;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Building;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Plot;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.common.entity.edcr.SetBack;
import org.egov.edcr.feature.GeneralRule;
import org.egov.infra.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class RearYardService
extends GeneralRule {
    private static final String RULE_35 = "35 Table-8";
    private static final String RULE_36 = "36";
    private static final String RULE_37_TWO_A = "37-2-A";
    private static final String RULE_37_TWO_B = "37-2-B";
    private static final String RULE_37_TWO_C = "37-2-C";
    private static final String RULE_37_TWO_D = "37-2-D";
    private static final String RULE_37_TWO_G = "37-2-G";
    private static final String RULE_37_TWO_H = "37-2-H";
    private static final String RULE_37_TWO_I = "37-2-I";
    private static final String RULE_47 = "47";
    private static final String MINIMUMLABEL = "Minimum distance ";
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_0_9 = BigDecimal.valueOf(0.9);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_1_2 = BigDecimal.valueOf(1.2);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_1_5 = BigDecimal.valueOf(1.5);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_1_8 = BigDecimal.valueOf(1.8);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_2 = BigDecimal.valueOf(2L);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_2_5 = BigDecimal.valueOf(2.5);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_3 = BigDecimal.valueOf(3L);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_3_6 = BigDecimal.valueOf(3.6);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_4 = BigDecimal.valueOf(4L);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_4_5 = BigDecimal.valueOf(4.5);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_5 = BigDecimal.valueOf(5L);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_6 = BigDecimal.valueOf(6L);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_7 = BigDecimal.valueOf(7L);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_8 = BigDecimal.valueOf(8L);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_9 = BigDecimal.valueOf(9L);
    private static final BigDecimal REARYARDMINIMUM_DISTANCE_12 = BigDecimal.valueOf(12L);
    public static final String BSMT_REAR_YARD_DESC = "Basement Rear Setback";
    private static final int PLOTAREA_300 = 300;
    public static final BigDecimal ROAD_WIDTH_TWELVE_POINTTWO = BigDecimal.valueOf(12.2);

    public void processRearYard(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        Plot plot = pl.getPlot();
        if (plot == null) {
            return;
        }
        this.validateRearYard(pl);
        if (plot != null && !pl.getBlocks().isEmpty()) {
            for (Block block : pl.getBlocks()) {
                this.scrutinyDetail = new ScrutinyDetail();
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Level");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Occupancy");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Field Verified");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Permissible");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Provided");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(7), "Status");
                this.scrutinyDetail.setHeading("Rear Setback");
                RearYardResult rearYardResult = new RearYardResult();
                for (SetBack setback : block.getSetBacks()) {
                    if (setback.getRearYard() == null || setback.getRearYard().getMean().compareTo(BigDecimal.ZERO) <= 0) continue;
                    BigDecimal min = setback.getRearYard().getMinimumDistance();
                    BigDecimal mean = setback.getRearYard().getMean();
                    BigDecimal buildingHeight = setback.getRearYard().getHeight() != null && setback.getRearYard().getHeight().compareTo(BigDecimal.ZERO) > 0 ? setback.getRearYard().getHeight() : block.getBuilding().getBuildingHeight();
                    if (buildingHeight == null || !(min.doubleValue() > 0.0) && !(mean.doubleValue() > 0.0)) continue;
                    for (Occupancy occupancy : block.getBuilding().getTotalArea()) {
                        this.scrutinyDetail.setKey("Block_" + block.getName() + "_Rear Setback");
                        if (setback.getLevel() < 0) {
                            this.scrutinyDetail.setKey("Block_" + block.getName() + "_Basement Rear Setback");
                            this.checkRearYardBasement(pl, block.getBuilding(), block.getName(), setback.getLevel(), plot, BSMT_REAR_YARD_DESC, min, mean, occupancy.getTypeHelper(), rearYardResult);
                        }
                        if (occupancy.getTypeHelper().getSubtype() != null && ("A-R".equalsIgnoreCase(occupancy.getTypeHelper().getSubtype().getCode()) || "A-AF".equalsIgnoreCase(occupancy.getTypeHelper().getSubtype().getCode()) || "A-PO".equalsIgnoreCase(occupancy.getTypeHelper().getSubtype().getCode())) || "F".equalsIgnoreCase(occupancy.getTypeHelper().getType().getCode())) {
                            if (buildingHeight.compareTo(BigDecimal.valueOf(10L)) <= 0 && block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(3L)) <= 0) {
                                this.checkRearYardUptoTenMts(pl, block.getBuilding(), block, setback.getLevel(), plot, "Rear Setback", min, mean, occupancy.getTypeHelper(), rearYardResult, buildingHeight);
                                continue;
                            }
                            if (buildingHeight.compareTo(BigDecimal.valueOf(12L)) <= 0 && block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(4L)) <= 0) {
                                this.checkRearYardUptoToTweleveMts(setback, block.getBuilding(), pl, block, setback.getLevel(), plot, "Rear Setback", min, mean, occupancy.getTypeHelper(), rearYardResult, errors);
                                continue;
                            }
                            if (buildingHeight.compareTo(BigDecimal.valueOf(16L)) <= 0) {
                                this.checkRearYardUptoToSixteenMts(setback, block.getBuilding(), pl, block, setback.getLevel(), plot, "Rear Setback", min, mean, occupancy.getTypeHelper(), rearYardResult, errors);
                                continue;
                            }
                            if (buildingHeight.compareTo(BigDecimal.valueOf(16L)) <= 0) continue;
                            this.checkRearYardAboveSixteenMts(setback, block.getBuilding(), pl, block, setback.getLevel(), plot, "Rear Setback", min, mean, occupancy.getTypeHelper(), rearYardResult, buildingHeight);
                            continue;
                        }
                        if ("G".equalsIgnoreCase(occupancy.getTypeHelper().getType().getCode())) {
                            this.checkRearYardForIndustrial(setback, block.getBuilding(), pl, block, setback.getLevel(), plot, "Rear Setback", min, mean, occupancy.getTypeHelper(), rearYardResult);
                            continue;
                        }
                        this.checkRearYardOtherOccupancies(setback, block.getBuilding(), pl, block, setback.getLevel(), plot, "Rear Setback", min, mean, occupancy.getTypeHelper(), rearYardResult, buildingHeight);
                    }
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("Byelaw", rearYardResult.subRule);
                    details.put("Level", rearYardResult.level != null ? rearYardResult.level.toString() : "");
                    details.put("Occupancy", rearYardResult.occupancy);
                    if (rearYardResult.expectedmeanDistance != null && rearYardResult.expectedmeanDistance.compareTo(BigDecimal.valueOf(0L)) == 0) {
                        details.put("Field Verified", MINIMUMLABEL);
                        details.put("Permissible", rearYardResult.expectedminimumDistance.toString());
                        details.put("Provided", rearYardResult.actualMinDistance.toString());
                    } else {
                        details.put("Field Verified", MINIMUMLABEL);
                        details.put("Permissible", rearYardResult.expectedminimumDistance.toString());
                        details.put("Provided", rearYardResult.actualMinDistance.toString());
                    }
                    if (rearYardResult.status) {
                        details.put("Status", Result.Accepted.getResultVal());
                    } else {
                        details.put("Status", Result.Not_Accepted.getResultVal());
                    }
                    this.scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
                }
            }
        }
    }

    private Boolean checkRearYardUptoTenMts(Plan pl, Building building, Block block, Integer level, Plot plot, String rearYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, BigDecimal buildingHeight) {
        String subRule = RULE_35;
        String rule = "Rear Setback";
        Boolean valid = false;
        BigDecimal minVal = BigDecimal.valueOf(0L);
        BigDecimal meanVal = BigDecimal.valueOf(0L);
        BigDecimal depthOfPlot = pl.getPlanInformation().getDepthOfPlot();
        if (mostRestrictiveOccupancy.getSubtype() != null && ("A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()))) {
            valid = pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null && StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) && "COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) && pl.getPlanInformation().getRoadWidth().compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0 ? this.commercialUptoSixteenMts(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, "28", rule, minVal, meanVal, depthOfPlot, valid) : this.residentialUptoTenMts(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, subRule, rule, minVal, meanVal, depthOfPlot, valid);
        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            valid = this.commercialUptoSixteenMts(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, subRule, rule, minVal, meanVal, depthOfPlot, valid);
        }
        return valid;
    }

    private Boolean residentialUptoTenMts(Block block, Integer level, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal depthOfPlot, Boolean valid) {
        if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_0_9;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_1_2;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_1_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_1_8;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_2_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_3;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(45L)) > 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareRearYardResult(block.getName(), min, mean, mostRestrictiveOccupancy, rearYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean checkRearYardBasement(Plan plan, Building building, String blockName, Integer level, Plot plot, String rearYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult) {
        Boolean valid = false;
        String subRule = RULE_47;
        String rule = "Rear Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        if (mostRestrictiveOccupancy.getSubtype() != null && "A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            if (plot.getArea().compareTo(BigDecimal.valueOf(300L)) <= 0) {
                minVal = REARYARDMINIMUM_DISTANCE_3;
                valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
            }
            rule = BSMT_REAR_YARD_DESC;
            this.compareRearYardResult(blockName, min, mean, mostRestrictiveOccupancy, rearYardResult, valid, subRule, rule, minVal, meanVal, level);
        }
        return valid;
    }

    private Boolean checkRearYardUptoToTweleveMts(SetBack setback, Building building, Plan pl, Block block, Integer level, Plot plot, String rearYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, HashMap<String, String> errors) {
        String subRule = RULE_35;
        String rule = "Rear Setback";
        Boolean valid = false;
        BigDecimal minVal = BigDecimal.valueOf(0L);
        BigDecimal meanVal = BigDecimal.valueOf(0L);
        BigDecimal depthOfPlot = pl.getPlanInformation().getDepthOfPlot();
        if (mostRestrictiveOccupancy.getSubtype() != null && "A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode())) {
            if (pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null && StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) && "COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) && pl.getPlanInformation().getRoadWidth().compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                this.commercialUptoSixteenMts(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, "28", rule, minVal, meanVal, depthOfPlot, valid);
            } else {
                valid = this.residentialUptoTwelveMts(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, subRule, rule, minVal, meanVal, depthOfPlot, valid, errors, pl);
            }
        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            valid = this.commercialUptoSixteenMts(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, subRule, rule, minVal, meanVal, depthOfPlot, valid);
        }
        return valid;
    }

    private Boolean checkRearYardForIndustrial(SetBack setback, Building building, Plan pl, Block block, Integer level, Plot plot, String rearYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult) {
        String subRule = RULE_35;
        String rule = "Rear Setback";
        Boolean valid = false;
        BigDecimal minVal = BigDecimal.valueOf(0L);
        BigDecimal meanVal = BigDecimal.valueOf(0L);
        BigDecimal widthOfPlot = pl.getPlanInformation().getWidthOfPlot();
        valid = this.processRearYardForIndustrial(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, subRule, rule, minVal, meanVal, pl.getPlot().getArea(), widthOfPlot, valid);
        return valid;
    }

    private Boolean residentialUptoTwelveMts(Block block, Integer level, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal depthOfPlot, Boolean valid, HashMap<String, String> errors, Plan pl) {
        if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            errors.put("uptoTwelveHeightUptoTenDepthRearYard", "No construction shall be permitted if depth of plot is less than 10 and building height less than 12 having floors upto G+2.");
            pl.addErrors(errors);
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_1_8;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_2;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_2_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_3;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(45L)) > 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareRearYardResult(block.getName(), min, mean, mostRestrictiveOccupancy, rearYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean processRearYardForIndustrial(Block block, Integer level, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal plotArea, BigDecimal widthOfPlot, Boolean valid) {
        if (plotArea.compareTo(BigDecimal.valueOf(550L)) < 0) {
            if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
                minVal = REARYARDMINIMUM_DISTANCE_3;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(12L)) <= 0) {
                minVal = REARYARDMINIMUM_DISTANCE_3;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
                minVal = REARYARDMINIMUM_DISTANCE_3;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(18L)) <= 0) {
                minVal = REARYARDMINIMUM_DISTANCE_4;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(18L)) > 0) {
                minVal = REARYARDMINIMUM_DISTANCE_4_5;
            }
        } else if (plotArea.compareTo(BigDecimal.valueOf(550L)) > 0 && plotArea.compareTo(BigDecimal.valueOf(1000L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4_5;
        } else if (plotArea.compareTo(BigDecimal.valueOf(1000L)) > 0 && plotArea.compareTo(BigDecimal.valueOf(5000L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_6;
        } else if (plotArea.compareTo(BigDecimal.valueOf(5000L)) > 0 && plotArea.compareTo(BigDecimal.valueOf(30000L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_9;
        } else if (plotArea.compareTo(BigDecimal.valueOf(30000L)) > 0) {
            minVal = REARYARDMINIMUM_DISTANCE_12;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareRearYardResult(block.getName(), min, mean, mostRestrictiveOccupancy, rearYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean checkRearYardUptoToSixteenMts(SetBack setback, Building building, Plan pl, Block block, Integer level, Plot plot, String rearYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, HashMap<String, String> errors) {
        String subRule = RULE_35;
        String rule = "Rear Setback";
        Boolean valid = false;
        BigDecimal minVal = BigDecimal.valueOf(0L);
        BigDecimal meanVal = BigDecimal.valueOf(0L);
        BigDecimal depthOfPlot = pl.getPlanInformation().getDepthOfPlot();
        if ("A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) && block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(5L)) <= 0) {
            valid = pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null && StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) && "COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) && pl.getPlanInformation().getRoadWidth().compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0 ? this.commercialUptoSixteenMts(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, "28", rule, minVal, meanVal, depthOfPlot, valid) : this.residentialUptoSixteenMts(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, subRule, rule, minVal, meanVal, depthOfPlot, valid, errors, pl);
        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            valid = this.commercialUptoSixteenMts(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, subRule, rule, minVal, meanVal, depthOfPlot, valid);
        }
        return valid;
    }

    private Boolean residentialUptoSixteenMts(Block block, Integer level, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal depthOfPlot, Boolean valid, HashMap<String, String> errors, Plan pl) {
        if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            errors.put("uptoSixteenHeightUptoTenDepthRearYard", "No construction shall be permitted if depth of plot is less than 10 and building height less than 16 having floors upto G+4.");
            pl.addErrors(errors);
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_2;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_3;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_3_6;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(45L)) > 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4_5;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareRearYardResult(block.getName(), min, mean, mostRestrictiveOccupancy, rearYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean commercialUptoSixteenMts(Block block, Integer level, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal depthOfPlot, Boolean valid) {
        if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_2;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_3;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(45L)) > 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4_5;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareRearYardResult(block.getName(), min, mean, mostRestrictiveOccupancy, rearYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean checkRearYardAboveSixteenMts(SetBack setback, Building building, Plan pl, Block block, Integer level, Plot plot, String rearYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, BigDecimal buildingHeight) {
        Boolean valid = false;
        String subRule = RULE_36;
        String rule = "Rear Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        valid = this.allOccupancyForHighRise(block, level, min, mean, mostRestrictiveOccupancy, rearYardResult, subRule, rule, minVal, meanVal, buildingHeight);
        return valid;
    }

    private Boolean allOccupancyForHighRise(Block block, Integer level, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal blockBuildingHeight) {
        Boolean valid = false;
        if (blockBuildingHeight.compareTo(BigDecimal.valueOf(16L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(19L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4_5;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(19L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(22L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_4_5;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(22L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(25L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_5;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(25L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(28L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_6;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(28L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(31L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_7;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(31L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(36L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_7;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(36L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(41L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_8;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(41L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(46L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_8;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(46L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(51L)) <= 0) {
            minVal = REARYARDMINIMUM_DISTANCE_9;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(51L)) > 0) {
            minVal = REARYARDMINIMUM_DISTANCE_9;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareRearYardResult(block.getName(), min, mean, mostRestrictiveOccupancy, rearYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean checkRearYardOtherOccupancies(SetBack setback, Building building, Plan pl, Block block, Integer level, Plot plot, String rearYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, BigDecimal buildingHeight) {
        Boolean valid = false;
        String subRule = RULE_37_TWO_A;
        String rule = "Rear Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        if (mostRestrictiveOccupancy.getType() != null && "B".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = REARYARDMINIMUM_DISTANCE_6;
            subRule = RULE_37_TWO_A;
        }
        if (mostRestrictiveOccupancy.getType() != null && "B".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = REARYARDMINIMUM_DISTANCE_6;
            subRule = RULE_37_TWO_B;
        }
        if (mostRestrictiveOccupancy.getType() != null && "D".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = REARYARDMINIMUM_DISTANCE_6;
            subRule = RULE_37_TWO_C;
        }
        if (mostRestrictiveOccupancy.getType() != null && "D".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = REARYARDMINIMUM_DISTANCE_7;
            subRule = RULE_37_TWO_D;
        }
        if (mostRestrictiveOccupancy.getType() != null && "I".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = REARYARDMINIMUM_DISTANCE_9;
            subRule = RULE_37_TWO_G;
        }
        if (mostRestrictiveOccupancy.getType() != null && "A".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = REARYARDMINIMUM_DISTANCE_3;
            subRule = RULE_37_TWO_H;
        }
        if (mostRestrictiveOccupancy.getType() != null && "F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            subRule = RULE_37_TWO_I;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareRearYardResult(block.getName(), min, mean, mostRestrictiveOccupancy, rearYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean validateMinimumAndMeanValue(BigDecimal min, BigDecimal mean, BigDecimal minval, BigDecimal meanval) {
        Boolean valid = false;
        if (min.compareTo(minval) >= 0 && mean.compareTo(meanval) >= 0) {
            valid = true;
        }
        return valid;
    }

    private void validateRearYard(Plan pl) {
        for (Block block : pl.getBlocks()) {
            if (block.getCompletelyExisting().booleanValue()) continue;
            Boolean rearYardDefined = false;
            for (SetBack setback : block.getSetBacks()) {
                if (setback.getRearYard() == null || setback.getRearYard().getMean().compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                rearYardDefined = true;
            }
            if (rearYardDefined.booleanValue() || pl.getPlanInformation().getNocToAbutRearDesc().equalsIgnoreCase("YES")) continue;
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("Rear Setback", this.prepareMessage("msg.error.not.defined", "Rear Setback for Block " + block.getName()));
            pl.addErrors(errors);
        }
    }

    private void compareRearYardResult(String blockName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, RearYardResult rearYardResult, Boolean valid, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, Integer level) {
        String occupancyName = mostRestrictiveOccupancy.getSubtype() != null ? mostRestrictiveOccupancy.getSubtype().getName() : mostRestrictiveOccupancy.getType().getName();
        if (minVal.compareTo(rearYardResult.expectedminimumDistance) >= 0) {
            if (minVal.compareTo(rearYardResult.expectedminimumDistance) == 0) {
                rearYardResult.rule = rearYardResult.rule != null ? rearYardResult.rule + "," + rule : rule;
                String string = rearYardResult.occupancy = rearYardResult.occupancy != null ? rearYardResult.occupancy + "," + occupancyName : occupancyName;
                if (meanVal.compareTo(rearYardResult.expectedmeanDistance) >= 0) {
                    rearYardResult.expectedmeanDistance = meanVal;
                    rearYardResult.actualMeanDistance = mean;
                }
            } else {
                rearYardResult.rule = rule;
                rearYardResult.occupancy = occupancyName;
                rearYardResult.expectedmeanDistance = meanVal;
                rearYardResult.actualMeanDistance = mean;
            }
            rearYardResult.subRule = subRule;
            rearYardResult.blockName = blockName;
            rearYardResult.level = level;
            rearYardResult.expectedminimumDistance = minVal;
            rearYardResult.actualMinDistance = min;
            rearYardResult.status = valid;
        }
    }

    private class RearYardResult {
        String rule;
        String subRule;
        String blockName;
        Integer level;
        BigDecimal actualMeanDistance = BigDecimal.ZERO;
        BigDecimal actualMinDistance = BigDecimal.ZERO;
        String occupancy;
        BigDecimal expectedminimumDistance = BigDecimal.ZERO;
        BigDecimal expectedmeanDistance = BigDecimal.ZERO;
        boolean status = false;

        private RearYardResult() {
        }
    }
}

