/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.DARamp;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.OccupancyType;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Plot;
import org.egov.common.entity.edcr.Ramp;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.Util;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class RampService
extends FeatureProcess {
    private static final String SUBRULE_50_C_4_B = " 50-c-4-b";
    private static final String SUBRULE_40 = "40";
    private static final String SUBRULE_50_C_4_B_DESCRIPTION = "Maximum slope of ramp %s";
    private static final String SUBRULE_50_C_4_B_SLOPE_DESCRIPTION = "Maximum Slope of DA Ramp %s";
    private static final String FLOOR = "Floor";
    private static final String SUBRULE_50_C_4_B_SLOPE_MAN_DESC = "Slope of DA Ramp";

    @Override
    public Plan validate(Plan pl) {
        for (Block block : pl.getBlocks()) {
            if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty()) continue;
            for (Floor floor : block.getBuilding().getFloors()) {
                List ramps = floor.getRamps();
                if (ramps == null || ramps.isEmpty()) continue;
                for (Ramp ramp : ramps) {
                    List rampPolyLines = ramp.getRamps();
                    if (rampPolyLines == null || rampPolyLines.isEmpty()) continue;
                    this.validateDimensions(pl, block.getNumber(), floor.getNumber(), ramp.getNumber().toString(), rampPolyLines);
                }
            }
        }
        HashMap<String, String> errors = new HashMap<String, String>();
        OccupancyTypeHelper mostRestrictiveOccupancyType = pl.getVirtualBuilding().getMostRestrictiveFarHelper();
        if (pl != null && !pl.getBlocks().isEmpty()) {
            for (Block block : pl.getBlocks()) {
                if (pl.getPlot() == null || Util.checkExemptionConditionForSmallPlotAtBlkLevel((Plot)pl.getPlot(), (Block)block) || mostRestrictiveOccupancyType == null || mostRestrictiveOccupancyType.getSubtype() == null || "A-R".equalsIgnoreCase(mostRestrictiveOccupancyType.getSubtype().getCode())) continue;
                if (!block.getDARamps().isEmpty()) {
                    boolean isSlopeDefined = false;
                    for (DARamp daRamp : block.getDARamps()) {
                        if (daRamp == null || daRamp.getSlope() == null || daRamp.getSlope().compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                        isSlopeDefined = true;
                    }
                    if (isSlopeDefined) continue;
                    errors.put(String.format("DA Ramp %s slope for block %s", "", block.getNumber()), this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{String.format("DA Ramp %s slope for block %s", "", block.getNumber())}, LocaleContextHolder.getLocale()));
                    pl.addErrors(errors);
                    continue;
                }
                errors.put(String.format("DA Ramp", block.getNumber()), this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{String.format("DA Ramp", block.getNumber())}, LocaleContextHolder.getLocale()));
                pl.addErrors(errors);
                break;
            }
        }
        return pl;
    }

    private boolean getOccupanciesForRamp(OccupancyType occupancyType) {
        return occupancyType.equals((Object)OccupancyType.OCCUPANCY_A2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_A3) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_A4) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_B1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_B2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_B3) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_C) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_C1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_C2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_C3) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_D) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_D1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_D2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_E) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F1) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F2) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F3) || occupancyType.equals((Object)OccupancyType.OCCUPANCY_F4);
    }

    @Override
    public Plan process(Plan pl) {
        this.validate(pl);
        if (pl != null && !pl.getBlocks().isEmpty()) {
            for (Block block : pl.getBlocks()) {
                OccupancyTypeHelper mostRestrictiveFarHelper;
                boolean valid;
                this.scrutinyDetail = new ScrutinyDetail();
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
                this.scrutinyDetail.setKey("Block_" + block.getNumber() + "_DA Ramp - Defined or not");
                ScrutinyDetail scrutinyDetail1 = new ScrutinyDetail();
                scrutinyDetail1.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail1.addColumnHeading(Integer.valueOf(2), "Description");
                scrutinyDetail1.addColumnHeading(Integer.valueOf(3), "Required");
                scrutinyDetail1.addColumnHeading(Integer.valueOf(4), "Provided");
                scrutinyDetail1.addColumnHeading(Integer.valueOf(5), "Status");
                scrutinyDetail1.setKey("Block_" + block.getNumber() + "_DA Ramp - Slope width");
                ScrutinyDetail scrutinyDetail2 = new ScrutinyDetail();
                scrutinyDetail2.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail2.addColumnHeading(Integer.valueOf(2), "Description");
                scrutinyDetail2.addColumnHeading(Integer.valueOf(3), "Required");
                scrutinyDetail2.addColumnHeading(Integer.valueOf(4), "Provided");
                scrutinyDetail2.addColumnHeading(Integer.valueOf(5), "Status");
                scrutinyDetail2.setKey("Block_" + block.getNumber() + "_DA Ramp - Maximum Slope");
                ScrutinyDetail scrutinyDetail3 = new ScrutinyDetail();
                scrutinyDetail3.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail3.addColumnHeading(Integer.valueOf(2), FLOOR);
                scrutinyDetail3.addColumnHeading(Integer.valueOf(3), "Required");
                scrutinyDetail3.addColumnHeading(Integer.valueOf(4), "Provided");
                scrutinyDetail3.addColumnHeading(Integer.valueOf(5), "Status");
                scrutinyDetail3.setSubHeading("Minimum number of da rooms");
                scrutinyDetail3.setKey("Block_" + block.getNumber() + "_DA Room");
                ScrutinyDetail scrutinyDetail4 = new ScrutinyDetail();
                scrutinyDetail4.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail4.addColumnHeading(Integer.valueOf(2), "Description");
                scrutinyDetail4.addColumnHeading(Integer.valueOf(3), FLOOR);
                scrutinyDetail4.addColumnHeading(Integer.valueOf(4), "Required");
                scrutinyDetail4.addColumnHeading(Integer.valueOf(5), "Provided");
                scrutinyDetail4.addColumnHeading(Integer.valueOf(6), "Status");
                scrutinyDetail4.setKey("Block_" + block.getNumber() + "_Ramp - Minimum Width");
                ScrutinyDetail scrutinyDetail5 = new ScrutinyDetail();
                scrutinyDetail5.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail5.addColumnHeading(Integer.valueOf(2), "Description");
                scrutinyDetail5.addColumnHeading(Integer.valueOf(3), FLOOR);
                scrutinyDetail5.addColumnHeading(Integer.valueOf(4), "Required");
                scrutinyDetail5.addColumnHeading(Integer.valueOf(5), "Provided");
                scrutinyDetail5.addColumnHeading(Integer.valueOf(6), "Status");
                scrutinyDetail5.setKey("Block_" + block.getNumber() + "_Ramp - Maximum Slope");
                OccupancyTypeHelper mostRestrictiveOccupancyType = pl.getVirtualBuilding().getMostRestrictiveFarHelper();
                if (block.getBuilding() == null || block.getBuilding().getOccupancies().isEmpty()) continue;
                if (!(pl.getPlot() == null || Util.checkExemptionConditionForSmallPlotAtBlkLevel((Plot)pl.getPlot(), (Block)block) || mostRestrictiveOccupancyType == null || mostRestrictiveOccupancyType.getSubtype() == null || "A-R".equalsIgnoreCase(mostRestrictiveOccupancyType.getSubtype().getCode()) || block.getDARamps().isEmpty())) {
                    boolean isSlopeDefined = false;
                    for (DARamp daRamp : block.getDARamps()) {
                        if (daRamp == null || daRamp.getSlope() == null || daRamp.getSlope().compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                        isSlopeDefined = true;
                    }
                    if (isSlopeDefined) {
                        this.setReportOutputDetails(pl, SUBRULE_50_C_4_B, SUBRULE_50_C_4_B_SLOPE_MAN_DESC, "", " Defined in the plan.", Result.Accepted.getResultVal(), scrutinyDetail1);
                    } else {
                        this.setReportOutputDetails(pl, SUBRULE_50_C_4_B, SUBRULE_50_C_4_B_SLOPE_MAN_DESC, "", " Not defined in the plan.", Result.Not_Accepted.getResultVal(), scrutinyDetail1);
                    }
                    valid = false;
                    if (isSlopeDefined) {
                        HashMap<String, String> mapOfRampNumberAndSlopeValues = new HashMap<String, String>();
                        BigDecimal expectedSlope = BigDecimal.valueOf(1L).divide(BigDecimal.valueOf(12L), 2, RoundingMode.HALF_UP);
                        for (DARamp daRamp : block.getDARamps()) {
                            BigDecimal slope = daRamp.getSlope();
                            if (slope == null || slope.compareTo(BigDecimal.valueOf(0L)) <= 0 || expectedSlope == null || slope.compareTo(expectedSlope) > 0) continue;
                            valid = true;
                            mapOfRampNumberAndSlopeValues.put("daRampNumber", daRamp.getNumber().toString());
                            mapOfRampNumberAndSlopeValues.put("slope", slope.toString());
                            break;
                        }
                        if (valid) {
                            this.setReportOutputDetails(pl, SUBRULE_50_C_4_B, String.format(SUBRULE_50_C_4_B_SLOPE_DESCRIPTION, mapOfRampNumberAndSlopeValues.get("daRampNumber")), expectedSlope.toString(), (String)mapOfRampNumberAndSlopeValues.get("slope"), Result.Accepted.getResultVal(), scrutinyDetail2);
                        } else {
                            this.setReportOutputDetails(pl, SUBRULE_50_C_4_B, String.format(SUBRULE_50_C_4_B_SLOPE_DESCRIPTION, ""), expectedSlope.toString(), "Less than 0.08 for all da ramps", Result.Not_Accepted.getResultVal(), scrutinyDetail2);
                        }
                    }
                }
                if (block.getBuilding().getBuildingHeight().compareTo(new BigDecimal(15)) <= 0) continue;
                OccupancyTypeHelper occupancyTypeHelper = mostRestrictiveFarHelper = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
                if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty()) continue;
                for (Floor floor : block.getBuilding().getFloors()) {
                    for (Ramp ramp : floor.getRamps()) {
                        String value;
                        Object measurement2;
                        if (!ramp.getRampClosed().booleanValue()) continue;
                        ArrayList<BigDecimal> rampWidths = new ArrayList<BigDecimal>();
                        ArrayList<BigDecimal> rampLengths = new ArrayList<BigDecimal>();
                        for (Object measurement2 : ramp.getRamps()) {
                            rampWidths.add(measurement2.getWidth());
                            rampLengths.add(measurement2.getHeight());
                        }
                        BigDecimal rampTotalLength = BigDecimal.ZERO;
                        measurement2 = rampLengths.iterator();
                        while (measurement2.hasNext()) {
                            BigDecimal length = (BigDecimal)measurement2.next();
                            rampTotalLength = rampTotalLength.add(length);
                        }
                        if (rampTotalLength.compareTo(BigDecimal.valueOf(0L)) <= 0 || ramp.getFloorHeight() == null) continue;
                        boolean isTypicalRepititiveFloor = false;
                        BigDecimal rampSlope = ramp.getFloorHeight().divide(rampTotalLength, 2, RoundingMode.HALF_UP);
                        ramp.setSlope(rampSlope);
                        BigDecimal expectedSlope = BigDecimal.ZERO;
                        expectedSlope = mostRestrictiveFarHelper != null && (mostRestrictiveFarHelper.getType() != null && mostRestrictiveFarHelper.getType().getCode().equalsIgnoreCase("C") || mostRestrictiveFarHelper.getSubtype() != null && (mostRestrictiveFarHelper.getSubtype().getCode().equalsIgnoreCase("C-MA") || mostRestrictiveFarHelper.getSubtype().getCode().equalsIgnoreCase("C-MIP") || mostRestrictiveFarHelper.getSubtype().getCode().equalsIgnoreCase("C-MOP"))) ? BigDecimal.valueOf(0.05) : (ramp.getFloorHeight().compareTo(BigDecimal.valueOf(2.4)) > 0 ? BigDecimal.valueOf(0.05) : BigDecimal.valueOf(0.08));
                        valid = false;
                        Map typicalFloorValues = Util.getTypicalFloorValues((Block)block, (Floor)floor, (Boolean)isTypicalRepititiveFloor);
                        if (((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) continue;
                        if (rampSlope.compareTo(expectedSlope) <= 0) {
                            valid = true;
                        }
                        String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
                        if (valid) {
                            this.setReportOutputDetailsFloorWiseWithDescription(pl, SUBRULE_40, String.format(SUBRULE_50_C_4_B_DESCRIPTION, ramp.getNumber()), value, expectedSlope.toString(), rampSlope.toString(), Result.Accepted.getResultVal(), scrutinyDetail5);
                            continue;
                        }
                        this.setReportOutputDetailsFloorWiseWithDescription(pl, SUBRULE_40, String.format(SUBRULE_50_C_4_B_DESCRIPTION, ramp.getNumber()), value, expectedSlope.toString(), rampSlope.toString(), Result.Not_Accepted.getResultVal(), scrutinyDetail5);
                    }
                }
            }
        }
        return pl;
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    private void setReportOutputDetailsFloorWise(Plan pl, String ruleNo, String floor, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put(FLOOR, floor);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    private void setReportOutputDetailsFloorWiseWithDescription(Plan pl, String ruleNo, String ruleDesc, String floor, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put(FLOOR, floor);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    private void validateDimensions(Plan plan, String blockNo, int floorNo, String rampNo, List<Measurement> rampPolylines) {
        int count = 0;
        for (Measurement m : rampPolylines) {
            if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
            ++count;
        }
        if (count > 0) {
            plan.addError(String.format("BLK_%s_FLR_%s_RAMP_%s", blockNo, floorNo, rampNo), count + " number of ramp polyline not having only 4 points in layer " + String.format("BLK_%s_FLR_%s_RAMP_%s", blockNo, floorNo, rampNo));
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

