/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class RainWaterHarvesting
extends FeatureProcess {
    private static final String RULE_51 = "51";
    private static final String RULE_51_DESCRIPTION = "Rain Water Harvesting";
    private static final BigDecimal HUNDRED = BigDecimal.valueOf(100L);
    private static final String RWH_DECLARATION_ERROR = "RWH_DECLARED in PLAN_INFO layer must be declared as YES for plot area greater than 100 sqm.";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        OccupancyTypeHelper mostRestrictiveFarHelper;
        HashMap<String, String> errors = new HashMap<String, String>();
        this.scrutinyDetail = new ScrutinyDetail();
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        this.scrutinyDetail.setKey("Common_Rain Water Harvesting");
        String subRule = RULE_51;
        String subRuleDesc = RULE_51_DESCRIPTION;
        BigDecimal plotArea = pl.getPlot() != null ? pl.getPlot().getArea() : BigDecimal.ZERO;
        OccupancyTypeHelper occupancyTypeHelper = mostRestrictiveFarHelper = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
        if (mostRestrictiveFarHelper != null && mostRestrictiveFarHelper.getType() != null) {
            if ("A".equalsIgnoreCase(mostRestrictiveFarHelper.getType().getCode()) && plotArea.compareTo(HUNDRED) >= 0) {
                this.addOutput(pl, errors, subRule, subRuleDesc);
            } else if ("F".equalsIgnoreCase(mostRestrictiveFarHelper.getType().getCode())) {
                this.addOutput(pl, errors, subRule, subRuleDesc);
            } else if ("G".equalsIgnoreCase(mostRestrictiveFarHelper.getType().getCode())) {
                this.addOutput(pl, errors, subRule, subRuleDesc);
            }
        }
        return pl;
    }

    private void addOutput(Plan pl, HashMap<String, String> errors, String subRule, String subRuleDesc) {
        if (pl.getPlanInformation() != null && pl.getPlanInformation().getRwhDeclared() != null) {
            if (pl.getPlanInformation().getRwhDeclared().equalsIgnoreCase("NO") || pl.getPlanInformation().getRwhDeclared().equalsIgnoreCase("NA")) {
                errors.put("RWH_DECLARED", RWH_DECLARATION_ERROR);
                pl.addErrors(errors);
                this.addReportOutput(pl, subRule, subRuleDesc);
            } else {
                this.addReportOutput(pl, subRule, subRuleDesc);
            }
        }
    }

    private void addReportOutput(Plan pl, String subRule, String subRuleDesc) {
        if (pl.getUtility() != null) {
            if (pl.getUtility().getRainWaterHarvest() != null && !pl.getUtility().getRainWaterHarvest().isEmpty()) {
                this.setReportOutputDetails(pl, subRule, subRuleDesc, null, "Defined in the plan", Result.Verify.getResultVal());
            } else {
                this.setReportOutputDetails(pl, subRule, subRuleDesc, null, "Not Defined in the plan", Result.Not_Accepted.getResultVal());
            }
        }
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

