/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.dcr.helper.OccupancyHelperDetail;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class PlotArea
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(PlotArea.class);
    private static final String RULE_34 = "34-1";
    public static final String PLOTAREA_DESCRIPTION = "Minimum Plot Area";
    public static final BigDecimal THREE_ZERO = BigDecimal.valueOf(300L);
    public static final BigDecimal FIVE_ZERO = BigDecimal.valueOf(500L);

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        BigDecimal plotArea;
        if (pl.getPlot() != null && (plotArea = pl.getPlot().getArea()) != null) {
            ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
            scrutinyDetail.setKey("Common_Plot Area");
            scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
            scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Occupancy");
            scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Permitted");
            scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", RULE_34);
            details.put("Description", PLOTAREA_DESCRIPTION);
            Map<String, BigDecimal> occupancyValuesMap = this.getOccupancyValues();
            if (pl.getVirtualBuilding() != null && pl.getVirtualBuilding().getMostRestrictiveFarHelper() != null) {
                OccupancyHelperDetail occupancyType;
                OccupancyHelperDetail occupancyHelperDetail = occupancyType = pl.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype() : pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType();
                if (occupancyType != null) {
                    details.put("Occupancy", occupancyType.getName());
                    BigDecimal occupancyValues = occupancyValuesMap.get(occupancyType.getCode());
                    if (occupancyValues != null) {
                        if (plotArea.compareTo(occupancyValues) >= 0) {
                            details.put("Permitted", String.valueOf(occupancyValues) + "m2");
                            details.put("Provided", plotArea.toString() + "m2");
                            details.put("Status", Result.Accepted.getResultVal());
                            scrutinyDetail.getDetail().add(details);
                            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                        } else {
                            details.put("Permitted", String.valueOf(occupancyValues) + "m2");
                            details.put("Provided", plotArea.toString() + "m2");
                            details.put("Status", Result.Not_Accepted.getResultVal());
                            scrutinyDetail.getDetail().add(details);
                            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                        }
                    }
                }
            }
        }
        return pl;
    }

    public Map<String, BigDecimal> getOccupancyValues() {
        HashMap<String, BigDecimal> plotAreaValues = new HashMap<String, BigDecimal>();
        plotAreaValues.put("F-RT", THREE_ZERO);
        plotAreaValues.put("M-NAPI", THREE_ZERO);
        plotAreaValues.put("F-CB", THREE_ZERO);
        plotAreaValues.put("S-MCH", FIVE_ZERO);
        plotAreaValues.put("E-PS", THREE_ZERO);
        return plotAreaValues;
    }
}

