/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.stereotype.Service;

@Service
public class PlantationGreenStrip
extends FeatureProcess {
    private static final String RULE_37_6 = "37-6";

    @Override
    public Plan validate(Plan pl) {
        return null;
    }

    @Override
    public Plan process(Plan pl) {
        if (pl.getPlot() != null && pl.getPlot().getArea().compareTo(BigDecimal.valueOf(300L)) > 0) {
            for (Block block : pl.getBlocks()) {
                ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
                scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
                scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Permissible");
                scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
                scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
                scrutinyDetail.setKey("Block_" + block.getNumber() + "_Continuous Green Planting Strip");
                boolean isWidthAccepted = false;
                BigDecimal minWidth = BigDecimal.ZERO;
                List widths = block.getPlantationGreenStripes().stream().map(greenStrip -> greenStrip.getWidth()).collect(Collectors.toList());
                if (widths.isEmpty()) {
                    pl.addError("RULE_37_6", this.getLocaleMessage("msg.error.not.defined", "Block " + block.getNumber() + " Continuous Green Planting Strip"));
                }
                if (widths.isEmpty()) continue;
                minWidth = (BigDecimal)widths.stream().reduce(BigDecimal::min).get();
                if (minWidth.compareTo(BigDecimal.valueOf(0.6)) >= 0) {
                    isWidthAccepted = true;
                }
                this.buildResult(pl, scrutinyDetail, isWidthAccepted, "Width of continuos plantation green strip", ">= 0.6", minWidth.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS).toString());
            }
        }
        return pl;
    }

    private void buildResult(Plan pl, ScrutinyDetail scrutinyDetail, boolean valid, String description, String permited, String provided) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_37_6);
        details.put("Description", description);
        details.put("Permissible", permited);
        details.put("Provided", provided);
        details.put("Status", valid ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

