/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.stereotype.Service;

@Service
public class Plantation
extends FeatureProcess {
    private static final Logger LOGGER = Logger.getLogger(Plantation.class);
    private static final String RULE_32 = "32";
    public static final String PLANTATION_TREECOVER_DESCRIPTION = "Plantation tree cover";

    @Override
    public Plan validate(Plan pl) {
        return null;
    }

    @Override
    public Plan process(Plan pl) {
        this.validate(pl);
        this.scrutinyDetail = new ScrutinyDetail();
        this.scrutinyDetail.setKey("Common_Plantation");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_32);
        details.put("Description", PLANTATION_TREECOVER_DESCRIPTION);
        BigDecimal totalArea = BigDecimal.ZERO;
        BigDecimal plotArea = BigDecimal.ZERO;
        BigDecimal plantationPer = BigDecimal.ZERO;
        String type = "";
        String subType = "";
        if (pl.getPlantation() != null && pl.getPlantation().getPlantations() != null && !pl.getPlantation().getPlantations().isEmpty()) {
            for (Measurement m : pl.getPlantation().getPlantations()) {
                totalArea = totalArea.add(m.getArea());
            }
            if (pl.getPlot() != null) {
                plotArea = pl.getPlot().getArea();
            }
            if (pl.getVirtualBuilding() != null && pl.getVirtualBuilding().getMostRestrictiveFarHelper() != null && pl.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype() != null) {
                type = pl.getVirtualBuilding().getMostRestrictiveFarHelper().getType().getCode();
                subType = pl.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype().getCode();
            }
            if (totalArea.intValue() > 0 && plotArea != null && plotArea.intValue() > 0) {
                plantationPer = totalArea.divide(plotArea, 2, DcrConstants.ROUNDMODE_MEASUREMENTS);
            }
            if ("A-AF".equals(subType) || "A-SA".equals(subType) || "B".equals(type) || "D".equals(type) || "G".equals(type)) {
                if (plantationPer.compareTo(new BigDecimal("0.10")) < 0) {
                    details.put("Required", ">= 10%");
                    details.put("Provided", plantationPer.multiply(new BigDecimal(100)).toString() + "%");
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
                } else {
                    details.put("Required", ">= 10%");
                    details.put("Provided", plantationPer.multiply(new BigDecimal(100)).toString() + "%");
                    details.put("Status", Result.Accepted.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
                }
            } else if (plantationPer.compareTo(new BigDecimal("0.05")) < 0) {
                details.put("Required", ">= 5%");
                details.put("Provided", plantationPer.multiply(new BigDecimal(100)).toString() + "%");
                details.put("Status", Result.Not_Accepted.getResultVal());
                this.scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
            } else {
                details.put("Required", ">= 5%");
                details.put("Provided", plantationPer.multiply(new BigDecimal(100)).toString() + "%");
                details.put("Status", Result.Accepted.getResultVal());
                this.scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

