/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Passage;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.Util;
import org.springframework.stereotype.Service;

@Service
public class PassageService
extends FeatureProcess {
    private static final String RULE41 = "41";
    private static final String RULE39_6 = "39(6)";
    private static final String PASSAGE_STAIR_MINIMUM_WIDTH = "1.2";
    private static final String RULE39_6_DESCRIPTION = "The minimum passage giving access to stair";
    private static final String RULE_41_DESCRIPTION = "The minimum width of corridors/ verandhas";

    @Override
    public Plan validate(Plan plan) {
        return plan;
    }

    @Override
    public Plan process(Plan plan) {
        for (Block block : plan.getBlocks()) {
            BigDecimal minWidth;
            if (block.getBuilding() == null) continue;
            ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
            scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Required");
            scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Provided");
            scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Status");
            scrutinyDetail.setKey("Block_" + block.getNumber() + "_Passage");
            ScrutinyDetail scrutinyDetail1 = new ScrutinyDetail();
            scrutinyDetail1.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail1.addColumnHeading(Integer.valueOf(2), "Required");
            scrutinyDetail1.addColumnHeading(Integer.valueOf(3), "Provided");
            scrutinyDetail1.addColumnHeading(Integer.valueOf(4), "Status");
            scrutinyDetail1.setKey("Block_" + block.getNumber() + "_Passage Stair");
            Passage passage = block.getBuilding().getPassage();
            if (passage == null) continue;
            List passagePolylines = passage.getPassageDimensions();
            List passageStairPolylines = passage.getPassageStairDimensions();
            if (passagePolylines != null && passagePolylines.size() > 0) {
                BigDecimal minPassagePolyLine = (BigDecimal)passagePolylines.stream().reduce(BigDecimal::min).get();
                minWidth = Util.roundOffTwoDecimal((BigDecimal)minPassagePolyLine);
                if (minWidth.compareTo(BigDecimal.ONE) >= 0) {
                    this.setReportOutputDetails(plan, RULE41, RULE_41_DESCRIPTION, String.valueOf(1), String.valueOf(minWidth), Result.Accepted.getResultVal(), scrutinyDetail);
                } else {
                    this.setReportOutputDetails(plan, RULE41, RULE_41_DESCRIPTION, String.valueOf(1), String.valueOf(minWidth), Result.Not_Accepted.getResultVal(), scrutinyDetail);
                }
            }
            if (passageStairPolylines == null || passageStairPolylines.size() <= 0) continue;
            BigDecimal minPassageStairPolyLine = (BigDecimal)passageStairPolylines.stream().reduce(BigDecimal::min).get();
            minWidth = Util.roundOffTwoDecimal((BigDecimal)minPassageStairPolyLine);
            if (minWidth.compareTo(Util.roundOffTwoDecimal((BigDecimal)BigDecimal.valueOf(1.2))) >= 0) {
                this.setReportOutputDetails(plan, RULE39_6, RULE39_6_DESCRIPTION, PASSAGE_STAIR_MINIMUM_WIDTH, String.valueOf(minWidth), Result.Accepted.getResultVal(), scrutinyDetail1);
                continue;
            }
            this.setReportOutputDetails(plan, RULE39_6, RULE39_6_DESCRIPTION, PASSAGE_STAIR_MINIMUM_WIDTH, String.valueOf(minWidth), Result.Not_Accepted.getResultVal(), scrutinyDetail1);
        }
        return plan;
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

