/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.OccupancyType;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.ParkingDetails;
import org.egov.common.entity.edcr.ParkingHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.Util;
import org.springframework.stereotype.Service;

@Service
public class Parking
extends FeatureProcess {
    private static final Logger LOGGER = Logger.getLogger(Parking.class);
    private static final String OUT_OF = "Out of ";
    private static final String SLOT_HAVING_GT_4_PTS = " number of polygon not having only 4 points.";
    private static final String LOADING_UNLOADING_DESC = "Minimum required Loading/Unloading area";
    private static final String MINIMUM_AREA_OF_EACH_DA_PARKING = " Minimum width of Each Special parking";
    private static final String SP_PARKING_SLOT_AREA = "Special Parking Area";
    private static final String NO_VIOLATION_OF_AREA = "No violation of area in ";
    private static final String MIN_AREA_EACH_CAR_PARKING = " Minimum Area of Each ECS parking";
    private static final String PARKING_VIOLATED_MINIMUM_AREA = " parking violated minimum area.";
    private static final String PARKING = " parking ";
    private static final String NUMBERS = " Numbers ";
    private static final String MECHANICAL_PARKING = "Mechanical parking";
    private static final String MAX_ALLOWED_MECH_PARK = "Maximum allowed mechanical parking";
    private static final String TWO_WHEELER_PARK_AREA = "Two Wheeler Parking Area";
    private static final String LOADING_UNLOADING_AREA = "Loading Unloading Area";
    private static final String SP_PARKING = "Special parking";
    private static final String SUB_RULE_34_1_DESCRIPTION = "Parking Slots Area";
    private static final String SUB_RULE_34_2 = "34-2";
    private static final String SUB_RULE_40_8 = "40-8";
    private static final String SUB_RULE_40_11 = "40-11";
    private static final String PARKING_MIN_AREA = "5 M x 2 M";
    private static final double PARKING_SLOT_WIDTH = 2.0;
    private static final double PARKING_SLOT_HEIGHT = 5.0;
    private static final double SP_PARK_SLOT_MIN_SIDE = 3.6;
    private static final String DA_PARKING_MIN_AREA = " 3.60 M ";
    public static final String NO_OF_UNITS = "No of apartment units";
    private static final double TWO_WHEEL_PARKING_AREA_WIDTH = 1.5;
    private static final double TWO_WHEEL_PARKING_AREA_HEIGHT = 2.0;
    private static final double MECH_PARKING_WIDTH = 2.7;
    private static final double MECH_PARKING_HEIGHT = 5.5;
    private static final double OPEN_ECS = 23.0;
    private static final double COVER_ECS = 28.0;
    private static final double BSMNT_ECS = 32.0;
    private static final double PARK_A = 0.25;
    private static final double PARK_F = 0.3;
    private static final double PARK_VISITOR = 0.15;
    private static final String SUB_RULE_40 = "40";
    private static final String SUB_RULE_40_2 = "40-2";
    private static final String SUB_RULE_40_2_DESCRIPTION = "Parking space";
    private static final String SUB_RULE_40_10 = "40-10";
    private static final String SUB_RULE_40_10_DESCRIPTION = "Visitor\u2019s Parking";
    public static final String OPEN_PARKING_DIM_DESC = "Open parking ECS dimension ";
    public static final String COVER_PARKING_DIM_DESC = "Cover parking ECS dimension ";
    public static final String BSMNT_PARKING_DIM_DESC = "Basement parking ECS dimension ";
    public static final String VISITOR_PARKING = "Visitor parking";
    public static final String SPECIAL_PARKING_DIM_DESC = "Special parking ECS dimension ";
    public static final String TWO_WHEELER_DIM_DESC = "Two wheeler parking dimension ";
    public static final String MECH_PARKING_DESC = "Mechanical parking dimension ";
    public static final String MECH_PARKING_DIM_DESC = "All Mechanical parking polylines should have dimension 2.7*5.5 m\u00b2";
    public static final String MECH_PARKING_DIM_DESC_NA = " mechanical parking polyines does not have dimensions 2.7*5.5 m\u00b2";
    private static final String PARKING_VIOLATED_DIM = " parking violated dimension.";
    private static final String PARKING_AREA_DIM = "1.5 M x 2 M";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        this.validate(pl);
        this.scrutinyDetail = new ScrutinyDetail();
        this.scrutinyDetail.setKey("Common_Parking");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        this.processParking(pl);
        return pl;
    }

    private void validateDimensions(Plan pl) {
        int count;
        ParkingDetails parkDtls = pl.getParkingDetails();
        if (!parkDtls.getCars().isEmpty()) {
            count = 0;
            for (Measurement m : parkDtls.getCars()) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError("PARKING_SLOT", "PARKING_SLOT" + count + SLOT_HAVING_GT_4_PTS);
            }
        }
        if (!parkDtls.getOpenCars().isEmpty()) {
            count = 0;
            for (Measurement m : parkDtls.getOpenCars()) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError(OPEN_PARKING_DIM_DESC, OPEN_PARKING_DIM_DESC + count + SLOT_HAVING_GT_4_PTS);
            }
        }
        if (!parkDtls.getCoverCars().isEmpty()) {
            count = 0;
            for (Measurement m : parkDtls.getCoverCars()) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError(COVER_PARKING_DIM_DESC, COVER_PARKING_DIM_DESC + count + SLOT_HAVING_GT_4_PTS);
            }
        }
        if (!parkDtls.getCoverCars().isEmpty()) {
            count = 0;
            for (Measurement m : parkDtls.getBasementCars()) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError(BSMNT_PARKING_DIM_DESC, BSMNT_PARKING_DIM_DESC + count + SLOT_HAVING_GT_4_PTS);
            }
        }
        if (!parkDtls.getSpecial().isEmpty()) {
            count = 0;
            for (Measurement m : parkDtls.getDisabledPersons()) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError(SPECIAL_PARKING_DIM_DESC, SPECIAL_PARKING_DIM_DESC + count + " number of DA Parking slot polygon not having only 4 points.");
            }
        }
        if (!parkDtls.getLoadUnload().isEmpty()) {
            count = 0;
            for (Measurement m : parkDtls.getLoadUnload()) {
                if (m.getArea().compareTo(BigDecimal.valueOf(30L)) >= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError("load unload", count + " loading unloading parking spaces doesnt contain minimum of 30m2");
            }
        }
        if (!parkDtls.getMechParking().isEmpty()) {
            count = 0;
            for (Measurement m : parkDtls.getMechParking()) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError(MECHANICAL_PARKING, count + " number of Mechanical parking slot polygon not having only 4 points.");
            }
        }
        if (!parkDtls.getTwoWheelers().isEmpty()) {
            count = 0;
            for (Measurement m : parkDtls.getTwoWheelers()) {
                if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
                ++count;
            }
            if (count > 0) {
                pl.addError(TWO_WHEELER_DIM_DESC, TWO_WHEELER_DIM_DESC + count + " number of two wheeler Parking slot polygon not having only 4 points.");
            }
        }
    }

    public void processParking(Plan pl) {
        ParkingHelper helper = new ParkingHelper();
        OccupancyTypeHelper mostRestrictiveOccupancy = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
        BigDecimal totalBuiltupArea = pl.getOccupancies().stream().map(Occupancy::getBuiltUpArea).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal coverParkingArea = BigDecimal.ZERO;
        BigDecimal basementParkingArea = BigDecimal.ZERO;
        for (Block block : pl.getBlocks()) {
            for (Floor floor : block.getBuilding().getFloors()) {
                coverParkingArea = coverParkingArea.add(floor.getParking().getCoverCars().stream().map(Measurement::getArea).reduce(BigDecimal.ZERO, BigDecimal::add));
                basementParkingArea = basementParkingArea.add(floor.getParking().getBasementCars().stream().map(Measurement::getArea).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        BigDecimal openParkingArea = pl.getParkingDetails().getOpenCars().stream().map(Measurement::getArea).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalProvidedCarParkArea = openParkingArea.add(coverParkingArea).add(basementParkingArea);
        ParkingHelper parkingHelper = helper;
        parkingHelper.totalRequiredCarParking = parkingHelper.totalRequiredCarParking + openParkingArea.doubleValue() / 23.0;
        parkingHelper = helper;
        parkingHelper.totalRequiredCarParking = parkingHelper.totalRequiredCarParking + coverParkingArea.doubleValue() / 28.0;
        parkingHelper = helper;
        parkingHelper.totalRequiredCarParking = parkingHelper.totalRequiredCarParking + basementParkingArea.doubleValue() / 32.0;
        Double requiredCarParkArea = 0.0;
        Double requiredVisitorParkArea = 0.0;
        BigDecimal providedVisitorParkArea = BigDecimal.ZERO;
        this.validateSpecialParking(pl, helper, totalBuiltupArea);
        if (totalBuiltupArea != null && totalBuiltupArea.doubleValue() <= 300.0) {
            if (mostRestrictiveOccupancy != null && "A".equals(mostRestrictiveOccupancy.getType().getCode())) {
                if (totalBuiltupArea.doubleValue() <= 200.0) {
                    requiredCarParkArea = requiredCarParkArea + 23.0;
                } else if (totalBuiltupArea.doubleValue() > 200.0 && totalBuiltupArea.doubleValue() <= 300.0) {
                    requiredCarParkArea = requiredCarParkArea + 46.0;
                }
            } else {
                BigDecimal builtupArea = totalBuiltupArea.subtract(totalBuiltupArea.multiply(BigDecimal.valueOf(0.15)));
                double requiredEcs = builtupArea.divide(BigDecimal.valueOf(100L)).multiply(BigDecimal.valueOf(2L)).setScale(0, RoundingMode.UP).doubleValue();
                if (openParkingArea.doubleValue() > 0.0 && coverParkingArea.doubleValue() > 0.0) {
                    requiredCarParkArea = requiredCarParkArea + 28.0 * requiredEcs;
                } else if (openParkingArea.doubleValue() > 0.0 && basementParkingArea.doubleValue() > 0.0) {
                    requiredCarParkArea = requiredCarParkArea + 32.0 * requiredEcs;
                } else if (coverParkingArea.doubleValue() > 0.0 && basementParkingArea.doubleValue() > 0.0) {
                    requiredCarParkArea = requiredCarParkArea + 32.0 * requiredEcs;
                } else if (coverParkingArea.doubleValue() > 0.0) {
                    requiredCarParkArea = requiredCarParkArea + 28.0 * requiredEcs;
                } else if (basementParkingArea.doubleValue() > 0.0) {
                    requiredCarParkArea = requiredCarParkArea + 32.0 * requiredEcs;
                } else if (openParkingArea.doubleValue() > 0.0) {
                    requiredCarParkArea = requiredCarParkArea + 23.0 * requiredEcs;
                }
            }
        } else {
            providedVisitorParkArea = pl.getParkingDetails().getVisitors().stream().map(Measurement::getArea).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (mostRestrictiveOccupancy != null && "A".equals(mostRestrictiveOccupancy.getType().getCode())) {
                requiredCarParkArea = totalBuiltupArea.doubleValue() * 0.25;
                if (mostRestrictiveOccupancy != null && mostRestrictiveOccupancy.getSubtype() != null && "A-AF".equals(mostRestrictiveOccupancy.getSubtype().getCode())) {
                    requiredVisitorParkArea = requiredCarParkArea * 0.15;
                }
            } else if (mostRestrictiveOccupancy != null && "F".equals(mostRestrictiveOccupancy.getType().getCode())) {
                requiredCarParkArea = totalBuiltupArea.doubleValue() * 0.3;
                if (mostRestrictiveOccupancy != null && mostRestrictiveOccupancy.getSubtype() != null && ("F-H".equals(mostRestrictiveOccupancy.getSubtype().getCode()) || "F-RT".equals(mostRestrictiveOccupancy.getSubtype().getCode()) || "F-LD".equals(mostRestrictiveOccupancy.getSubtype().getCode()) || "F-CB".equals(mostRestrictiveOccupancy.getSubtype().getCode()) || "F-IT".equals(mostRestrictiveOccupancy.getSubtype().getCode()))) {
                    requiredCarParkArea = totalBuiltupArea.doubleValue() * 0.3;
                }
            } else if (mostRestrictiveOccupancy != null && "G".equals(mostRestrictiveOccupancy.getType().getCode())) {
                requiredCarParkArea = totalBuiltupArea.doubleValue() * 0.3;
            }
        }
        BigDecimal requiredCarParkingArea = Util.roundOffTwoDecimal((BigDecimal)BigDecimal.valueOf(requiredCarParkArea));
        BigDecimal totalProvidedCarParkingArea = Util.roundOffTwoDecimal((BigDecimal)totalProvidedCarParkArea);
        BigDecimal requiredVisitorParkingArea = Util.roundOffTwoDecimal((BigDecimal)BigDecimal.valueOf(requiredVisitorParkArea));
        BigDecimal providedVisitorParkingArea = Util.roundOffTwoDecimal((BigDecimal)providedVisitorParkArea);
        if (totalProvidedCarParkArea.doubleValue() == 0.0) {
            pl.addError(SUB_RULE_40_2_DESCRIPTION, this.getLocaleMessage("msg.error.not.defined", SUB_RULE_40_2_DESCRIPTION));
        } else if (requiredCarParkArea > 0.0 && totalProvidedCarParkingArea.compareTo(requiredCarParkingArea) < 0) {
            this.setReportOutputDetails(pl, SUB_RULE_40_2, SUB_RULE_40_2_DESCRIPTION, requiredCarParkingArea + "m2", totalProvidedCarParkingArea + "m2", Result.Not_Accepted.getResultVal());
        } else {
            this.setReportOutputDetails(pl, SUB_RULE_40_2, SUB_RULE_40_2_DESCRIPTION, requiredCarParkingArea + "m2", totalProvidedCarParkingArea + "m2", Result.Accepted.getResultVal());
        }
        if (requiredVisitorParkArea > 0.0 && providedVisitorParkArea.compareTo(requiredVisitorParkingArea) < 0) {
            this.setReportOutputDetails(pl, SUB_RULE_40_10, SUB_RULE_40_10_DESCRIPTION, requiredVisitorParkingArea + "m2", providedVisitorParkArea + "m2", Result.Not_Accepted.getResultVal());
        } else if (requiredVisitorParkArea > 0.0) {
            this.setReportOutputDetails(pl, SUB_RULE_40_10, SUB_RULE_40_10_DESCRIPTION, requiredVisitorParkingArea + "m2", providedVisitorParkingArea + "m2", Result.Accepted.getResultVal());
        }
        LOGGER.info((Object)("******************Require no of Car Parking***************" + helper.totalRequiredCarParking));
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    private void validateSpecialParking(Plan pl, ParkingHelper helper, BigDecimal totalBuiltupArea) {
        BigDecimal maxHeightOfBuilding = BigDecimal.ZERO;
        int failedCount = 0;
        int success = 0;
        if (!pl.getParkingDetails().getSpecial().isEmpty()) {
            for (Measurement m : pl.getParkingDetails().getSpecial()) {
                if (m.getInvalidReason() != null && m.getInvalidReason().length() > 0) {
                    ++failedCount;
                    continue;
                }
                ++success;
            }
            if (failedCount > 0) {
                pl.addError(SPECIAL_PARKING_DIM_DESC, SPECIAL_PARKING_DIM_DESC + failedCount + " number not having only 4 points.");
            }
            pl.getParkingDetails().setValidSpecialSlots(Integer.valueOf(success));
        }
        for (Block block : pl.getBlocks()) {
            if (block.getBuilding().getBuildingHeight().compareTo(maxHeightOfBuilding) <= 0) continue;
            maxHeightOfBuilding = block.getBuilding().getBuildingHeight();
        }
        if (maxHeightOfBuilding.compareTo(new BigDecimal(15)) >= 0 || pl.getPlot() != null && pl.getPlot().getArea().compareTo(new BigDecimal(500)) > 0) {
            if (pl.getParkingDetails().getValidSpecialSlots() == 0) {
                pl.addError(SUB_RULE_40_11, this.getLocaleMessage("msg.error.not.defined", SP_PARKING));
            } else {
                for (Measurement m : pl.getParkingDetails().getSpecial()) {
                    if (m.getMinimumSide().compareTo(new BigDecimal(0)) > 0 && m.getMinimumSide().compareTo(new BigDecimal(3.6)) >= 0) {
                        this.setReportOutputDetails(pl, SUB_RULE_40_11, SP_PARKING, "1 Numbers ", pl.getParkingDetails().getValidSpecialSlots() + NUMBERS, Result.Accepted.getResultVal());
                        continue;
                    }
                    if (m.getMinimumSide().compareTo(new BigDecimal(0)) <= 0) continue;
                    this.setReportOutputDetails(pl, SUB_RULE_40_11, SP_PARKING, "1 Numbers ", pl.getParkingDetails().getValidSpecialSlots() + NUMBERS, Result.Not_Accepted.getResultVal());
                }
            }
        }
    }

    private void processTwoWheelerParking(Plan pl, ParkingHelper helper) {
        helper.twoWheelerParking = BigDecimal.valueOf(0.25 * helper.totalRequiredCarParking * 2.7 * 5.5).setScale(4, 4).doubleValue();
        double providedArea = 0.0;
        for (Measurement measurement : pl.getParkingDetails().getTwoWheelers()) {
            providedArea += measurement.getArea().doubleValue();
        }
        if (providedArea < helper.twoWheelerParking) {
            this.setReportOutputDetails(pl, SUB_RULE_34_2, TWO_WHEELER_PARK_AREA, helper.twoWheelerParking + " " + "m2", BigDecimal.valueOf(providedArea).setScale(2, 4) + " " + "m2", Result.Not_Accepted.getResultVal());
        } else {
            this.setReportOutputDetails(pl, SUB_RULE_34_2, TWO_WHEELER_PARK_AREA, helper.twoWheelerParking + " " + "m2", BigDecimal.valueOf(providedArea).setScale(2, 4) + " " + "m2", Result.Accepted.getResultVal());
        }
    }

    private void processMechanicalParking(Plan pl) {
        int count = 0;
        for (Measurement m : pl.getParkingDetails().getMechParking()) {
            if (m.getWidth().compareTo(BigDecimal.valueOf(2.7)) >= 0 && m.getHeight().compareTo(BigDecimal.valueOf(5.5)) >= 0) continue;
            ++count;
        }
        if (count > 0) {
            this.setReportOutputDetails(pl, SUB_RULE_34_2, MECH_PARKING_DESC, MECH_PARKING_DIM_DESC, count + MECH_PARKING_DIM_DESC_NA, Result.Not_Accepted.getResultVal());
        } else {
            this.setReportOutputDetails(pl, SUB_RULE_34_2, MECH_PARKING_DESC, MECH_PARKING_DIM_DESC, count + MECH_PARKING_DIM_DESC_NA, Result.Accepted.getResultVal());
        }
    }

    private void checkDimensionForCarParking(Plan pl, ParkingHelper helper) {
        int parkingCount = pl.getParkingDetails().getCars().size();
        int failedCount = 0;
        int success = 0;
        for (Measurement slot : pl.getParkingDetails().getCars()) {
            if (slot.getHeight().setScale(2, RoundingMode.UP).doubleValue() >= 5.0 && slot.getWidth().setScale(2, RoundingMode.UP).doubleValue() >= 2.0) {
                ++success;
                continue;
            }
            ++failedCount;
        }
        pl.getParkingDetails().setValidCarParkingSlots(Integer.valueOf(parkingCount - failedCount));
        if (parkingCount > 0) {
            if (failedCount > 0) {
                if (helper.totalRequiredCarParking.intValue() == pl.getParkingDetails().getValidCarParkingSlots().intValue()) {
                    this.setReportOutputDetails(pl, SUB_RULE_40, SUB_RULE_34_1_DESCRIPTION, "5 M x 2 M Minimum Area of Each ECS parking", OUT_OF + parkingCount + PARKING + failedCount + PARKING_VIOLATED_MINIMUM_AREA, Result.Accepted.getResultVal());
                } else {
                    this.setReportOutputDetails(pl, SUB_RULE_40, SUB_RULE_34_1_DESCRIPTION, "5 M x 2 M Minimum Area of Each ECS parking", OUT_OF + parkingCount + PARKING + failedCount + PARKING_VIOLATED_MINIMUM_AREA, Result.Not_Accepted.getResultVal());
                }
            } else {
                this.setReportOutputDetails(pl, SUB_RULE_40, SUB_RULE_34_1_DESCRIPTION, "5 M x 2 M Minimum Area of Each ECS parking", NO_VIOLATION_OF_AREA + parkingCount + PARKING, Result.Accepted.getResultVal());
            }
        }
        int openParkCount = pl.getParkingDetails().getOpenCars().size();
        int openFailedCount = 0;
        int openSuccess = 0;
        for (Measurement slot : pl.getParkingDetails().getOpenCars()) {
            if (slot.getHeight().setScale(2, RoundingMode.UP).doubleValue() >= 5.0 && slot.getWidth().setScale(2, RoundingMode.UP).doubleValue() >= 2.0) {
                ++openSuccess;
                continue;
            }
            ++openFailedCount;
        }
        pl.getParkingDetails().setValidOpenCarSlots(Integer.valueOf(openParkCount - openFailedCount));
        if (openParkCount > 0) {
            if (openFailedCount > 0) {
                if (helper.totalRequiredCarParking.intValue() == pl.getParkingDetails().getValidOpenCarSlots().intValue()) {
                    this.setReportOutputDetails(pl, SUB_RULE_40, OPEN_PARKING_DIM_DESC, "5 M x 2 M Minimum Area of Each ECS parking", OUT_OF + openParkCount + PARKING + openFailedCount + PARKING_VIOLATED_MINIMUM_AREA, Result.Accepted.getResultVal());
                } else {
                    this.setReportOutputDetails(pl, SUB_RULE_40, OPEN_PARKING_DIM_DESC, "5 M x 2 M Minimum Area of Each ECS parking", OUT_OF + openParkCount + PARKING + openFailedCount + PARKING_VIOLATED_MINIMUM_AREA, Result.Not_Accepted.getResultVal());
                }
            } else {
                this.setReportOutputDetails(pl, SUB_RULE_40, OPEN_PARKING_DIM_DESC, "5 M x 2 M Minimum Area of Each ECS parking", NO_VIOLATION_OF_AREA + openParkCount + PARKING, Result.Accepted.getResultVal());
            }
        }
        int coverParkCount = pl.getParkingDetails().getCoverCars().size();
        int coverFailedCount = 0;
        int coverSuccess = 0;
        for (Measurement slot : pl.getParkingDetails().getCoverCars()) {
            if (slot.getHeight().setScale(2, RoundingMode.UP).doubleValue() >= 5.0 && slot.getWidth().setScale(2, RoundingMode.UP).doubleValue() >= 2.0) {
                ++coverSuccess;
                continue;
            }
            ++coverFailedCount;
        }
        pl.getParkingDetails().setValidCoverCarSlots(Integer.valueOf(coverParkCount - coverFailedCount));
        if (coverParkCount > 0) {
            if (coverFailedCount > 0) {
                if (helper.totalRequiredCarParking.intValue() == pl.getParkingDetails().getValidCoverCarSlots().intValue()) {
                    this.setReportOutputDetails(pl, SUB_RULE_40, COVER_PARKING_DIM_DESC, "5 M x 2 M Minimum Area of Each ECS parking", OUT_OF + coverParkCount + PARKING + coverFailedCount + PARKING_VIOLATED_MINIMUM_AREA, Result.Accepted.getResultVal());
                } else {
                    this.setReportOutputDetails(pl, SUB_RULE_40, COVER_PARKING_DIM_DESC, "5 M x 2 M Minimum Area of Each ECS parking", OUT_OF + coverParkCount + PARKING + coverFailedCount + PARKING_VIOLATED_MINIMUM_AREA, Result.Not_Accepted.getResultVal());
                }
            } else {
                this.setReportOutputDetails(pl, SUB_RULE_40, COVER_PARKING_DIM_DESC, "5 M x 2 M Minimum Area of Each ECS parking", NO_VIOLATION_OF_AREA + coverParkCount + PARKING, Result.Accepted.getResultVal());
            }
        }
        int bsmntParkCount = pl.getParkingDetails().getBasementCars().size();
        int bsmntFailedCount = 0;
        int bsmntSuccess = 0;
        for (Measurement slot : pl.getParkingDetails().getBasementCars()) {
            if (slot.getHeight().setScale(2, RoundingMode.UP).doubleValue() >= 5.0 && slot.getWidth().setScale(2, RoundingMode.UP).doubleValue() >= 2.0) {
                ++bsmntSuccess;
                continue;
            }
            ++bsmntFailedCount;
        }
        pl.getParkingDetails().setValidBasementCarSlots(Integer.valueOf(bsmntParkCount - bsmntFailedCount));
        if (bsmntParkCount > 0) {
            if (bsmntFailedCount > 0) {
                if (helper.totalRequiredCarParking.intValue() == pl.getParkingDetails().getValidBasementCarSlots().intValue()) {
                    this.setReportOutputDetails(pl, SUB_RULE_40, BSMNT_PARKING_DIM_DESC, "5 M x 2 M Minimum Area of Each ECS parking", OUT_OF + bsmntParkCount + PARKING + bsmntFailedCount + PARKING_VIOLATED_MINIMUM_AREA, Result.Accepted.getResultVal());
                } else {
                    this.setReportOutputDetails(pl, SUB_RULE_40, BSMNT_PARKING_DIM_DESC, "5 M x 2 M Minimum Area of Each ECS parking", OUT_OF + bsmntParkCount + PARKING + bsmntFailedCount + PARKING_VIOLATED_MINIMUM_AREA, Result.Not_Accepted.getResultVal());
                }
            } else {
                this.setReportOutputDetails(pl, SUB_RULE_40, BSMNT_PARKING_DIM_DESC, "5 M x 2 M Minimum Area of Each ECS parking", NO_VIOLATION_OF_AREA + bsmntParkCount + PARKING, Result.Accepted.getResultVal());
            }
        }
    }

    private void checkDimensionForSpecialParking(Plan pl, ParkingHelper helper) {
        int success = 0;
        int specialFailedCount = 0;
        int specialParkCount = pl.getParkingDetails().getSpecial().size();
        for (Measurement spParkSlot : pl.getParkingDetails().getSpecial()) {
            if (spParkSlot.getMinimumSide().doubleValue() >= 3.6) {
                ++success;
                continue;
            }
            ++specialFailedCount;
        }
        pl.getParkingDetails().setValidSpecialSlots(Integer.valueOf(specialParkCount - specialFailedCount));
        if (specialParkCount > 0) {
            if (specialFailedCount > 0) {
                if (helper.daParking.intValue() == pl.getParkingDetails().getValidSpecialSlots().intValue()) {
                    this.setReportOutputDetails(pl, SUB_RULE_40_8, SP_PARKING_SLOT_AREA, " 3.60 M  Minimum width of Each Special parking", NO_VIOLATION_OF_AREA + pl.getParkingDetails().getValidSpecialSlots() + PARKING, Result.Accepted.getResultVal());
                } else {
                    this.setReportOutputDetails(pl, SUB_RULE_40_8, SP_PARKING_SLOT_AREA, " 3.60 M  Minimum width of Each Special parking", OUT_OF + specialParkCount + PARKING + specialFailedCount + PARKING_VIOLATED_MINIMUM_AREA, Result.Not_Accepted.getResultVal());
                }
            } else {
                this.setReportOutputDetails(pl, SUB_RULE_40_8, SP_PARKING_SLOT_AREA, " 3.60 M  Minimum width of Each Special parking", NO_VIOLATION_OF_AREA + specialParkCount + PARKING, Result.Accepted.getResultVal());
            }
        }
    }

    private void checkDimensionForTwoWheelerParking(Plan pl, ParkingHelper helper) {
        double providedArea = 0.0;
        int twoWheelParkingCount = pl.getParkingDetails().getTwoWheelers().size();
        int failedTwoWheelCount = 0;
        helper.twoWheelerParking = BigDecimal.valueOf(0.25 * helper.totalRequiredCarParking * 2.7 * 5.5).setScale(4, 4).doubleValue();
        if (!pl.getParkingDetails().getTwoWheelers().isEmpty()) {
            for (Measurement m : pl.getParkingDetails().getTwoWheelers()) {
                if (m.getWidth().setScale(2, RoundingMode.UP).doubleValue() < 1.5 || m.getHeight().setScale(2, RoundingMode.UP).doubleValue() < 2.0) {
                    ++failedTwoWheelCount;
                }
                providedArea += m.getArea().doubleValue();
            }
        }
        if (providedArea < helper.twoWheelerParking) {
            this.setReportOutputDetails(pl, SUB_RULE_34_2, TWO_WHEELER_PARK_AREA, helper.twoWheelerParking + " " + "m2", BigDecimal.valueOf(providedArea).setScale(2, 4) + " " + "m2", Result.Not_Accepted.getResultVal());
        } else {
            this.setReportOutputDetails(pl, SUB_RULE_34_2, TWO_WHEELER_PARK_AREA, helper.twoWheelerParking + " " + "m2", BigDecimal.valueOf(providedArea).setScale(2, 4) + " " + "m2", Result.Accepted.getResultVal());
        }
        if (providedArea >= helper.twoWheelerParking && failedTwoWheelCount >= 0) {
            this.setReportOutputDetails(pl, SUB_RULE_40, TWO_WHEELER_DIM_DESC, PARKING_AREA_DIM, OUT_OF + twoWheelParkingCount + PARKING + failedTwoWheelCount + PARKING_VIOLATED_DIM, Result.Accepted.getResultVal());
        } else {
            this.setReportOutputDetails(pl, SUB_RULE_40, TWO_WHEELER_DIM_DESC, PARKING_AREA_DIM, OUT_OF + twoWheelParkingCount + PARKING + failedTwoWheelCount + PARKING_VIOLATED_DIM, Result.Not_Accepted.getResultVal());
        }
    }

    private BigDecimal getTotalCarpetAreaByOccupancy(Plan pl, OccupancyType type) {
        BigDecimal totalArea = BigDecimal.ZERO;
        for (Block b : pl.getBlocks()) {
            for (Occupancy occupancy : b.getBuilding().getTotalArea()) {
                if (!occupancy.getType().equals((Object)type)) continue;
                totalArea = totalArea.add(occupancy.getCarpetArea());
            }
        }
        return totalArea;
    }

    private void checkAreaForLoadUnloadSpaces(Plan pl) {
        double providedArea = 0.0;
        BigDecimal totalBuiltupArea = pl.getOccupancies().stream().map(Occupancy::getBuiltUpArea).reduce(BigDecimal.ZERO, BigDecimal::add);
        double requiredArea = Math.abs((totalBuiltupArea.doubleValue() - 700.0) / 1000.0 * 30.0);
        if (!pl.getParkingDetails().getLoadUnload().isEmpty()) {
            for (Measurement m : pl.getParkingDetails().getLoadUnload()) {
                if (m.getArea().compareTo(BigDecimal.valueOf(30L)) < 0) continue;
                providedArea += m.getArea().doubleValue();
            }
        }
        if (providedArea < requiredArea) {
            this.setReportOutputDetails(pl, SUB_RULE_40, LOADING_UNLOADING_AREA, requiredArea + " " + "m2", BigDecimal.valueOf(providedArea).setScale(2, 4) + " " + "m2", Result.Not_Accepted.getResultVal());
        } else {
            this.setReportOutputDetails(pl, SUB_RULE_40, LOADING_UNLOADING_AREA, requiredArea + " " + "m2", BigDecimal.valueOf(providedArea).setScale(2, 4) + " " + "m2", Result.Accepted.getResultVal());
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

