/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class Parapet
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(Parapet.class);
    private static final String RULE_41_V = "41-v";
    public static final String PARAPET_DESCRIPTION = "Parapet";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Parapet");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_41_V);
        details.put("Description", PARAPET_DESCRIPTION);
        BigDecimal minHeight = BigDecimal.ZERO;
        for (Block b : pl.getBlocks()) {
            if (b.getParapets() == null || b.getParapets().isEmpty()) continue;
            minHeight = (BigDecimal)b.getParapets().stream().reduce(BigDecimal::min).get();
            if (minHeight.compareTo(new BigDecimal(1.2)) >= 0 && minHeight.compareTo(new BigDecimal(1.5)) <= 0) {
                details.put("Required", "Height >= 1.2 and height <= 1.5");
                details.put("Provided", "Height >= " + minHeight + " and height <= " + minHeight);
                details.put("Status", Result.Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                continue;
            }
            details.put("Required", "Height >= 1.2 and height <= 1.5");
            details.put("Provided", "Height >= " + minHeight + " and height <= " + minHeight);
            details.put("Status", Result.Not_Accepted.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

