/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.ElectricLine;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.entity.blackbox.PlanDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class OverheadElectricalLineService
extends FeatureProcess {
    private static final String SUB_RULE_31 = "31";
    private static final BigDecimal VERTICAL_DISTANCE_11000 = BigDecimal.valueOf(2.5);
    private static final BigDecimal VERTICAL_DISTANCE_33000 = BigDecimal.valueOf(3.7);
    private static final BigDecimal HORIZONTAL_DISTANCE_33000 = BigDecimal.valueOf(2L);
    private static final BigDecimal HORIZONTAL_DISTANCE_11000 = BigDecimal.valueOf(1.2);
    private static final int VOLTAGE_11000 = 11;
    private static final int VOLTAGE_33000 = 33;
    private static final String REMARKS = "Remarks";
    private static final String VOLTAGE = "Voltage";

    @Override
    public Plan validate(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (ElectricLine electricalLine : pl.getElectricLine()) {
            if (!electricalLine.getPresentInDxf().booleanValue()) continue;
            if (electricalLine.getVoltage() == null) {
                errors.put(VOLTAGE, this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{VOLTAGE}, LocaleContextHolder.getLocale()));
                pl.addErrors(errors);
            }
            if (electricalLine.getVoltage() == null || electricalLine.getHorizontalDistance() != null || electricalLine.getVerticalDistance() != null) continue;
            errors.put("Horizontal/Vertical line distance from electric line ", this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{"Horizontal/Vertical line distance from electric line "}, LocaleContextHolder.getLocale()));
            pl.addErrors(errors);
        }
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        this.validate(pl);
        this.scrutinyDetail = new ScrutinyDetail();
        this.scrutinyDetail.setKey("Common_OverHead Electric Line");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), VOLTAGE);
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(7), REMARKS);
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(8), "Status");
        for (ElectricLine electricalLine : pl.getElectricLine()) {
            boolean verticalDistancePassed;
            if (!electricalLine.getPresentInDxf().booleanValue() || electricalLine.getVoltage() == null || electricalLine.getVoltage().compareTo(BigDecimal.ZERO) <= 0 || electricalLine.getHorizontalDistance() == null && electricalLine.getVerticalDistance() == null) continue;
            boolean horizontalDistancePassed = false;
            if (electricalLine.getHorizontalDistance() != null) {
                String expectedResult = "";
                String actualResult = electricalLine.getHorizontalDistance().toString() + "(MTR)";
                if (electricalLine.getVoltage().compareTo(BigDecimal.valueOf(11L)) < 0) {
                    expectedResult = HORIZONTAL_DISTANCE_11000.toString() + "(MTR)";
                    if (electricalLine.getHorizontalDistance().compareTo(HORIZONTAL_DISTANCE_11000) >= 0) {
                        horizontalDistancePassed = true;
                    }
                } else if (electricalLine.getVoltage().compareTo(BigDecimal.valueOf(11L)) >= 0 && electricalLine.getVoltage().compareTo(BigDecimal.valueOf(33L)) <= 0) {
                    expectedResult = HORIZONTAL_DISTANCE_33000.toString() + "(MTR)";
                    if (electricalLine.getHorizontalDistance().compareTo(HORIZONTAL_DISTANCE_33000) >= 0) {
                        horizontalDistancePassed = true;
                    }
                } else if (electricalLine.getVoltage().compareTo(BigDecimal.valueOf(33L)) > 0) {
                    Double totalHorizontalOHE = HORIZONTAL_DISTANCE_33000.doubleValue() + 0.3 * Math.ceil(electricalLine.getVoltage().subtract(BigDecimal.valueOf(33L)).divide(BigDecimal.valueOf(33L), 2, RoundingMode.HALF_UP).doubleValue());
                    expectedResult = totalHorizontalOHE + "(MTR)";
                    if (electricalLine.getHorizontalDistance().compareTo(BigDecimal.valueOf(totalHorizontalOHE)) >= 0) {
                        horizontalDistancePassed = true;
                    }
                }
                if (horizontalDistancePassed) {
                    this.setReportOutputDetails(pl, SUB_RULE_31, " Minimum Horizontal line distance from electric line " + electricalLine.getNumber(), expectedResult, actualResult, Result.Accepted.getResultVal(), "", electricalLine.getVoltage().toString() + "(KV)");
                    continue;
                }
                boolean verticalDistancePassed2 = this.processVerticalDistance(electricalLine, pl, "", "");
                if (verticalDistancePassed2) {
                    this.setReportOutputDetails(pl, SUB_RULE_31, " Minimum Horizontal line distance from electric line " + electricalLine.getNumber(), expectedResult, actualResult, Result.Verify.getResultVal(), String.format("NOC from Chief Electrical Inspector or an officer authorized by him shall be obtained as minimum horizontal line distance from electric line %s is not satisfied as per rule", electricalLine.getNumber()), electricalLine.getVoltage().toString() + "(KV)");
                } else {
                    this.setReportOutputDetails(pl, SUB_RULE_31, " Minimum Horizontal line distance from electric line " + electricalLine.getNumber(), expectedResult, actualResult, Result.Not_Accepted.getResultVal(), "", electricalLine.getVoltage().toString() + "(KV)");
                }
                if (!verticalDistancePassed2) continue;
                HashMap<String, String> noc = new HashMap<String, String>();
                noc.put(" Minimum Horizontal line distance from electric line " + electricalLine.getNumber(), "NOC from Chief Electrical Inspector or an officer authorized by him shall be obtained. ");
                pl.addNocs(noc);
                continue;
            }
            if (electricalLine.getHorizontalDistance() != null || electricalLine.getVerticalDistance() == null || !(verticalDistancePassed = this.processVerticalDistance(electricalLine, pl, String.format("NOC from Chief Electrical Inspector or an officer authorized by him shall be obtained as minimum horizontal line distance from electric line %s is not defined in plan as per rule", electricalLine.getNumber()), ""))) continue;
            HashMap<String, String> noc = new HashMap<String, String>();
            noc.put(" Minimum Horizontal line distance from electric line " + electricalLine.getNumber(), "NOC from Chief Electrical Inspector or an officer authorized by him shall be obtained. ");
            pl.addNocs(noc);
        }
        return pl;
    }

    private boolean processVerticalDistance(ElectricLine electricalLine, Plan plan, String remarks1, String remarks2) {
        boolean verticalDistancePassed = false;
        if (electricalLine.getVerticalDistance() != null) {
            String actualResult = electricalLine.getVerticalDistance().toString() + "(MTR)";
            String expectedResult = "";
            if (electricalLine.getVoltage().compareTo(BigDecimal.valueOf(11L)) < 0) {
                expectedResult = VERTICAL_DISTANCE_11000.toString() + "(MTR)";
                if (electricalLine.getVerticalDistance().compareTo(VERTICAL_DISTANCE_11000) >= 0) {
                    verticalDistancePassed = true;
                }
            } else if (electricalLine.getVoltage().compareTo(BigDecimal.valueOf(11L)) >= 0 && electricalLine.getVoltage().compareTo(BigDecimal.valueOf(33L)) <= 0) {
                expectedResult = VERTICAL_DISTANCE_33000.toString() + "(MTR)";
                if (electricalLine.getVerticalDistance().compareTo(VERTICAL_DISTANCE_33000) >= 0) {
                    verticalDistancePassed = true;
                }
            } else if (electricalLine.getVoltage().compareTo(BigDecimal.valueOf(33L)) > 0) {
                Double totalVertficalOHE = VERTICAL_DISTANCE_33000.doubleValue() + 0.3 * Math.ceil(electricalLine.getVoltage().subtract(BigDecimal.valueOf(33L)).divide(BigDecimal.valueOf(33L), 2, RoundingMode.HALF_UP).doubleValue());
                expectedResult = totalVertficalOHE + "(MTR)";
                if (electricalLine.getVerticalDistance().compareTo(BigDecimal.valueOf(totalVertficalOHE)) >= 0) {
                    verticalDistancePassed = true;
                }
            }
            if (verticalDistancePassed) {
                this.setReportOutputDetails(plan, SUB_RULE_31, " Minimum Vertical line distance from electric line " + electricalLine.getNumber(), expectedResult, actualResult, Result.Accepted.getResultVal(), remarks1, electricalLine.getVoltage().toString() + "(KV)");
            } else {
                this.setReportOutputDetails(plan, SUB_RULE_31, " Minimum Vertical line distance from electric line " + electricalLine.getNumber(), expectedResult, actualResult, Result.Not_Accepted.getResultVal(), remarks2, electricalLine.getVoltage().toString() + "(KV)");
            }
        }
        return verticalDistancePassed;
    }

    private boolean processVerticalDistance(ElectricLine electricalLine, PlanDetail planDetail, String remarks1, String remarks2) {
        boolean verticalDistancePassed = false;
        if (electricalLine.getVerticalDistance() != null) {
            String actualResult = electricalLine.getVerticalDistance().toString() + "(MTR)";
            String expectedResult = "";
            if (electricalLine.getVoltage().compareTo(BigDecimal.valueOf(11L)) < 0) {
                expectedResult = VERTICAL_DISTANCE_11000.toString() + "(MTR)";
                if (electricalLine.getVerticalDistance().compareTo(VERTICAL_DISTANCE_11000) >= 0) {
                    verticalDistancePassed = true;
                }
            } else if (electricalLine.getVoltage().compareTo(BigDecimal.valueOf(11L)) >= 0 && electricalLine.getVoltage().compareTo(BigDecimal.valueOf(33L)) <= 0) {
                expectedResult = VERTICAL_DISTANCE_33000.toString() + "(MTR)";
                if (electricalLine.getVerticalDistance().compareTo(VERTICAL_DISTANCE_33000) >= 0) {
                    verticalDistancePassed = true;
                }
            } else if (electricalLine.getVoltage().compareTo(BigDecimal.valueOf(33L)) > 0) {
                Double totalVertficalOHE = VERTICAL_DISTANCE_33000.doubleValue() + 0.3 * Math.ceil(electricalLine.getVoltage().subtract(BigDecimal.valueOf(33L)).divide(BigDecimal.valueOf(33L), 2, RoundingMode.HALF_UP).doubleValue());
                expectedResult = totalVertficalOHE + "(MTR)";
                if (electricalLine.getVerticalDistance().compareTo(BigDecimal.valueOf(totalVertficalOHE)) >= 0) {
                    verticalDistancePassed = true;
                }
            }
            if (verticalDistancePassed) {
                this.setReportOutputDetails((Plan)planDetail, SUB_RULE_31, " Minimum Vertical line distance from electric line " + electricalLine.getNumber(), expectedResult, actualResult, Result.Accepted.getResultVal(), remarks1, electricalLine.getVoltage().toString() + "(KV)");
            } else {
                this.setReportOutputDetails((Plan)planDetail, SUB_RULE_31, " Minimum Vertical line distance from electric line " + electricalLine.getNumber(), expectedResult, actualResult, Result.Not_Accepted.getResultVal(), remarks2, electricalLine.getVoltage().toString() + "(KV)");
            }
        }
        return verticalDistancePassed;
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status, String remarks, String voltage) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put(REMARKS, remarks);
        details.put(VOLTAGE, voltage);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

