/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Building;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class OverHangs
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(OverHangs.class);
    private static final String RULE_45 = "45";
    public static final String OVERHANGS_DESCRIPTION = "Minimum width of chajja";
    private static final String FLOOR = "Floor";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_45);
        details.put("Description", OVERHANGS_DESCRIPTION);
        BigDecimal minWidth = BigDecimal.ZERO;
        for (Block b : pl.getBlocks()) {
            ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
            scrutinyDetail.setKey("Block_" + b.getNumber() + "_Chajja");
            scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
            Building building = b.getBuilding();
            if (building == null) continue;
            for (Floor floor : building.getFloors()) {
                if (floor.getOverHangs() == null || floor.getOverHangs().isEmpty()) continue;
                List widths = floor.getOverHangs().stream().map(overhang -> overhang.getWidth()).collect(Collectors.toList());
                minWidth = (BigDecimal)widths.stream().reduce(BigDecimal::min).get();
                if (minWidth.compareTo(new BigDecimal("0.75")) > 0) {
                    details.put(FLOOR, floor.getNumber().toString());
                    details.put("Permissible", ">0.75");
                    details.put("Provided", minWidth.toString());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                    continue;
                }
                details.put(FLOOR, floor.getNumber().toString());
                details.put("Permissible", ">0.75");
                details.put("Provided", minWidth.toString());
                details.put("Status", Result.Not_Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

