/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.infra.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class MonumentDistance
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(MonumentDistance.class);
    private static final String RULE_20 = "20";
    public static final String MONUMENT_DESCRIPTION = "Distance from monument";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Monument Distance");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Distance");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Permitted");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
        HashMap<String, String> errors = new HashMap<String, String>();
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_20);
        details.put("Description", MONUMENT_DESCRIPTION);
        BigDecimal minDistanceFromMonument = BigDecimal.ZERO;
        BigDecimal maxHeightOfBuilding = BigDecimal.ZERO;
        List distancesFromMonument = pl.getDistanceToExternalEntity().getMonuments();
        List blocks = pl.getBlocks();
        Block maxBuildingHeightBlock = new Block();
        if (StringUtils.isNotBlank((String)pl.getPlanInformation().getBuildingNearMonument()) && "YES".equalsIgnoreCase(pl.getPlanInformation().getBuildingNearMonument())) {
            if (!distancesFromMonument.isEmpty()) {
                minDistanceFromMonument = (BigDecimal)distancesFromMonument.stream().reduce(BigDecimal::min).get();
                if (StringUtils.isNotBlank((String)pl.getPlanInformation().getNocNearMonument()) && "YES".equalsIgnoreCase(pl.getPlanInformation().getNocNearMonument())) {
                    details.put("Distance", ">300");
                    details.put("Permitted", "Permitted with NOC");
                    details.put("Provided", minDistanceFromMonument + " with NOC");
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    for (Block b : blocks) {
                        if (b.getBuilding().getBuildingHeight().compareTo(maxHeightOfBuilding) <= 0) continue;
                        maxHeightOfBuilding = b.getBuilding().getBuildingHeight();
                        maxBuildingHeightBlock = b;
                    }
                    if (minDistanceFromMonument.compareTo(BigDecimal.valueOf(300L)) > 0) {
                        details.put("Distance", ">300");
                        details.put("Permitted", "ALL");
                        details.put("Provided", minDistanceFromMonument.toString());
                        details.put("Status", Result.Accepted.getResultVal());
                        scrutinyDetail.getDetail().add(details);
                        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                    } else {
                        if (minDistanceFromMonument.compareTo(BigDecimal.valueOf(100L)) <= 0) {
                            details.put("Distance", ">300");
                            details.put("Permitted", "No Construction is allowed with in 100 mts from monument");
                            details.put("Provided", minDistanceFromMonument.toString());
                            details.put("Status", Result.Not_Accepted.getResultVal());
                            scrutinyDetail.getDetail().add(details);
                            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                        }
                        if (minDistanceFromMonument.compareTo(BigDecimal.valueOf(100L)) > 0 && minDistanceFromMonument.compareTo(BigDecimal.valueOf(300L)) <= 0) {
                            if (maxHeightOfBuilding.compareTo(BigDecimal.valueOf(7L)) <= 0 && maxBuildingHeightBlock.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(1L)) <= 0) {
                                details.put("Distance", "From 100 to 300");
                                details.put("Permitted", "Building Height: 7mt, No of floors: 1");
                                details.put("Provided", "Building Height: " + maxHeightOfBuilding + "mt, No of floors: " + maxBuildingHeightBlock.getBuilding().getFloorsAboveGround());
                                details.put("Status", Result.Accepted.getResultVal());
                                scrutinyDetail.getDetail().add(details);
                                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                            } else {
                                details.put("Distance", "From 100 to 300");
                                details.put("Permitted", "Building Height: 7mt, No of floors: 1");
                                details.put("Provided", "Building Height: " + maxHeightOfBuilding + "mt, No of floors: " + maxBuildingHeightBlock.getBuilding().getFloorsAboveGround());
                                details.put("Status", Result.Not_Accepted.getResultVal());
                                scrutinyDetail.getDetail().add(details);
                                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                            }
                        }
                    }
                }
            } else {
                errors.put("Distance_From_Monumnet", "No distance is provided from monument");
                pl.addErrors(errors);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

