/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.stereotype.Service;

@Service
public class MezzanineFloorService
extends FeatureProcess {
    private static final String SUBRULE_46 = "46";
    private static final String RULE46_MAXAREA_DESC = "Maximum allowed area of mezzanine floor";
    private static final String RULE46_MINAREA_DESC = "Minimum area of mezzanine floor";
    private static final String RULE46_DIM_DESC = "Minimum height of mezzanine floor";
    public static final String SUB_RULE_55_7_DESC = "Maximum allowed area of balcony";
    public static final String SUB_RULE_55_7 = "55-7";
    private static final String FLOOR = "Floor";
    public static final String HALL_NUMBER = "Hall Number";
    private static final BigDecimal AREA_9_POINT_5 = BigDecimal.valueOf(9.5);
    private static final BigDecimal HEIGHT_2_POINT_2 = BigDecimal.valueOf(2.2);

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        this.validate(pl);
        String subRule = SUBRULE_46;
        if (pl != null && !pl.getBlocks().isEmpty()) {
            for (Block block : pl.getBlocks()) {
                this.scrutinyDetail = new ScrutinyDetail();
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), FLOOR);
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Required");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
                this.scrutinyDetail.setKey("Block_" + block.getNumber() + "_Mezzanine Floor");
                if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty()) continue;
                BigDecimal totalBuiltupArea = BigDecimal.ZERO;
                for (Floor floor : block.getBuilding().getFloors()) {
                    BigDecimal builtupArea = BigDecimal.ZERO;
                    for (Occupancy occ : floor.getOccupancies()) {
                        if (occ.getIsMezzanine().booleanValue() || occ.getBuiltUpArea() == null) continue;
                        builtupArea = builtupArea.add(occ.getBuiltUpArea().subtract(occ.getDeduction()));
                    }
                    totalBuiltupArea = totalBuiltupArea.add(builtupArea);
                    for (Occupancy mezzanineFloor : floor.getOccupancies()) {
                        if (!mezzanineFloor.getIsMezzanine().booleanValue() || floor.getNumber() == 0) continue;
                        if (mezzanineFloor.getBuiltUpArea() != null && mezzanineFloor.getBuiltUpArea().doubleValue() > 0.0 && mezzanineFloor.getTypeHelper() == null) {
                            pl.addError(" Not defined in the plan.", this.getLocaleMessage("msg.error.mezz.occupancy.not.defined", block.getNumber(), String.valueOf(floor.getNumber()), mezzanineFloor.getMezzanineNumber()));
                        }
                        BigDecimal mezzanineFloorArea = BigDecimal.ZERO;
                        if (mezzanineFloor.getBuiltUpArea() != null) {
                            mezzanineFloorArea = mezzanineFloor.getBuiltUpArea().subtract(mezzanineFloor.getDeduction());
                        }
                        boolean valid = false;
                        BigDecimal oneThirdOfBuiltup = builtupArea.divide(BigDecimal.valueOf(3L), 2, DcrConstants.ROUNDMODE_MEASUREMENTS);
                        if (mezzanineFloorArea.doubleValue() > 0.0 && mezzanineFloorArea.compareTo(oneThirdOfBuiltup) <= 0) {
                            valid = true;
                        }
                        String floorNo = " floor " + floor.getNumber();
                        BigDecimal height = mezzanineFloor.getHeight();
                        if (height.compareTo(BigDecimal.ZERO) == 0) {
                            pl.addError(RULE46_DIM_DESC, this.getLocaleMessage("msg.height.notdefined", "Mezzanine floor " + mezzanineFloor.getMezzanineNumber(), block.getName(), String.valueOf(floor.getNumber())));
                        } else if (height.compareTo(HEIGHT_2_POINT_2) >= 0) {
                            this.setReportOutputDetails(pl, subRule, "Minimum height of mezzanine floor " + mezzanineFloor.getMezzanineNumber(), floorNo, HEIGHT_2_POINT_2 + "(MTR)", height + "(MTR)", Result.Accepted.getResultVal());
                        } else {
                            this.setReportOutputDetails(pl, subRule, "Minimum height of mezzanine floor " + mezzanineFloor.getMezzanineNumber(), floorNo, HEIGHT_2_POINT_2 + "(MTR)", height + "(MTR)", Result.Not_Accepted.getResultVal());
                        }
                        if (mezzanineFloor.getBuiltUpArea().compareTo(AREA_9_POINT_5) >= 0) {
                            this.setReportOutputDetails(pl, subRule, "Minimum area of mezzanine floor " + mezzanineFloor.getMezzanineNumber(), floorNo, AREA_9_POINT_5 + "m2", mezzanineFloor.getBuiltUpArea() + "m2", Result.Accepted.getResultVal());
                        } else {
                            this.setReportOutputDetails(pl, subRule, "Minimum area of mezzanine floor " + mezzanineFloor.getMezzanineNumber(), floorNo, AREA_9_POINT_5 + "m2", mezzanineFloor.getBuiltUpArea() + "m2", Result.Not_Accepted.getResultVal());
                        }
                        if (valid) {
                            this.setReportOutputDetails(pl, subRule, "Maximum allowed area of mezzanine floor " + mezzanineFloor.getMezzanineNumber(), floorNo, oneThirdOfBuiltup + "m2", mezzanineFloorArea + "m2", Result.Accepted.getResultVal());
                            continue;
                        }
                        this.setReportOutputDetails(pl, subRule, "Maximum allowed area of mezzanine floor " + mezzanineFloor.getMezzanineNumber(), floorNo, oneThirdOfBuiltup + "m2", mezzanineFloorArea + "m2", Result.Not_Accepted.getResultVal());
                    }
                }
            }
        }
        return pl;
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String floor, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put(FLOOR, floor);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

