/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Plan;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class MeanOfAccess
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(MeanOfAccess.class);
    public static final BigDecimal VAL_4000 = BigDecimal.valueOf(4000L);
    private static final String ACCESS_WIDTH = "Access Width";
    private static final String SUBRULE_57_5 = "57-5";
    private static final String SUBRULE_58_3b = "58-3-b";
    private static final String SUBRULE_59_4 = "59-4";
    private static final String SUB_RULE_DESCRIPTION = "Minimum access width for plan for %s";
    public static final String OCCUPANCY = "occupancy";
    private static final String SUBRULE_33_1 = "33-1";
    public static final BigDecimal VAL_300 = BigDecimal.valueOf(300L);
    public static final BigDecimal VAL_600 = BigDecimal.valueOf(600L);
    public static final BigDecimal VAL_1000 = BigDecimal.valueOf(1000L);
    public static final BigDecimal VAL_8000 = BigDecimal.valueOf(8000L);
    public static final BigDecimal VAL_18000 = BigDecimal.valueOf(18000L);
    public static final BigDecimal VAL_24000 = BigDecimal.valueOf(24000L);
    public static final BigDecimal VAL_1500 = BigDecimal.valueOf(1500L);
    public static final BigDecimal VAL_6000 = BigDecimal.valueOf(6000L);
    public static final BigDecimal VAL_12000 = BigDecimal.valueOf(12000L);
    private static final String SUBRULE_116 = "116";
    private static final String SUB_RULE_DES = "Minimum access width";
    private static final String OCCPNCYCONDITION = "Occupancy/Condition";
    private static final String REMARKS = "Remarks";

    @Override
    public Plan process(Plan pl) {
        return pl;
    }

    public Plan validateAccessWidth(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (pl.getPlanInformation() != null && pl.getPlanInformation().getAccessWidth() == null) {
            errors.put(ACCESS_WIDTH, this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{ACCESS_WIDTH}, LocaleContextHolder.getLocale()));
            pl.addErrors(errors);
        }
        return pl;
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String occupancy, String expected, String actual, String status, String remarks) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put(OCCPNCYCONDITION, occupancy);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        details.put(REMARKS, remarks);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    private String removeDuplicates(SortedSet<String> uniqueData) {
        StringBuilder str = new StringBuilder();
        ArrayList<String> unqList = new ArrayList<String>(uniqueData);
        for (String unique : unqList) {
            str.append(unique);
            if (unique.equals(unqList.get(unqList.size() - 1))) continue;
            str.append(" , ");
        }
        return str.toString();
    }

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

