/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class LocationPlan
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(LocationPlan.class);
    private static final String RULE_5_4_I_A = "5-4-i-a ";
    public static final String LOCATION_PLAN_DESCRIPTION = "Location Plan";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Location Plan");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Status");
        HashMap<String, String> errors = new HashMap<String, String>();
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_5_4_I_A);
        details.put("Description", LOCATION_PLAN_DESCRIPTION);
        if (pl.getDrawingPreference().getLocationPlans() == null) {
            errors.put("LOCATION_PLAN", "LOCATION_PLAN layer is not provided");
            pl.addErrors(errors);
        } else if (!pl.getDrawingPreference().getLocationPlans().isEmpty()) {
            details.put("Provided", "Location plans provided");
            details.put("Status", Result.Accepted.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        } else {
            details.put("Provided", "PolyLine is not defined in LOCATION_PLAN layer");
            details.put("Status", Result.Not_Accepted.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

