/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Lift;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class LiftService
extends FeatureProcess {
    private static final String SUBRULE_48_DESC = "Minimum number of lifts for block %s";
    private static final String SUBRULE_48 = "48";
    private static final String REMARKS = "Remarks";
    private static final String SUBRULE_48_DESCRIPTION = "Minimum number of lifts";
    private static final String SUBRULE_40A_3 = "40A-3";
    private static final String SUBRULE_118 = "118";
    private static final String SUBRULE_118_DESCRIPTION = "Minimum dimension Of lift %s on floor %s";
    private static final String SUBRULE_118_DESC = "Minimum dimension Of lift";

    @Override
    public Plan validate(Plan plan) {
        for (Block block : plan.getBlocks()) {
            if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty()) continue;
            for (Floor floor : block.getBuilding().getFloors()) {
                List lifts = floor.getLifts();
                if (lifts == null || lifts.isEmpty()) continue;
                for (Lift lift : lifts) {
                    List liftPolyLines = lift.getLifts();
                    if (liftPolyLines == null || liftPolyLines.isEmpty()) continue;
                    this.validateDimensions(plan, block.getNumber(), floor.getNumber(), lift.getNumber().toString(), liftPolyLines);
                }
            }
        }
        return plan;
    }

    @Override
    public Plan process(Plan plan) {
        if (plan != null && !plan.getBlocks().isEmpty()) {
            for (Block block : plan.getBlocks()) {
                this.scrutinyDetail = new ScrutinyDetail();
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), REMARKS);
                this.scrutinyDetail.setKey("Block_" + block.getNumber() + "_Lift - Minimum Required");
                ScrutinyDetail scrutinyDetail1 = new ScrutinyDetail();
                scrutinyDetail1.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail1.addColumnHeading(Integer.valueOf(2), "Description");
                scrutinyDetail1.addColumnHeading(Integer.valueOf(3), "Required");
                scrutinyDetail1.addColumnHeading(Integer.valueOf(4), "Provided");
                scrutinyDetail1.addColumnHeading(Integer.valueOf(5), "Status");
                scrutinyDetail1.addColumnHeading(Integer.valueOf(6), REMARKS);
                scrutinyDetail1.setKey("Block_" + block.getNumber() + "_Lift - Minimum Dimension");
                if (block.getBuilding() == null || block.getBuilding().getOccupancies().isEmpty() || !block.getBuilding().getIsHighRise().booleanValue() || !"A-AF".equals(plan.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype().getCode()) && !"B".equals(plan.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype().getCode()) && !"E".equals(plan.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype().getCode()) && !"F".equals(plan.getVirtualBuilding().getMostRestrictiveFarHelper().getSubtype().getCode())) continue;
                BigDecimal noOfLiftsRqrd = BigDecimal.valueOf(1L);
                boolean valid = false;
                if (BigDecimal.valueOf(Double.valueOf(block.getNumberOfLifts())).compareTo(noOfLiftsRqrd) >= 0) {
                    valid = true;
                }
                if (valid) {
                    this.setReportOutputDetails(plan, SUBRULE_48, SUBRULE_48_DESCRIPTION, noOfLiftsRqrd.toString(), block.getNumberOfLifts(), Result.Accepted.getResultVal(), "", this.scrutinyDetail);
                    continue;
                }
                this.setReportOutputDetails(plan, SUBRULE_48, SUBRULE_48_DESCRIPTION, noOfLiftsRqrd.toString(), block.getNumberOfLifts(), Result.Not_Accepted.getResultVal(), "", this.scrutinyDetail);
            }
        }
        return plan;
    }

    private void setReportOutputDetails(Plan plan, String ruleNo, String ruleDesc, String expected, String actual, String status, String remarks, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        details.put(REMARKS, remarks);
        scrutinyDetail.getDetail().add(details);
        plan.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    private void validateDimensions(Plan plan, String blockNo, int floorNo, String liftNo, List<Measurement> liftPolylines) {
        int count = 0;
        for (Measurement m : liftPolylines) {
            if (m.getInvalidReason() == null || m.getInvalidReason().length() <= 0) continue;
            ++count;
        }
        if (count > 0) {
            plan.addError(String.format("BLK_%s_FLR_%s_LIFT_%s", blockNo, floorNo, liftNo), count + " number of lift polyline not having only 4 points in layer " + String.format("BLK_%s_FLR_%s_LIFT_%s", blockNo, floorNo, liftNo));
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

