/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.Util;
import org.egov.infra.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class LandUse
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(LandUse.class);
    private static final String RULE_28 = "28";
    public static final BigDecimal ROAD_WIDTH_TWELVE_POINTTWO = BigDecimal.valueOf(12.2);
    private static final String ROAD_WIDTH = "Road Width";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        this.validateCommercialZone(pl, errors);
        return pl;
    }

    private void validateCommercialZone(Plan pl, HashMap<String, String> errors) {
        for (Block block : pl.getBlocks()) {
            StringBuffer floorNos = new StringBuffer();
            boolean isAccepted = false;
            String blkNo = block.getNumber();
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), ROAD_WIDTH);
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Required");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
            this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
            this.scrutinyDetail.setKey("Block_" + blkNo + "_Land Use");
            BigDecimal roadWidth = pl.getPlanInformation().getRoadWidth();
            if (pl.getPlanInformation() == null || roadWidth == null || !StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) || !"COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) || Util.roundOffTwoDecimal((BigDecimal)roadWidth).compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) continue;
            List floors = block.getBuilding().getFloors();
            for (Floor floor : floors) {
                List occupancies = floor.getOccupancies();
                ArrayList<String> occupancyTypes = new ArrayList<String>();
                for (Occupancy occupancy : occupancies) {
                    if (occupancy.getTypeHelper() != null && occupancy.getTypeHelper().getType() != null) {
                        occupancyTypes.add(occupancy.getTypeHelper().getType().getCode());
                    }
                    if (occupancy.getTypeHelper() == null || occupancy.getTypeHelper().getSubtype() == null) continue;
                    occupancyTypes.add(occupancy.getTypeHelper().getSubtype().getCode());
                }
                if (occupancyTypes.size() <= 0 || !occupancyTypes.contains("F")) continue;
                floorNos.append(floor.getNumber()).append(",");
            }
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", RULE_28);
            details.put("Description", "Land use Zone");
            details.put(ROAD_WIDTH, pl.getPlanInformation().getRoadWidth().toString());
            details.put("Required", "Atleast one floor should be commercial");
            details.put("Provided", floorNos.length() == 0 ? "commercial floor is not present" : floorNos.toString().substring(0, floorNos.length() - 1) + " floors are commercial");
            details.put("Status", isAccepted ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
            this.scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

