/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.RoomHeight;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.service.ProcessHelper;
import org.springframework.stereotype.Service;

@Service
public class Kitchen
extends FeatureProcess {
    private static final String SUBRULE_41_III = "41-iii";
    private static final String SUBRULE_41_III_DESC = "Minimum height of kitchen";
    private static final String SUBRULE_41_III_AREA_DESC = "Total area of %s";
    private static final String SUBRULE_41_III_TOTAL_WIDTH = "Minimum Width of %s";
    public static final BigDecimal MINIMUM_HEIGHT_2_75 = BigDecimal.valueOf(2.75);
    public static final BigDecimal MINIMUM_HEIGHT_2_4 = BigDecimal.valueOf(2.4);
    public static final BigDecimal MINIMUM_AREA_4_5 = BigDecimal.valueOf(4.5);
    public static final BigDecimal MINIMUM_AREA_7_5 = BigDecimal.valueOf(7.5);
    public static final BigDecimal MINIMUM_AREA_5 = BigDecimal.valueOf(5L);
    public static final BigDecimal MINIMUM_WIDTH_1_8 = BigDecimal.valueOf(1.8);
    public static final BigDecimal MINIMUM_WIDTH_2_1 = BigDecimal.valueOf(2.1);
    private static final String FLOOR = "Floor";
    private static final String ROOM_HEIGHT_NOTDEFINED = "Kitchen height is not defined in layer ";
    private static final String LAYER_ROOM_HEIGHT = "BLK_%s_FLR_%s_%s";
    private static final String KITCHEN = "kitchen";
    private static final String KITCHEN_STORE = "kitchen with store room";
    private static final String KITCHEN_DINING = "kitchen with dining hall";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        Map heightOfRoomFeaturesColor = (Map)pl.getSubFeatureColorCodesMaster().get("HeightOfRoom");
        this.validate(pl);
        HashMap<String, String> errors = new HashMap<String, String>();
        if (pl != null && pl.getBlocks() != null) {
            OccupancyTypeHelper mostRestrictiveOccupancy;
            OccupancyTypeHelper occupancyTypeHelper = mostRestrictiveOccupancy = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
            if (mostRestrictiveOccupancy != null && mostRestrictiveOccupancy.getSubtype() != null && ("A".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode()) || "F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode()))) {
                for (Block block : pl.getBlocks()) {
                    if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty()) continue;
                    this.scrutinyDetail = new ScrutinyDetail();
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), FLOOR);
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Required");
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
                    this.scrutinyDetail.setKey("Block_" + block.getNumber() + "_Kitchen");
                    for (Floor floor : block.getBuilding().getFloors()) {
                        BigDecimal minRoomWidth;
                        Map<String, Object> typicalFloorValues;
                        ArrayList<BigDecimal> kitchenAreas = new ArrayList<BigDecimal>();
                        ArrayList<BigDecimal> kitchenStoreAreas = new ArrayList<BigDecimal>();
                        ArrayList<BigDecimal> kitchenDiningAreas = new ArrayList<BigDecimal>();
                        ArrayList<BigDecimal> kitchenWidths = new ArrayList<BigDecimal>();
                        ArrayList<BigDecimal> kitchenStoreWidths = new ArrayList<BigDecimal>();
                        ArrayList<BigDecimal> kitchenDiningWidths = new ArrayList<BigDecimal>();
                        BigDecimal minimumHeight = BigDecimal.ZERO;
                        BigDecimal totalArea = BigDecimal.ZERO;
                        BigDecimal minWidth = BigDecimal.ZERO;
                        String subRule = null;
                        String subRuleDesc = null;
                        String kitchenRoomColor = "";
                        String kitchenStoreRoomColor = "";
                        String kitchenDiningRoomColor = "";
                        if ("A".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
                            kitchenRoomColor = "Residential kitchen room";
                            kitchenStoreRoomColor = "Residential kitchen store room";
                            kitchenDiningRoomColor = "Residential kitchen dining room";
                        } else {
                            kitchenRoomColor = "Commercial kitchen room";
                            kitchenStoreRoomColor = "Commercial kitchen store room";
                            kitchenDiningRoomColor = "Commercial kitchen dining room";
                        }
                        if (floor.getKitchen() != null) {
                            ArrayList<BigDecimal> kitchenHeights = new ArrayList<BigDecimal>();
                            List heights = floor.getKitchen().getHeights();
                            List kitchenRooms = floor.getKitchen().getRooms();
                            for (RoomHeight roomHeight : heights) {
                                kitchenHeights.add(roomHeight.getHeight());
                            }
                            for (Measurement kitchen : kitchenRooms) {
                                if (((Integer)heightOfRoomFeaturesColor.get(kitchenRoomColor)).intValue() == kitchen.getColorCode()) {
                                    kitchenAreas.add(kitchen.getArea());
                                    kitchenWidths.add(kitchen.getWidth());
                                }
                                if (((Integer)heightOfRoomFeaturesColor.get(kitchenStoreRoomColor)).intValue() == kitchen.getColorCode()) {
                                    kitchenStoreAreas.add(kitchen.getArea());
                                    kitchenStoreWidths.add(kitchen.getWidth());
                                }
                                if (((Integer)heightOfRoomFeaturesColor.get(kitchenDiningRoomColor)).intValue() != kitchen.getColorCode()) continue;
                                kitchenDiningAreas.add(kitchen.getArea());
                                kitchenDiningWidths.add(kitchen.getWidth());
                            }
                            if (!kitchenHeights.isEmpty()) {
                                BigDecimal minHeight = (BigDecimal)kitchenHeights.stream().reduce(BigDecimal::min).get();
                                minimumHeight = MINIMUM_HEIGHT_2_75;
                                subRule = SUBRULE_41_III;
                                subRuleDesc = SUBRULE_41_III_DESC;
                                boolean valid = false;
                                boolean isTypicalRepititiveFloor = false;
                                Map<String, Object> typicalFloorValues2 = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
                                this.buildResult(pl, floor, minimumHeight, subRule, subRuleDesc, minHeight, valid, typicalFloorValues2);
                            } else {
                                String layerName = String.format(LAYER_ROOM_HEIGHT, block.getNumber(), floor.getNumber(), "KITCHEN");
                                errors.put(layerName, ROOM_HEIGHT_NOTDEFINED + layerName);
                                pl.addErrors(errors);
                            }
                        }
                        subRule = SUBRULE_41_III;
                        if (!kitchenAreas.isEmpty()) {
                            totalArea = kitchenAreas.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                            minimumHeight = MINIMUM_AREA_5;
                            subRuleDesc = String.format(SUBRULE_41_III_AREA_DESC, KITCHEN);
                            boolean valid = false;
                            boolean isTypicalRepititiveFloor = false;
                            typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
                            this.buildResult(pl, floor, minimumHeight, subRule, subRuleDesc, totalArea, valid, typicalFloorValues);
                        }
                        if (!kitchenWidths.isEmpty()) {
                            boolean valid = false;
                            boolean isTypicalRepititiveFloor = false;
                            typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
                            minRoomWidth = (BigDecimal)kitchenWidths.stream().reduce(BigDecimal::min).get();
                            minWidth = MINIMUM_WIDTH_1_8;
                            subRuleDesc = String.format(SUBRULE_41_III_TOTAL_WIDTH, KITCHEN);
                            this.buildResult(pl, floor, minWidth, subRule, subRuleDesc, minRoomWidth, valid, typicalFloorValues);
                        }
                        if (!kitchenStoreAreas.isEmpty()) {
                            totalArea = kitchenStoreAreas.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                            minimumHeight = MINIMUM_AREA_4_5;
                            subRuleDesc = String.format(SUBRULE_41_III_AREA_DESC, KITCHEN_STORE);
                            boolean valid = false;
                            boolean isTypicalRepititiveFloor = false;
                            typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
                            this.buildResult(pl, floor, minimumHeight, subRule, subRuleDesc, totalArea, valid, typicalFloorValues);
                        }
                        if (!kitchenStoreWidths.isEmpty()) {
                            boolean valid = false;
                            boolean isTypicalRepititiveFloor = false;
                            typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
                            minRoomWidth = (BigDecimal)kitchenStoreWidths.stream().reduce(BigDecimal::min).get();
                            minWidth = MINIMUM_WIDTH_1_8;
                            subRuleDesc = String.format(SUBRULE_41_III_TOTAL_WIDTH, KITCHEN_STORE);
                            this.buildResult(pl, floor, minWidth, subRule, subRuleDesc, minRoomWidth, valid, typicalFloorValues);
                        }
                        if (!kitchenDiningAreas.isEmpty()) {
                            totalArea = kitchenDiningAreas.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                            minimumHeight = MINIMUM_AREA_7_5;
                            subRuleDesc = String.format(SUBRULE_41_III_AREA_DESC, KITCHEN_DINING);
                            boolean valid = false;
                            boolean isTypicalRepititiveFloor = false;
                            typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
                            this.buildResult(pl, floor, minimumHeight, subRule, subRuleDesc, totalArea, valid, typicalFloorValues);
                        }
                        if (kitchenDiningWidths.isEmpty()) continue;
                        boolean valid = false;
                        boolean isTypicalRepititiveFloor = false;
                        typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
                        minRoomWidth = (BigDecimal)kitchenDiningWidths.stream().reduce(BigDecimal::min).get();
                        minWidth = MINIMUM_WIDTH_2_1;
                        subRuleDesc = String.format(SUBRULE_41_III_TOTAL_WIDTH, KITCHEN_DINING);
                        this.buildResult(pl, floor, minWidth, subRule, subRuleDesc, minRoomWidth, valid, typicalFloorValues);
                    }
                }
            }
        }
        return pl;
    }

    private void buildResult(Plan pl, Floor floor, BigDecimal expected, String subRule, String subRuleDesc, BigDecimal actual, boolean valid, Map<String, Object> typicalFloorValues) {
        if (!((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue() && expected.compareTo(BigDecimal.valueOf(0L)) > 0 && subRule != null && subRuleDesc != null) {
            String value;
            if (actual.compareTo(expected) >= 0) {
                valid = true;
            }
            String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
            if (valid) {
                this.setReportOutputDetails(pl, subRule, subRuleDesc, value, expected + "(MTR)", actual + "(MTR)", Result.Accepted.getResultVal());
            } else {
                this.setReportOutputDetails(pl, subRule, subRuleDesc, value, expected + "(MTR)", actual + "(MTR)", Result.Not_Accepted.getResultVal());
            }
        }
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String floor, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put(FLOOR, floor);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

