/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class InteriorOpenSpaceService
extends FeatureProcess {
    private static Logger LOG = Logger.getLogger(InteriorOpenSpaceService.class);
    private static final String RULE_43A = "43A";
    private static final String RULE_43 = "43";
    public static final String INTERNALCOURTYARD_DESCRIPTION = "Internal Courtyard";
    public static final String VENTILATIONSHAFT_DESCRIPTION = "Ventilation Shaft";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        for (Block b : pl.getBlocks()) {
            ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
            scrutinyDetail.setKey("Common_Interior Open Space");
            scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
            scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
            scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
            scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
            if (b.getBuilding() == null || b.getBuilding().getFloors() == null || b.getBuilding().getFloors().isEmpty()) continue;
            for (Floor f : b.getBuilding().getFloors()) {
                this.processVentilationShaft(pl, scrutinyDetail, f);
                this.processInteriorCourtYard(pl, scrutinyDetail, f);
            }
        }
        return pl;
    }

    private void processInteriorCourtYard(Plan pl, ScrutinyDetail scrutinyDetail, Floor f) {
        if (f.getInteriorOpenSpace() != null && f.getInteriorOpenSpace().getInnerCourtYard() != null && f.getInteriorOpenSpace().getInnerCourtYard().getMeasurements() != null && !f.getInteriorOpenSpace().getInnerCourtYard().getMeasurements().isEmpty()) {
            HashMap<String, String> details;
            BigDecimal minInteriorCourtYardArea = f.getInteriorOpenSpace().getInnerCourtYard().getMeasurements().stream().map(Measurement::getArea).reduce(BigDecimal::min).get();
            BigDecimal minInteriorCourtYardWidth = f.getInteriorOpenSpace().getInnerCourtYard().getMeasurements().stream().map(Measurement::getWidth).reduce(BigDecimal::min).get();
            if (minInteriorCourtYardArea.compareTo(BigDecimal.ZERO) > 0) {
                details = new HashMap<String, String>();
                details.put("Byelaw", RULE_43);
                details.put("Description", INTERNALCOURTYARD_DESCRIPTION);
                if (minInteriorCourtYardArea.compareTo(BigDecimal.valueOf(9L)) >= 0) {
                    details.put("Required", "Minimum area 9.0 Sq. M  ");
                    details.put("Provided", "Area " + minInteriorCourtYardArea + " at floor " + f.getNumber());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    details.put("Required", "Minimum area 9.0 Sq. M  ");
                    details.put("Provided", "Area " + minInteriorCourtYardArea + " at floor " + f.getNumber());
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            }
            if (minInteriorCourtYardWidth.compareTo(BigDecimal.ZERO) > 0) {
                details = new HashMap();
                details.put("Byelaw", RULE_43A);
                details.put("Description", INTERNALCOURTYARD_DESCRIPTION);
                if (minInteriorCourtYardWidth.compareTo(BigDecimal.valueOf(3L)) >= 0) {
                    details.put("Required", "Minimum width 3.0 M ");
                    details.put("Provided", "Area  " + minInteriorCourtYardWidth + " at floor " + f.getNumber());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    details.put("Required", "Minimum width 3.0 M ");
                    details.put("Provided", "Area  " + minInteriorCourtYardWidth + " at floor " + f.getNumber());
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            }
        }
    }

    private void processVentilationShaft(Plan pl, ScrutinyDetail scrutinyDetail, Floor f) {
        if (f.getInteriorOpenSpace() != null && f.getInteriorOpenSpace().getVentilationShaft() != null && f.getInteriorOpenSpace().getVentilationShaft().getMeasurements() != null && !f.getInteriorOpenSpace().getVentilationShaft().getMeasurements().isEmpty()) {
            HashMap<String, String> details;
            BigDecimal minVentilationShaftArea = f.getInteriorOpenSpace().getVentilationShaft().getMeasurements().stream().map(Measurement::getArea).reduce(BigDecimal::min).get();
            BigDecimal minVentilationShaftWidth = f.getInteriorOpenSpace().getVentilationShaft().getMeasurements().stream().map(Measurement::getWidth).reduce(BigDecimal::min).get();
            if (minVentilationShaftArea.compareTo(BigDecimal.ZERO) > 0) {
                details = new HashMap<String, String>();
                details.put("Byelaw", RULE_43);
                details.put("Description", VENTILATIONSHAFT_DESCRIPTION);
                if (minVentilationShaftArea.compareTo(BigDecimal.valueOf(1.2)) >= 0) {
                    details.put("Required", "Minimum area 1.2 Sq. M  ");
                    details.put("Provided", "Area " + minVentilationShaftArea + " at floor " + f.getNumber());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    details.put("Required", "Minimum area 1.2 Sq. M  ");
                    details.put("Provided", "Area " + minVentilationShaftArea + " at floor " + f.getNumber());
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            }
            if (minVentilationShaftWidth.compareTo(BigDecimal.ZERO) > 0) {
                details = new HashMap();
                details.put("Byelaw", RULE_43A);
                details.put("Description", VENTILATIONSHAFT_DESCRIPTION);
                if (minVentilationShaftWidth.compareTo(BigDecimal.valueOf(0.9)) >= 0) {
                    details.put("Required", "Minimum width 0.9 M ");
                    details.put("Provided", "Area  " + minVentilationShaftWidth + " at floor " + f.getNumber());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    details.put("Required", "Minimum width 0.9 M ");
                    details.put("Provided", "Area  " + minVentilationShaftWidth + " at floor " + f.getNumber());
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            }
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

