/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.Room;
import org.egov.common.entity.edcr.RoomHeight;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.service.ProcessHelper;
import org.springframework.stereotype.Service;

@Service
public class HeightOfRoom
extends FeatureProcess {
    private static final String SUBRULE_41_II_A = "41-ii-a";
    private static final String SUBRULE_41_II_B = "41-ii-b";
    private static final String SUBRULE_41_II_A_AC_DESC = "Minimum height of ac room";
    private static final String SUBRULE_41_II_A_REGULAR_DESC = "Minimum height of regular room";
    private static final String SUBRULE_41_II_B_AREA_DESC = "Total area of rooms";
    private static final String SUBRULE_41_II_B_TOTAL_WIDTH = "Minimum Width of room";
    public static final BigDecimal MINIMUM_HEIGHT_3_6 = BigDecimal.valueOf(3.6);
    public static final BigDecimal MINIMUM_HEIGHT_3 = BigDecimal.valueOf(3L);
    public static final BigDecimal MINIMUM_HEIGHT_2_75 = BigDecimal.valueOf(2.75);
    public static final BigDecimal MINIMUM_HEIGHT_2_4 = BigDecimal.valueOf(2.4);
    public static final BigDecimal MINIMUM_AREA_9_5 = BigDecimal.valueOf(9.5);
    public static final BigDecimal MINIMUM_WIDTH_2_4 = BigDecimal.valueOf(2.4);
    public static final BigDecimal MINIMUM_WIDTH_2_1 = BigDecimal.valueOf(2.1);
    private static final String FLOOR = "Floor";
    private static final String ROOM_HEIGHT_NOTDEFINED = "Room height is not defined in layer ";
    private static final String LAYER_ROOM_HEIGHT = "BLK_%s_FLR_%s_%s";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        Map heightOfRoomFeaturesColor = (Map)pl.getSubFeatureColorCodesMaster().get("HeightOfRoom");
        this.validate(pl);
        HashMap<Object, String> errors = new HashMap<Object, String>();
        if (pl != null && pl.getBlocks() != null) {
            OccupancyTypeHelper mostRestrictiveOccupancy;
            OccupancyTypeHelper occupancyTypeHelper = mostRestrictiveOccupancy = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
            if (mostRestrictiveOccupancy != null && mostRestrictiveOccupancy.getType() != null && ("A".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode()) || "G".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode()) || "F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode()))) {
                for (Block block : pl.getBlocks()) {
                    if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty()) continue;
                    this.scrutinyDetail = new ScrutinyDetail();
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), FLOOR);
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Required");
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
                    this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
                    this.scrutinyDetail.setKey("Block_" + block.getNumber() + "_Room");
                    for (Floor floor : block.getBuilding().getFloors()) {
                        Object layerName;
                        Map<String, Object> typicalFloorValues;
                        boolean isTypicalRepititiveFloor;
                        BigDecimal minHeight;
                        ArrayList<BigDecimal> roomAreas = new ArrayList<BigDecimal>();
                        ArrayList<BigDecimal> roomWidths = new ArrayList<BigDecimal>();
                        BigDecimal minimumHeight = BigDecimal.ZERO;
                        BigDecimal totalArea = BigDecimal.ZERO;
                        BigDecimal minWidth = BigDecimal.ZERO;
                        String subRule = null;
                        String subRuleDesc = null;
                        String color = "";
                        if ("A".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
                            color = "Residential room";
                        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
                            color = "Commercial room";
                        } else if ("G".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
                            color = "Industrial room";
                        }
                        if (floor.getAcRooms() != null && floor.getAcRooms().size() > 0) {
                            ArrayList<BigDecimal> residentialAcRoomHeights = new ArrayList<BigDecimal>();
                            ArrayList acHeights = new ArrayList();
                            ArrayList acRooms = new ArrayList();
                            for (Room room : floor.getAcRooms()) {
                                if (room.getHeights() != null) {
                                    acHeights.addAll(room.getHeights());
                                }
                                if (room.getRooms() == null) continue;
                                acRooms.addAll(room.getRooms());
                            }
                            for (RoomHeight roomHeight : acHeights) {
                                if (((Integer)heightOfRoomFeaturesColor.get(color)).intValue() != roomHeight.getColorCode()) continue;
                                residentialAcRoomHeights.add(roomHeight.getHeight());
                            }
                            for (Measurement acRoom : acRooms) {
                                if (((Integer)heightOfRoomFeaturesColor.get(color)).intValue() != acRoom.getColorCode()) continue;
                                roomAreas.add(acRoom.getArea());
                                roomWidths.add(acRoom.getWidth());
                            }
                            if (!residentialAcRoomHeights.isEmpty()) {
                                minHeight = (BigDecimal)residentialAcRoomHeights.stream().reduce(BigDecimal::min).get();
                                minimumHeight = !"G".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode()) ? MINIMUM_HEIGHT_2_4 : MINIMUM_HEIGHT_3;
                                subRule = SUBRULE_41_II_A;
                                subRuleDesc = SUBRULE_41_II_A_AC_DESC;
                                boolean valid = false;
                                isTypicalRepititiveFloor = false;
                                typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
                                this.buildResult(pl, floor, minimumHeight, subRule, subRuleDesc, minHeight, valid, typicalFloorValues);
                            } else {
                                layerName = String.format(LAYER_ROOM_HEIGHT, block.getNumber(), floor.getNumber(), "AC_ROOM");
                                errors.put(layerName, ROOM_HEIGHT_NOTDEFINED + (String)layerName);
                                pl.addErrors(errors);
                            }
                        }
                        if (floor.getRegularRooms() != null && floor.getRegularRooms().size() > 0) {
                            ArrayList<BigDecimal> residentialRoomHeights = new ArrayList<BigDecimal>();
                            ArrayList heights = new ArrayList();
                            ArrayList rooms = new ArrayList();
                            for (Room room : floor.getRegularRooms()) {
                                if (room.getHeights() != null) {
                                    heights.addAll(room.getHeights());
                                }
                                if (room.getRooms() == null) continue;
                                rooms.addAll(room.getRooms());
                            }
                            for (RoomHeight roomHeight : heights) {
                                if (((Integer)heightOfRoomFeaturesColor.get(color)).intValue() != roomHeight.getColorCode()) continue;
                                residentialRoomHeights.add(roomHeight.getHeight());
                            }
                            for (Measurement room : rooms) {
                                if (((Integer)heightOfRoomFeaturesColor.get(color)).intValue() != room.getColorCode()) continue;
                                roomAreas.add(room.getArea());
                                roomWidths.add(room.getWidth());
                            }
                            if (!residentialRoomHeights.isEmpty()) {
                                minHeight = (BigDecimal)residentialRoomHeights.stream().reduce(BigDecimal::min).get();
                                minimumHeight = !"G".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode()) ? MINIMUM_HEIGHT_2_75 : MINIMUM_HEIGHT_3_6;
                                subRule = SUBRULE_41_II_A;
                                subRuleDesc = SUBRULE_41_II_A_REGULAR_DESC;
                                boolean valid = false;
                                isTypicalRepititiveFloor = false;
                                typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
                                this.buildResult(pl, floor, minimumHeight, subRule, subRuleDesc, minHeight, valid, typicalFloorValues);
                            } else {
                                layerName = String.format(LAYER_ROOM_HEIGHT, block.getNumber(), floor.getNumber(), "REGULAR_ROOM");
                                errors.put(layerName, ROOM_HEIGHT_NOTDEFINED + (String)layerName);
                                pl.addErrors(errors);
                            }
                        }
                        if (roomAreas.isEmpty()) continue;
                        totalArea = roomAreas.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
                        BigDecimal minRoomWidth = (BigDecimal)roomWidths.stream().reduce(BigDecimal::min).get();
                        if (roomAreas.size() == 1) {
                            minimumHeight = MINIMUM_AREA_9_5;
                            minWidth = MINIMUM_WIDTH_2_4;
                        } else if (roomAreas.size() == 2) {
                            minimumHeight = MINIMUM_AREA_9_5;
                            minWidth = MINIMUM_WIDTH_2_1;
                        }
                        subRule = SUBRULE_41_II_B;
                        subRuleDesc = SUBRULE_41_II_B_AREA_DESC;
                        boolean valid = false;
                        boolean isTypicalRepititiveFloor2 = false;
                        Map<String, Object> typicalFloorValues2 = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor2);
                        this.buildResult(pl, floor, minimumHeight, subRule, subRuleDesc, totalArea, valid, typicalFloorValues2);
                        subRuleDesc = SUBRULE_41_II_B_TOTAL_WIDTH;
                        this.buildResult(pl, floor, minWidth, subRule, subRuleDesc, minRoomWidth, valid, typicalFloorValues2);
                    }
                }
            }
        }
        return pl;
    }

    private void buildResult(Plan pl, Floor floor, BigDecimal expected, String subRule, String subRuleDesc, BigDecimal actual, boolean valid, Map<String, Object> typicalFloorValues) {
        if (!((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue() && expected.compareTo(BigDecimal.valueOf(0L)) > 0 && subRule != null && subRuleDesc != null) {
            String value;
            if (actual.compareTo(expected) >= 0) {
                valid = true;
            }
            String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
            if (valid) {
                this.setReportOutputDetails(pl, subRule, subRuleDesc, value, expected + "(MTR)", actual + "(MTR)", Result.Accepted.getResultVal());
            } else {
                this.setReportOutputDetails(pl, subRule, subRuleDesc, value, expected + "(MTR)", actual + "(MTR)", Result.Not_Accepted.getResultVal());
            }
        }
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String floor, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put(FLOOR, floor);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

