/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.Util;
import org.springframework.stereotype.Service;

@Service
public class HeadRoom
extends FeatureProcess {
    private static final String RULE42_5_ii = "42-5-ii";
    private static final String RULE_42_5_ii_DESCRIPTION = "Minimum clear of stair head-room";
    private static final BigDecimal TWO_POINTTWO = BigDecimal.valueOf(2.2);

    @Override
    public Plan validate(Plan plan) {
        return plan;
    }

    @Override
    public Plan process(Plan plan) {
        for (Block block : plan.getBlocks()) {
            List headRoomDimensions;
            if (block.getBuilding() == null) continue;
            ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
            scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
            scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
            scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
            scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
            scrutinyDetail.setKey("Block_" + block.getNumber() + "_Stair Headroom");
            org.egov.common.entity.edcr.HeadRoom headRoom = block.getBuilding().getHeadRoom();
            if (headRoom == null || (headRoomDimensions = headRoom.getHeadRoomDimensions()) == null || headRoomDimensions.size() <= 0) continue;
            BigDecimal minHeadRoomDimension = (BigDecimal)headRoomDimensions.stream().reduce(BigDecimal::min).get();
            BigDecimal minWidth = Util.roundOffTwoDecimal((BigDecimal)minHeadRoomDimension);
            if (minWidth.compareTo(TWO_POINTTWO) >= 0) {
                this.setReportOutputDetails(plan, RULE42_5_ii, RULE_42_5_ii_DESCRIPTION, String.valueOf(TWO_POINTTWO), String.valueOf(minWidth), Result.Accepted.getResultVal(), scrutinyDetail);
                continue;
            }
            this.setReportOutputDetails(plan, RULE42_5_ii, RULE_42_5_ii_DESCRIPTION, String.valueOf(TWO_POINTTWO), String.valueOf(minWidth), Result.Not_Accepted.getResultVal(), scrutinyDetail);
        }
        return plan;
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String ruleDesc, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put("Description", ruleDesc);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

