/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.feature.Parking;
import org.springframework.stereotype.Service;

@Service
public class GuardRoom
extends FeatureProcess {
    private static final Logger LOGGER = Logger.getLogger(Parking.class);
    private static final String RULE_48_A = "48-A";
    public static final String GUARD_ROOM_DIMENSION_DESCRIPTION = "Guard Room Dimension";
    public static final String GUARD_ROOM_AREA_DESCRIPTION = "Guard Room Area";
    public static final String GUARD_ROOM_HEIGHT_DESCRIPTION = "Guard Room Height";

    @Override
    public Plan validate(Plan pl) {
        return null;
    }

    @Override
    public Plan process(Plan pl) {
        this.validate(pl);
        this.scrutinyDetail = new ScrutinyDetail();
        this.scrutinyDetail.setKey("Common_Guard Room");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Required");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
        this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        HashMap<String, String> details = new HashMap<String, String>();
        HashMap<String, String> errors = new HashMap<String, String>();
        BigDecimal minHeight = BigDecimal.ZERO;
        BigDecimal minWidth = BigDecimal.ZERO;
        BigDecimal minArea = BigDecimal.ZERO;
        BigDecimal minCabinHeight = BigDecimal.ZERO;
        if (pl.getGuardRoom() != null && !pl.getGuardRoom().getGuardRooms().isEmpty()) {
            List heightList = pl.getGuardRoom().getGuardRooms().stream().map(Measurement::getHeight).collect(Collectors.toList());
            List widthList = pl.getGuardRoom().getGuardRooms().stream().map(Measurement::getWidth).collect(Collectors.toList());
            List atreaList = pl.getGuardRoom().getGuardRooms().stream().map(Measurement::getArea).collect(Collectors.toList());
            List cabinHeightList = pl.getGuardRoom().getCabinHeights();
            if (cabinHeightList != null && !cabinHeightList.isEmpty()) {
                minHeight = (BigDecimal)heightList.stream().reduce(BigDecimal::min).get();
                minWidth = (BigDecimal)widthList.stream().reduce(BigDecimal::min).get();
                minArea = (BigDecimal)atreaList.stream().reduce(BigDecimal::min).get();
                minCabinHeight = (BigDecimal)cabinHeightList.stream().reduce(BigDecimal::min).get();
                if (minHeight.compareTo(new BigDecimal("4")) >= 0 && minWidth.compareTo(new BigDecimal("3")) >= 0) {
                    details.put("Byelaw", RULE_48_A);
                    details.put("Description", GUARD_ROOM_DIMENSION_DESCRIPTION);
                    details.put("Required", "Dimension > 3x4");
                    details.put("Provided", "Dimension: " + minWidth + "x" + minHeight);
                    details.put("Status", Result.Accepted.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                } else {
                    details = new HashMap();
                    details.put("Byelaw", RULE_48_A);
                    details.put("Description", GUARD_ROOM_DIMENSION_DESCRIPTION);
                    details.put("Required", "Dimension > 3x4");
                    details.put("Provided", "Dimension: " + minWidth + "x" + minHeight);
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                }
                if (minArea.compareTo(new BigDecimal("10")) <= 0) {
                    details = new HashMap();
                    details.put("Byelaw", RULE_48_A);
                    details.put("Description", GUARD_ROOM_AREA_DESCRIPTION);
                    details.put("Required", "Area < = 10");
                    details.put("Provided", "Area: " + minArea);
                    details.put("Status", Result.Accepted.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                } else {
                    details = new HashMap();
                    details.put("Byelaw", RULE_48_A);
                    details.put("Description", GUARD_ROOM_AREA_DESCRIPTION);
                    details.put("Required", "Area < = 10");
                    details.put("Provided", "Area: " + minArea);
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                }
                if (minCabinHeight.compareTo(new BigDecimal("0.75")) >= 0 && minCabinHeight.compareTo(new BigDecimal("2.2")) <= 0) {
                    details = new HashMap();
                    details.put("Byelaw", RULE_48_A);
                    details.put("Description", GUARD_ROOM_HEIGHT_DESCRIPTION);
                    details.put("Required", "Height >= 0.75m and <= 2.2m");
                    details.put("Provided", "Height: " + minCabinHeight + "m");
                    details.put("Status", Result.Accepted.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                } else {
                    details = new HashMap();
                    details.put("Byelaw", RULE_48_A);
                    details.put("Description", GUARD_ROOM_HEIGHT_DESCRIPTION);
                    details.put("Required", "Height >= 0.75m and <= 2.2m");
                    details.put("Provided", "Height: " + minCabinHeight + "m");
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    this.scrutinyDetail.getDetail().add(details);
                }
                pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
            } else {
                errors.put("Distance_Guard Room", "Cabin heights is not provided in layer GUARD_ROOM");
                pl.addErrors(errors);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

