/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.infra.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class GovtBuildingDistance
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(GovtBuildingDistance.class);
    private static final String RULE_21 = "21";
    public static final String GOVTBUILDING_DESCRIPTION = "Distance from Government Building";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Government Building Distance");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Distance");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Permitted");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
        HashMap<String, String> errors = new HashMap<String, String>();
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_21);
        details.put("Description", GOVTBUILDING_DESCRIPTION);
        BigDecimal minDistanceFromGovtBuilding = BigDecimal.ZERO;
        BigDecimal maxHeightOfBuilding = BigDecimal.ZERO;
        List distancesFromGovtBuilding = pl.getDistanceToExternalEntity().getGovtBuildings();
        List blocks = pl.getBlocks();
        if (StringUtils.isNotBlank((String)pl.getPlanInformation().getBuildingNearGovtBuilding()) && "YES".equalsIgnoreCase(pl.getPlanInformation().getBuildingNearGovtBuilding())) {
            if (!distancesFromGovtBuilding.isEmpty()) {
                minDistanceFromGovtBuilding = (BigDecimal)distancesFromGovtBuilding.stream().reduce(BigDecimal::min).get();
                for (Block b : blocks) {
                    if (b.getBuilding().getBuildingHeight().compareTo(maxHeightOfBuilding) <= 0) continue;
                    maxHeightOfBuilding = b.getBuilding().getBuildingHeight();
                }
                if (minDistanceFromGovtBuilding.compareTo(BigDecimal.valueOf(200L)) > 0) {
                    details.put("Distance", ">200");
                    details.put("Permitted", "ALL");
                    details.put("Provided", minDistanceFromGovtBuilding.toString());
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else if (maxHeightOfBuilding.compareTo(BigDecimal.valueOf(10L)) <= 0) {
                    details.put("Distance", "<=200");
                    details.put("Permitted", "Building Height: 10mt");
                    details.put("Provided", "Building Height: " + maxHeightOfBuilding + "mt");
                    details.put("Status", Result.Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                } else {
                    details.put("Distance", "<=200");
                    details.put("Permitted", "Building Height: 10mt");
                    details.put("Provided", "Building Height: " + maxHeightOfBuilding + "mt");
                    details.put("Status", Result.Not_Accepted.getResultVal());
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            } else {
                errors.put("Distance_From_Govt_Building", "No distance is provided from government building");
                pl.addErrors(errors);
            }
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

