/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Flight;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.common.entity.edcr.StairLanding;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.egov.edcr.utility.Util;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class GeneralStair
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(GeneralStair.class);
    private static final String FLOOR = "Floor";
    private static final String RULE42_5_II = "42-5-ii";
    private static final String EXPECTED_NO_OF_RISER = "12";
    private static final String NO_OF_RISER_DESCRIPTION = "Maximum no of risers required per flight for general stair %s flight %s";
    private static final String WIDTH_DESCRIPTION = "Minimum width for general stair %s flight %s";
    private static final String TREAD_DESCRIPTION = "Minimum tread for general stair %s flight %s";
    private static final String NO_OF_RISERS = "Number of risers ";
    private static final String FLIGHT_POLYLINE_NOT_DEFINED_DESCRIPTION = "Flight polyline is not defined in layer ";
    private static final String FLIGHT_LENGTH_DEFINED_DESCRIPTION = "Flight polyline length is not defined in layer ";
    private static final String FLIGHT_WIDTH_DEFINED_DESCRIPTION = "Flight polyline width is not defined in layer ";
    private static final String WIDTH_LANDING_DESCRIPTION = "Minimum width for general stair %s mid landing %s";
    private static final String FLIGHT_NOT_DEFINED_DESCRIPTION = "General stair flight is not defined in block %s floor %s";

    @Override
    public Plan validate(Plan plan) {
        return plan;
    }

    @Override
    public Plan process(Plan plan) {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Block block : plan.getBlocks()) {
            int generalStairCount = 0;
            if (block.getBuilding() == null) continue;
            ScrutinyDetail scrutinyDetail2 = new ScrutinyDetail();
            scrutinyDetail2.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail2.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetail2.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetail2.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetail2.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetail2.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetail2.setKey("Block_" + block.getNumber() + "_General Stair - Width");
            ScrutinyDetail scrutinyDetail3 = new ScrutinyDetail();
            scrutinyDetail3.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail3.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetail3.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetail3.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetail3.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetail3.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetail3.setKey("Block_" + block.getNumber() + "_General Stair - Tread width");
            ScrutinyDetail scrutinyDetailRise = new ScrutinyDetail();
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetailRise.setKey("Block_" + block.getNumber() + "_General Stair - Number of risers");
            ScrutinyDetail scrutinyDetailLanding = new ScrutinyDetail();
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetailLanding.setKey("Block_" + block.getNumber() + "_General Stair - Mid landing");
            OccupancyTypeHelper mostRestrictiveOccupancyType = block.getBuilding() != null ? block.getBuilding().getMostRestrictiveFarHelper() : null;
            List floors = block.getBuilding().getFloors();
            ArrayList<String> stairAbsent = new ArrayList<String>();
            for (Floor floor : floors) {
                if (floor.getTerrace().booleanValue()) continue;
                boolean isTypicalRepititiveFloor = false;
                Map typicalFloorValues = Util.getTypicalFloorValues((Block)block, (Floor)floor, (Boolean)isTypicalRepititiveFloor);
                List generalStairs = floor.getGeneralStairs();
                int size = generalStairs.size();
                generalStairCount += size;
                if (!generalStairs.isEmpty()) {
                    for (org.egov.common.entity.edcr.GeneralStair generalStair : generalStairs) {
                        this.validateFlight(plan, errors, block, scrutinyDetail2, scrutinyDetail3, scrutinyDetailRise, mostRestrictiveOccupancyType, floor, typicalFloorValues, generalStair);
                        List landings = generalStair.getLandings();
                        if (!landings.isEmpty()) {
                            this.validateLanding(plan, block, scrutinyDetailLanding, mostRestrictiveOccupancyType, floor, typicalFloorValues, generalStair, landings, errors);
                            continue;
                        }
                        errors.put("General Stair landing not defined in block " + block.getNumber() + " floor " + floor.getNumber() + " stair " + generalStair.getNumber(), "General Stair landing not defined in block " + block.getNumber() + " floor " + floor.getNumber() + " stair " + generalStair.getNumber());
                        plan.addErrors(errors);
                    }
                    continue;
                }
                stairAbsent.add("Block " + block.getNumber() + " floor " + floor.getNumber());
            }
            if (block.getBuilding().getFloors().size() > 1 && !stairAbsent.isEmpty()) {
                for (String error : stairAbsent) {
                    errors.put("General Stair " + error, "General stair not defined in " + error);
                    plan.addErrors(errors);
                }
            }
            if (block.getBuilding().getFloors().size() <= 1 || generalStairCount != 0) continue;
            errors.put("General Stair not defined in blk " + block.getNumber(), "General Stair not defined in block " + block.getNumber() + ", it is mandatory for building with floors more than one.");
            plan.addErrors(errors);
        }
        return plan;
    }

    private void validateLanding(Plan plan, Block block, ScrutinyDetail scrutinyDetailLanding, OccupancyTypeHelper mostRestrictiveOccupancyType, Floor floor, Map<String, Object> typicalFloorValues, org.egov.common.entity.edcr.GeneralStair generalStair, List<StairLanding> landings, HashMap<String, String> errors) {
        for (StairLanding landing : landings) {
            List widths = landing.getWidths();
            if (!widths.isEmpty()) {
                String value;
                BigDecimal minimumWidth;
                BigDecimal landingWidth = (BigDecimal)widths.stream().reduce(BigDecimal::min).get();
                BigDecimal minWidth = BigDecimal.ZERO;
                boolean valid = false;
                if (((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) continue;
                minWidth = Util.roundOffTwoDecimal((BigDecimal)landingWidth);
                if (minWidth.compareTo(minimumWidth = this.getRequiredWidth(block, mostRestrictiveOccupancyType)) >= 0) {
                    valid = true;
                }
                String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
                if (valid) {
                    this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(WIDTH_LANDING_DESCRIPTION, generalStair.getNumber(), landing.getNumber()), minimumWidth.toString(), String.valueOf(minWidth), Result.Accepted.getResultVal(), scrutinyDetailLanding);
                    continue;
                }
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(WIDTH_LANDING_DESCRIPTION, generalStair.getNumber(), landing.getNumber()), minimumWidth.toString(), String.valueOf(minWidth), Result.Not_Accepted.getResultVal(), scrutinyDetailLanding);
                continue;
            }
            errors.put("General Stair landing width not defined in block " + block.getNumber() + " floor " + floor.getNumber() + " stair " + generalStair.getNumber(), "General Stair landing width not defined in block " + block.getNumber() + " floor " + floor.getNumber() + " stair " + generalStair.getNumber());
            plan.addErrors(errors);
        }
    }

    private void validateFlight(Plan plan, HashMap<String, String> errors, Block block, ScrutinyDetail scrutinyDetail2, ScrutinyDetail scrutinyDetail3, ScrutinyDetail scrutinyDetailRise, OccupancyTypeHelper mostRestrictiveOccupancyType, Floor floor, Map<String, Object> typicalFloorValues, org.egov.common.entity.edcr.GeneralStair generalStair) {
        if (!generalStair.getFlights().isEmpty()) {
            for (Flight flight : generalStair.getFlights()) {
                List flightPolyLines = flight.getFlights();
                List flightLengths = flight.getLengthOfFlights();
                List flightWidths = flight.getWidthOfFlights();
                BigDecimal noOfRises = flight.getNoOfRises();
                Boolean flightPolyLineClosed = flight.getFlightClosed();
                BigDecimal minTread = BigDecimal.ZERO;
                BigDecimal minFlightWidth = BigDecimal.ZERO;
                String flightLayerName = String.format("BLK_%s_FLR_%s_STAIR_%s_FLIGHT_%s", block.getNumber(), floor.getNumber(), generalStair.getNumber(), flight.getNumber());
                if (flightPolyLines != null && flightPolyLines.size() > 0) {
                    if (!flightPolyLineClosed.booleanValue()) continue;
                    if (flightWidths != null && flightWidths.size() > 0) {
                        minFlightWidth = this.validateWidth(plan, scrutinyDetail2, floor, block, typicalFloorValues, generalStair, flight, flightWidths, minFlightWidth, mostRestrictiveOccupancyType);
                    } else {
                        errors.put("Flight PolyLine width" + flightLayerName, FLIGHT_WIDTH_DEFINED_DESCRIPTION + flightLayerName);
                        plan.addErrors(errors);
                    }
                    if (flightLengths != null && flightLengths.size() > 0) {
                        try {
                            minTread = this.validateTread(plan, errors, block, scrutinyDetail3, floor, typicalFloorValues, generalStair, flight, flightLengths, minTread, mostRestrictiveOccupancyType);
                        }
                        catch (ArithmeticException e) {
                            LOG.info((Object)"Denominator is zero");
                        }
                    } else {
                        errors.put("Flight PolyLine length" + flightLayerName, FLIGHT_LENGTH_DEFINED_DESCRIPTION + flightLayerName);
                        plan.addErrors(errors);
                    }
                    if (noOfRises.compareTo(BigDecimal.ZERO) > 0) {
                        try {
                            this.validateNoOfRises(plan, errors, block, scrutinyDetailRise, floor, typicalFloorValues, generalStair, flight, noOfRises);
                        }
                        catch (ArithmeticException e) {
                            LOG.info((Object)"Denominator is zero");
                        }
                        continue;
                    }
                    errors.put("noofRise" + flightLayerName, this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{NO_OF_RISERS + flightLayerName}, LocaleContextHolder.getLocale()));
                    plan.addErrors(errors);
                    continue;
                }
                errors.put("Flight PolyLine " + flightLayerName, FLIGHT_POLYLINE_NOT_DEFINED_DESCRIPTION + flightLayerName);
                plan.addErrors(errors);
            }
        } else {
            String error = String.format(FLIGHT_NOT_DEFINED_DESCRIPTION, block.getNumber(), floor.getNumber());
            errors.put(error, error);
            plan.addErrors(errors);
        }
    }

    private BigDecimal validateWidth(Plan plan, ScrutinyDetail scrutinyDetail2, Floor floor, Block block, Map<String, Object> typicalFloorValues, org.egov.common.entity.edcr.GeneralStair generalStair, Flight flight, List<BigDecimal> flightWidths, BigDecimal minFlightWidth, OccupancyTypeHelper mostRestrictiveOccupancyType) {
        BigDecimal flightPolyLine = (BigDecimal)flightWidths.stream().reduce(BigDecimal::min).get();
        boolean valid = false;
        if (!((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) {
            String value;
            BigDecimal minimumWidth;
            minFlightWidth = Util.roundOffTwoDecimal((BigDecimal)flightPolyLine);
            if (minFlightWidth.compareTo(minimumWidth = this.getRequiredWidth(block, mostRestrictiveOccupancyType)) >= 0) {
                valid = true;
            }
            String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
            if (valid) {
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(WIDTH_DESCRIPTION, generalStair.getNumber(), flight.getNumber()), minimumWidth.toString(), String.valueOf(minFlightWidth), Result.Accepted.getResultVal(), scrutinyDetail2);
            } else {
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(WIDTH_DESCRIPTION, generalStair.getNumber(), flight.getNumber()), minimumWidth.toString(), String.valueOf(minFlightWidth), Result.Not_Accepted.getResultVal(), scrutinyDetail2);
            }
        }
        return minFlightWidth;
    }

    private BigDecimal getRequiredWidth(Block block, OccupancyTypeHelper mostRestrictiveOccupancyType) {
        if (mostRestrictiveOccupancyType != null && mostRestrictiveOccupancyType.getType() != null && "A-AF".equalsIgnoreCase(mostRestrictiveOccupancyType.getType().getCode())) {
            return BigDecimal.valueOf(1.9);
        }
        if (mostRestrictiveOccupancyType != null && mostRestrictiveOccupancyType.getType() != null && "A-AF-GH".equalsIgnoreCase(mostRestrictiveOccupancyType.getType().getCode())) {
            return BigDecimal.valueOf(0.75);
        }
        if (mostRestrictiveOccupancyType != null && mostRestrictiveOccupancyType.getType() != null && "A".equalsIgnoreCase(mostRestrictiveOccupancyType.getType().getCode()) && block.getBuilding().getBuildingHeight().compareTo(BigDecimal.valueOf(10L)) <= 0 && block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(3L)) <= 0) {
            return BigDecimal.ONE;
        }
        if (mostRestrictiveOccupancyType != null && mostRestrictiveOccupancyType.getType() != null && "A".equalsIgnoreCase(mostRestrictiveOccupancyType.getType().getCode())) {
            return BigDecimal.valueOf(1.25);
        }
        if (mostRestrictiveOccupancyType != null && mostRestrictiveOccupancyType.getType() != null && "B".equalsIgnoreCase(mostRestrictiveOccupancyType.getType().getCode())) {
            return BigDecimal.valueOf(1.5);
        }
        if (mostRestrictiveOccupancyType != null && mostRestrictiveOccupancyType.getType() != null && "D".equalsIgnoreCase(mostRestrictiveOccupancyType.getType().getCode())) {
            return BigDecimal.valueOf(2L);
        }
        return BigDecimal.valueOf(1.5);
    }

    private BigDecimal validateTread(Plan plan, HashMap<String, String> errors, Block block, ScrutinyDetail scrutinyDetail3, Floor floor, Map<String, Object> typicalFloorValues, org.egov.common.entity.edcr.GeneralStair generalStair, Flight flight, List<BigDecimal> flightLengths, BigDecimal minTread, OccupancyTypeHelper mostRestrictiveOccupancyType) {
        BigDecimal totalLength = flightLengths.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        totalLength = Util.roundOffTwoDecimal((BigDecimal)totalLength);
        BigDecimal requiredTread = this.getRequiredTread(mostRestrictiveOccupancyType);
        if (flight.getNoOfRises() != null) {
            BigDecimal noOfFlights = BigDecimal.valueOf(flightLengths.size());
            if (flight.getNoOfRises().compareTo(noOfFlights) > 0) {
                BigDecimal denominator = flight.getNoOfRises().subtract(noOfFlights);
                minTread = totalLength.divide(denominator, 2, DcrConstants.ROUNDMODE_MEASUREMENTS);
                boolean valid = false;
                if (!((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) {
                    String value;
                    if (Util.roundOffTwoDecimal((BigDecimal)minTread).compareTo(Util.roundOffTwoDecimal((BigDecimal)requiredTread)) >= 0) {
                        valid = true;
                    }
                    String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
                    if (valid) {
                        this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(TREAD_DESCRIPTION, generalStair.getNumber(), flight.getNumber()), requiredTread.toString(), String.valueOf(minTread), Result.Accepted.getResultVal(), scrutinyDetail3);
                    } else {
                        this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(TREAD_DESCRIPTION, generalStair.getNumber(), flight.getNumber()), requiredTread.toString(), String.valueOf(minTread), Result.Not_Accepted.getResultVal(), scrutinyDetail3);
                    }
                }
            } else if (flight.getNoOfRises().compareTo(BigDecimal.ZERO) > 0) {
                String flightLayerName = String.format("BLK_%s_FLR_%s_STAIR_%s_FLIGHT_%s", block.getNumber(), floor.getNumber(), generalStair.getNumber(), flight.getNumber());
                errors.put("NoOfRisesCount" + flightLayerName, "Number of risers count should be greater than the count of length of flight dimensions defined in layer " + flightLayerName);
                plan.addErrors(errors);
            }
        }
        return minTread;
    }

    private BigDecimal getRequiredTread(OccupancyTypeHelper mostRestrictiveOccupancyType) {
        if (mostRestrictiveOccupancyType != null && mostRestrictiveOccupancyType.getSubtype() != null && "A-AF".equalsIgnoreCase(mostRestrictiveOccupancyType.getSubtype().getCode())) {
            return BigDecimal.valueOf(0.25);
        }
        return BigDecimal.valueOf(0.3);
    }

    private void validateNoOfRises(Plan plan, HashMap<String, String> errors, Block block, ScrutinyDetail scrutinyDetail3, Floor floor, Map<String, Object> typicalFloorValues, org.egov.common.entity.edcr.GeneralStair generalStair, Flight flight, BigDecimal noOfRises) {
        boolean valid = false;
        if (!((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) {
            String value;
            if (Util.roundOffTwoDecimal((BigDecimal)noOfRises).compareTo(Util.roundOffTwoDecimal((BigDecimal)BigDecimal.valueOf(12L))) <= 0) {
                valid = true;
            }
            String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
            if (valid) {
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(NO_OF_RISER_DESCRIPTION, generalStair.getNumber(), flight.getNumber()), EXPECTED_NO_OF_RISER, String.valueOf(noOfRises), Result.Accepted.getResultVal(), scrutinyDetail3);
            } else {
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(NO_OF_RISER_DESCRIPTION, generalStair.getNumber(), flight.getNumber()), EXPECTED_NO_OF_RISER, String.valueOf(noOfRises), Result.Not_Accepted.getResultVal(), scrutinyDetail3);
            }
        }
    }

    private void setReportOutputDetailsFloorStairWise(Plan pl, String ruleNo, String floor, String description, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put(FLOOR, floor);
        details.put("Description", description);
        details.put("Permissible", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

