/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.HashMap;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Building;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Plot;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.common.entity.edcr.SetBack;
import org.egov.edcr.feature.GeneralRule;
import org.egov.infra.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FrontYardService
extends GeneralRule {
    private static final String RULE_35 = "35 Table-8";
    private static final String RULE_36 = "36";
    private static final String RULE_37_TWO_A = "37-2-A";
    private static final String RULE_37_TWO_B = "37-2-B";
    private static final String RULE_37_TWO_C = "37-2-C";
    private static final String RULE_37_TWO_D = "37-2-D";
    private static final String RULE_37_TWO_G = "37-2-G";
    private static final String RULE_37_TWO_H = "37-2-H";
    private static final String RULE_37_TWO_I = "37-2-I";
    private static final String RULE_47 = "47";
    private static final String MINIMUMLABEL = "Minimum distance ";
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_1_5 = BigDecimal.valueOf(1.5);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_1_8 = BigDecimal.valueOf(1.8);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_2_5 = BigDecimal.valueOf(2.5);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_3 = BigDecimal.valueOf(3L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_3_6 = BigDecimal.valueOf(3.6);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_4 = BigDecimal.valueOf(4L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_4_5 = BigDecimal.valueOf(4.5);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_5 = BigDecimal.valueOf(5L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_5_5 = BigDecimal.valueOf(5.5);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_6 = BigDecimal.valueOf(6L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_6_5 = BigDecimal.valueOf(6.5);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_7 = BigDecimal.valueOf(7L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_7_5 = BigDecimal.valueOf(7.5);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_8 = BigDecimal.valueOf(8L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_9 = BigDecimal.valueOf(9L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_10 = BigDecimal.valueOf(10L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_11 = BigDecimal.valueOf(11L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_12 = BigDecimal.valueOf(12L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_13 = BigDecimal.valueOf(13L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_14 = BigDecimal.valueOf(14L);
    private static final BigDecimal FRONTYARDMINIMUM_DISTANCE_15 = BigDecimal.valueOf(15L);
    public static final BigDecimal ROAD_WIDTH_TWELVE_POINTTWO = BigDecimal.valueOf(12.2);
    public static final String BSMT_FRONT_YARD_DESC = "Basement Front Yard";
    private static final int PLOTAREA_300 = 300;

    public void processFrontYard(Plan pl) {
        Plot plot = pl.getPlot();
        HashMap<String, String> errors = new HashMap<String, String>();
        if (plot == null) {
            return;
        }
        this.validateFrontYard(pl);
        if (plot != null && !pl.getBlocks().isEmpty()) {
            for (Block block : pl.getBlocks()) {
                ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
                scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Level");
                scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Occupancy");
                scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Field Verified");
                scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Permissible");
                scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Provided");
                scrutinyDetail.addColumnHeading(Integer.valueOf(7), "Status");
                scrutinyDetail.setHeading("Front Setback");
                FrontYardResult frontYardResult = new FrontYardResult();
                for (SetBack setback : block.getSetBacks()) {
                    if (setback.getFrontYard() == null) continue;
                    BigDecimal min = setback.getFrontYard().getMinimumDistance();
                    BigDecimal mean = setback.getFrontYard().getMean();
                    BigDecimal buildingHeight = setback.getFrontYard().getHeight() != null && setback.getFrontYard().getHeight().compareTo(BigDecimal.ZERO) > 0 ? setback.getFrontYard().getHeight() : block.getBuilding().getBuildingHeight();
                    if (buildingHeight == null || !(min.doubleValue() > 0.0) && !(mean.doubleValue() > 0.0)) continue;
                    for (Occupancy occupancy : block.getBuilding().getTotalArea()) {
                        scrutinyDetail.setKey("Block_" + block.getName() + "_" + "Front Setback");
                        if (setback.getLevel() < 0) {
                            scrutinyDetail.setKey("Block_" + block.getName() + "_Basement Front Yard");
                            this.checkFrontYardBasement(pl, block.getBuilding(), block.getName(), setback.getLevel(), plot, BSMT_FRONT_YARD_DESC, min, mean, occupancy.getTypeHelper(), frontYardResult);
                        }
                        if (occupancy.getTypeHelper().getSubtype() != null && ("A-R".equalsIgnoreCase(occupancy.getTypeHelper().getSubtype().getCode()) || "A-AF".equalsIgnoreCase(occupancy.getTypeHelper().getSubtype().getCode()) || "A-PO".equalsIgnoreCase(occupancy.getTypeHelper().getSubtype().getCode())) || "F".equalsIgnoreCase(occupancy.getTypeHelper().getType().getCode())) {
                            if (buildingHeight.compareTo(BigDecimal.valueOf(10L)) <= 0 && block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(3L)) <= 0) {
                                this.checkFrontYardUptoTenMts(pl, block.getBuilding(), block.getName(), setback.getLevel(), plot, "Front Setback", min, mean, occupancy.getTypeHelper(), frontYardResult, errors);
                                continue;
                            }
                            if (buildingHeight.compareTo(BigDecimal.valueOf(12L)) <= 0 && block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(4L)) <= 0) {
                                this.checkFrontYardUptoTwelveMts(setback, block.getBuilding(), pl, setback.getLevel(), block.getName(), plot, "Front Setback", min, mean, occupancy.getTypeHelper(), frontYardResult, errors);
                                continue;
                            }
                            if (buildingHeight.compareTo(BigDecimal.valueOf(16L)) <= 0) {
                                this.checkFrontYardUptoSixteenMts(setback, block.getBuilding(), buildingHeight, pl, setback.getLevel(), block, plot, "Front Setback", min, mean, occupancy.getTypeHelper(), frontYardResult, errors);
                                continue;
                            }
                            if (buildingHeight.compareTo(BigDecimal.valueOf(16L)) <= 0) continue;
                            this.checkFrontYardAboveSixteenMts(setback, block.getBuilding(), buildingHeight, pl, setback.getLevel(), block.getName(), plot, "Front Setback", min, mean, occupancy.getTypeHelper(), frontYardResult);
                            continue;
                        }
                        if ("G".equalsIgnoreCase(occupancy.getTypeHelper().getType().getCode())) {
                            this.checkFrontYardForIndustrial(pl, block.getBuilding(), block.getName(), setback.getLevel(), plot, "Front Setback", min, mean, occupancy.getTypeHelper(), frontYardResult);
                            continue;
                        }
                        this.checkFrontYardOtherOccupancies(pl, block.getBuilding(), block.getName(), setback.getLevel(), plot, "Front Setback", min, mean, occupancy.getTypeHelper(), frontYardResult);
                    }
                    if (!errors.isEmpty()) continue;
                    HashMap<String, String> details = new HashMap<String, String>();
                    details.put("Byelaw", frontYardResult.subRule);
                    details.put("Level", frontYardResult.level != null ? frontYardResult.level.toString() : "");
                    details.put("Occupancy", frontYardResult.occupancy);
                    details.put("Field Verified", MINIMUMLABEL);
                    details.put("Permissible", frontYardResult.expectedminimumDistance.toString());
                    details.put("Provided", frontYardResult.actualMinDistance.toString());
                    if (frontYardResult.status) {
                        details.put("Status", Result.Accepted.getResultVal());
                    } else {
                        details.put("Status", Result.Not_Accepted.getResultVal());
                    }
                    scrutinyDetail.getDetail().add(details);
                    pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                }
            }
        }
    }

    private void validateFrontYard(Plan pl) {
        for (Block block : pl.getBlocks()) {
            if (block.getCompletelyExisting().booleanValue()) continue;
            Boolean frontYardDefined = false;
            for (SetBack setback : block.getSetBacks()) {
                if (setback.getFrontYard() == null || setback.getFrontYard().getMean().compareTo(BigDecimal.valueOf(0L)) <= 0) continue;
                frontYardDefined = true;
            }
            if (frontYardDefined.booleanValue()) continue;
            HashMap<String, String> errors = new HashMap<String, String>();
            errors.put("Front Setback", this.prepareMessage("msg.error.not.defined", "Front Setback for Block " + block.getName()));
            pl.addErrors(errors);
        }
    }

    private Boolean checkFrontYardUptoSixteenMts(SetBack setback, Building building, BigDecimal blockBuildingHeight, Plan pl, Integer level, Block block, Plot plot, String frontYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, HashMap<String, String> errors) {
        Boolean valid = false;
        String subRule = RULE_35;
        String rule = "Front Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        BigDecimal depthOfPlot = pl.getPlanInformation().getDepthOfPlot();
        if (mostRestrictiveOccupancy.getSubtype() != null && "A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) && block.getBuilding().getFloorsAboveGround().compareTo(BigDecimal.valueOf(5L)) <= 0) {
            valid = pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null && StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) && "COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) && pl.getPlanInformation().getRoadWidth().compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0 ? this.commercialUptoSixteenMts(level, block.getName(), min, mean, mostRestrictiveOccupancy, frontYardResult, valid, "28", rule, minVal, meanVal, depthOfPlot) : this.residentialUptoSixteenMts(level, block.getName(), min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, depthOfPlot, errors, pl);
        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            valid = this.commercialUptoSixteenMts(level, block.getName(), min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, depthOfPlot);
        }
        return valid;
    }

    private Boolean residentialUptoSixteenMts(Integer level, String blockName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, Boolean valid, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal depthOfPlot, HashMap<String, String> errors, Plan pl) {
        if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            errors.put("uptoSixteenHeightUptoTenDepthFrontYard", "No construction shall be permitted if depth of plot is less than 10 and building height less than 16 having floors upto G+4.");
            pl.addErrors(errors);
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_3;
            valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_4_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_5_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_6;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(45L)) > 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_6;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareFrontYardResult(blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean commercialUptoSixteenMts(Integer level, String blockName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, Boolean valid, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal depthOfPlot) {
        if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_4_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_4_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_5_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_6;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_6_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_7;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_7_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(45L)) > 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_8;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareFrontYardResult(blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean checkFrontYardAboveSixteenMts(SetBack setback, Building building, BigDecimal blockBuildingHeight, Plan pl, Integer level, String blockName, Plot plot, String frontYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult) {
        Boolean valid = false;
        String subRule = RULE_36;
        String rule = "Front Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        valid = this.allOccupancyForHighRise(level, blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, blockBuildingHeight);
        return valid;
    }

    private Boolean allOccupancyForHighRise(Integer level, String blockName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, Boolean valid, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal blockBuildingHeight) {
        if (blockBuildingHeight.compareTo(BigDecimal.valueOf(16L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(19L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_6_5;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(19L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(22L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_7_5;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(22L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(25L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_8;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(25L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(28L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_9;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(28L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(31L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_10;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(31L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(36L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_11;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(36L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(41L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_12;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(41L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(46L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_13;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(46L)) > 0 && blockBuildingHeight.compareTo(BigDecimal.valueOf(51L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_14;
        } else if (blockBuildingHeight.compareTo(BigDecimal.valueOf(51L)) > 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_15;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareFrontYardResult(blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean checkFrontYardUptoTenMts(Plan pl, Building building, String blockName, Integer level, Plot plot, String frontYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, HashMap<String, String> errors) {
        Boolean valid = false;
        String subRule = RULE_35;
        String rule = "Front Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        BigDecimal depthOfPlot = pl.getPlanInformation().getDepthOfPlot();
        if (mostRestrictiveOccupancy.getSubtype() != null && ("A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()))) {
            valid = pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null && StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) && "COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) && pl.getPlanInformation().getRoadWidth().compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0 ? this.commercialUptoSixteenMts(level, blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, "28", rule, minVal, meanVal, depthOfPlot) : this.residentialUptoTenMts(blockName, level, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, depthOfPlot, errors, pl);
        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            valid = this.commercialUptoSixteenMts(level, blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, depthOfPlot);
        }
        return valid;
    }

    private Boolean checkFrontYardBasement(Plan plan, Building building, String blockName, Integer level, Plot plot, String frontYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult) {
        Boolean valid = false;
        String subRule = RULE_47;
        String rule = "Front Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        if (mostRestrictiveOccupancy.getSubtype() != null && "A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            if (plot.getArea().compareTo(BigDecimal.valueOf(300L)) <= 0) {
                minVal = FRONTYARDMINIMUM_DISTANCE_3;
                valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
            }
            rule = BSMT_FRONT_YARD_DESC;
            this.compareFrontYardResult(blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, level);
        }
        return valid;
    }

    private Boolean checkFrontYardForIndustrial(Plan pl, Building building, String blockName, Integer level, Plot plot, String frontYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult) {
        Boolean valid = false;
        String subRule = RULE_35;
        String rule = "Front Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        BigDecimal widthOfPlot = pl.getPlanInformation().getWidthOfPlot();
        valid = this.processFrontYardForIndustrial(blockName, level, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, pl.getPlot().getArea(), widthOfPlot);
        return valid;
    }

    private Boolean checkFrontYardOtherOccupancies(Plan pl, Building building, String blockName, Integer level, Plot plot, String frontYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult) {
        Boolean valid = false;
        String subRule = RULE_37_TWO_A;
        String rule = "Front Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        if (mostRestrictiveOccupancy.getType() != null && "B".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = FRONTYARDMINIMUM_DISTANCE_9;
            subRule = RULE_37_TWO_A;
        }
        if (mostRestrictiveOccupancy.getType() != null && "B".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = FRONTYARDMINIMUM_DISTANCE_9;
            subRule = RULE_37_TWO_B;
        }
        if (mostRestrictiveOccupancy.getType() != null && "D".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = FRONTYARDMINIMUM_DISTANCE_12;
            subRule = RULE_37_TWO_C;
        }
        if (mostRestrictiveOccupancy.getType() != null && "D".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = FRONTYARDMINIMUM_DISTANCE_12;
            subRule = RULE_37_TWO_D;
        }
        if (mostRestrictiveOccupancy.getType() != null && "I".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = BigDecimal.ZERO;
            subRule = RULE_37_TWO_G;
        }
        if (mostRestrictiveOccupancy.getType() != null && "A".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            minVal = BigDecimal.ZERO;
            subRule = RULE_37_TWO_H;
        }
        if (mostRestrictiveOccupancy.getType() != null && "F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            subRule = RULE_37_TWO_I;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareFrontYardResult(blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private void compareFrontYardResult(String blockName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, Boolean valid, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, Integer level) {
        String occupancyName = mostRestrictiveOccupancy.getSubtype() != null ? mostRestrictiveOccupancy.getSubtype().getName() : mostRestrictiveOccupancy.getType().getName();
        if (minVal.compareTo(frontYardResult.expectedminimumDistance) >= 0) {
            if (minVal.compareTo(frontYardResult.expectedminimumDistance) == 0) {
                frontYardResult.rule = frontYardResult.rule != null ? frontYardResult.rule + "," + rule : rule;
                frontYardResult.occupancy = frontYardResult.occupancy != null ? frontYardResult.occupancy + "," + occupancyName : occupancyName;
            } else {
                frontYardResult.rule = rule;
                frontYardResult.occupancy = occupancyName;
            }
            frontYardResult.subRule = subRule;
            frontYardResult.blockName = blockName;
            frontYardResult.level = level;
            frontYardResult.expectedminimumDistance = minVal;
            frontYardResult.expectedmeanDistance = meanVal;
            frontYardResult.actualMinDistance = min;
            frontYardResult.actualMeanDistance = mean;
            frontYardResult.status = valid;
        }
    }

    private Boolean checkFrontYardUptoTwelveMts(SetBack setback, Building building, Plan pl, Integer level, String blockName, Plot plot, String frontYardFieldName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, HashMap<String, String> errors) {
        Boolean valid = false;
        String subRule = RULE_35;
        String rule = "Front Setback";
        BigDecimal minVal = BigDecimal.ZERO;
        BigDecimal meanVal = BigDecimal.ZERO;
        BigDecimal depthOfPlot = pl.getPlanInformation().getDepthOfPlot();
        if (mostRestrictiveOccupancy.getSubtype() != null && "A-R".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode()) || "A-PO".equalsIgnoreCase(mostRestrictiveOccupancy.getSubtype().getCode())) {
            valid = pl.getPlanInformation() != null && pl.getPlanInformation().getRoadWidth() != null && StringUtils.isNotBlank((String)pl.getPlanInformation().getLandUseZone()) && "COMMERCIAL".equalsIgnoreCase(pl.getPlanInformation().getLandUseZone()) && pl.getPlanInformation().getRoadWidth().compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0 ? this.commercialUptoSixteenMts(level, blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, "28", rule, minVal, meanVal, depthOfPlot) : this.residentialUptoTwelveMts(level, blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, depthOfPlot, errors, pl);
        } else if ("F".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode())) {
            valid = this.commercialUptoSixteenMts(level, blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, depthOfPlot);
        }
        return valid;
    }

    private Boolean residentialUptoTwelveMts(Integer level, String blockName, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, Boolean valid, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal depthOfPlot, HashMap<String, String> errors, Plan pl) {
        if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            errors.put("uptoTwelveHeightUptoTenDepthFrontYard", "No construction shall be permitted if depth of plot is less than 10 and building height less than 12 having floors upto G+2.");
            pl.addErrors(errors);
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_2_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_3_6;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_4_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(45L)) > 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_6;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareFrontYardResult(blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean residentialUptoTenMts(String blockName, Integer level, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, Boolean valid, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal depthOfPlot, HashMap<String, String> errors, Plan pl) {
        if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_1_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(10L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_1_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(15L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(21L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_1_8;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(21L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(27L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_2_5;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(27L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(33L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_3;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(33L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(39L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_3;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(39L)) > 0 && depthOfPlot.compareTo(BigDecimal.valueOf(45L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_4;
        } else if (depthOfPlot.compareTo(BigDecimal.valueOf(45L)) > 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_4;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareFrontYardResult(blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean processFrontYardForIndustrial(String blockName, Integer level, BigDecimal min, BigDecimal mean, OccupancyTypeHelper mostRestrictiveOccupancy, FrontYardResult frontYardResult, Boolean valid, String subRule, String rule, BigDecimal minVal, BigDecimal meanVal, BigDecimal plotArea, BigDecimal widthOfPlot) {
        if (plotArea.compareTo(BigDecimal.valueOf(550L)) < 0) {
            if (widthOfPlot.compareTo(BigDecimal.valueOf(10L)) <= 0) {
                minVal = FRONTYARDMINIMUM_DISTANCE_3;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(12L)) <= 0) {
                minVal = FRONTYARDMINIMUM_DISTANCE_4;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(15L)) <= 0) {
                minVal = FRONTYARDMINIMUM_DISTANCE_5;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(18L)) <= 0) {
                minVal = FRONTYARDMINIMUM_DISTANCE_6;
            } else if (widthOfPlot.compareTo(BigDecimal.valueOf(18L)) > 0) {
                minVal = FRONTYARDMINIMUM_DISTANCE_6;
            }
        } else if (plotArea.compareTo(BigDecimal.valueOf(550L)) > 0 && plotArea.compareTo(BigDecimal.valueOf(1000L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_9;
        } else if (plotArea.compareTo(BigDecimal.valueOf(1000L)) > 0 && plotArea.compareTo(BigDecimal.valueOf(5000L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_10;
        } else if (plotArea.compareTo(BigDecimal.valueOf(5000L)) > 0 && plotArea.compareTo(BigDecimal.valueOf(30000L)) <= 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_12;
        } else if (plotArea.compareTo(BigDecimal.valueOf(30000L)) > 0) {
            minVal = FRONTYARDMINIMUM_DISTANCE_15;
        }
        valid = this.validateMinimumAndMeanValue(min, mean, minVal, meanVal);
        this.compareFrontYardResult(blockName, min, mean, mostRestrictiveOccupancy, frontYardResult, valid, subRule, rule, minVal, meanVal, level);
        return valid;
    }

    private Boolean validateMinimumAndMeanValue(BigDecimal min, BigDecimal mean, BigDecimal minval, BigDecimal meanval) {
        Boolean valid = false;
        if (min.compareTo(minval) >= 0 && mean.compareTo(meanval) >= 0) {
            valid = true;
        }
        return valid;
    }

    private class FrontYardResult {
        String rule;
        String subRule;
        String blockName;
        Integer level;
        BigDecimal actualMeanDistance = BigDecimal.ZERO;
        BigDecimal actualMinDistance = BigDecimal.ZERO;
        String occupancy;
        BigDecimal expectedminimumDistance = BigDecimal.ZERO;
        BigDecimal expectedmeanDistance = BigDecimal.ZERO;
        String additionalCondition;
        boolean status = false;

        private FrontYardResult() {
        }
    }
}

