/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.stereotype.Service;

@Service
public class FireTenderMovement
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(FireTenderMovement.class);
    private static final BigDecimal FIFTEEN = BigDecimal.valueOf(15L);
    private static final BigDecimal THREE_POINTSIXSIX = BigDecimal.valueOf(3.66);
    private static final String RULE_36_3 = "36-3";

    @Override
    public Plan validate(Plan plan) {
        return plan;
    }

    @Override
    public Plan process(Plan plan) {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Block block : plan.getBlocks()) {
            ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
            scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
            scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Permissible");
            scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Provided");
            scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
            scrutinyDetail.setKey("Block_" + block.getNumber() + "_Fire Tender Movement");
            if (block.getBuilding() == null || block.getBuilding().getBuildingHeight().setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS).compareTo(FIFTEEN) <= 0) continue;
            org.egov.common.entity.edcr.FireTenderMovement fireTenderMovement = block.getFireTenderMovement();
            if (fireTenderMovement != null) {
                List widths = fireTenderMovement.getFireTenderMovements().stream().map(fireTenderMovmnt -> fireTenderMovmnt.getWidth()).collect(Collectors.toList());
                BigDecimal minWidth = (BigDecimal)widths.stream().reduce(BigDecimal::min).get();
                BigDecimal providedWidth = minWidth.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS);
                Boolean isAccepted = providedWidth.compareTo(THREE_POINTSIXSIX) >= 0;
                HashMap<String, String> details = new HashMap<String, String>();
                details.put("Byelaw", RULE_36_3);
                details.put("Description", "Width of fire tender movement");
                details.put("Permissible", ">= " + THREE_POINTSIXSIX.toString());
                details.put("Provided", providedWidth.toString());
                details.put("Status", isAccepted != false ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                plan.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                if (fireTenderMovement.getErrors().isEmpty()) continue;
                StringBuffer yardNames = new StringBuffer();
                for (String yardName : fireTenderMovement.getErrors()) {
                    yardNames = yardNames.append(yardName).append(", ");
                }
                errors.put("FTM_SETBACK", "Fire tender movement for block " + block.getNumber() + " is not inside " + yardNames.toString().substring(0, yardNames.length() - 2) + ".");
                plan.addErrors(errors);
                continue;
            }
            errors.put("BLK_FTM_" + block.getNumber(), "Fire tender movement not defined for Block " + block.getNumber());
            plan.addErrors(errors);
        }
        return plan;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

