/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Flight;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.common.entity.edcr.StairLanding;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.egov.edcr.utility.Util;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class FireStair
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(FireStair.class);
    private static final String FLOOR = "Floor";
    private static final String RULE42_5_II = "42-5-iii-f";
    private static final String EXPECTED_NO_OF_RISE = "12";
    private static final String NO_OF_RISER_DESCRIPTION = "Maximum no of risers required per flight for fire stair %s flight %s";
    private static final String WIDTH_DESCRIPTION = "Minimum width for fire stair %s flight %s";
    private static final String TREAD_DESCRIPTION = "Minimum tread for fire stair %s flight %s";
    private static final String NO_OF_RISERS = "Number of risers ";
    private static final String FLIGHT_POLYLINE_NOT_DEFINED_DESCRIPTION = "Flight polyline is not defined in layer ";
    private static final String FLIGHT_LENGTH_DEFINED_DESCRIPTION = "Flight polyline length is not defined in layer ";
    private static final String FLIGHT_WIDTH_DEFINED_DESCRIPTION = "Flight polyline width is not defined in layer ";
    private static final String WIDTH_LANDING_DESCRIPTION = "Minimum width for fire stair %s mid landing %s";
    private static final String FLIGHT_NOT_DEFINED_DESCRIPTION = "Fire stair flight is not defined in block %s floor %s";

    @Override
    public Plan validate(Plan plan) {
        return plan;
    }

    @Override
    public Plan process(Plan plan) {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (Block block : plan.getBlocks()) {
            int fireStairCount = 0;
            if (block.getBuilding() == null) continue;
            ScrutinyDetail scrutinyDetail2 = new ScrutinyDetail();
            scrutinyDetail2.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail2.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetail2.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetail2.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetail2.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetail2.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetail2.setKey("Block_" + block.getNumber() + "_Fire Stair - Width");
            ScrutinyDetail scrutinyDetail3 = new ScrutinyDetail();
            scrutinyDetail3.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetail3.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetail3.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetail3.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetail3.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetail3.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetail3.setKey("Block_" + block.getNumber() + "_Fire Stair - Tread width");
            ScrutinyDetail scrutinyDetailRise = new ScrutinyDetail();
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetailRise.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetailRise.setKey("Block_" + block.getNumber() + "_Fire Stair - Number of risers");
            ScrutinyDetail scrutinyDetailLanding = new ScrutinyDetail();
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(4), "Permissible");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(5), "Provided");
            scrutinyDetailLanding.addColumnHeading(Integer.valueOf(6), "Status");
            scrutinyDetailLanding.setKey("Block_" + block.getNumber() + "_Fire Stair - Mid landing");
            ScrutinyDetail scrutinyDetailAbutBltUp = new ScrutinyDetail();
            scrutinyDetailAbutBltUp.addColumnHeading(Integer.valueOf(1), "Byelaw");
            scrutinyDetailAbutBltUp.addColumnHeading(Integer.valueOf(2), FLOOR);
            scrutinyDetailAbutBltUp.addColumnHeading(Integer.valueOf(3), "Description");
            scrutinyDetailAbutBltUp.addColumnHeading(Integer.valueOf(4), "Provided");
            scrutinyDetailAbutBltUp.addColumnHeading(Integer.valueOf(5), "Status");
            scrutinyDetailAbutBltUp.setKey("Block_" + block.getNumber() + "_Fire Stair - Abutting External Wall");
            OccupancyTypeHelper mostRestrictiveOccupancyType = plan.getVirtualBuilding() != null ? plan.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
            List floors = block.getBuilding().getFloors();
            ArrayList<String> fireStairAbsent = new ArrayList<String>();
            for (Floor floor : floors) {
                if (floor.getTerrace().booleanValue()) continue;
                boolean isTypicalRepititiveFloor = false;
                Map typicalFloorValues = Util.getTypicalFloorValues((Block)block, (Floor)floor, (Boolean)isTypicalRepititiveFloor);
                List fireStairs = floor.getFireStairs();
                fireStairCount += fireStairs.size();
                if (!fireStairs.isEmpty()) {
                    for (org.egov.common.entity.edcr.FireStair fireStair : fireStairs) {
                        this.setReportOutputDetailsBltUp(plan, RULE42_5_II, floor.getNumber().toString(), "Fire stair should abut floor external wall", fireStair.isAbuttingBltUp() ? "Is abuting external wall" : "Not abuting external wall", fireStair.isAbuttingBltUp() ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal(), scrutinyDetailAbutBltUp);
                        this.validateFlight(plan, errors, block, scrutinyDetail2, scrutinyDetail3, scrutinyDetailRise, mostRestrictiveOccupancyType, floor, typicalFloorValues, fireStair);
                        List landings = fireStair.getLandings();
                        if (!landings.isEmpty()) {
                            this.validateLanding(plan, block, scrutinyDetailLanding, floor, typicalFloorValues, fireStair, landings, errors);
                            continue;
                        }
                        errors.put("Fire Stair landing not defined in blk " + block.getNumber() + " floor " + floor.getNumber() + " fire stair " + fireStair.getNumber(), "Fire Stair landing not defined in blk " + block.getNumber() + " floor " + floor.getNumber() + " fire stair " + fireStair.getNumber());
                        plan.addErrors(errors);
                    }
                    continue;
                }
                if (!block.getBuilding().getIsHighRise().booleanValue()) continue;
                fireStairAbsent.add("Block " + block.getNumber() + " floor " + floor.getNumber());
            }
            if (!fireStairAbsent.isEmpty()) {
                for (String error : fireStairAbsent) {
                    errors.put("Fire Stair " + error, "Fire stair not defined in " + error);
                    plan.addErrors(errors);
                }
            }
            if (!block.getBuilding().getIsHighRise().booleanValue() || fireStairCount != 0) continue;
            errors.put("FireStair not defined in blk " + block.getNumber(), "FireStair not defined in block " + block.getNumber() + ", it is mandatory for building with height more than 15m.");
            plan.addErrors(errors);
        }
        return plan;
    }

    private void validateLanding(Plan plan, Block block, ScrutinyDetail scrutinyDetailLanding, Floor floor, Map<String, Object> typicalFloorValues, org.egov.common.entity.edcr.FireStair fireStair, List<StairLanding> landings, HashMap<String, String> errors) {
        for (StairLanding landing : landings) {
            List widths = landing.getWidths();
            if (!widths.isEmpty()) {
                String value;
                BigDecimal minimumWidth;
                BigDecimal landingWidth = (BigDecimal)widths.stream().reduce(BigDecimal::min).get();
                BigDecimal minWidth = BigDecimal.ZERO;
                boolean valid = false;
                if (((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) continue;
                minWidth = Util.roundOffTwoDecimal((BigDecimal)landingWidth);
                if (minWidth.compareTo(minimumWidth = BigDecimal.valueOf(1L)) >= 0) {
                    valid = true;
                }
                String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
                if (valid) {
                    this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(WIDTH_LANDING_DESCRIPTION, fireStair.getNumber(), landing.getNumber()), minimumWidth.toString(), String.valueOf(minWidth), Result.Accepted.getResultVal(), scrutinyDetailLanding);
                    continue;
                }
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(WIDTH_LANDING_DESCRIPTION, fireStair.getNumber(), landing.getNumber()), minimumWidth.toString(), String.valueOf(minWidth), Result.Not_Accepted.getResultVal(), scrutinyDetailLanding);
                continue;
            }
            errors.put("Fire Stair landing width not defined in blk " + block.getNumber() + " floor " + floor.getNumber() + " fire stair " + fireStair.getNumber(), "Fire Stair landing width not defined in blk " + block.getNumber() + " floor " + floor.getNumber() + " fire stair " + fireStair.getNumber());
            plan.addErrors(errors);
        }
    }

    private void validateFlight(Plan plan, HashMap<String, String> errors, Block block, ScrutinyDetail scrutinyDetail2, ScrutinyDetail scrutinyDetail3, ScrutinyDetail scrutinyDetailRise, OccupancyTypeHelper mostRestrictiveOccupancyType, Floor floor, Map<String, Object> typicalFloorValues, org.egov.common.entity.edcr.FireStair fireStair) {
        if (!fireStair.getFlights().isEmpty()) {
            for (Flight flight : fireStair.getFlights()) {
                List flightPolyLines = flight.getFlights();
                List flightLengths = flight.getLengthOfFlights();
                List flightWidths = flight.getWidthOfFlights();
                BigDecimal noOfRises = flight.getNoOfRises();
                Boolean flightPolyLineClosed = flight.getFlightClosed();
                BigDecimal minTread = BigDecimal.ZERO;
                BigDecimal minFlightWidth = BigDecimal.ZERO;
                String flightLayerName = String.format("BLK_%s_FLR_%s_FIRESTAIR_%s_FLIGHT_%s", block.getNumber(), floor.getNumber(), fireStair.getNumber(), flight.getNumber());
                if (floor.getTerrace().booleanValue()) continue;
                if (flightPolyLines != null && flightPolyLines.size() > 0) {
                    if (!flightPolyLineClosed.booleanValue()) continue;
                    if (flightWidths != null && flightWidths.size() > 0) {
                        minFlightWidth = this.validateWidth(plan, scrutinyDetail2, floor, block, typicalFloorValues, fireStair, flight, flightWidths, minFlightWidth, mostRestrictiveOccupancyType);
                    } else {
                        errors.put("Flight PolyLine width" + flightLayerName, FLIGHT_WIDTH_DEFINED_DESCRIPTION + flightLayerName);
                        plan.addErrors(errors);
                    }
                    if (flightLengths != null && flightLengths.size() > 0) {
                        try {
                            minTread = this.validateTread(plan, errors, block, scrutinyDetail3, floor, typicalFloorValues, fireStair, flight, flightLengths, minTread, mostRestrictiveOccupancyType);
                        }
                        catch (ArithmeticException e) {
                            LOG.info((Object)"Denominator is zero");
                        }
                    } else {
                        errors.put("Flight PolyLine length" + flightLayerName, FLIGHT_LENGTH_DEFINED_DESCRIPTION + flightLayerName);
                        plan.addErrors(errors);
                    }
                    if (noOfRises.compareTo(BigDecimal.ZERO) > 0) {
                        try {
                            this.validateNoOfRises(plan, errors, block, scrutinyDetailRise, floor, typicalFloorValues, flight, fireStair, noOfRises);
                        }
                        catch (ArithmeticException e) {
                            LOG.info((Object)"Denominator is zero");
                        }
                        continue;
                    }
                    String layerName = String.format("BLK_%s_FLR_%s_FIRESTAIR_%s_FLIGHT_%s", block.getNumber(), floor.getNumber(), fireStair.getNumber());
                    errors.put("noofRise" + layerName, this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{NO_OF_RISERS + layerName}, LocaleContextHolder.getLocale()));
                    plan.addErrors(errors);
                    continue;
                }
                errors.put("Flight PolyLine " + flightLayerName, FLIGHT_POLYLINE_NOT_DEFINED_DESCRIPTION + flightLayerName);
                plan.addErrors(errors);
            }
        } else {
            String error = String.format(FLIGHT_NOT_DEFINED_DESCRIPTION, block.getNumber(), floor.getNumber());
            errors.put(error, error);
            plan.addErrors(errors);
        }
    }

    private BigDecimal validateWidth(Plan plan, ScrutinyDetail scrutinyDetail2, Floor floor, Block block, Map<String, Object> typicalFloorValues, org.egov.common.entity.edcr.FireStair fireStair, Flight flight, List<BigDecimal> flightWidths, BigDecimal minFlightWidth, OccupancyTypeHelper mostRestrictiveOccupancyType) {
        BigDecimal flightPolyLine = (BigDecimal)flightWidths.stream().reduce(BigDecimal::min).get();
        boolean valid = false;
        if (!((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) {
            String value;
            BigDecimal minimumWidth;
            minFlightWidth = Util.roundOffTwoDecimal((BigDecimal)flightPolyLine);
            if (minFlightWidth.compareTo(minimumWidth = BigDecimal.valueOf(1L)) >= 0) {
                valid = true;
            }
            String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
            if (valid) {
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(WIDTH_DESCRIPTION, fireStair.getNumber(), flight.getNumber()), minimumWidth.toString(), String.valueOf(minFlightWidth), Result.Accepted.getResultVal(), scrutinyDetail2);
            } else {
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(WIDTH_DESCRIPTION, fireStair.getNumber(), flight.getNumber()), minimumWidth.toString(), String.valueOf(minFlightWidth), Result.Not_Accepted.getResultVal(), scrutinyDetail2);
            }
        }
        return minFlightWidth;
    }

    private BigDecimal validateTread(Plan plan, HashMap<String, String> errors, Block block, ScrutinyDetail scrutinyDetail3, Floor floor, Map<String, Object> typicalFloorValues, org.egov.common.entity.edcr.FireStair fireStair, Flight flight, List<BigDecimal> flightLengths, BigDecimal minTread, OccupancyTypeHelper mostRestrictiveOccupancyType) {
        BigDecimal totalLength = flightLengths.stream().reduce(BigDecimal.ZERO, BigDecimal::add);
        totalLength = Util.roundOffTwoDecimal((BigDecimal)totalLength);
        BigDecimal requiredTread = BigDecimal.valueOf(0.25);
        if (flight.getNoOfRises() != null) {
            BigDecimal noOfFlights = BigDecimal.valueOf(flightLengths.size());
            if (flight.getNoOfRises().compareTo(noOfFlights) > 0) {
                BigDecimal denominator = flight.getNoOfRises().subtract(noOfFlights);
                minTread = totalLength.divide(denominator, 2, DcrConstants.ROUNDMODE_MEASUREMENTS);
                boolean valid = false;
                if (!((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) {
                    String value;
                    if (Util.roundOffTwoDecimal((BigDecimal)minTread).compareTo(Util.roundOffTwoDecimal((BigDecimal)requiredTread)) >= 0) {
                        valid = true;
                    }
                    String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
                    if (valid) {
                        this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(TREAD_DESCRIPTION, fireStair.getNumber(), flight.getNumber()), requiredTread.toString(), String.valueOf(minTread), Result.Accepted.getResultVal(), scrutinyDetail3);
                    } else {
                        this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(TREAD_DESCRIPTION, fireStair.getNumber(), flight.getNumber()), requiredTread.toString(), String.valueOf(minTread), Result.Not_Accepted.getResultVal(), scrutinyDetail3);
                    }
                }
            } else if (flight.getNoOfRises().compareTo(BigDecimal.ZERO) > 0) {
                String flightLayerName = String.format("BLK_%s_FLR_%s_FIRESTAIR_%s_FLIGHT_%s", block.getNumber(), floor.getNumber(), fireStair.getNumber(), flight.getNumber());
                errors.put("NoOfRisesCount" + flightLayerName, "Number of risers count should be greater than the count of length of flight dimensions defined in layer " + flightLayerName);
                plan.addErrors(errors);
            }
        }
        return minTread;
    }

    private void validateNoOfRises(Plan plan, HashMap<String, String> errors, Block block, ScrutinyDetail scrutinyDetail3, Floor floor, Map<String, Object> typicalFloorValues, Flight flight, org.egov.common.entity.edcr.FireStair fireStair, BigDecimal noOfRises) {
        boolean valid = false;
        if (!((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) {
            String value;
            if (Util.roundOffTwoDecimal((BigDecimal)noOfRises).compareTo(Util.roundOffTwoDecimal((BigDecimal)BigDecimal.valueOf(12L))) <= 0) {
                valid = true;
            }
            String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
            if (valid) {
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(NO_OF_RISER_DESCRIPTION, fireStair.getNumber(), flight.getNumber()), EXPECTED_NO_OF_RISE, String.valueOf(noOfRises), Result.Accepted.getResultVal(), scrutinyDetail3);
            } else {
                this.setReportOutputDetailsFloorStairWise(plan, RULE42_5_II, value, String.format(NO_OF_RISER_DESCRIPTION, fireStair.getNumber(), flight.getNumber()), EXPECTED_NO_OF_RISE, String.valueOf(noOfRises), Result.Not_Accepted.getResultVal(), scrutinyDetail3);
            }
        }
    }

    private void setReportOutputDetailsFloorStairWise(Plan pl, String ruleNo, String floor, String description, String expected, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put(FLOOR, floor);
        details.put("Description", description);
        details.put("Permissible", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    private void setReportOutputDetailsBltUp(Plan pl, String ruleNo, String floor, String description, String actual, String status, ScrutinyDetail scrutinyDetail) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put(FLOOR, floor);
        details.put("Description", description);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

