/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.util.Date;
import java.util.Map;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class FeatureProcess {
    protected ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
    public static final String STATUS = "Status";
    public static final String PROVIDED = "Provided";
    public static final String LEVEL = "Level";
    public static final String OCCUPANCY = "Occupancy";
    public static final String FIELDVERIFIED = "Field Verified";
    public static final String REQUIRED = "Required";
    public static final String PERMITTED = "Permitted";
    public static final String PERMISSIBLE = "Permissible";
    public static final String DESCRIPTION = "Description";
    public static final String RULE_NO = "Byelaw";
    public static final String DISTANCE = "Distance";
    public static final String VERIFIED = "Verified";
    public static final String ACTION = "Action";
    public static final String AREA_TYPE = "Area Type";
    public static final String ROAD_WIDTH = "Road Width";
    @Autowired
    @Qualifier(value="parentMessageSource")
    protected MessageSource edcrMessageSource;

    public abstract Map<String, Date> getAmendments();

    public abstract Plan validate(Plan var1);

    public abstract Plan process(Plan var1);

    public MessageSource getEdcrMessageSource() {
        return this.edcrMessageSource;
    }

    public void setEdcrMessageSource(MessageSource edcrMessageSource) {
        this.edcrMessageSource = edcrMessageSource;
    }

    public String getLocaleMessage(String code, String ... args) {
        return this.edcrMessageSource.getMessage(code, (Object[])args, LocaleContextHolder.getLocale());
    }

    public String getAmendmentsRefNumber(Date applicationDate) {
        String refNumber = "";
        Map<String, Date> amendments = this.getAmendments();
        for (String key : amendments.keySet()) {
            if (applicationDate == null || applicationDate.compareTo(amendments.get(key)) < 0) continue;
            refNumber = key;
        }
        return refNumber;
    }
}

