/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.egov.common.entity.dcr.helper.OccupancyHelperDetail;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Building;
import org.egov.common.entity.edcr.FarDetails;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.service.ProcessPrintHelper;
import org.egov.edcr.utility.DcrConstants;
import org.egov.infra.utils.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class Far
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(Far.class);
    private static final String VALIDATION_NEGATIVE_FLOOR_AREA = "msg.error.negative.floorarea.occupancy.floor";
    private static final String VALIDATION_NEGATIVE_EXISTING_FLOOR_AREA = "msg.error.negative.existing.floorarea.occupancy.floor";
    private static final String VALIDATION_NEGATIVE_BUILTUP_AREA = "msg.error.negative.builtuparea.occupancy.floor";
    private static final String VALIDATION_NEGATIVE_EXISTING_BUILTUP_AREA = "msg.error.negative.existing.builtuparea.occupancy.floor";
    public static final String RULE_31_1 = "31-1";
    public static final String RULE_38 = "38";
    private static final BigDecimal POINTTWO = BigDecimal.valueOf(0.2);
    private static final BigDecimal POINTFOUR = BigDecimal.valueOf(0.4);
    private static final BigDecimal POINTFIVE = BigDecimal.valueOf(0.5);
    private static final BigDecimal POINTSIX = BigDecimal.valueOf(0.6);
    private static final BigDecimal POINTSEVEN = BigDecimal.valueOf(0.7);
    private static final BigDecimal ONE = BigDecimal.valueOf(1L);
    private static final BigDecimal ONE_POINTTWO = BigDecimal.valueOf(1.2);
    private static final BigDecimal ONE_POINTFIVE = BigDecimal.valueOf(1.5);
    private static final BigDecimal ONE_POINTEIGHT = BigDecimal.valueOf(1.8);
    private static final BigDecimal TWO = BigDecimal.valueOf(2L);
    private static final BigDecimal TWO_POINTFIVE = BigDecimal.valueOf(2.5);
    private static final BigDecimal THREE = BigDecimal.valueOf(3L);
    private static final BigDecimal THREE_POINTTWOFIVE = BigDecimal.valueOf(3.25);
    private static final BigDecimal THREE_POINTFIVE = BigDecimal.valueOf(3.5);
    private static final BigDecimal FIFTEEN = BigDecimal.valueOf(15L);
    private static final BigDecimal ROAD_WIDTH_TWO_POINTFOUR = BigDecimal.valueOf(2.4);
    private static final BigDecimal ROAD_WIDTH_TWO_POINTFOURFOUR = BigDecimal.valueOf(2.44);
    private static final BigDecimal ROAD_WIDTH_THREE_POINTSIX = BigDecimal.valueOf(3.6);
    private static final BigDecimal ROAD_WIDTH_FOUR_POINTEIGHT = BigDecimal.valueOf(4.8);
    private static final BigDecimal ROAD_WIDTH_SIX_POINTONE = BigDecimal.valueOf(6.1);
    private static final BigDecimal ROAD_WIDTH_NINE_POINTONE = BigDecimal.valueOf(9.1);
    private static final BigDecimal ROAD_WIDTH_TWELVE_POINTTWO = BigDecimal.valueOf(12.2);
    private static final BigDecimal ROAD_WIDTH_EIGHTEEN_POINTTHREE = BigDecimal.valueOf(18.3);
    private static final BigDecimal ROAD_WIDTH_TWENTYFOUR_POINTFOUR = BigDecimal.valueOf(24.4);
    private static final BigDecimal ROAD_WIDTH_TWENTYSEVEN_POINTFOUR = BigDecimal.valueOf(27.4);
    private static final BigDecimal ROAD_WIDTH_THIRTY_POINTFIVE = BigDecimal.valueOf(30.5);
    public static final String OLD = "OLD";
    public static final String NEW = "NEW";
    public static final String OLD_AREA_ERROR = "road width old area";
    public static final String NEW_AREA_ERROR = "road width new area";
    public static final String OLD_AREA_ERROR_MSG = "No construction shall be permitted if the road width is less than 2.4m for old area.";
    public static final String NEW_AREA_ERROR_MSG = "No construction shall be permitted if the road width is less than 6.1m for new area.";

    @Override
    public Plan validate(Plan pl) {
        if (pl.getPlot() == null || pl.getPlot() != null && (pl.getPlot().getArea() == null || pl.getPlot().getArea().doubleValue() == 0.0)) {
            pl.addError("Plot Area ", this.getLocaleMessage("msg.error.not.defined", "Plot Area "));
        }
        return pl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Plan process(Plan pl) {
        BigDecimal plotArea;
        OccupancyTypeHelper mostRestrictiveOccupancy;
        this.decideNocIsRequired(pl);
        HashMap<String, String> errorMsgs = new HashMap<String, String>();
        int errors = pl.getErrors().size();
        this.validate(pl);
        int validatedErrors = pl.getErrors().size();
        if (validatedErrors > errors) {
            return pl;
        }
        BigDecimal totalExistingBuiltUpArea = BigDecimal.ZERO;
        BigDecimal totalExistingFloorArea = BigDecimal.ZERO;
        BigDecimal totalBuiltUpArea = BigDecimal.ZERO;
        BigDecimal totalFloorArea = BigDecimal.ZERO;
        BigDecimal totalCarpetArea = BigDecimal.ZERO;
        BigDecimal totalExistingCarpetArea = BigDecimal.ZERO;
        HashSet<OccupancyTypeHelper> distinctOccupancyTypesHelper = new HashSet<OccupancyTypeHelper>();
        for (Object blk : pl.getBlocks()) {
            Object occupancy;
            void var16_19;
            void var17_34;
            Object occupancy322;
            Object flr22;
            BigDecimal flrArea = BigDecimal.ZERO;
            BigDecimal bltUpArea = BigDecimal.ZERO;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            BigDecimal bigDecimal2 = BigDecimal.ZERO;
            Object carpetArea = BigDecimal.ZERO;
            BigDecimal existingCarpetArea = BigDecimal.ZERO;
            Building building = blk.getBuilding();
            for (Object flr22 : building.getFloors()) {
                for (Object occupancy322 : flr22.getOccupancies()) {
                    this.validate2(pl, (Block)blk, (Floor)flr22, (Occupancy)occupancy322);
                    bltUpArea = bltUpArea.add(occupancy322.getBuiltUpArea() == null ? BigDecimal.valueOf(0L) : occupancy322.getBuiltUpArea());
                    BigDecimal bigDecimal3 = var17_34.add(occupancy322.getExistingBuiltUpArea() == null ? BigDecimal.valueOf(0L) : occupancy322.getExistingBuiltUpArea());
                    flrArea = flrArea.add(occupancy322.getFloorArea());
                    BigDecimal bigDecimal4 = var16_19.add(occupancy322.getExistingFloorArea());
                    carpetArea = ((BigDecimal)carpetArea).add(occupancy322.getCarpetArea());
                    existingCarpetArea = existingCarpetArea.add(occupancy322.getExistingCarpetArea());
                }
            }
            building.setTotalFloorArea(flrArea);
            building.setTotalBuitUpArea(bltUpArea);
            building.setTotalExistingBuiltUpArea((BigDecimal)var17_34);
            building.setTotalExistingFloorArea((BigDecimal)var16_19);
            if (var17_34.compareTo(bltUpArea) == 0) {
                blk.setCompletelyExisting(Boolean.TRUE);
            }
            totalFloorArea = totalFloorArea.add(flrArea);
            totalBuiltUpArea = totalBuiltUpArea.add(bltUpArea);
            totalExistingBuiltUpArea = totalExistingBuiltUpArea.add((BigDecimal)var17_34);
            totalExistingFloorArea = totalExistingFloorArea.add((BigDecimal)var16_19);
            totalCarpetArea = totalCarpetArea.add((BigDecimal)carpetArea);
            totalExistingCarpetArea = totalExistingCarpetArea.add(existingCarpetArea);
            HashSet<OccupancyTypeHelper> occupancyByBlock = new HashSet<OccupancyTypeHelper>();
            flr22 = building.getFloors().iterator();
            while (flr22.hasNext()) {
                Floor flr3 = (Floor)flr22.next();
                for (Occupancy occupancy4 : flr3.getOccupancies()) {
                    if (occupancy4.getTypeHelper() == null) continue;
                    occupancyByBlock.add(occupancy4.getTypeHelper());
                }
            }
            ArrayList<Object> listOfMapOfAllDtls = new ArrayList<Object>();
            ArrayList<OccupancyTypeHelper> listOfOccupancyTypes = new ArrayList<OccupancyTypeHelper>();
            occupancy322 = occupancyByBlock.iterator();
            while (occupancy322.hasNext()) {
                OccupancyTypeHelper occupancyType = (OccupancyTypeHelper)occupancy322.next();
                HashMap allDtlsMap = new HashMap();
                BigDecimal blockWiseFloorArea = BigDecimal.ZERO;
                BigDecimal blockWiseBuiltupArea = BigDecimal.ZERO;
                BigDecimal blockWiseExistingFloorArea = BigDecimal.ZERO;
                BigDecimal blockWiseExistingBuiltupArea = BigDecimal.ZERO;
                for (Floor flr4 : blk.getBuilding().getFloors()) {
                    for (Occupancy occupancy2 : flr4.getOccupancies()) {
                        if (occupancyType.getType() == null || occupancyType.getType().getCode() == null || occupancy2.getTypeHelper() == null || occupancy2.getTypeHelper().getType() == null || occupancy2.getTypeHelper().getType().getCode() == null || !occupancy2.getTypeHelper().getType().getCode().equals(occupancyType.getType().getCode())) continue;
                        blockWiseFloorArea = blockWiseFloorArea.add(occupancy2.getFloorArea());
                        blockWiseBuiltupArea = blockWiseBuiltupArea.add(occupancy2.getBuiltUpArea() == null ? BigDecimal.valueOf(0L) : occupancy2.getBuiltUpArea());
                        blockWiseExistingFloorArea = blockWiseExistingFloorArea.add(occupancy2.getExistingFloorArea());
                        blockWiseExistingBuiltupArea = blockWiseExistingBuiltupArea.add(occupancy2.getExistingBuiltUpArea() == null ? BigDecimal.valueOf(0L) : occupancy2.getExistingBuiltUpArea());
                    }
                }
                Occupancy occupancy2 = new Occupancy();
                occupancy2.setBuiltUpArea(blockWiseBuiltupArea);
                occupancy2.setFloorArea(blockWiseFloorArea);
                occupancy2.setExistingFloorArea(blockWiseExistingFloorArea);
                occupancy2.setExistingBuiltUpArea(blockWiseExistingBuiltupArea);
                occupancy2.setCarpetArea(blockWiseFloorArea.multiply(BigDecimal.valueOf(0.8)));
                occupancy2.setTypeHelper(occupancyType);
                building.getTotalArea().add(occupancy2);
                allDtlsMap.put("occupancy", occupancyType);
                allDtlsMap.put("totalFloorArea", blockWiseFloorArea);
                allDtlsMap.put("totalBuiltUpArea", blockWiseBuiltupArea);
                allDtlsMap.put("existingFloorArea", blockWiseExistingFloorArea);
                allDtlsMap.put("existingBuiltUpArea", blockWiseExistingBuiltupArea);
                listOfOccupancyTypes.add(occupancyType);
                listOfMapOfAllDtls.add(allDtlsMap);
            }
            HashSet setOfOccupancyTypes = new HashSet(listOfOccupancyTypes);
            ArrayList listOfOccupanciesOfAParticularblock = new ArrayList();
            for (OccupancyTypeHelper occupancyType : setOfOccupancyTypes) {
                if (occupancyType == null) continue;
                occupancy = new Occupancy();
                BigDecimal totalFlrArea = BigDecimal.ZERO;
                BigDecimal totalBltUpArea = BigDecimal.ZERO;
                BigDecimal totalExistingFlrArea = BigDecimal.ZERO;
                BigDecimal totalExistingBltUpArea = BigDecimal.ZERO;
                for (Map map : listOfMapOfAllDtls) {
                    if (!occupancyType.equals(map.get("occupancy"))) continue;
                    totalFlrArea = totalFlrArea.add((BigDecimal)map.get("totalFloorArea"));
                    totalBltUpArea = totalBltUpArea.add((BigDecimal)map.get("totalBuiltUpArea"));
                    totalExistingBltUpArea = totalExistingBltUpArea.add((BigDecimal)map.get("existingBuiltUpArea"));
                    totalExistingFlrArea = totalExistingFlrArea.add((BigDecimal)map.get("existingFloorArea"));
                }
                occupancy.setTypeHelper(occupancyType);
                occupancy.setBuiltUpArea(totalBltUpArea);
                occupancy.setFloorArea(totalFlrArea);
                occupancy.setExistingBuiltUpArea(totalExistingBltUpArea);
                occupancy.setExistingFloorArea(totalExistingFlrArea);
                occupancy.setExistingCarpetArea(totalExistingFlrArea.multiply(BigDecimal.valueOf(0.8)));
                occupancy.setCarpetArea(totalFlrArea.multiply(BigDecimal.valueOf(0.8)));
                listOfOccupanciesOfAParticularblock.add(occupancy);
            }
            blk.getBuilding().setOccupancies((List)listOfOccupanciesOfAParticularblock);
            if (!listOfOccupanciesOfAParticularblock.isEmpty()) {
                Occupancy occupancy3;
                boolean singleFamilyBuildingTypeOccupancyPresent = false;
                boolean otherThanSingleFamilyOccupancyTypePresent = false;
                occupancy = listOfOccupanciesOfAParticularblock.iterator();
                while (occupancy.hasNext()) {
                    Occupancy occupancy6 = (Occupancy)occupancy.next();
                    if (occupancy6.getTypeHelper().getSubtype() != null && "A-R".equals(occupancy6.getTypeHelper().getSubtype().getCode())) {
                        singleFamilyBuildingTypeOccupancyPresent = true;
                        continue;
                    }
                    otherThanSingleFamilyOccupancyTypePresent = true;
                    break;
                }
                blk.setSingleFamilyBuilding(Boolean.valueOf(!otherThanSingleFamilyOccupancyTypePresent && singleFamilyBuildingTypeOccupancyPresent));
                boolean allResidentialOccTypes = false;
                boolean allResidentialOrCommercialOccTypes = false;
                Iterator iterator = listOfOccupanciesOfAParticularblock.iterator();
                while (iterator.hasNext()) {
                    occupancy3 = (Occupancy)iterator.next();
                    if (occupancy3.getTypeHelper() == null || occupancy3.getTypeHelper().getType() == null) continue;
                    boolean residentialOccupancyType = false;
                    if ("A".equals(occupancy3.getTypeHelper().getType().getCode())) {
                        residentialOccupancyType = true;
                    }
                    if (!residentialOccupancyType) {
                        allResidentialOccTypes = false;
                        break;
                    }
                    allResidentialOccTypes = true;
                }
                blk.setResidentialBuilding(Boolean.valueOf(allResidentialOccTypes));
                iterator = listOfOccupanciesOfAParticularblock.iterator();
                while (iterator.hasNext()) {
                    occupancy3 = (Occupancy)iterator.next();
                    if (occupancy3.getTypeHelper() == null || occupancy3.getTypeHelper().getType() == null) continue;
                    boolean residentialOrCommercialOccupancyType = false;
                    if ("A".equals(occupancy3.getTypeHelper().getType().getCode()) || "F".equals(occupancy3.getTypeHelper().getType().getCode())) {
                        residentialOrCommercialOccupancyType = true;
                    }
                    if (!residentialOrCommercialOccupancyType) {
                        allResidentialOrCommercialOccTypes = false;
                        break;
                    }
                    allResidentialOrCommercialOccTypes = true;
                }
                blk.setResidentialOrCommercialBuilding(Boolean.valueOf(allResidentialOrCommercialOccTypes));
            }
            if (blk.getBuilding().getFloors() == null || blk.getBuilding().getFloors().isEmpty()) continue;
            BigDecimal noOfFloorsAboveGround = BigDecimal.ZERO;
            for (Floor floor2 : blk.getBuilding().getFloors()) {
                if (floor2.getNumber() == null || floor2.getNumber() < 0) continue;
                noOfFloorsAboveGround = noOfFloorsAboveGround.add(BigDecimal.valueOf(1L));
            }
            boolean hasTerrace = blk.getBuilding().getFloors().stream().anyMatch(floor -> floor.getTerrace().equals(Boolean.TRUE));
            noOfFloorsAboveGround = hasTerrace ? noOfFloorsAboveGround.subtract(BigDecimal.ONE) : noOfFloorsAboveGround;
            blk.getBuilding().setMaxFloor(noOfFloorsAboveGround);
            blk.getBuilding().setFloorsAboveGround(noOfFloorsAboveGround);
            blk.getBuilding().setTotalFloors(BigDecimal.valueOf(blk.getBuilding().getFloors().size()));
        }
        for (Object blk : pl.getBlocks()) {
            Building building = blk.getBuilding();
            Iterator<OccupancyTypeHelper> blockWiseOccupancyTypes = new ArrayList();
            for (Occupancy occupancy : blk.getBuilding().getOccupancies()) {
                if (occupancy.getTypeHelper() == null) continue;
                blockWiseOccupancyTypes.add(occupancy.getTypeHelper());
            }
            HashSet<OccupancyTypeHelper> hashSet = new HashSet<OccupancyTypeHelper>((Collection<OccupancyTypeHelper>)((Object)blockWiseOccupancyTypes));
            OccupancyTypeHelper occupancyTypeHelper = this.getMostRestrictiveFar(hashSet);
            blk.getBuilding().setMostRestrictiveFarHelper(occupancyTypeHelper);
            for (Floor flr : building.getFloors()) {
                BigDecimal flrArea = BigDecimal.ZERO;
                BigDecimal existingFlrArea = BigDecimal.ZERO;
                BigDecimal carpetArea = BigDecimal.ZERO;
                BigDecimal existingCarpetArea = BigDecimal.ZERO;
                BigDecimal existingBltUpArea = BigDecimal.ZERO;
                for (Occupancy occupancy : flr.getOccupancies()) {
                    flrArea = flrArea.add(occupancy.getFloorArea());
                    existingFlrArea = existingFlrArea.add(occupancy.getExistingFloorArea());
                    carpetArea = carpetArea.add(occupancy.getCarpetArea());
                    existingCarpetArea = existingCarpetArea.add(occupancy.getExistingCarpetArea());
                }
                List occupancies = flr.getOccupancies();
                for (Occupancy occupancy : occupancies) {
                    existingBltUpArea = existingBltUpArea.add(occupancy.getExistingBuiltUpArea() != null ? occupancy.getExistingBuiltUpArea() : BigDecimal.ZERO);
                }
                if (occupancyTypeHelper != null && occupancyTypeHelper.getConvertedSubtype() != null && !"A-R".equals(occupancyTypeHelper.getSubtype().getCode())) {
                    if (carpetArea.compareTo(BigDecimal.ZERO) == 0) {
                        pl.addError("Carpet area in block " + blk.getNumber() + "floor " + flr.getNumber(), "Carpet area is not defined in block " + blk.getNumber() + "floor " + flr.getNumber());
                    }
                    if (existingBltUpArea.compareTo(BigDecimal.ZERO) > 0 && existingCarpetArea.compareTo(BigDecimal.ZERO) == 0) {
                        pl.addError("Existing Carpet area in block " + blk.getNumber() + "floor " + flr.getNumber(), "Existing Carpet area is not defined in block " + blk.getNumber() + "floor " + flr.getNumber());
                    }
                }
                if (flrArea.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS).compareTo(carpetArea.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS)) < 0) {
                    pl.addError("Floor area in block " + blk.getNumber() + "floor " + flr.getNumber(), "Floor area is less than carpet area in block " + blk.getNumber() + "floor " + flr.getNumber());
                }
                if (existingBltUpArea.compareTo(BigDecimal.ZERO) <= 0 || existingFlrArea.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS).compareTo(existingCarpetArea.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS)) >= 0) continue;
                pl.addError("Existing floor area in block " + blk.getNumber() + "floor " + flr.getNumber(), "Existing Floor area is less than carpet area in block " + blk.getNumber() + "floor " + flr.getNumber());
            }
        }
        ArrayList<OccupancyTypeHelper> plotWiseOccupancyTypes = new ArrayList<OccupancyTypeHelper>();
        for (Block block : pl.getBlocks()) {
            for (Occupancy occupancy : block.getBuilding().getOccupancies()) {
                if (occupancy.getTypeHelper() == null) continue;
                plotWiseOccupancyTypes.add(occupancy.getTypeHelper());
            }
        }
        HashSet<OccupancyTypeHelper> setOfDistinctOccupancyTypes = new HashSet<OccupancyTypeHelper>(plotWiseOccupancyTypes);
        distinctOccupancyTypesHelper.addAll(setOfDistinctOccupancyTypes);
        ArrayList<Occupancy> occupanciesForPlan = new ArrayList<Occupancy>();
        for (OccupancyTypeHelper occupancyTypeHelper : setOfDistinctOccupancyTypes) {
            void var17_43;
            if (occupancyTypeHelper == null) continue;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            BigDecimal totalBuiltUpAreaForAllBlks = BigDecimal.ZERO;
            BigDecimal totalCarpetAreaForAllBlks = BigDecimal.ZERO;
            Object totalExistBuiltUpAreaForAllBlks = BigDecimal.ZERO;
            BigDecimal totalExistFloorAreaForAllBlks = BigDecimal.ZERO;
            BigDecimal totalExistCarpetAreaForAllBlks = BigDecimal.ZERO;
            Occupancy occupancy = new Occupancy();
            for (Block block : pl.getBlocks()) {
                for (Occupancy buildingOccupancy : block.getBuilding().getOccupancies()) {
                    if (!occupancyTypeHelper.equals((Object)buildingOccupancy.getTypeHelper())) continue;
                    BigDecimal bigDecimal5 = var17_43.add(buildingOccupancy.getFloorArea());
                    totalBuiltUpAreaForAllBlks = totalBuiltUpAreaForAllBlks.add(buildingOccupancy.getBuiltUpArea());
                    totalCarpetAreaForAllBlks = totalCarpetAreaForAllBlks.add(buildingOccupancy.getCarpetArea());
                    totalExistBuiltUpAreaForAllBlks = ((BigDecimal)totalExistBuiltUpAreaForAllBlks).add(buildingOccupancy.getExistingBuiltUpArea());
                    totalExistFloorAreaForAllBlks = totalExistFloorAreaForAllBlks.add(buildingOccupancy.getExistingFloorArea());
                    totalExistCarpetAreaForAllBlks = totalExistCarpetAreaForAllBlks.add(buildingOccupancy.getExistingCarpetArea());
                }
            }
            occupancy.setTypeHelper(occupancyTypeHelper);
            occupancy.setBuiltUpArea(totalBuiltUpAreaForAllBlks);
            occupancy.setCarpetArea(totalCarpetAreaForAllBlks);
            occupancy.setFloorArea((BigDecimal)var17_43);
            occupancy.setExistingBuiltUpArea((BigDecimal)totalExistBuiltUpAreaForAllBlks);
            occupancy.setExistingFloorArea(totalExistFloorAreaForAllBlks);
            occupancy.setExistingCarpetArea(totalExistCarpetAreaForAllBlks);
            occupanciesForPlan.add(occupancy);
        }
        pl.setOccupancies(occupanciesForPlan);
        pl.getVirtualBuilding().setTotalFloorArea(totalFloorArea);
        pl.getVirtualBuilding().setTotalCarpetArea(totalCarpetArea);
        pl.getVirtualBuilding().setTotalExistingBuiltUpArea(totalExistingBuiltUpArea);
        pl.getVirtualBuilding().setTotalExistingFloorArea(totalExistingFloorArea);
        pl.getVirtualBuilding().setTotalExistingCarpetArea(totalExistingCarpetArea);
        pl.getVirtualBuilding().setOccupancyTypes(distinctOccupancyTypesHelper);
        pl.getVirtualBuilding().setTotalBuitUpArea(totalBuiltUpArea);
        pl.getVirtualBuilding().setMostRestrictiveFarHelper(this.getMostRestrictiveFar(setOfDistinctOccupancyTypes));
        if (!distinctOccupancyTypesHelper.isEmpty()) {
            boolean bl;
            boolean allResidentialOccTypesForPlan = false;
            for (OccupancyTypeHelper occupancyTypeHelper : distinctOccupancyTypesHelper) {
                LOG.info((Object)("occupancy :" + occupancyTypeHelper));
                boolean residentialOccupancyType = false;
                if (occupancyTypeHelper.getType() != null && "A".equals(occupancyTypeHelper.getType().getCode())) {
                    residentialOccupancyType = true;
                }
                if (!residentialOccupancyType) {
                    allResidentialOccTypesForPlan = false;
                    break;
                }
                allResidentialOccTypesForPlan = true;
            }
            pl.getVirtualBuilding().setResidentialBuilding(Boolean.valueOf(allResidentialOccTypesForPlan));
            boolean bl2 = false;
            for (OccupancyTypeHelper occupancyType : distinctOccupancyTypesHelper) {
                boolean residentialOrCommercialOccupancyTypeForPlan = false;
                if (occupancyType.getType() != null && ("A".equals(occupancyType.getType().getCode()) || "F".equals(occupancyType.getType().getCode()))) {
                    residentialOrCommercialOccupancyTypeForPlan = true;
                }
                if (!residentialOrCommercialOccupancyTypeForPlan) {
                    bl = false;
                    break;
                }
                boolean bl3 = true;
            }
            pl.getVirtualBuilding().setResidentialOrCommercialBuilding(Boolean.valueOf(bl));
        }
        OccupancyTypeHelper occupancyTypeHelper = mostRestrictiveOccupancy = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
        if (!(pl.getVirtualBuilding().getResidentialOrCommercialBuilding().booleanValue() || mostRestrictiveOccupancy != null && mostRestrictiveOccupancy.getType() != null && "G".equalsIgnoreCase(mostRestrictiveOccupancy.getType().getCode()))) {
            pl.getErrors().put("occupancy_allowed", "Only residential or commerical or industrial buildings will be scrutinized for now.");
            return pl;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (OccupancyTypeHelper oth : pl.getVirtualBuilding().getOccupancyTypes()) {
            if (oth.getSubtype() == null) continue;
            hashSet.add(oth.getSubtype().getCode());
        }
        if (hashSet.size() == 1 && hashSet.contains("A-PO")) {
            pl.getErrors().put("occupancy_po_not_allowed", "Plans with only professional office occupancy is not allowed");
            return pl;
        }
        OccupancyTypeHelper occupancyTypeHelper2 = pl.getVirtualBuilding().getMostRestrictiveFarHelper();
        BigDecimal providedFar = BigDecimal.ZERO;
        BigDecimal surrenderRoadArea = BigDecimal.ZERO;
        if (!pl.getSurrenderRoads().isEmpty()) {
            for (Measurement measurement : pl.getSurrenderRoads()) {
                surrenderRoadArea = surrenderRoadArea.add(measurement.getArea());
            }
        }
        pl.setTotalSurrenderRoadArea(surrenderRoadArea.setScale(2, DcrConstants.ROUNDMODE_MEASUREMENTS));
        BigDecimal bigDecimal = plotArea = pl.getPlot() != null ? pl.getPlot().getArea().add(surrenderRoadArea) : BigDecimal.ZERO;
        if (plotArea.doubleValue() > 0.0) {
            providedFar = pl.getVirtualBuilding().getTotalFloorArea().divide(plotArea, 2, DcrConstants.ROUNDMODE_MEASUREMENTS);
        }
        pl.setFarDetails(new FarDetails());
        pl.getFarDetails().setProvidedFar(Double.valueOf(providedFar.doubleValue()));
        String typeOfArea = pl.getPlanInformation().getTypeOfArea();
        BigDecimal roadWidth = pl.getPlanInformation().getRoadWidth();
        if (occupancyTypeHelper2 != null && StringUtils.isNotBlank((String)typeOfArea) && roadWidth != null && !this.processFarForSpecialOccupancy(pl, occupancyTypeHelper2, providedFar, typeOfArea, roadWidth, errorMsgs).booleanValue()) {
            if (occupancyTypeHelper2.getType() != null && "A".equalsIgnoreCase(occupancyTypeHelper2.getType().getCode()) || occupancyTypeHelper2.getSubtype() != null && ("A-R".equalsIgnoreCase(occupancyTypeHelper2.getSubtype().getCode()) || "A-AF".equalsIgnoreCase(occupancyTypeHelper2.getSubtype().getCode()))) {
                this.processFarResidential(pl, occupancyTypeHelper2, providedFar, typeOfArea, roadWidth, errorMsgs);
            }
            if (occupancyTypeHelper2.getType() != null && ("G".equalsIgnoreCase(occupancyTypeHelper2.getType().getCode()) || "B".equalsIgnoreCase(occupancyTypeHelper2.getType().getCode()) || "D".equalsIgnoreCase(occupancyTypeHelper2.getType().getCode()))) {
                this.processFarForGBDOccupancy(pl, occupancyTypeHelper2, providedFar, typeOfArea, roadWidth, errorMsgs);
            }
            if (occupancyTypeHelper2.getType() != null && "I".equalsIgnoreCase(occupancyTypeHelper2.getType().getCode())) {
                this.processFarHaazardous(pl, occupancyTypeHelper2, providedFar, typeOfArea, roadWidth, errorMsgs);
            }
            if (occupancyTypeHelper2.getType() != null && "F".equalsIgnoreCase(occupancyTypeHelper2.getType().getCode())) {
                this.processFarNonResidential(pl, occupancyTypeHelper2, providedFar, typeOfArea, roadWidth, errorMsgs);
            }
        }
        ProcessPrintHelper.print(pl);
        return pl;
    }

    private void decideNocIsRequired(Plan pl) {
        Boolean isHighRise = false;
        for (Block b : pl.getBlocks()) {
            if ((b.getBuilding() == null || b.getBuilding().getBuildingHeight().compareTo(new BigDecimal(5)) <= 0) && (b.getBuilding() == null || b.getBuilding().getCoverageArea() == null || b.getBuilding().getCoverageArea().compareTo(new BigDecimal(500)) <= 0)) continue;
            isHighRise = true;
        }
        if (isHighRise.booleanValue()) {
            pl.getPlanInformation().setNocFireDept("YES");
        }
        if (StringUtils.isNotBlank((String)pl.getPlanInformation().getBuildingNearMonument()) && "YES".equalsIgnoreCase(pl.getPlanInformation().getBuildingNearMonument())) {
            BigDecimal minDistanceFromMonument = BigDecimal.ZERO;
            List distancesFromMonument = pl.getDistanceToExternalEntity().getMonuments();
            if (!distancesFromMonument.isEmpty() && (minDistanceFromMonument = (BigDecimal)distancesFromMonument.stream().reduce(BigDecimal::min).get()).compareTo(BigDecimal.valueOf(300L)) > 0) {
                pl.getPlanInformation().setNocNearMonument("YES");
            }
        }
    }

    private void validate2(Plan pl, Block blk, Floor flr, Occupancy occupancy) {
        String occupancyTypeHelper = "";
        if (occupancy.getTypeHelper() != null) {
            if (occupancy.getTypeHelper().getType() != null) {
                occupancyTypeHelper = occupancy.getTypeHelper().getType().getName();
            } else if (occupancy.getTypeHelper().getSubtype() != null) {
                occupancyTypeHelper = occupancy.getTypeHelper().getSubtype().getName();
            }
        }
        if (occupancy.getBuiltUpArea() != null && occupancy.getBuiltUpArea().compareTo(BigDecimal.valueOf(0L)) < 0) {
            pl.addError(VALIDATION_NEGATIVE_BUILTUP_AREA, this.getLocaleMessage(VALIDATION_NEGATIVE_BUILTUP_AREA, blk.getNumber(), flr.getNumber().toString(), occupancyTypeHelper));
        }
        if (occupancy.getExistingBuiltUpArea() != null && occupancy.getExistingBuiltUpArea().compareTo(BigDecimal.valueOf(0L)) < 0) {
            pl.addError(VALIDATION_NEGATIVE_EXISTING_BUILTUP_AREA, this.getLocaleMessage(VALIDATION_NEGATIVE_EXISTING_BUILTUP_AREA, blk.getNumber(), flr.getNumber().toString(), occupancyTypeHelper));
        }
        occupancy.setFloorArea((occupancy.getBuiltUpArea() == null ? BigDecimal.ZERO : occupancy.getBuiltUpArea()).subtract(occupancy.getDeduction() == null ? BigDecimal.ZERO : occupancy.getDeduction()));
        if (occupancy.getFloorArea() != null && occupancy.getFloorArea().compareTo(BigDecimal.valueOf(0L)) < 0) {
            pl.addError(VALIDATION_NEGATIVE_FLOOR_AREA, this.getLocaleMessage(VALIDATION_NEGATIVE_FLOOR_AREA, blk.getNumber(), flr.getNumber().toString(), occupancyTypeHelper));
        }
        occupancy.setExistingFloorArea((occupancy.getExistingBuiltUpArea() == null ? BigDecimal.ZERO : occupancy.getExistingBuiltUpArea()).subtract(occupancy.getExistingDeduction() == null ? BigDecimal.ZERO : occupancy.getExistingDeduction()));
        if (occupancy.getExistingFloorArea() != null && occupancy.getExistingFloorArea().compareTo(BigDecimal.valueOf(0L)) < 0) {
            pl.addError(VALIDATION_NEGATIVE_EXISTING_FLOOR_AREA, this.getLocaleMessage(VALIDATION_NEGATIVE_EXISTING_FLOOR_AREA, blk.getNumber(), flr.getNumber().toString(), occupancyTypeHelper));
        }
    }

    protected OccupancyTypeHelper getMostRestrictiveFar(Set<OccupancyTypeHelper> distinctOccupancyTypes) {
        Set<Object> codes = new HashSet();
        HashMap<String, OccupancyTypeHelper> codesMap = new HashMap<String, OccupancyTypeHelper>();
        for (OccupancyTypeHelper typeHelper : distinctOccupancyTypes) {
            if (typeHelper.getType() != null) {
                codesMap.put(typeHelper.getType().getCode(), typeHelper);
            }
            if (typeHelper.getSubtype() == null) continue;
            codesMap.put(typeHelper.getSubtype().getCode(), typeHelper);
        }
        codes = codesMap.keySet();
        if (codes.contains("S-ECFG")) {
            return (OccupancyTypeHelper)codesMap.get("S-ECFG");
        }
        if (codes.contains("A-FH")) {
            return (OccupancyTypeHelper)codesMap.get("A-FH");
        }
        if (codes.contains("S-SAS")) {
            return (OccupancyTypeHelper)codesMap.get("S-SAS");
        }
        if (codes.contains("D-B")) {
            return (OccupancyTypeHelper)codesMap.get("D-B");
        }
        if (codes.contains("D-C")) {
            return (OccupancyTypeHelper)codesMap.get("D-C");
        }
        if (codes.contains("D-A")) {
            return (OccupancyTypeHelper)codesMap.get("D-A");
        }
        if (codes.contains("H-PP")) {
            return (OccupancyTypeHelper)codesMap.get("H-PP");
        }
        if (codes.contains("E-NS")) {
            return (OccupancyTypeHelper)codesMap.get("E-NS");
        }
        if (codes.contains("M-DFPAB")) {
            return (OccupancyTypeHelper)codesMap.get("M-DFPAB");
        }
        if (codes.contains("E-PS")) {
            return (OccupancyTypeHelper)codesMap.get("E-PS");
        }
        if (codes.contains("E-SFMC")) {
            return (OccupancyTypeHelper)codesMap.get("E-SFMC");
        }
        if (codes.contains("E-SFDAP")) {
            return (OccupancyTypeHelper)codesMap.get("E-SFDAP");
        }
        if (codes.contains("E-EARC")) {
            return (OccupancyTypeHelper)codesMap.get("E-EARC");
        }
        if (codes.contains("S-MCH")) {
            return (OccupancyTypeHelper)codesMap.get("S-MCH");
        }
        if (codes.contains("S-BH")) {
            return (OccupancyTypeHelper)codesMap.get("S-BH");
        }
        if (codes.contains("S-CRC")) {
            return (OccupancyTypeHelper)codesMap.get("S-CRC");
        }
        if (codes.contains("S-CA")) {
            return (OccupancyTypeHelper)codesMap.get("S-CA");
        }
        if (codes.contains("S-SC")) {
            return (OccupancyTypeHelper)codesMap.get("S-SC");
        }
        if (codes.contains("S-ICC")) {
            return (OccupancyTypeHelper)codesMap.get("S-ICC");
        }
        if (codes.contains("A2")) {
            return (OccupancyTypeHelper)codesMap.get("A2");
        }
        if (codes.contains("E-CLG")) {
            return (OccupancyTypeHelper)codesMap.get("E-CLG");
        }
        if (codes.contains("M-OHF")) {
            return (OccupancyTypeHelper)codesMap.get("M-OHF");
        }
        if (codes.contains("M-VH")) {
            return (OccupancyTypeHelper)codesMap.get("M-VH");
        }
        if (codes.contains("M-NAPI")) {
            return (OccupancyTypeHelper)codesMap.get("M-NAPI");
        }
        if (codes.contains("A-SA")) {
            return (OccupancyTypeHelper)codesMap.get("A-SA");
        }
        if (codes.contains("M-HOTHC")) {
            return (OccupancyTypeHelper)codesMap.get("M-HOTHC");
        }
        if (codes.contains("E-SACA")) {
            return (OccupancyTypeHelper)codesMap.get("E-SACA");
        }
        if (codes.contains("G")) {
            return (OccupancyTypeHelper)codesMap.get("G");
        }
        if (codes.contains("F")) {
            return (OccupancyTypeHelper)codesMap.get("F");
        }
        if (codes.contains("A")) {
            return (OccupancyTypeHelper)codesMap.get("A");
        }
        return null;
    }

    private Boolean processFarForSpecialOccupancy(Plan pl, OccupancyTypeHelper occupancyType, BigDecimal far, String typeOfArea, BigDecimal roadWidth, HashMap<String, String> errors) {
        String occupancyName;
        OccupancyTypeHelper mostRestrictiveOccupancyType = pl.getVirtualBuilding() != null ? pl.getVirtualBuilding().getMostRestrictiveFarHelper() : null;
        String expectedResult = "";
        boolean isAccepted = false;
        if (mostRestrictiveOccupancyType != null && mostRestrictiveOccupancyType.getSubtype() != null) {
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("S-ECFG") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("A-FH")) {
                isAccepted = far.compareTo(POINTTWO) <= 0;
                expectedResult = "<= 0.2";
                return true;
            }
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("S-SAS")) {
                isAccepted = far.compareTo(POINTFOUR) <= 0;
                expectedResult = "<= 0.4";
                return true;
            }
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("D-B")) {
                isAccepted = far.compareTo(POINTFIVE) <= 0;
                expectedResult = "<= 0.5";
                return true;
            }
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("D-C")) {
                isAccepted = far.compareTo(POINTSIX) <= 0;
                expectedResult = "<= 0.6";
                return true;
            }
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("D-A")) {
                isAccepted = far.compareTo(POINTSEVEN) <= 0;
                expectedResult = "<= 0.7";
                return true;
            }
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("H-PP") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("E-NS") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("M-DFPAB")) {
                isAccepted = far.compareTo(ONE) <= 0;
                expectedResult = "<= 1";
                return true;
            }
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("E-PS") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("E-SFMC") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("E-SFDAP") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("E-EARC") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("S-MCH") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("S-BH") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("S-CRC") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("S-CA") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("S-SC") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("S-ICC") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("A2")) {
                isAccepted = far.compareTo(ONE_POINTTWO) <= 0;
                expectedResult = "<= 1.2";
                return true;
            }
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("B2") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("E-CLG") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("M-OHF") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("M-VH") || mostRestrictiveOccupancyType.getSubtype().getCode().equals("M-NAPI")) {
                isAccepted = far.compareTo(ONE_POINTFIVE) <= 0;
                expectedResult = "<= 1.5";
                return true;
            }
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("A-SA")) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                expectedResult = "<= 2.5";
                return true;
            }
            if (mostRestrictiveOccupancyType.getSubtype().getCode().equals("E-SACA")) {
                isAccepted = far.compareTo(FIFTEEN) <= 0;
                expectedResult = "<= 15";
                return true;
            }
        }
        String string = occupancyName = occupancyType.getSubtype() != null ? occupancyType.getSubtype().getName() : occupancyType.getType().getName();
        if (StringUtils.isNotBlank((String)expectedResult)) {
            this.buildResult(pl, occupancyName, far, typeOfArea, roadWidth, expectedResult, isAccepted);
        }
        return false;
    }

    private void processFarResidential(Plan pl, OccupancyTypeHelper occupancyType, BigDecimal far, String typeOfArea, BigDecimal roadWidth, HashMap<String, String> errors) {
        String expectedResult = "";
        boolean isAccepted = false;
        if (typeOfArea.equalsIgnoreCase(OLD)) {
            if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOUR) < 0) {
                errors.put(OLD_AREA_ERROR, OLD_AREA_ERROR_MSG);
                pl.addErrors(errors);
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOURFOUR) >= 0 && roadWidth.compareTo(ROAD_WIDTH_THREE_POINTSIX) < 0) {
                isAccepted = far.compareTo(ONE_POINTTWO) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(ONE_POINTTWO.doubleValue()));
                expectedResult = "<= 1.2";
            } else if (roadWidth.compareTo(ROAD_WIDTH_THREE_POINTSIX) >= 0 && roadWidth.compareTo(ROAD_WIDTH_FOUR_POINTEIGHT) < 0) {
                isAccepted = far.compareTo(ONE_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(ONE_POINTFIVE.doubleValue()));
                expectedResult = "<= 1.5";
            } else if (roadWidth.compareTo(ROAD_WIDTH_FOUR_POINTEIGHT) >= 0 && roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                isAccepted = far.compareTo(ONE_POINTEIGHT) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(ONE_POINTEIGHT.doubleValue()));
                expectedResult = "<= 1.8";
            } else if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) < 0) {
                isAccepted = far.compareTo(TWO) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO.doubleValue()));
                expectedResult = "<= 2";
            } else if (roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO_POINTFIVE.doubleValue()));
                expectedResult = "<= 2.5";
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) >= 0 && roadWidth.compareTo(ROAD_WIDTH_EIGHTEEN_POINTTHREE) < 0) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO_POINTFIVE.doubleValue()));
                expectedResult = "<= 2.5";
            } else if (roadWidth.compareTo(ROAD_WIDTH_EIGHTEEN_POINTTHREE) >= 0) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO_POINTFIVE.doubleValue()));
                expectedResult = "<= 2.5";
            }
        }
        if (typeOfArea.equalsIgnoreCase(NEW)) {
            if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                errors.put(NEW_AREA_ERROR, NEW_AREA_ERROR_MSG);
                pl.addErrors(errors);
            } else if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) < 0) {
                isAccepted = far.compareTo(TWO) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO.doubleValue()));
                expectedResult = "<= 2";
            } else if (roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO_POINTFIVE.doubleValue()));
                expectedResult = "<= 2.5";
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) >= 0 && roadWidth.compareTo(ROAD_WIDTH_EIGHTEEN_POINTTHREE) < 0) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO_POINTFIVE.doubleValue()));
                expectedResult = "<= 2.5";
            } else if (roadWidth.compareTo(ROAD_WIDTH_EIGHTEEN_POINTTHREE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWENTYFOUR_POINTFOUR) < 0) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO_POINTFIVE.doubleValue()));
                expectedResult = "<= 2.5";
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWENTYFOUR_POINTFOUR) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWENTYSEVEN_POINTFOUR) < 0) {
                isAccepted = far.compareTo(THREE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(THREE.doubleValue()));
                expectedResult = "<= 3";
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWENTYSEVEN_POINTFOUR) >= 0 && roadWidth.compareTo(ROAD_WIDTH_THIRTY_POINTFIVE) < 0) {
                isAccepted = far.compareTo(THREE_POINTTWOFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(THREE_POINTTWOFIVE.doubleValue()));
                expectedResult = "<= 3.25";
            } else if (roadWidth.compareTo(ROAD_WIDTH_THIRTY_POINTFIVE) >= 0) {
                isAccepted = far.compareTo(THREE_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(THREE_POINTFIVE.doubleValue()));
                expectedResult = "<= 3.5";
            }
        }
        String occupancyName = occupancyType.getType().getName();
        if (errors.isEmpty() && StringUtils.isNotBlank((String)expectedResult)) {
            this.buildResult(pl, occupancyName, far, typeOfArea, roadWidth, expectedResult, isAccepted);
        }
    }

    private void processFarNonResidential(Plan pl, OccupancyTypeHelper occupancyType, BigDecimal far, String typeOfArea, BigDecimal roadWidth, HashMap<String, String> errors) {
        String expectedResult = "";
        boolean isAccepted = false;
        if (typeOfArea.equalsIgnoreCase(OLD)) {
            if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOUR) < 0) {
                errors.put(OLD_AREA_ERROR, OLD_AREA_ERROR_MSG);
                pl.addErrors(errors);
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOURFOUR) >= 0 && roadWidth.compareTo(ROAD_WIDTH_THREE_POINTSIX) < 0) {
                isAccepted = far.compareTo(ONE_POINTTWO) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO.doubleValue()));
                expectedResult = "<= 1.2";
            } else if (roadWidth.compareTo(ROAD_WIDTH_THREE_POINTSIX) >= 0 && roadWidth.compareTo(ROAD_WIDTH_FOUR_POINTEIGHT) < 0) {
                isAccepted = far.compareTo(BigDecimal.ZERO) >= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(BigDecimal.ZERO.doubleValue()));
                expectedResult = "0";
            } else if (roadWidth.compareTo(ROAD_WIDTH_FOUR_POINTEIGHT) >= 0 && roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                isAccepted = far.compareTo(BigDecimal.ZERO) >= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(BigDecimal.ZERO.doubleValue()));
                expectedResult = "0";
            } else if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) < 0) {
                isAccepted = far.compareTo(BigDecimal.ZERO) >= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(BigDecimal.ZERO.doubleValue()));
                expectedResult = "0";
            } else if (roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                isAccepted = far.compareTo(BigDecimal.ZERO) >= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(BigDecimal.ZERO.doubleValue()));
                expectedResult = "0";
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) >= 0 && roadWidth.compareTo(ROAD_WIDTH_EIGHTEEN_POINTTHREE) < 0) {
                isAccepted = far.compareTo(TWO) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO.doubleValue()));
                expectedResult = "<= 2";
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWENTYFOUR_POINTFOUR) >= 0) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO_POINTFIVE.doubleValue()));
                expectedResult = "<= 2.5";
            }
        }
        if (typeOfArea.equalsIgnoreCase(NEW)) {
            if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                errors.put(NEW_AREA_ERROR, NEW_AREA_ERROR_MSG);
                pl.addErrors(errors);
            } else if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) < 0) {
                isAccepted = far.compareTo(BigDecimal.ZERO) >= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(BigDecimal.ZERO.doubleValue()));
                expectedResult = "0";
            } else if (roadWidth.compareTo(ROAD_WIDTH_NINE_POINTONE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) < 0) {
                isAccepted = far.compareTo(BigDecimal.ZERO) >= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(BigDecimal.ZERO.doubleValue()));
                expectedResult = "0";
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) >= 0 && roadWidth.compareTo(ROAD_WIDTH_EIGHTEEN_POINTTHREE) < 0) {
                isAccepted = far.compareTo(TWO) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO.doubleValue()));
                expectedResult = "<= 2";
            } else if (roadWidth.compareTo(ROAD_WIDTH_EIGHTEEN_POINTTHREE) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWENTYFOUR_POINTFOUR) < 0) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO_POINTFIVE.doubleValue()));
                expectedResult = "<= 2.5";
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWENTYFOUR_POINTFOUR) >= 0 && roadWidth.compareTo(ROAD_WIDTH_TWENTYSEVEN_POINTFOUR) < 0) {
                isAccepted = far.compareTo(TWO_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(TWO_POINTFIVE.doubleValue()));
                expectedResult = "<= 2.5";
            } else if (roadWidth.compareTo(ROAD_WIDTH_TWENTYSEVEN_POINTFOUR) >= 0 && roadWidth.compareTo(ROAD_WIDTH_THIRTY_POINTFIVE) < 0) {
                isAccepted = far.compareTo(THREE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(THREE.doubleValue()));
                expectedResult = "<= 3";
            } else if (roadWidth.compareTo(ROAD_WIDTH_THIRTY_POINTFIVE) >= 0) {
                isAccepted = far.compareTo(THREE_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(THREE_POINTFIVE.doubleValue()));
                expectedResult = "<= 3";
            }
        }
        String occupancyName = occupancyType.getType().getName();
        if (errors.isEmpty() && StringUtils.isNotBlank((String)expectedResult)) {
            this.buildResult(pl, occupancyName, far, typeOfArea, roadWidth, expectedResult, isAccepted);
        }
    }

    private void processFarForGBDOccupancy(Plan pl, OccupancyTypeHelper occupancyType, BigDecimal far, String typeOfArea, BigDecimal roadWidth, HashMap<String, String> errors) {
        String expectedResult = "";
        boolean isAccepted = false;
        if (typeOfArea.equalsIgnoreCase(OLD)) {
            if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOUR) < 0) {
                errors.put(OLD_AREA_ERROR, OLD_AREA_ERROR_MSG);
                pl.addErrors(errors);
                return;
            }
            isAccepted = far.compareTo(ONE_POINTFIVE) <= 0;
            pl.getFarDetails().setPermissableFar(Double.valueOf(ONE_POINTFIVE.doubleValue()));
            expectedResult = "<=" + ONE_POINTFIVE;
        }
        if (typeOfArea.equalsIgnoreCase(NEW)) {
            if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                errors.put(NEW_AREA_ERROR, NEW_AREA_ERROR_MSG);
                pl.addErrors(errors);
                return;
            }
            isAccepted = far.compareTo(ONE_POINTFIVE) <= 0;
            pl.getFarDetails().setPermissableFar(Double.valueOf(ONE_POINTFIVE.doubleValue()));
            expectedResult = "<=" + ONE_POINTFIVE;
        }
        String occupancyName = occupancyType.getType().getName();
        if (occupancyType.getSubtype() != null) {
            OccupancyHelperDetail subtype = occupancyType.getSubtype();
            occupancyName = subtype.getName();
            String code = subtype.getCode();
            if ("G-PHI".equalsIgnoreCase(code)) {
                isAccepted = far.compareTo(POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(POINTFIVE.doubleValue()));
                expectedResult = "<=" + POINTFIVE;
            } else if ("G-NPHI".equalsIgnoreCase(code)) {
                isAccepted = far.compareTo(ONE_POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(ONE_POINTFIVE.doubleValue()));
                expectedResult = "<=" + ONE_POINTFIVE;
            }
        }
        if (errors.isEmpty() && StringUtils.isNotBlank((String)expectedResult)) {
            this.buildResult(pl, occupancyName, far, typeOfArea, roadWidth, expectedResult, isAccepted);
        }
    }

    private void processFarHaazardous(Plan pl, OccupancyTypeHelper occupancyType, BigDecimal far, String typeOfArea, BigDecimal roadWidth, HashMap<String, String> errors) {
        String expectedResult = "";
        boolean isAccepted = false;
        if (typeOfArea.equalsIgnoreCase(OLD)) {
            if (roadWidth.compareTo(ROAD_WIDTH_TWO_POINTFOUR) < 0) {
                errors.put(OLD_AREA_ERROR, OLD_AREA_ERROR_MSG);
                pl.addErrors(errors);
            } else {
                isAccepted = far.compareTo(POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(POINTFIVE.doubleValue()));
                expectedResult = "<=" + POINTFIVE;
            }
        }
        if (typeOfArea.equalsIgnoreCase(NEW)) {
            if (roadWidth.compareTo(ROAD_WIDTH_SIX_POINTONE) < 0) {
                errors.put(NEW_AREA_ERROR, NEW_AREA_ERROR_MSG);
                pl.addErrors(errors);
            } else {
                isAccepted = far.compareTo(POINTFIVE) <= 0;
                pl.getFarDetails().setPermissableFar(Double.valueOf(POINTFIVE.doubleValue()));
                expectedResult = "<=" + POINTFIVE;
            }
        }
        String occupancyName = occupancyType.getType().getName();
        if (errors.isEmpty() && StringUtils.isNotBlank((String)expectedResult)) {
            this.buildResult(pl, occupancyName, far, typeOfArea, roadWidth, expectedResult, isAccepted);
        }
    }

    private void buildResult(Plan pl, String occupancyName, BigDecimal far, String typeOfArea, BigDecimal roadWidth, String expectedResult, boolean isAccepted) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Occupancy");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Area Type");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Road Width");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Permissible");
        scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(7), "Status");
        scrutinyDetail.setKey("Common_FAR");
        String actualResult = far.toString();
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_38);
        details.put("Occupancy", occupancyName);
        details.put("Area Type", typeOfArea);
        details.put("Road Width", roadWidth.toString());
        details.put("Permissible", expectedResult);
        details.put("Provided", actualResult);
        details.put("Status", isAccepted ? Result.Accepted.getResultVal() : Result.Not_Accepted.getResultVal());
        scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
    }

    private ScrutinyDetail getFarScrutinyDetail(String key) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Area Type");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Road Width");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Permissible");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
        scrutinyDetail.setKey(key);
        return scrutinyDetail;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

