/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.egov.common.entity.dcr.helper.OccupancyHelperDetail;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Occupancy;
import org.egov.common.entity.edcr.OccupancyTypeHelper;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.service.ProcessHelper;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class ExitWidth
extends FeatureProcess {
    private static final String EXIT_WIDTH_DESC = "Exit Width";
    public static final BigDecimal VAL_0_75 = BigDecimal.valueOf(0.75);
    public static final BigDecimal VAL_1_2 = BigDecimal.valueOf(1.2);
    private static final String SUBRULE_42_3 = "42-3";
    private static final String OCCUPANCY = "Occupancy";
    private static final String EXIT_WIDTH = "Exit Width";
    private static final String FLOOR = "Floor";

    private Plan validateExitWidth(Plan pl) {
        HashMap<String, String> errors = new HashMap<String, String>();
        if (!pl.getBlocks().isEmpty()) {
            for (Block block : pl.getBlocks()) {
                OccupancyTypeHelper mostRestrictiveOccupancyType;
                if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty() || (mostRestrictiveOccupancyType = pl.getVirtualBuilding().getMostRestrictiveFarHelper()) != null && mostRestrictiveOccupancyType.getSubtype() != null && "A-R".equalsIgnoreCase(mostRestrictiveOccupancyType.getSubtype().getCode())) continue;
                for (Floor floor : block.getBuilding().getFloors()) {
                    if (!floor.getExitWidthDoor().isEmpty() || !floor.getExitWidthStair().isEmpty()) continue;
                    errors.put(String.format("exit stairway/doorway width for block %s floor %s", block.getNumber(), floor.getNumber()), this.edcrMessageSource.getMessage("msg.error.not.defined", (Object[])new String[]{String.format("exit stairway/doorway width for block %s floor %s", block.getNumber(), floor.getNumber())}, LocaleContextHolder.getLocale()));
                    pl.addErrors(errors);
                }
            }
        }
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        String rule = "Exit Width";
        String subRule = null;
        this.validateExitWidth(pl);
        if (!pl.getBlocks().isEmpty()) {
            for (Block block : pl.getBlocks()) {
                this.scrutinyDetail = new ScrutinyDetail();
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(2), FLOOR);
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(3), OCCUPANCY);
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Required");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
                this.scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
                this.scrutinyDetail.setKey("Block_" + block.getNumber() + "_Exit Width- Minimum Exit Width");
                ScrutinyDetail scrutinyDetail2 = new ScrutinyDetail();
                scrutinyDetail2.addColumnHeading(Integer.valueOf(1), "Byelaw");
                scrutinyDetail2.addColumnHeading(Integer.valueOf(2), FLOOR);
                scrutinyDetail2.addColumnHeading(Integer.valueOf(3), "Required");
                scrutinyDetail2.addColumnHeading(Integer.valueOf(4), "Provided");
                scrutinyDetail2.addColumnHeading(Integer.valueOf(5), "Status");
                scrutinyDetail2.setKey("Block_" + block.getNumber() + "_Exit Width- Maximum Occupant Load");
                if (block.getBuilding() == null || block.getBuilding().getFloors().isEmpty() || ProcessHelper.checkExemptionConditionForBuildingParts(block)) continue;
                for (Floor flr : block.getBuilding().getFloors()) {
                    BigDecimal totalOccupantLoadForAFloor = BigDecimal.ZERO;
                    ArrayList<BigDecimal> listOfMaxOccupantsAllowedThrghExits = new ArrayList<BigDecimal>();
                    ArrayList occupancyTypeValueListMap = new ArrayList();
                    if (!flr.getOccupancies().isEmpty()) {
                        for (Object occupancy : flr.getOccupancies()) {
                            HashMap<String, Object> occupancyTypeValueMap = new HashMap<String, Object>();
                            String occupancyTypeHelper = "";
                            OccupancyHelperDetail occupancyHelperDetail = null;
                            if (occupancy.getTypeHelper().getSubtype() != null) {
                                occupancyHelperDetail = occupancy.getTypeHelper().getSubtype();
                                occupancyTypeHelper = occupancy.getTypeHelper().getSubtype().getCode();
                            } else if (occupancy.getTypeHelper() != null && occupancy.getTypeHelper().getType() != null) {
                                occupancyHelperDetail = occupancy.getTypeHelper().getType();
                                occupancyTypeHelper = occupancy.getTypeHelper().getType().getCode();
                            }
                            BigDecimal value = occupancyTypeHelper.equals("A") || occupancyTypeHelper.equals("A-R") || occupancyTypeHelper.equals("A-SR") || occupancyTypeHelper.equals("A-HE") || occupancyTypeHelper.equals("A-AF") || occupancyTypeHelper.equals("A-PO") ? VAL_0_75 : VAL_1_2;
                            if (occupancyHelperDetail != null) {
                                occupancyTypeValueMap.put(OCCUPANCY, occupancyHelperDetail.getName());
                            }
                            occupancyTypeValueMap.put("Exit Width", value);
                            occupancyTypeValueListMap.add(occupancyTypeValueMap);
                        }
                        if (!occupancyTypeValueListMap.isEmpty()) {
                            Object occupancy;
                            Map mostRestrictiveOccupancyAndMaxValueMap = (Map)occupancyTypeValueListMap.get(0);
                            occupancy = occupancyTypeValueListMap.iterator();
                            while (occupancy.hasNext()) {
                                Map occupancyValueMap = (Map)occupancy.next();
                                if (((BigDecimal)occupancyValueMap.get("Exit Width")).compareTo((BigDecimal)mostRestrictiveOccupancyAndMaxValueMap.get("Exit Width")) == 0) {
                                    String[] occupancyString;
                                    if (mostRestrictiveOccupancyAndMaxValueMap.get(OCCUPANCY) == null || occupancyValueMap.get(OCCUPANCY).equals(mostRestrictiveOccupancyAndMaxValueMap.get(OCCUPANCY))) continue;
                                    TreeSet<String> uniqueOccupancies = new TreeSet<String>();
                                    for (String str : occupancyString = (occupancyValueMap.get(OCCUPANCY) + " , " + mostRestrictiveOccupancyAndMaxValueMap.get(OCCUPANCY)).split(" , ")) {
                                        uniqueOccupancies.add(str);
                                    }
                                    String occupancyStr = this.removeDuplicates(uniqueOccupancies);
                                    mostRestrictiveOccupancyAndMaxValueMap.put(OCCUPANCY, occupancyStr);
                                    continue;
                                }
                                if (((BigDecimal)mostRestrictiveOccupancyAndMaxValueMap.get("Exit Width")).compareTo((BigDecimal)occupancyValueMap.get("Exit Width")) >= 0) continue;
                                mostRestrictiveOccupancyAndMaxValueMap.putAll(occupancyValueMap);
                            }
                            this.validateExitWidth(flr, pl, subRule, rule, block, (BigDecimal)mostRestrictiveOccupancyAndMaxValueMap.get("Exit Width"), (String)mostRestrictiveOccupancyAndMaxValueMap.get(OCCUPANCY));
                        }
                    }
                    for (Object occupancy : flr.getOccupancies()) {
                        BigDecimal noOfOccupantsPerUnitExitWidthOfStairWay;
                        BigDecimal noOfDoors;
                        BigDecimal occupantLoadDivisonFactor;
                        BigDecimal occupantLoad = BigDecimal.ZERO;
                        BigDecimal maxOccupantsAllowedThrghExits = BigDecimal.ZERO;
                        String occupancyTypeHelper = "";
                        if (occupancy.getTypeHelper() != null) {
                            if (occupancy.getTypeHelper().getSubtype() != null) {
                                occupancyTypeHelper = occupancy.getTypeHelper().getSubtype().getCode();
                            } else if (occupancy.getTypeHelper().getType() != null) {
                                occupancyTypeHelper = occupancy.getTypeHelper().getType().getCode();
                            }
                        }
                        if (occupancyTypeHelper.equals("A") || occupancyTypeHelper.equals("A-R") || occupancyTypeHelper.equals("A-AF") || occupancyTypeHelper.equals("A-PO")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(12.5);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(75L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(25L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        } else if (occupancyTypeHelper.equals("A-SR") || occupancyTypeHelper.equals("A-HE")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(4L);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(75L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(50L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        } else if (occupancyTypeHelper.equals("B") || occupancyTypeHelper.equals("B2") || occupancyTypeHelper.equals("B-HEI")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(4L);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(75L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(25L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        } else if (occupancyTypeHelper.equals("C") || occupancyTypeHelper.equals("C-MIP") || occupancyTypeHelper.equals("C-MOP") || occupancyTypeHelper.equals("C-MA")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(15L);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(75L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(25L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        } else if (occupancyTypeHelper.equals("D") || occupancyTypeHelper.equals("D-AW") || occupancyTypeHelper.equals("D-BT")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(1.5);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(90L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(60L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        } else if (occupancyTypeHelper.equals("E")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(1.5);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(75L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(50L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        } else if (occupancyTypeHelper.equals("F") || occupancyTypeHelper.equals("F-PP") || occupancyTypeHelper.equals("F-PA") || occupancyTypeHelper.equals("F-H") || occupancyTypeHelper.equals("F-K")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(4.5);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(75L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(50L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        } else if (occupancyTypeHelper.equals("G") || occupancyTypeHelper.equals("G-SI") || occupancyTypeHelper.equals("G-PHI") || occupancyTypeHelper.equals("G-NPHI")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(10L);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(75L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(50L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        } else if (occupancyTypeHelper.equals("H")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(30L);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(75L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(50L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        } else if (occupancyTypeHelper.equals("I") || occupancyTypeHelper.equals("I-1") || occupancyTypeHelper.equals("I-2")) {
                            occupantLoadDivisonFactor = BigDecimal.valueOf(10L);
                            occupantLoad = this.getOccupantLoadOfAFloor((Occupancy)occupancy, occupantLoadDivisonFactor);
                            noOfDoors = BigDecimal.valueOf(25L);
                            noOfOccupantsPerUnitExitWidthOfStairWay = BigDecimal.valueOf(10L);
                            maxOccupantsAllowedThrghExits = this.getMaximumNumberOfOccupantsAllwdThroughExits(flr, noOfDoors, noOfOccupantsPerUnitExitWidthOfStairWay);
                        }
                        totalOccupantLoadForAFloor = totalOccupantLoadForAFloor.add(occupantLoad);
                        listOfMaxOccupantsAllowedThrghExits.add(maxOccupantsAllowedThrghExits);
                    }
                    if (listOfMaxOccupantsAllowedThrghExits.isEmpty()) continue;
                    BigDecimal minimumOfMaxOccupantsAllowedThrghExits = (BigDecimal)listOfMaxOccupantsAllowedThrghExits.get(0);
                    for (BigDecimal occupantsAllowedThroughExits : listOfMaxOccupantsAllowedThrghExits) {
                        if (occupantsAllowedThroughExits.compareTo(minimumOfMaxOccupantsAllowedThrghExits) >= 0) continue;
                        minimumOfMaxOccupantsAllowedThrghExits = occupantsAllowedThroughExits;
                    }
                    this.validateRuleOccupantLoad(rule, subRule, totalOccupantLoadForAFloor, minimumOfMaxOccupantsAllowedThrghExits, pl, block, flr, scrutinyDetail2);
                }
            }
        }
        return pl;
    }

    private void validateRuleOccupantLoad(String rule, String subRule, BigDecimal occupantLoadInAFlr, BigDecimal maxOccupantsAllowedThrghExits, Plan pl, Block block, Floor floor, ScrutinyDetail scrutinyDetail2) {
        Map<String, Object> typicalFloorValues;
        boolean valid = false;
        boolean isTypicalRepititiveFloor = false;
        if (maxOccupantsAllowedThrghExits != null && occupantLoadInAFlr != null && maxOccupantsAllowedThrghExits.compareTo(BigDecimal.ZERO) > 0 && occupantLoadInAFlr.compareTo(BigDecimal.ZERO) > 0 && !((Boolean)(typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor)).get("isTypicalRepititiveFloor")).booleanValue()) {
            String value;
            if (maxOccupantsAllowedThrghExits.compareTo(occupantLoadInAFlr) >= 0) {
                valid = true;
                subRule = SUBRULE_42_3;
            }
            String string = value = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
            if (valid) {
                this.setReportOutputDetailsWithoutOccupancy(pl, subRule, value, occupantLoadInAFlr.toString(), maxOccupantsAllowedThrghExits.toString(), Result.Accepted.getResultVal(), scrutinyDetail2);
            } else {
                this.setReportOutputDetailsWithoutOccupancy(pl, subRule, value, occupantLoadInAFlr.toString(), maxOccupantsAllowedThrghExits.toString(), Result.Not_Accepted.getResultVal(), scrutinyDetail2);
            }
        }
    }

    private BigDecimal getMaximumNumberOfOccupantsAllwdThroughExits(Floor floor, BigDecimal noOfDoors, BigDecimal noOfOccupantsPerUnitExitWidthOfStairWay) {
        if (!floor.getExitWidthDoor().isEmpty() || !floor.getExitWidthStair().isEmpty()) {
            Double roundedValue;
            Double sumOfAccessWidthDoor = 0.0;
            Double sumOfAccessWidthStair = 0.0;
            BigDecimal augend1 = BigDecimal.ZERO;
            BigDecimal augend2 = BigDecimal.ZERO;
            if (!floor.getExitWidthDoor().isEmpty()) {
                sumOfAccessWidthDoor = floor.getExitWidthDoor().stream().mapToDouble(BigDecimal::doubleValue).sum();
            }
            if (!floor.getExitWidthStair().isEmpty()) {
                sumOfAccessWidthStair = floor.getExitWidthStair().stream().mapToDouble(BigDecimal::doubleValue).sum();
            }
            if (sumOfAccessWidthDoor.compareTo(0.0) > 0) {
                roundedValue = Math.floor(sumOfAccessWidthDoor * Double.valueOf(4.0)) / Double.valueOf(4.0);
                augend1 = BigDecimal.valueOf(Math.ceil(roundedValue * noOfDoors.doubleValue() / 0.5));
            }
            if (sumOfAccessWidthStair.compareTo(0.0) > 0) {
                roundedValue = Math.floor(sumOfAccessWidthStair * Double.valueOf(4.0)) / Double.valueOf(4.0);
                augend2 = BigDecimal.valueOf(Math.ceil(roundedValue * noOfOccupantsPerUnitExitWidthOfStairWay.doubleValue() / 0.5));
            }
            return augend1.add(augend2);
        }
        return BigDecimal.ZERO;
    }

    private BigDecimal getOccupantLoadOfAFloor(Occupancy occupancy, BigDecimal occupantLoadDivisonFactor) {
        return BigDecimal.valueOf(Math.ceil(occupancy.getBuiltUpArea().divide(occupantLoadDivisonFactor, 2, DcrConstants.ROUNDMODE_MEASUREMENTS).doubleValue()));
    }

    private void validateExitWidth(Floor floor, Plan pl, String subRule, String rule, Block block, BigDecimal value, String occupancyType) {
        boolean isTypicalRepititiveFloor = false;
        if (!floor.getExitWidthDoor().isEmpty()) {
            BigDecimal minimumExitWidth = (BigDecimal)floor.getExitWidthDoor().get(0);
            for (BigDecimal exitWidthDoor : floor.getExitWidthDoor()) {
                if (exitWidthDoor.compareTo(minimumExitWidth) >= 0) continue;
                minimumExitWidth = exitWidthDoor;
            }
            Map<String, Object> typicalFloorValues = ProcessHelper.getTypicalFloorValues(block, floor, isTypicalRepititiveFloor);
            if (!((Boolean)typicalFloorValues.get("isTypicalRepititiveFloor")).booleanValue()) {
                String typclFloor;
                Boolean valid = false;
                subRule = SUBRULE_42_3;
                if (minimumExitWidth.compareTo(value) >= 0) {
                    valid = true;
                }
                String string = typclFloor = typicalFloorValues.get("typicalFloors") != null ? (String)typicalFloorValues.get("typicalFloors") : " floor " + floor.getNumber();
                if (valid.booleanValue()) {
                    this.setReportOutputDetails(pl, subRule, typclFloor, occupancyType, value + "(MTR)", minimumExitWidth + "(MTR)", Result.Accepted.getResultVal());
                } else {
                    this.setReportOutputDetails(pl, subRule, typclFloor, occupancyType, value + "(MTR)", minimumExitWidth + "(MTR)", Result.Accepted.getResultVal());
                }
            }
        }
    }

    private void setReportOutputDetails(Plan pl, String ruleNo, String floor, String occupancy, String expected, String actual, String status) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put(FLOOR, floor);
        details.put(OCCUPANCY, occupancy);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        this.scrutinyDetail.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    private void setReportOutputDetailsWithoutOccupancy(Plan pl, String ruleNo, String floor, String expected, String actual, String status, ScrutinyDetail scrutinyDetail2) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put(FLOOR, floor);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        scrutinyDetail2.getDetail().add(details);
        pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail2);
    }

    private String removeDuplicates(SortedSet<String> uniqueData) {
        StringBuilder str = new StringBuilder();
        ArrayList<String> unqList = new ArrayList<String>(uniqueData);
        for (String unique : unqList) {
            str.append(unique);
            if (unique.equals(unqList.get(unqList.size() - 1))) continue;
            str.append(" , ");
        }
        return str.toString();
    }

    @Override
    public Plan validate(Plan pl) {
        this.validateExitWidth(pl);
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

