/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class DistanceToRoad
extends FeatureProcess {
    private static final String SUB_RULE_25_1 = "25-1";
    private static final String SUB_RULE_25_1_PROVISIO = "25-1 Provisio";
    private static final String SUB_RULE_25_1_PROVISIO_DESC = "Distance from building to street boundary";
    private static final String SUB_RULE_26_DESCRIPTION = "Prohibition for constructions abutting public roads.";
    private static final String SUB_RULE_62_1DESCRIPTION = "Minimum distance between plot boundary and abutting Street.";
    private static final String SUB_RULE_26 = "26";
    private static final String RULE_62 = "62";
    private static final String SUB_RULE_62_1 = "62-1";
    private static BigDecimal FIVE = BigDecimal.valueOf(5L);
    private static BigDecimal THREE = BigDecimal.valueOf(3L);
    private static BigDecimal SEVEN = BigDecimal.valueOf(7L);
    private static BigDecimal TWO = BigDecimal.valueOf(2L);
    private static BigDecimal ONEPOINTFIVE = BigDecimal.valueOf(1.5);
    private static final String RULE_EXPECTED_KEY = "meanofaccess.expected";
    private static final String RULE_ACTUAL_KEY = "meanofaccess.actual";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        return pl;
    }

    private void checkBuildingDistanceFromRoad(Plan pl, BigDecimal exptectedDistance, List<BigDecimal> roadDistances, String fieldVerified, String subRule, String rule, String subRuleDesc) {
        for (BigDecimal minimumDistance : roadDistances) {
            HashMap<String, String> details;
            String expectedResult = this.getLocaleMessage(RULE_EXPECTED_KEY, exptectedDistance.toString());
            String actualResult = this.getLocaleMessage(RULE_ACTUAL_KEY, minimumDistance.toString());
            if (exptectedDistance.compareTo(minimumDistance) > 0) {
                details = new HashMap<String, String>();
                details.put("Byelaw", subRule);
                details.put("Description", subRuleDesc);
                details.put("Required", expectedResult);
                details.put("Provided", actualResult);
                details.put("Status", Result.Not_Accepted.getResultVal());
                this.scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
                continue;
            }
            details = new HashMap();
            details.put("Byelaw", subRule);
            details.put("Description", subRuleDesc);
            details.put("Required", expectedResult);
            details.put("Provided", actualResult);
            details.put("Status", Result.Accepted.getResultVal());
            this.scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
        }
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

