/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Measurement;
import org.egov.common.entity.edcr.OccupancyType;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.egov.edcr.utility.DcrConstants;
import org.springframework.stereotype.Service;

@Service
public class Coverage
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(Coverage.class);
    private static final String RULE_DESCRIPTION_KEY = "coverage.description";
    private static final String RULE_EXPECTED_KEY = "coverage.expected";
    private static final String RULE_ACTUAL_KEY = "coverage.actual";
    private static final BigDecimal Forty = BigDecimal.valueOf(40L);
    public static final String RULE_38 = "38";
    private static final BigDecimal ROAD_WIDTH_TWELVE_POINTTWO = BigDecimal.valueOf(12.2);
    private static final BigDecimal ROAD_WIDTH_THIRTY_POINTFIVE = BigDecimal.valueOf(30.5);

    @Override
    public Plan validate(Plan pl) {
        for (Block block : pl.getBlocks()) {
            if (!block.getCoverage().isEmpty()) continue;
            pl.addError("coverageArea" + block.getNumber(), "Coverage Area for block " + block.getNumber() + " not Provided");
        }
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        BigDecimal roadWidth;
        this.validate(pl);
        BigDecimal totalCoverage = BigDecimal.ZERO;
        BigDecimal totalCoverageArea = BigDecimal.ZERO;
        for (Block block : pl.getBlocks()) {
            BigDecimal coverageAreaWithoutDeduction = BigDecimal.ZERO;
            BigDecimal coverageDeductionArea = BigDecimal.ZERO;
            for (Measurement coverage : block.getCoverage()) {
                coverageAreaWithoutDeduction = coverageAreaWithoutDeduction.add(coverage.getArea());
            }
            for (Measurement deduct : block.getCoverageDeductions()) {
                coverageDeductionArea = coverageDeductionArea.add(deduct.getArea());
            }
            if (block.getBuilding() == null) continue;
            block.getBuilding().setCoverageArea(coverageAreaWithoutDeduction.subtract(coverageDeductionArea));
            BigDecimal coverage = BigDecimal.ZERO;
            if (pl.getPlot().getArea().doubleValue() > 0.0) {
                coverage = block.getBuilding().getCoverageArea().multiply(BigDecimal.valueOf(100L)).divide(pl.getPlanInformation().getPlotArea(), 2, DcrConstants.ROUNDMODE_MEASUREMENTS);
            }
            block.getBuilding().setCoverage(coverage);
            totalCoverageArea = totalCoverageArea.add(block.getBuilding().getCoverageArea());
        }
        if (pl.getPlot() != null && pl.getPlot().getArea().doubleValue() > 0.0) {
            totalCoverage = totalCoverageArea.multiply(BigDecimal.valueOf(100L)).divide(pl.getPlanInformation().getPlotArea(), 2, DcrConstants.ROUNDMODE_MEASUREMENTS);
        }
        pl.setCoverage(totalCoverage);
        if (pl.getVirtualBuilding() != null) {
            pl.getVirtualBuilding().setTotalCoverageArea(totalCoverageArea);
        }
        if ((roadWidth = pl.getPlanInformation().getRoadWidth()) != null && roadWidth.compareTo(ROAD_WIDTH_TWELVE_POINTTWO) >= 0 && roadWidth.compareTo(ROAD_WIDTH_THIRTY_POINTFIVE) <= 0) {
            this.processCoverage(pl, "", totalCoverage, Forty);
        }
        return pl;
    }

    private void processCoverage(Plan pl, String occupancy, BigDecimal coverage, BigDecimal upperLimit) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Coverage");
        scrutinyDetail.setHeading("Coverage in Percentage");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Permissible");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Provided");
        scrutinyDetail.addColumnHeading(Integer.valueOf(6), "Status");
        String desc = this.getLocaleMessage(RULE_DESCRIPTION_KEY, upperLimit.toString());
        String actualResult = this.getLocaleMessage(RULE_ACTUAL_KEY, coverage.toString());
        String expectedResult = this.getLocaleMessage(RULE_EXPECTED_KEY, upperLimit.toString());
        if (coverage.doubleValue() <= upperLimit.doubleValue()) {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", RULE_38);
            details.put("Description", desc);
            details.put("Permissible", expectedResult);
            details.put("Provided", actualResult);
            details.put("Status", Result.Accepted.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        } else {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("Byelaw", RULE_38);
            details.put("Description", desc);
            details.put("Permissible", expectedResult);
            details.put("Provided", actualResult);
            details.put("Status", Result.Not_Accepted.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        }
    }

    protected OccupancyType getMostRestrictiveCoverage(EnumSet<OccupancyType> distinctOccupancyTypes) {
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_B1)) {
            return OccupancyType.OCCUPANCY_B1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_B2)) {
            return OccupancyType.OCCUPANCY_B2;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_B3)) {
            return OccupancyType.OCCUPANCY_B3;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_D)) {
            return OccupancyType.OCCUPANCY_D;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_D1)) {
            return OccupancyType.OCCUPANCY_D1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_I2)) {
            return OccupancyType.OCCUPANCY_I2;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_I1)) {
            return OccupancyType.OCCUPANCY_I1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_C)) {
            return OccupancyType.OCCUPANCY_C;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_A1)) {
            return OccupancyType.OCCUPANCY_A1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_A4)) {
            return OccupancyType.OCCUPANCY_A4;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_A2)) {
            return OccupancyType.OCCUPANCY_A2;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_G1)) {
            return OccupancyType.OCCUPANCY_G1;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_E)) {
            return OccupancyType.OCCUPANCY_E;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_F)) {
            return OccupancyType.OCCUPANCY_F;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_F4)) {
            return OccupancyType.OCCUPANCY_F4;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_G2)) {
            return OccupancyType.OCCUPANCY_G2;
        }
        if (distinctOccupancyTypes.contains(OccupancyType.OCCUPANCY_H)) {
            return OccupancyType.OCCUPANCY_H;
        }
        return null;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

