/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Floor;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Ramp;
import org.egov.common.entity.edcr.Result;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class CommonFeature
extends FeatureProcess {
    private static final String FLOOR = "Floor";
    private static final String SUBRULE_48_3_DESC = "Minimum number of lifts";
    private static final String SUBRULE_42_5_V = "42-5-v";
    private static final String REMARKS = "Remarks";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan plan) {
        return plan;
    }

    private void processRule42_5_V_NotAccepted(Block block, Floor floor, Plan plan, String value) {
        this.setReportOutputDetails(plan, SUBRULE_42_5_V, value, String.valueOf(1), String.valueOf(0), Result.Not_Accepted.getResultVal(), "Lift or ramp not defined on this floor");
    }

    private void processRule42_5_V_Accepted(Block block, Floor floor, Plan plan, String value) {
        this.setReportOutputDetails(plan, SUBRULE_42_5_V, value, String.valueOf(1), String.valueOf(floor.getLifts().size()), Result.Accepted.getResultVal(), "Lift required as ramp not defined on this floor");
    }

    private Boolean checkRampDefinedOrNot(Floor floor) {
        Boolean flagRampFloor = false;
        if (!floor.getRamps().isEmpty()) {
            for (Ramp ramp : floor.getRamps()) {
                if (ramp == null) continue;
                flagRampFloor = true;
                break;
            }
        }
        return flagRampFloor;
    }

    private void setReportOutputDetails(Plan plan, String ruleNo, String floor, String expected, String actual, String status, String remarks) {
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", ruleNo);
        details.put(FLOOR, floor);
        details.put("Required", expected);
        details.put("Provided", actual);
        details.put("Status", status);
        details.put(REMARKS, remarks);
        this.scrutinyDetail.getDetail().add(details);
        plan.getReportOutput().getScrutinyDetails().add(this.scrutinyDetail);
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

