/*
 * Decompiled with CFR 0.152.
 */
package org.egov.edcr.feature;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.egov.common.entity.edcr.Block;
import org.egov.common.entity.edcr.Plan;
import org.egov.common.entity.edcr.Result;
import org.egov.common.entity.edcr.ScrutinyDetail;
import org.egov.edcr.feature.FeatureProcess;
import org.springframework.stereotype.Service;

@Service
public class Chimney
extends FeatureProcess {
    private static final Logger LOG = Logger.getLogger(Chimney.class);
    private static final String RULE_44_D = "44-d";
    public static final String CHIMNEY_DESCRIPTION = "Chimney";

    @Override
    public Plan validate(Plan pl) {
        return pl;
    }

    @Override
    public Plan process(Plan pl) {
        ScrutinyDetail scrutinyDetail = new ScrutinyDetail();
        scrutinyDetail.setKey("Common_Chimney");
        scrutinyDetail.addColumnHeading(Integer.valueOf(1), "Byelaw");
        scrutinyDetail.addColumnHeading(Integer.valueOf(2), "Description");
        scrutinyDetail.addColumnHeading(Integer.valueOf(3), "Verified");
        scrutinyDetail.addColumnHeading(Integer.valueOf(4), "Action");
        scrutinyDetail.addColumnHeading(Integer.valueOf(5), "Status");
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("Byelaw", RULE_44_D);
        BigDecimal minHeight = BigDecimal.ZERO;
        for (Block b : pl.getBlocks()) {
            minHeight = BigDecimal.ZERO;
            if (b.getChimneys() == null || b.getChimneys().isEmpty()) continue;
            minHeight = (BigDecimal)b.getChimneys().stream().reduce(BigDecimal::min).get();
            if (minHeight.compareTo(new BigDecimal(1)) <= 0) {
                details.put("Description", CHIMNEY_DESCRIPTION);
                details.put("Verified", "Verified whether chimney height is <= 1 meters");
                details.put("Action", "Not included chimney height(" + minHeight + ") to building height");
                details.put("Status", Result.Accepted.getResultVal());
                scrutinyDetail.getDetail().add(details);
                pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
                continue;
            }
            details.put("Description", CHIMNEY_DESCRIPTION);
            details.put("Verified", "Verified whether chimney height is <= 1 meters");
            details.put("Action", "Included chimney height(" + minHeight + ") to building height");
            details.put("Status", Result.Verify.getResultVal());
            scrutinyDetail.getDetail().add(details);
            pl.getReportOutput().getScrutinyDetails().add(scrutinyDetail);
        }
        return pl;
    }

    @Override
    public Map<String, Date> getAmendments() {
        return new LinkedHashMap<String, Date>();
    }
}

